package org.apache.cayenne.testdo.inheritance_people.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.exp.ExpressionFactory;
import org.apache.cayenne.exp.property.EntityProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.inheritance_people.Employee;

/**
 * Class _Address was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _Address extends BaseDataObject {

    private static final long serialVersionUID = 1L; 

    public static final NumericProperty<Integer> ADDRESS_ID_PK_PROPERTY = PropertyFactory.createNumeric(ExpressionFactory.dbPathExp("ADDRESS_ID"), Integer.class);
    public static final String ADDRESS_ID_PK_COLUMN = "ADDRESS_ID";

    public static final StringProperty<String> CITY = PropertyFactory.createString("city", String.class);
    public static final EntityProperty<Employee> TO_EMPLOYEE = PropertyFactory.createEntity("toEmployee", Employee.class);

    protected String city;

    protected Object toEmployee;

    public void setCity(String city) {
        beforePropertyWrite("city", this.city, city);
        this.city = city;
    }

    public String getCity() {
        beforePropertyRead("city");
        return this.city;
    }

    public void setToEmployee(Employee toEmployee) {
        setToOneTarget("toEmployee", toEmployee, true);
    }

    public Employee getToEmployee() {
        return (Employee)readProperty("toEmployee");
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "city":
                return this.city;
            case "toEmployee":
                return this.toEmployee;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "city":
                this.city = (String)val;
                break;
            case "toEmployee":
                this.toEmployee = val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.city);
        out.writeObject(this.toEmployee);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.city = (String)in.readObject();
        this.toEmployee = in.readObject();
    }

}
