package org.apache.cayenne.testdo.embeddable.auto;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import org.apache.cayenne.BaseDataObject;
import org.apache.cayenne.exp.property.EmbeddableProperty;
import org.apache.cayenne.exp.property.NumericProperty;
import org.apache.cayenne.exp.property.PropertyFactory;
import org.apache.cayenne.exp.property.StringProperty;
import org.apache.cayenne.testdo.embeddable.Embeddable1;

/**
 * Class _EmbedRoot was generated by Cayenne.
 * It is probably a good idea to avoid changing this class manually,
 * since it may be overwritten next time code is regenerated.
 * If you need to make any customizations, please use subclass.
 */
public abstract class _EmbedRoot extends BaseDataObject {

    private static final long serialVersionUID = 1L;

    public static final String ID_PK_COLUMN = "ID";

    public static final EmbeddableProperty<Embeddable1> EMBEDDED = PropertyFactory.createEmbeddable("embedded", Embeddable1.class);
    public static final StringProperty<String> NAME = PropertyFactory.createString("name", String.class);
    public static final NumericProperty<Integer> TYPE = PropertyFactory.createNumeric("type", Integer.class);

    protected Embeddable1 embedded;
    protected String name;
    protected int type;


    public void setEmbedded(Embeddable1 embedded) {
        beforePropertyWrite("embedded", this.embedded, embedded);
        this.embedded = embedded;
    }

    public Embeddable1 getEmbedded() {
        beforePropertyRead("embedded");
        return this.embedded;
    }

    public void setName(String name) {
        beforePropertyWrite("name", this.name, name);
        this.name = name;
    }

    public String getName() {
        beforePropertyRead("name");
        return this.name;
    }

    public void setType(int type) {
        beforePropertyWrite("type", this.type, type);
        this.type = type;
    }

    public int getType() {
        beforePropertyRead("type");
        return this.type;
    }

    @Override
    public Object readPropertyDirectly(String propName) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch(propName) {
            case "embedded":
                return this.embedded;
            case "name":
                return this.name;
            case "type":
                return this.type;
            default:
                return super.readPropertyDirectly(propName);
        }
    }

    @Override
    public void writePropertyDirectly(String propName, Object val) {
        if(propName == null) {
            throw new IllegalArgumentException();
        }

        switch (propName) {
            case "embedded":
                this.embedded = (Embeddable1)val;
                break;
            case "name":
                this.name = (String)val;
                break;
            case "type":
                this.type = val == null ? 0 : (int)val;
                break;
            default:
                super.writePropertyDirectly(propName, val);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        writeSerialized(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        readSerialized(in);
    }

    @Override
    protected void writeState(ObjectOutputStream out) throws IOException {
        super.writeState(out);
        out.writeObject(this.embedded);
        out.writeObject(this.name);
        out.writeInt(this.type);
    }

    @Override
    protected void readState(ObjectInputStream in) throws IOException, ClassNotFoundException {
        super.readState(in);
        this.embedded = (Embeddable1)in.readObject();
        this.name = (String)in.readObject();
        this.type = in.readInt();
    }

}
