/*****************************************************************
 *   Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 ****************************************************************/

package org.apache.cayenne.remote.hessian.service;

import java.io.IOException;

import org.apache.cayenne.util.PersistentObjectList;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.JavaSerializer;

/**
 * Serializer for PersistentObjectLists.
 * 
 * @since 1.2
 */
class ServerPersistentObjectListSerializer extends JavaSerializer {

    ServerPersistentObjectListSerializer() {
        super(PersistentObjectList.class);
    }

    @Override
    public void writeObject(Object object, AbstractHessianOutput out) throws IOException {
        PersistentObjectList list = (PersistentObjectList) object;
        if (list.isFault()) {
            out.writeNull();
        }
        else {
            super.writeObject(object, out);
        }
    }
}
