/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.adapters.base.data;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.management.openmbean.CompositeData;
import org.apache.cassandra.sidecar.adapters.base.data.CompositeDataUtil;
import org.apache.cassandra.sidecar.adapters.base.data.ProgressInfo;
import org.apache.cassandra.sidecar.adapters.base.data.StreamSummary;

public class SessionInfo {
    public final String peer;
    public final int sessionIndex;
    public final String connecting;
    public final List<StreamSummary> receivingSummaries;
    public final List<StreamSummary> sendingSummaries;
    public final String state;
    public final List<ProgressInfo> receivingFiles;
    public final List<ProgressInfo> sendingFiles;

    public SessionInfo(CompositeData data) {
        this.peer = (String)CompositeDataUtil.extractValue(data, "peer");
        this.sessionIndex = (Integer)CompositeDataUtil.extractValue(data, "sessionIndex");
        this.connecting = (String)CompositeDataUtil.extractValue(data, "connecting");
        this.receivingSummaries = this.parseSummaries((CompositeData[])CompositeDataUtil.extractValue(data, "receivingSummaries"));
        this.sendingSummaries = this.parseSummaries((CompositeData[])CompositeDataUtil.extractValue(data, "sendingSummaries"));
        this.state = (String)CompositeDataUtil.extractValue(data, "state");
        this.receivingFiles = this.parseFiles((CompositeData[])CompositeDataUtil.extractValue(data, "receivingFiles"));
        this.sendingFiles = this.parseFiles((CompositeData[])CompositeDataUtil.extractValue(data, "sendingFiles"));
    }

    public long totalSizeReceived() {
        return this.totalSizeInProgress(this.receivingFiles);
    }

    public long totalSizeSent() {
        return this.totalSizeInProgress(this.sendingFiles);
    }

    public long totalFilesToReceive() {
        return this.totalFiles(this.receivingSummaries);
    }

    public long totalFilesToSend() {
        return this.totalFiles(this.sendingSummaries);
    }

    public long totalSizeToReceive() {
        return this.totalSizes(this.receivingSummaries);
    }

    public long totalSizeToSend() {
        return this.totalSizes(this.sendingSummaries);
    }

    public long totalFilesReceived() {
        return this.totalFilesCompleted(this.receivingFiles);
    }

    public long totalFilesSent() {
        return this.totalFilesCompleted(this.sendingFiles);
    }

    private long totalSizes(List<StreamSummary> summaries) {
        long total = 0L;
        for (StreamSummary summary : summaries) {
            total += summary.totalSize;
        }
        return total;
    }

    private long totalFilesCompleted(List<ProgressInfo> files) {
        return files.stream().filter(ProgressInfo::isCompleted).count();
    }

    private long totalSizeInProgress(List<ProgressInfo> streams) {
        long total = 0L;
        for (ProgressInfo stream : streams) {
            total += stream.currentBytes;
        }
        return total;
    }

    private List<StreamSummary> parseSummaries(CompositeData[] summaries) {
        return Arrays.stream(summaries).map(StreamSummary::new).collect(Collectors.toList());
    }

    private List<ProgressInfo> parseFiles(CompositeData[] files) {
        return Arrays.stream(files).map(ProgressInfo::new).collect(Collectors.toList());
    }

    private long totalFiles(List<StreamSummary> summaries) {
        long total = 0L;
        for (StreamSummary summary : summaries) {
            total += (long)summary.files;
        }
        return total;
    }
}

