/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db.schema;

import com.datastax.driver.core.PreparedStatement;
import com.datastax.driver.core.Session;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.SchemaKeyspaceConfiguration;
import org.apache.cassandra.sidecar.coordination.ExecuteOnClusterLeaseholderOnly;
import org.apache.cassandra.sidecar.db.schema.TableSchema;
import org.jetbrains.annotations.NotNull;

public class RestoreJobsSchema
extends TableSchema
implements ExecuteOnClusterLeaseholderOnly {
    private static final String RESTORE_JOB_TABLE_NAME = "restore_job_v5";
    private final SchemaKeyspaceConfiguration keyspaceConfig;
    private final SecondBoundConfiguration tableTtl;
    private PreparedStatement insertJob;
    private PreparedStatement updateBlobSecrets;
    private PreparedStatement updateStatus;
    private PreparedStatement updateJobAgent;
    private PreparedStatement updateExpireAt;
    private PreparedStatement updateSliceCount;
    private PreparedStatement selectJob;
    private PreparedStatement findAllByCreatedAt;

    public RestoreJobsSchema(SchemaKeyspaceConfiguration keyspaceConfig, SecondBoundConfiguration tableTtl) {
        this.keyspaceConfig = keyspaceConfig;
        this.tableTtl = tableTtl;
    }

    protected String keyspaceName() {
        return this.keyspaceConfig.keyspace();
    }

    protected void prepareStatements(@NotNull Session session) {
        this.insertJob = this.prepare(this.insertJob, session, CqlLiterals.insertJob(this.keyspaceConfig));
        this.updateBlobSecrets = this.prepare(this.updateBlobSecrets, session, CqlLiterals.updateBlobSecrets(this.keyspaceConfig));
        this.updateStatus = this.prepare(this.updateStatus, session, CqlLiterals.updateStatus(this.keyspaceConfig));
        this.updateJobAgent = this.prepare(this.updateJobAgent, session, CqlLiterals.updateJobAgent(this.keyspaceConfig));
        this.updateExpireAt = this.prepare(this.updateExpireAt, session, CqlLiterals.updateExpireAt(this.keyspaceConfig));
        this.updateSliceCount = this.prepare(this.updateSliceCount, session, CqlLiterals.updateSliceCount(this.keyspaceConfig));
        this.selectJob = this.prepare(this.selectJob, session, CqlLiterals.selectJob(this.keyspaceConfig));
        this.findAllByCreatedAt = this.prepare(this.findAllByCreatedAt, session, CqlLiterals.findAllByCreatedAt(this.keyspaceConfig));
    }

    protected String tableName() {
        return RESTORE_JOB_TABLE_NAME;
    }

    protected String createSchemaStatement() {
        return String.format("CREATE TABLE IF NOT EXISTS %s.%s (  created_at date,  job_id timeuuid,  keyspace_name text,  table_name text,  job_agent text,  status text,  blob_secrets blob,  import_options blob,  expire_at timestamp,  slice_count bigint,  bucket_count smallint,  consistency_level text,  local_datacenter text,  local_datacenter_only boolean,  PRIMARY KEY (created_at, job_id)) WITH default_time_to_live = %s", this.keyspaceConfig.keyspace(), RESTORE_JOB_TABLE_NAME, this.tableTtl.toSeconds());
    }

    public PreparedStatement insertJob() {
        return this.insertJob;
    }

    public PreparedStatement updateBlobSecrets() {
        return this.updateBlobSecrets;
    }

    public PreparedStatement updateStatus() {
        return this.updateStatus;
    }

    public PreparedStatement updateJobAgent() {
        return this.updateJobAgent;
    }

    public PreparedStatement updateExpireAt() {
        return this.updateExpireAt;
    }

    public PreparedStatement updateSliceCount() {
        return this.updateSliceCount;
    }

    public PreparedStatement selectJob() {
        return this.selectJob;
    }

    public PreparedStatement findAllByCreatedAt() {
        return this.findAllByCreatedAt;
    }

    private static class CqlLiterals {
        private CqlLiterals() {
        }

        static String insertJob(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("INSERT INTO %s.%s (  created_at,  job_id,  keyspace_name,  table_name,  job_agent,  status,  blob_secrets,  import_options,  consistency_level,  local_datacenter,  local_datacenter_only,  expire_at) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", config);
        }

        static String updateBlobSecrets(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("INSERT INTO %s.%s (  created_at,  job_id,  blob_secrets) VALUES (?, ? ,?)", config);
        }

        static String updateStatus(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("INSERT INTO %s.%s (  created_at,  job_id,  status) VALUES (?, ?, ?)", config);
        }

        static String updateJobAgent(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("INSERT INTO %s.%s (  created_at,  job_id,  job_agent) VALUES (?, ?, ?)", config);
        }

        static String updateExpireAt(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("INSERT INTO %s.%s (  created_at,  job_id,  expire_at) VALUES (?, ?, ?)", config);
        }

        static String updateSliceCount(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("INSERT INTO %s.%s (  created_at,  job_id,  slice_count) VALUES (?, ?, ?)", config);
        }

        static String selectJob(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("SELECT created_at, job_id, keyspace_name, table_name, job_agent, status, blob_secrets, import_options, consistency_level, local_datacenter, local_datacenter_only, expire_at, slice_count FROM %s.%s WHERE created_at = ? AND job_id = ?", config);
        }

        static String findAllByCreatedAt(SchemaKeyspaceConfiguration config) {
            return CqlLiterals.withTable("SELECT created_at, job_id, keyspace_name, table_name, job_agent, status, blob_secrets, import_options, consistency_level, local_datacenter, local_datacenter_only, expire_at, slice_count FROM %s.%s WHERE created_at = ?", config);
        }

        private static String withTable(String format, SchemaKeyspaceConfiguration config) {
            return String.format(format, config.keyspace(), RestoreJobsSchema.RESTORE_JOB_TABLE_NAME);
        }
    }
}

