/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.coordination;

import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.Metadata;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.sidecar.client.SidecarInstance;
import org.apache.cassandra.sidecar.client.SidecarInstanceImpl;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Token;
import org.apache.cassandra.sidecar.common.server.cluster.locator.TokenRange;
import org.apache.cassandra.sidecar.common.server.dns.DnsResolver;
import org.apache.cassandra.sidecar.common.server.utils.DriverUtils;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.config.ServiceConfiguration;
import org.apache.cassandra.sidecar.config.yaml.CassandraInputValidationConfigurationImpl;
import org.apache.cassandra.sidecar.coordination.CassandraClientTokenRingProvider;
import org.apache.cassandra.sidecar.coordination.SidecarPeerProvider;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class InnerDcTokenAdjacentPeerProvider
implements SidecarPeerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(InnerDcTokenAdjacentPeerProvider.class);
    protected final InstanceMetadataFetcher instanceFetcher;
    private final CassandraClientTokenRingProvider cassandraClientTokenRingProvider;
    private final ServiceConfiguration serviceConfiguration;
    private final DnsResolver dnsResolver;
    private final DriverUtils driverUtils;

    @Inject
    public InnerDcTokenAdjacentPeerProvider(InstanceMetadataFetcher instanceFetcher, CassandraClientTokenRingProvider cassandraClientTokenRingProvider, ServiceConfiguration serviceConfiguration, DnsResolver dnsResolver, DriverUtils driverUtils) {
        this.instanceFetcher = instanceFetcher;
        this.cassandraClientTokenRingProvider = cassandraClientTokenRingProvider;
        this.serviceConfiguration = serviceConfiguration;
        this.dnsResolver = dnsResolver;
        this.driverUtils = driverUtils;
    }

    @Override
    public Set<SidecarInstance> get() {
        Metadata metadata;
        try {
            metadata = this.instanceFetcher.callOnFirstAvailableInstance(instance -> instance.delegate().metadata());
        }
        catch (Throwable cause) {
            LOGGER.debug("Unable to retrieve metadata", cause);
            return Set.of();
        }
        List keyspaces = metadata.getKeyspaces().stream().filter(ks -> !CassandraInputValidationConfigurationImpl.DEFAULT_FORBIDDEN_KEYSPACES.contains(ks.getName())).collect(Collectors.toList());
        if (keyspaces.isEmpty()) {
            LOGGER.warn("No user keyspaces found");
            return Set.of();
        }
        Set<Host> localHosts = this.cassandraClientTokenRingProvider.localInstances();
        String localDc = Objects.requireNonNull(localHosts, "CachedLocalTokenRanges not initialized").stream().map(Host::getDatacenter).filter(Objects::nonNull).findAny().orElseThrow(() -> new RuntimeException("No local instances found."));
        Optional<KeyspaceMetadata> maxRfKeyspace = keyspaces.stream().filter(ks -> ks.getReplication().containsKey(localDc)).max(Comparator.comparingInt(a -> Integer.parseInt((String)a.getReplication().get(localDc))));
        if (maxRfKeyspace.isEmpty()) {
            LOGGER.info("No keyspace found replicated in DC dc={}", (Object)localDc);
            return Set.of();
        }
        int rf = Integer.parseInt((String)maxRfKeyspace.get().getReplication().get(localDc));
        int quorum = rf / 2;
        List<Pair<Host, BigInteger>> sortedLocalDcHosts = Objects.requireNonNull(this.cassandraClientTokenRingProvider.allInstances(), "CachedLocalTokenRanges not initialized").stream().filter(host -> host.getDatacenter().equals(localDc)).map(host -> Pair.of((Object)host, (Object)InnerDcTokenAdjacentPeerProvider.minToken(host))).sorted(Comparator.comparing(Pair::getRight)).collect(Collectors.toList());
        BigInteger localMinToken = InnerDcTokenAdjacentPeerProvider.minToken(localHosts);
        return InnerDcTokenAdjacentPeerProvider.adjacentHosts(this.driverUtils, localHosts::contains, localMinToken, sortedLocalDcHosts, quorum).stream().map(host -> this.driverUtils.getSocketAddress(host).getAddress().getHostAddress()).map(sidecarIpAddress -> {
            String sidecarHostname = sidecarIpAddress;
            try {
                sidecarHostname = this.dnsResolver.reverseResolve(sidecarIpAddress);
            }
            catch (UnknownHostException unknownHostException) {
                LOGGER.warn("Unable to reverse resolve hostname for {}", (Object)sidecarHostname, (Object)unknownHostException);
            }
            return new SidecarInstanceImpl(sidecarHostname, this.sidecarServicePort(sidecarHostname));
        }).collect(Collectors.toSet());
    }

    @VisibleForTesting
    protected int sidecarServicePort(String sidecarHostname) {
        return this.serviceConfiguration.port();
    }

    public static BigInteger minToken(Collection<Host> hosts) {
        return hosts.stream().map(InnerDcTokenAdjacentPeerProvider::minToken).min(BigInteger::compareTo).orElseThrow(() -> new RuntimeException("No min token found on hosts"));
    }

    public static BigInteger minToken(Host host) {
        return host.getTokens().stream().map(InnerDcTokenAdjacentPeerProvider::tokenToBigInteger).min(BigInteger::compareTo).orElseThrow(() -> new RuntimeException("No min token found on host: " + host.getHostId()));
    }

    public static BigInteger tokenToBigInteger(com.datastax.driver.core.Token token) {
        if (token.getType() == DataType.varint()) {
            return (BigInteger)token.getValue();
        }
        if (token.getType() == DataType.bigint()) {
            return BigInteger.valueOf((Long)token.getValue());
        }
        throw new IllegalArgumentException("Unsupported token type: " + token.getType() + ". Only tokens of Murmur3Partitioner and RandomPartitioner are supported.");
    }

    protected static BigInteger minToken(Stream<TokenRange> tokenRanges) {
        return tokenRanges.map(TokenRange::start).min(Token::compareTo).map(Token::toBigInteger).orElseThrow(() -> new IllegalStateException("No tokens for host"));
    }

    protected static Set<Host> adjacentHosts(DriverUtils driverUtils, Predicate<Host> isLocal, BigInteger localMinToken, List<Pair<Host, BigInteger>> sortedLocalDcHosts, int quorum) {
        int nextIdx;
        int i;
        HashSet<Host> adjacentHosts = new HashSet<Host>(quorum);
        int idx = Collections.binarySearch(sortedLocalDcHosts, null, (o1, o2) -> {
            BigInteger token1 = o1 == null ? localMinToken : (BigInteger)o1.getValue();
            BigInteger token2 = o2 == null ? localMinToken : (BigInteger)o2.getValue();
            return token1.compareTo(token2);
        });
        if (idx < 0) {
            throw new IllegalStateException("Could not find local instance");
        }
        for (i = 1; i <= quorum; ++i) {
            nextIdx = (idx + i) % sortedLocalDcHosts.size();
            Host nextHost = (Host)sortedLocalDcHosts.get(nextIdx).getKey();
            if (!isLocal.test(nextHost)) continue;
            LOGGER.warn("Insufficient other hosts to satisfy quorum quorum={} numHosts={}", (Object)quorum, (Object)i);
            quorum = i - 1;
            break;
        }
        for (i = 1; i <= quorum; ++i) {
            nextIdx = (idx + i) % sortedLocalDcHosts.size();
            adjacentHosts.add((Host)sortedLocalDcHosts.get(nextIdx).getKey());
        }
        Preconditions.checkArgument((adjacentHosts.size() == quorum ? 1 : 0) != 0, (String)String.format("Failed to find %d adjacent node(s) in the ring", quorum));
        for (Host host : adjacentHosts) {
            if (!isLocal.test(host)) continue;
            InetAddress address = driverUtils.getSocketAddress(host).getAddress();
            LOGGER.warn("Local instance selected as adjacent host localMinToken={} hostId={} address={} hostname={} canonicalHostname={}", new Object[]{localMinToken, host.getHostId(), address.getHostAddress(), address.getHostName(), address.getCanonicalHostName()});
            throw new IllegalArgumentException(String.format("Local instance selected as adjacent host: %s", host.getHostId()));
        }
        return adjacentHosts;
    }
}

