/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.bulkwriter.cloudstorage;

import java.util.Collections;
import o.a.c.sidecar.client.shaded.client.SidecarClient;
import org.apache.cassandra.spark.bulkwriter.CassandraClusterInfo;
import org.apache.cassandra.spark.bulkwriter.ClusterInfo;
import org.apache.cassandra.spark.bulkwriter.JobInfo;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApi;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApiFactory;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.CloudStorageDataTransferApiImpl;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.StorageClient;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CassandraClusterInfoGroup;
import org.apache.cassandra.spark.bulkwriter.cloudstorage.coordinated.CoordinatedCloudStorageDataTransferApi;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class CloudStorageDataTransferApiFactoryTest {
    private CloudStorageDataTransferApiFactory factory = CloudStorageDataTransferApiFactory.INSTANCE;

    CloudStorageDataTransferApiFactoryTest() {
    }

    @Test
    void testCreateCloudStorageDataTransferApi() {
        CassandraClusterInfo clusterInfo = (CassandraClusterInfo)Mockito.mock(CassandraClusterInfo.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)clusterInfo.getCassandraContext().getSidecarClient()).thenReturn((Object)((SidecarClient)Mockito.mock(SidecarClient.class)));
        CloudStorageDataTransferApi api = this.factory.createDataTransferApi((StorageClient)Mockito.mock(StorageClient.class), (JobInfo)Mockito.mock(JobInfo.class), (ClusterInfo)clusterInfo);
        Assertions.assertThat((Object)api).isInstanceOf(CloudStorageDataTransferApiImpl.class);
    }

    @Test
    void testCreateCloudStorageDataTransferApiFails() {
        CassandraClusterInfoGroup emptyGroup = (CassandraClusterInfoGroup)Mockito.mock(CassandraClusterInfoGroup.class);
        Mockito.when((Object)emptyGroup.size()).thenReturn((Object)0);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.factory.createDataTransferApi((StorageClient)Mockito.mock(StorageClient.class), (JobInfo)Mockito.mock(JobInfo.class), (ClusterInfo)emptyGroup)).isExactlyInstanceOf(IllegalArgumentException.class)).hasMessage("dataTransferApiByCluster cannot be empty");
    }

    @Test
    void testCreateCoordinatedCloudStorageDataTransferApi() {
        CassandraClusterInfo clusterInfo = (CassandraClusterInfo)Mockito.mock(CassandraClusterInfo.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)clusterInfo.clusterId()).thenReturn((Object)"clusterId");
        CassandraClusterInfoGroup group = CassandraClusterInfoGroup.createFrom(Collections.singletonList(clusterInfo));
        CloudStorageDataTransferApi api = this.factory.createDataTransferApi((StorageClient)Mockito.mock(StorageClient.class), (JobInfo)Mockito.mock(JobInfo.class), (ClusterInfo)group);
        Assertions.assertThat((Object)api).isInstanceOf(CoordinatedCloudStorageDataTransferApi.class);
    }
}

