/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.spark.data;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.cassandra.analytics.stats.Stats;
import org.apache.cassandra.bridge.TokenRange;
import org.apache.cassandra.spark.data.DataLayer;
import org.apache.cassandra.spark.data.ReplicationFactor;
import org.apache.cassandra.spark.data.SSTable;
import org.apache.cassandra.spark.data.SSTablesSupplier;
import org.apache.cassandra.spark.data.partitioner.CassandraInstance;
import org.apache.cassandra.spark.data.partitioner.CassandraRing;
import org.apache.cassandra.spark.data.partitioner.ConsistencyLevel;
import org.apache.cassandra.spark.data.partitioner.MultiDCReplicas;
import org.apache.cassandra.spark.data.partitioner.MultipleReplicas;
import org.apache.cassandra.spark.data.partitioner.NotEnoughReplicasException;
import org.apache.cassandra.spark.data.partitioner.Partitioner;
import org.apache.cassandra.spark.data.partitioner.SingleReplica;
import org.apache.cassandra.spark.data.partitioner.TokenPartitioner;
import org.apache.cassandra.spark.sparksql.NoMatchFoundException;
import org.apache.cassandra.spark.sparksql.filters.PartitionKeyFilter;
import org.apache.cassandra.spark.sparksql.filters.SparkRangeFilter;
import org.apache.cassandra.spark.utils.RangeUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PartitionedDataLayer
extends DataLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionedDataLayer.class);
    private static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.LOCAL_QUORUM;
    @NotNull
    protected ConsistencyLevel consistencyLevel;
    protected String datacenter;

    public PartitionedDataLayer(@Nullable ConsistencyLevel consistencyLevel, @Nullable String datacenter) {
        this.consistencyLevel = consistencyLevel != null ? consistencyLevel : DEFAULT_CONSISTENCY_LEVEL;
        this.datacenter = datacenter;
        if (consistencyLevel == ConsistencyLevel.SERIAL || consistencyLevel == ConsistencyLevel.LOCAL_SERIAL) {
            throw new IllegalArgumentException("SERIAL or LOCAL_SERIAL are invalid consistency levels for the Bulk Reader");
        }
    }

    protected void validateReplicationFactor(@NotNull ReplicationFactor replicationFactor) {
        PartitionedDataLayer.validateReplicationFactor(this.consistencyLevel, replicationFactor, this.datacenter);
    }

    @VisibleForTesting
    public static void validateReplicationFactor(@NotNull ConsistencyLevel consistencyLevel, @NotNull ReplicationFactor replicationFactor, @Nullable String dc) {
        if (replicationFactor.getReplicationStrategy() != ReplicationFactor.ReplicationStrategy.NetworkTopologyStrategy) {
            return;
        }
        if (dc == null && replicationFactor.getOptions().size() == 1) {
            return;
        }
        Preconditions.checkArgument((dc != null || !consistencyLevel.isDCLocal ? 1 : 0) != 0, (Object)("A DC must be specified for DC local consistency level " + consistencyLevel.name()));
        if (dc == null) {
            return;
        }
        Preconditions.checkArgument((ConsistencyLevel.EACH_QUORUM != consistencyLevel ? 1 : 0) != 0, (Object)("A DC should not be specified for EACH_QUORUM consistency level. Provided DC: " + dc));
        Preconditions.checkArgument((boolean)replicationFactor.getOptions().containsKey(dc), (String)"DC %s not found in replication factor %s", (Object[])new Object[]{dc, replicationFactor.getOptions().keySet()});
        Preconditions.checkArgument(((Integer)replicationFactor.getOptions().get(dc) > 0 ? 1 : 0) != 0, (String)"Cannot read from DC %s with non-positive replication factor %d", (Object[])new Object[]{dc, replicationFactor.getOptions().get(dc)});
    }

    public abstract CompletableFuture<Stream<SSTable>> listInstance(int var1, @NotNull Range<BigInteger> var2, @NotNull CassandraInstance var3);

    public abstract CassandraRing ring();

    public abstract TokenPartitioner tokenPartitioner();

    @Override
    public int partitionCount() {
        return this.tokenPartitioner().numPartitions();
    }

    @Override
    public Partitioner partitioner() {
        return this.ring().partitioner();
    }

    @Override
    public boolean isInPartition(int partitionId, BigInteger token, ByteBuffer key) {
        return this.tokenPartitioner().isInPartition(token, key, partitionId);
    }

    @Override
    public SparkRangeFilter sparkRangeFilter(int partitionId) {
        Map reversePartitionMap = this.tokenPartitioner().reversePartitionMap();
        Range sparkTokenRange = (Range)reversePartitionMap.get(partitionId);
        if (sparkTokenRange == null) {
            LOGGER.error("Unable to find the sparkTokenRange for partitionId={} in reversePartitionMap={}", (Object)partitionId, (Object)reversePartitionMap);
            throw new IllegalStateException(String.format("Unable to find sparkTokenRange for partitionId=%d in the reverse partition map", partitionId));
        }
        return SparkRangeFilter.create((TokenRange)RangeUtils.toTokenRange((Range)sparkTokenRange));
    }

    @Override
    public List<PartitionKeyFilter> partitionKeyFiltersInRange(int partitionId, List<PartitionKeyFilter> filters) throws NoMatchFoundException {
        SparkRangeFilter rangeFilter = this.sparkRangeFilter(partitionId);
        TokenRange sparkTokenRange = rangeFilter.tokenRange();
        List filtersInRange = filters.stream().filter(filter -> filter.overlaps(sparkTokenRange)).collect(Collectors.toList());
        if (!filters.isEmpty() && filtersInRange.isEmpty()) {
            LOGGER.info("None of the partition key filters overlap with Spark partition token range firstToken={} lastToken={}", (Object)sparkTokenRange.firstEnclosedValue(), (Object)sparkTokenRange.upperEndpoint());
            throw new NoMatchFoundException();
        }
        return this.filterNonIntersectingSSTables() ? filtersInRange : filters;
    }

    public ConsistencyLevel consistencylevel() {
        return this.consistencyLevel;
    }

    @Override
    public SSTablesSupplier sstables(int partitionId, @Nullable SparkRangeFilter sparkRangeFilter, @NotNull List<PartitionKeyFilter> partitionKeyFilters) {
        HashMap<Range<BigInteger>, List<CassandraInstance>> instRanges;
        TokenPartitioner tokenPartitioner = this.tokenPartitioner();
        if (partitionId < 0 || partitionId >= tokenPartitioner.numPartitions()) {
            throw new IllegalStateException("PartitionId outside expected range: " + partitionId);
        }
        Range range = tokenPartitioner.getTokenRange(partitionId);
        CassandraRing ring = this.ring();
        ReplicationFactor replicationFactor = ring.replicationFactor();
        this.validateReplicationFactor(replicationFactor);
        HashMap<Range<BigInteger>, List<CassandraInstance>> subRanges = this.ring().getSubRanges(range).asMapOfRanges();
        if (partitionKeyFilters.isEmpty()) {
            instRanges = subRanges;
        } else {
            instRanges = new HashMap<Range<BigInteger>, List<CassandraInstance>>();
            subRanges.keySet().forEach(instRange -> {
                TokenRange tokenRange = RangeUtils.toTokenRange((Range)instRange);
                if (partitionKeyFilters.stream().anyMatch(filter -> filter.overlaps(tokenRange))) {
                    instRanges.putIfAbsent((Range<BigInteger>)instRange, (List)subRanges.get(instRange));
                }
            });
        }
        Set<CassandraInstance> replicas = PartitionedDataLayer.rangesToReplicas(this.consistencyLevel, this.datacenter, instRanges);
        LOGGER.info("Creating partitioned SSTablesSupplier for Spark partition partitionId={} rangeLower={} rangeUpper={} numReplicas={}", new Object[]{partitionId, range.lowerEndpoint(), range.upperEndpoint(), replicas.size()});
        return this.constructSSTablesSupplier(partitionId, replicationFactor, instRanges, replicas, (Range<BigInteger>)range);
    }

    @NotNull
    private SSTablesSupplier constructSSTablesSupplier(int partitionId, ReplicationFactor replicationFactor, Map<Range<BigInteger>, List<CassandraInstance>> instRanges, Set<CassandraInstance> replicas, Range<BigInteger> range) {
        if (this.consistencyLevel == ConsistencyLevel.EACH_QUORUM) {
            Map minReplicasPerDC = this.consistencyLevel.eachQuorumBlockFor(replicationFactor);
            LOGGER.debug("Reading with EACH_QUORUM consistency level for partitionId={}, minReplicasPerDC={}", (Object)partitionId, (Object)minReplicasPerDC);
            Map replicasByDC = replicas.stream().collect(Collectors.groupingBy(CassandraInstance::dataCenter, Collectors.toSet()));
            HashMap<String, SSTablesSupplier> perDCSSTablesSupplier = new HashMap<String, SSTablesSupplier>(minReplicasPerDC.size());
            for (Map.Entry entry : minReplicasPerDC.entrySet()) {
                Set<CassandraInstance> replicasInDC = replicasByDC.getOrDefault(entry.getKey(), Collections.emptySet());
                MultipleReplicas multipleReplicas = this.constructSSTablesSupplierSingleDC(partitionId, instRanges, replicasInDC, range, (Integer)entry.getValue());
                perDCSSTablesSupplier.put((String)entry.getKey(), multipleReplicas);
            }
            return new MultiDCReplicas(perDCSSTablesSupplier);
        }
        int minReplicas = this.consistencyLevel.blockFor(replicationFactor, this.datacenter);
        return this.constructSSTablesSupplierSingleDC(partitionId, instRanges, replicas, range, minReplicas);
    }

    @NotNull
    private MultipleReplicas constructSSTablesSupplierSingleDC(int partitionId, Map<Range<BigInteger>, List<CassandraInstance>> instRanges, Set<CassandraInstance> replicas, Range<BigInteger> range, int minReplicas) {
        ReplicaSet replicaSet = PartitionedDataLayer.splitReplicas(this.consistencyLevel, this.datacenter, instRanges, replicas, this::getAvailability, minReplicas, partitionId);
        if (replicaSet.primary().size() < minReplicas) {
            assert (replicaSet.backup().isEmpty());
            throw new NotEnoughReplicasException(this.consistencyLevel, (BigInteger)range.lowerEndpoint(), (BigInteger)range.upperEndpoint(), minReplicas, replicas.size(), this.datacenter);
        }
        ExecutorService executor = this.executorService();
        Stats stats = this.stats();
        Set<SingleReplica> primaryReplicas = replicaSet.primary().stream().map(instance -> new SingleReplica((CassandraInstance)instance, this, range, partitionId, executor, stats, replicaSet.isRepairPrimary((CassandraInstance)instance))).collect(Collectors.toSet());
        Set<SingleReplica> backupReplicas = replicaSet.backup().stream().map(instance -> new SingleReplica((CassandraInstance)instance, this, range, partitionId, executor, stats, true)).collect(Collectors.toSet());
        return new MultipleReplicas(primaryReplicas, backupReplicas, stats);
    }

    public boolean filterNonIntersectingSSTables() {
        return true;
    }

    protected AvailabilityHint getAvailability(CassandraInstance instance) {
        return AvailabilityHint.UNKNOWN;
    }

    static Set<CassandraInstance> rangesToReplicas(@NotNull ConsistencyLevel consistencyLevel, @Nullable String dataCenter, @NotNull Map<Range<BigInteger>, List<CassandraInstance>> ranges) {
        return ranges.values().stream().flatMap(Collection::stream).filter(instance -> !consistencyLevel.isDCLocal || dataCenter == null || instance.dataCenter().equals(dataCenter)).collect(Collectors.toSet());
    }

    static ReplicaSet splitReplicas(@NotNull ConsistencyLevel consistencyLevel, @Nullable String dataCenter, @NotNull Map<Range<BigInteger>, List<CassandraInstance>> ranges, @NotNull Set<CassandraInstance> replicas, @NotNull Function<CassandraInstance, AvailabilityHint> availability, int minReplicas, int partitionId) throws NotEnoughReplicasException {
        ReplicaSet split = PartitionedDataLayer.splitReplicas(replicas, ranges, availability, minReplicas, partitionId);
        PartitionedDataLayer.validateConsistency(consistencyLevel, dataCenter, ranges, split.primary(), minReplicas);
        return split;
    }

    private static void validateConsistency(@NotNull ConsistencyLevel consistencyLevel, @Nullable String dc, @NotNull Map<Range<BigInteger>, List<CassandraInstance>> workerRanges, @NotNull Set<CassandraInstance> primaryReplicas, int minReplicas) throws NotEnoughReplicasException {
        for (Map.Entry<Range<BigInteger>, List<CassandraInstance>> range : workerRanges.entrySet()) {
            int count = (int)range.getValue().stream().filter(primaryReplicas::contains).count();
            if (count >= minReplicas) continue;
            throw new NotEnoughReplicasException(consistencyLevel, (BigInteger)range.getKey().lowerEndpoint(), (BigInteger)range.getKey().upperEndpoint(), minReplicas, count, dc);
        }
    }

    static ReplicaSet splitReplicas(Collection<CassandraInstance> instances, @NotNull Map<Range<BigInteger>, List<CassandraInstance>> ranges, Function<CassandraInstance, AvailabilityHint> availability, int minReplicas, int partitionId) {
        ReplicaSet replicaSet = new ReplicaSet(minReplicas, partitionId);
        instances.stream().sorted(Comparator.comparing(availability, AvailabilityHint.AVAILABILITY_HINT_COMPARATOR)).forEach(replicaSet::add);
        if (ranges.size() != 1) {
            LOGGER.warn("Cannot use incremental repair awareness when Spark partition owns more than one replica set, performance will be degraded numRanges={}", (Object)ranges.size());
            replicaSet.incrementalRepairPrimary = null;
        }
        return replicaSet;
    }

    public abstract ReplicationFactor replicationFactor(String var1);

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.datacenter).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        PartitionedDataLayer that = (PartitionedDataLayer)other;
        return new EqualsBuilder().append((Object)this.datacenter, (Object)that.datacenter).isEquals();
    }

    public static class ReplicaSet {
        private final Set<CassandraInstance> primary;
        private final Set<CassandraInstance> backup;
        private final int minReplicas;
        private final int partitionId;
        private CassandraInstance incrementalRepairPrimary;

        ReplicaSet(int minReplicas, int partitionId) {
            this.minReplicas = minReplicas;
            this.partitionId = partitionId;
            this.primary = new HashSet<CassandraInstance>();
            this.backup = new HashSet<CassandraInstance>();
        }

        public ReplicaSet add(CassandraInstance instance) {
            if (this.primary.size() < this.minReplicas) {
                LOGGER.info("Selecting instance as primary replica nodeName={} token={} dc={} partitionId={}", new Object[]{instance.nodeName(), instance.token(), instance.dataCenter(), this.partitionId});
                return this.addPrimary(instance);
            }
            return this.addBackup(instance);
        }

        public boolean isRepairPrimary(CassandraInstance instance) {
            return this.incrementalRepairPrimary == null || this.incrementalRepairPrimary.equals((Object)instance);
        }

        public Set<CassandraInstance> primary() {
            return this.primary;
        }

        public ReplicaSet addPrimary(CassandraInstance instance) {
            if (this.incrementalRepairPrimary == null) {
                this.incrementalRepairPrimary = instance;
            }
            this.primary.add(instance);
            return this;
        }

        public Set<CassandraInstance> backup() {
            return this.backup;
        }

        public ReplicaSet addBackup(CassandraInstance instance) {
            LOGGER.info("Selecting instance as backup replica nodeName={} token={} dc={} partitionId={}", new Object[]{instance.nodeName(), instance.token(), instance.dataCenter(), this.partitionId});
            this.backup.add(instance);
            return this;
        }
    }

    public static enum AvailabilityHint {
        UP(0),
        MOVING(1),
        LEAVING(1),
        UNKNOWN(2),
        JOINING(2),
        DOWN(2);

        private final int priority;
        public static final Comparator<AvailabilityHint> AVAILABILITY_HINT_COMPARATOR;

        private AvailabilityHint(int priority) {
            this.priority = priority;
        }

        public static AvailabilityHint fromState(String status, String state) {
            if (status.equalsIgnoreCase(DOWN.name())) {
                return DOWN;
            }
            if (status.equalsIgnoreCase(UNKNOWN.name())) {
                return UNKNOWN;
            }
            if (state.equalsIgnoreCase("NORMAL")) {
                return AvailabilityHint.valueOf(status.toUpperCase());
            }
            if (state.equalsIgnoreCase(MOVING.name())) {
                return MOVING;
            }
            if (state.equalsIgnoreCase(LEAVING.name())) {
                return LEAVING;
            }
            if (state.equalsIgnoreCase("STARTING")) {
                return AvailabilityHint.valueOf(status.toUpperCase());
            }
            if (state.equalsIgnoreCase(JOINING.name())) {
                return JOINING;
            }
            return UNKNOWN;
        }

        static {
            AVAILABILITY_HINT_COMPARATOR = Comparator.comparingInt(other -> other.priority);
        }
    }
}

