/*
 * Decompiled with CFR 0.152.
 */
package org.psjava.ds.tree.segmenttree;

import org.psjava.ds.array.Array;
import org.psjava.ds.math.BinaryOperator;
import org.psjava.ds.tree.segmenttree.EnhancedRangeUpdatableSegmentTreeOperator;
import org.psjava.ds.tree.segmenttree.LazyPropagatingSegmentTree;
import org.psjava.ds.tree.segmenttree.SegmentTree;
import org.psjava.formula.Power;

public class RangeUpdatableSegmentTree<T>
implements SegmentTree<T> {
    private LazyPropagatingSegmentTree<T, T> sub;

    public static final <T> RangeUpdatableSegmentTree<T> create(Array<T> initialData, BinaryOperator<T> operator) {
        return new RangeUpdatableSegmentTree<T>(initialData, operator);
    }

    private RangeUpdatableSegmentTree(Array<T> initialData, final BinaryOperator<T> operator) {
        this.sub = new LazyPropagatingSegmentTree(initialData, new EnhancedRangeUpdatableSegmentTreeOperator<T, T>(){

            @Override
            public T mergeRangeValue(T oldRangeValue, int rangeSize, T updateData) {
                return Power.calc(updateData, rangeSize, operator);
            }

            @Override
            public T mergeSingleValue(T v1, T v2) {
                return operator.calc(v1, v2);
            }

            @Override
            public T mergeUpdateData(T oldData, T newData) {
                return newData;
            }
        });
    }

    @Override
    public T query(int start, int end) {
        return this.sub.queryRange(start, end);
    }

    @Override
    public void update(int p, T v) {
        this.updateRange(p, p + 1, v);
    }

    public void updateRange(int start, int end, T value) {
        this.sub.updateRange(start, end, value);
    }

    public String toString() {
        return this.sub.toString();
    }
}

