/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.Snapshot;
import com.codahale.metrics.Timer;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.metrics.CassandraMetricsRegistry;
import org.apache.cassandra.metrics.DecayingEstimatedHistogramReservoir;
import org.apache.cassandra.metrics.DefaultNameFactory;
import org.apache.cassandra.metrics.MetricNameFactory;

public class LatencyMetrics {
    public final LatencyMetricsTimer latency;
    public final Counter totalLatency;
    private List<LatencyMetrics> parents = Lists.newArrayList();
    private final List<LatencyMetrics> children = Lists.newArrayList();
    protected final MetricNameFactory factory;
    protected final MetricNameFactory aliasFactory;
    protected final String namePrefix;

    public LatencyMetrics(String type, String scope) {
        this(type, "", scope);
    }

    public LatencyMetrics(String type, String namePrefix, String scope) {
        this(new DefaultNameFactory(type, scope), namePrefix);
    }

    public LatencyMetrics(MetricNameFactory factory, String namePrefix) {
        this(factory, null, namePrefix);
    }

    public LatencyMetrics(MetricNameFactory factory, MetricNameFactory aliasFactory, String namePrefix) {
        this.factory = factory;
        this.aliasFactory = aliasFactory;
        this.namePrefix = namePrefix;
        LatencyMetricsTimer timer = new LatencyMetricsTimer(new DecayingEstimatedHistogramReservoir());
        LatencyMetricsCounter counter = new LatencyMetricsCounter();
        if (aliasFactory == null) {
            this.latency = CassandraMetricsRegistry.Metrics.register(factory.createMetricName(namePrefix + "Latency"), timer);
            this.totalLatency = CassandraMetricsRegistry.Metrics.register(factory.createMetricName(namePrefix + "TotalLatency"), counter);
        } else {
            this.latency = CassandraMetricsRegistry.Metrics.register(factory.createMetricName(namePrefix + "Latency"), aliasFactory.createMetricName(namePrefix + "Latency"), timer);
            this.totalLatency = CassandraMetricsRegistry.Metrics.register(factory.createMetricName(namePrefix + "TotalLatency"), aliasFactory.createMetricName(namePrefix + "TotalLatency"), counter);
        }
    }

    public LatencyMetrics(MetricNameFactory factory, String namePrefix, LatencyMetrics ... parents) {
        this(factory, null, namePrefix);
        this.parents = Arrays.asList(parents);
        for (LatencyMetrics parent : parents) {
            parent.addChildren(this);
        }
    }

    private void addChildren(LatencyMetrics latencyMetric) {
        this.children.add(latencyMetric);
    }

    private synchronized void removeChildren(LatencyMetrics toRelease) {
        this.latency.releasedLatencyCount += toRelease.latency.getCount();
        DecayingEstimatedHistogramReservoir.EstimatedHistogramReservoirSnapshot childSnapshot = (DecayingEstimatedHistogramReservoir.EstimatedHistogramReservoirSnapshot)toRelease.latency.getSnapshot();
        DecayingEstimatedHistogramReservoir.EstimatedHistogramReservoirSnapshot snapshot = (DecayingEstimatedHistogramReservoir.EstimatedHistogramReservoirSnapshot)this.latency.getSnapshot();
        snapshot.add(childSnapshot);
        snapshot.rebaseReservoir();
        this.totalLatency.inc(toRelease.totalLatency.getCount());
        this.children.removeIf(latencyMetrics -> latencyMetrics.equals(toRelease));
    }

    public void addNano(long nanos) {
        this.latency.update(nanos, TimeUnit.NANOSECONDS);
        this.totalLatency.inc(nanos / 1000L);
    }

    public void release() {
        for (LatencyMetrics parent : this.parents) {
            parent.removeChildren(this);
        }
        if (this.aliasFactory == null) {
            CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "Latency"));
            CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "TotalLatency"));
        } else {
            CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "Latency"), this.aliasFactory.createMetricName(this.namePrefix + "Latency"));
            CassandraMetricsRegistry.Metrics.remove(this.factory.createMetricName(this.namePrefix + "TotalLatency"), this.aliasFactory.createMetricName(this.namePrefix + "TotalLatency"));
        }
    }

    class LatencyMetricsCounter
    extends Counter {
        LatencyMetricsCounter() {
        }

        public long getCount() {
            long count = super.getCount();
            for (LatencyMetrics child : LatencyMetrics.this.children) {
                count += child.totalLatency.getCount();
            }
            return count;
        }
    }

    public class LatencyMetricsTimer
    extends Timer {
        long releasedLatencyCount;

        public LatencyMetricsTimer(Reservoir reservoir) {
            super(reservoir);
            this.releasedLatencyCount = 0L;
        }

        public long getCount() {
            long count = super.getCount() + this.releasedLatencyCount;
            for (LatencyMetrics child : LatencyMetrics.this.children) {
                count += child.latency.getCount();
            }
            return count;
        }

        public double getFifteenMinuteRate() {
            double rate = super.getFifteenMinuteRate();
            for (LatencyMetrics child : LatencyMetrics.this.children) {
                rate += child.latency.getFifteenMinuteRate();
            }
            return rate;
        }

        public double getFiveMinuteRate() {
            double rate = super.getFiveMinuteRate();
            for (LatencyMetrics child : LatencyMetrics.this.children) {
                rate += child.latency.getFiveMinuteRate();
            }
            return rate;
        }

        public double getMeanRate() {
            double rate = super.getMeanRate();
            for (LatencyMetrics child : LatencyMetrics.this.children) {
                rate += child.latency.getMeanRate();
            }
            return rate;
        }

        public double getOneMinuteRate() {
            double rate = super.getOneMinuteRate();
            for (LatencyMetrics child : LatencyMetrics.this.children) {
                rate += child.latency.getOneMinuteRate();
            }
            return rate;
        }

        public Snapshot getSnapshot() {
            DecayingEstimatedHistogramReservoir.EstimatedHistogramReservoirSnapshot parent = (DecayingEstimatedHistogramReservoir.EstimatedHistogramReservoirSnapshot)super.getSnapshot();
            for (LatencyMetrics child : LatencyMetrics.this.children) {
                parent.add(child.latency.getSnapshot());
            }
            return parent;
        }
    }
}

