/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.processing.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.aws2.polly.Polly2Component;

/**
 * Synthesize speech using AWS Polly and AWS SDK version 2.x.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface Aws2PollyComponentBuilderFactory {

    /**
     * AWS Polly (camel-aws2-polly)
     * Synthesize speech using AWS Polly and AWS SDK version 2.x.
     * 
     * Category: cloud,ai
     * Since: 4.18
     * Maven coordinates: org.apache.camel:camel-aws2-polly
     * 
     * @return the dsl builder
     */
    static Aws2PollyComponentBuilder aws2Polly() {
        return new Aws2PollyComponentBuilderImpl();
    }

    /**
     * Builder for the AWS Polly component.
     */
    interface Aws2PollyComponentBuilder extends ComponentBuilder<Polly2Component> {
    
        /**
         * Component configuration.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws2.polly.Polly2Configuration&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param configuration the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder configuration(org.apache.camel.component.aws2.polly.Polly2Configuration configuration) {
            doSetProperty("configuration", configuration);
            return this;
        }
    
        /**
         * The engine to use for synthesis (standard, neural, long-form,
         * generative).
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.polly.model.Engine&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param engine the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder engine(software.amazon.awssdk.services.polly.model.Engine engine) {
            doSetProperty("engine", engine);
            return this;
        }
    
        /**
         * The language code for the synthesis.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param languageCode the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder languageCode(java.lang.String languageCode) {
            doSetProperty("languageCode", languageCode);
            return this;
        }
    
        
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    
        /**
         * The content of the lexicon in PLS format for putLexicon operation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param lexiconContent the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder lexiconContent(java.lang.String lexiconContent) {
            doSetProperty("lexiconContent", lexiconContent);
            return this;
        }
    
        /**
         * The name of the lexicon to use for getLexicon, putLexicon, or
         * deleteLexicon operations.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param lexiconName the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder lexiconName(java.lang.String lexiconName) {
            doSetProperty("lexiconName", lexiconName);
            return this;
        }
    
        /**
         * Lexicon names to apply during synthesis.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param lexiconNames the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder lexiconNames(java.lang.String lexiconNames) {
            doSetProperty("lexiconNames", lexiconNames);
            return this;
        }
    
        
        /**
         * The operation to perform.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.aws2.polly.Polly2Operations&lt;/code&gt; type.
         * 
         * Default: synthesizeSpeech
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder operation(org.apache.camel.component.aws2.polly.Polly2Operations operation) {
            doSetProperty("operation", operation);
            return this;
        }
    
        
        /**
         * The audio output format.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.polly.model.OutputFormat&lt;/code&gt; type.
         * 
         * Default: MP3
         * Group: producer
         * 
         * @param outputFormat the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder outputFormat(software.amazon.awssdk.services.polly.model.OutputFormat outputFormat) {
            doSetProperty("outputFormat", outputFormat);
            return this;
        }
    
        
        /**
         * Set the need for overriding the endpoint. This option needs to be
         * used in combination with the uriEndpointOverride option.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param overrideEndpoint the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder overrideEndpoint(boolean overrideEndpoint) {
            doSetProperty("overrideEndpoint", overrideEndpoint);
            return this;
        }
    
        
        /**
         * If we want to use a POJO request as body or not.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param pojoRequest the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder pojoRequest(boolean pojoRequest) {
            doSetProperty("pojoRequest", pojoRequest);
            return this;
        }
    
        /**
         * The region in which the Polly client needs to work. When using this
         * parameter, the configuration will expect the lowercase name of the
         * region (for example, ap-east-1) You'll need to use the name
         * Region.EU_WEST_1.id().
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param region the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder region(java.lang.String region) {
            doSetProperty("region", region);
            return this;
        }
    
        /**
         * The S3 bucket name for startSpeechSynthesisTask operation output.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param s3Bucket the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder s3Bucket(java.lang.String s3Bucket) {
            doSetProperty("s3Bucket", s3Bucket);
            return this;
        }
    
        /**
         * The S3 key prefix for startSpeechSynthesisTask operation output.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param s3KeyPrefix the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder s3KeyPrefix(java.lang.String s3KeyPrefix) {
            doSetProperty("s3KeyPrefix", s3KeyPrefix);
            return this;
        }
    
        /**
         * The sample rate in Hz for the audio output.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param sampleRate the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder sampleRate(java.lang.String sampleRate) {
            doSetProperty("sampleRate", sampleRate);
            return this;
        }
    
        /**
         * The SNS topic ARN for startSpeechSynthesisTask notifications.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param snsTopicArn the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder snsTopicArn(java.lang.String snsTopicArn) {
            doSetProperty("snsTopicArn", snsTopicArn);
            return this;
        }
    
        /**
         * The task ID for getSpeechSynthesisTask operation.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param taskId the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder taskId(java.lang.String taskId) {
            doSetProperty("taskId", taskId);
            return this;
        }
    
        
        /**
         * The type of text input (text or ssml).
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.polly.model.TextType&lt;/code&gt; type.
         * 
         * Default: TEXT
         * Group: producer
         * 
         * @param textType the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder textType(software.amazon.awssdk.services.polly.model.TextType textType) {
            doSetProperty("textType", textType);
            return this;
        }
    
        /**
         * Set the overriding uri endpoint. This option needs to be used in
         * combination with overrideEndpoint option.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param uriEndpointOverride the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder uriEndpointOverride(java.lang.String uriEndpointOverride) {
            doSetProperty("uriEndpointOverride", uriEndpointOverride);
            return this;
        }
    
        /**
         * The voice ID to use for synthesis.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.polly.model.VoiceId&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param voiceId the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder voiceId(software.amazon.awssdk.services.polly.model.VoiceId voiceId) {
            doSetProperty("voiceId", voiceId);
            return this;
        }
    
        
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder autowiredEnabled(boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
    
        /**
         * To use an existing configured AWS Polly client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.services.polly.PollyClient&lt;/code&gt; type.
         * 
         * Group: advanced
         * 
         * @param pollyClient the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder pollyClient(software.amazon.awssdk.services.polly.PollyClient pollyClient) {
            doSetProperty("pollyClient", pollyClient);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all consumer based health checks from
         * this component.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckConsumerEnabled the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder healthCheckConsumerEnabled(boolean healthCheckConsumerEnabled) {
            doSetProperty("healthCheckConsumerEnabled", healthCheckConsumerEnabled);
            return this;
        }
    
        
        /**
         * Used for enabling or disabling all producer based health checks from
         * this component. Notice: Camel has by default disabled all producer
         * based health-checks. You can turn on producer checks globally by
         * setting camel.health.producersEnabled=true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: health
         * 
         * @param healthCheckProducerEnabled the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder healthCheckProducerEnabled(boolean healthCheckProducerEnabled) {
            doSetProperty("healthCheckProducerEnabled", healthCheckProducerEnabled);
            return this;
        }
    
        /**
         * To define a proxy host when instantiating the Polly client.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyHost the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder proxyHost(java.lang.String proxyHost) {
            doSetProperty("proxyHost", proxyHost);
            return this;
        }
    
        /**
         * To define a proxy port when instantiating the Polly client.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: proxy
         * 
         * @param proxyPort the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder proxyPort(java.lang.Integer proxyPort) {
            doSetProperty("proxyPort", proxyPort);
            return this;
        }
    
        
        /**
         * To define a proxy protocol when instantiating the Polly client.
         * 
         * The option is a:
         * &lt;code&gt;software.amazon.awssdk.core.Protocol&lt;/code&gt; type.
         * 
         * Default: HTTPS
         * Group: proxy
         * 
         * @param proxyProtocol the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder proxyProtocol(software.amazon.awssdk.core.Protocol proxyProtocol) {
            doSetProperty("proxyProtocol", proxyProtocol);
            return this;
        }
    
        /**
         * Amazon AWS Access Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder accessKey(java.lang.String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
    
        /**
         * If using a profile credentials provider, this parameter will set the
         * profile name.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param profileCredentialsName the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder profileCredentialsName(java.lang.String profileCredentialsName) {
            doSetProperty("profileCredentialsName", profileCredentialsName);
            return this;
        }
    
        /**
         * Amazon AWS Secret Key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param secretKey the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder secretKey(java.lang.String secretKey) {
            doSetProperty("secretKey", secretKey);
            return this;
        }
    
        /**
         * Amazon AWS Session Token used when the user needs to assume an IAM
         * role.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sessionToken the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder sessionToken(java.lang.String sessionToken) {
            doSetProperty("sessionToken", sessionToken);
            return this;
        }
    
        
        /**
         * If we want to trust all certificates in case of overriding the
         * endpoint.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param trustAllCertificates the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder trustAllCertificates(boolean trustAllCertificates) {
            doSetProperty("trustAllCertificates", trustAllCertificates);
            return this;
        }
    
        
        /**
         * Set whether the Polly client should expect to load credentials
         * through a default credentials provider or to expect static
         * credentials to be passed in.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useDefaultCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder useDefaultCredentialsProvider(boolean useDefaultCredentialsProvider) {
            doSetProperty("useDefaultCredentialsProvider", useDefaultCredentialsProvider);
            return this;
        }
    
        
        /**
         * Set whether the Polly client should expect to load credentials
         * through a profile credentials provider.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useProfileCredentialsProvider the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder useProfileCredentialsProvider(boolean useProfileCredentialsProvider) {
            doSetProperty("useProfileCredentialsProvider", useProfileCredentialsProvider);
            return this;
        }
    
        
        /**
         * Set whether the Polly client should expect to use Session
         * Credentials. This is useful in a situation in which the user needs to
         * assume an IAM role for doing operations in Polly.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: security
         * 
         * @param useSessionCredentials the value to set
         * @return the dsl builder
         */
        default Aws2PollyComponentBuilder useSessionCredentials(boolean useSessionCredentials) {
            doSetProperty("useSessionCredentials", useSessionCredentials);
            return this;
        }
    }

    class Aws2PollyComponentBuilderImpl
            extends AbstractComponentBuilder<Polly2Component>
            implements Aws2PollyComponentBuilder {
        @Override
        protected Polly2Component buildConcreteComponent() {
            return new Polly2Component();
        }
        private org.apache.camel.component.aws2.polly.Polly2Configuration getOrCreateConfiguration(Polly2Component component) {
            if (component.getConfiguration() == null) {
                component.setConfiguration(new org.apache.camel.component.aws2.polly.Polly2Configuration());
            }
            return component.getConfiguration();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "configuration": ((Polly2Component) component).setConfiguration((org.apache.camel.component.aws2.polly.Polly2Configuration) value); return true;
            case "engine": getOrCreateConfiguration((Polly2Component) component).setEngine((software.amazon.awssdk.services.polly.model.Engine) value); return true;
            case "languageCode": getOrCreateConfiguration((Polly2Component) component).setLanguageCode((java.lang.String) value); return true;
            case "lazyStartProducer": ((Polly2Component) component).setLazyStartProducer((boolean) value); return true;
            case "lexiconContent": getOrCreateConfiguration((Polly2Component) component).setLexiconContent((java.lang.String) value); return true;
            case "lexiconName": getOrCreateConfiguration((Polly2Component) component).setLexiconName((java.lang.String) value); return true;
            case "lexiconNames": getOrCreateConfiguration((Polly2Component) component).setLexiconNames((java.lang.String) value); return true;
            case "operation": getOrCreateConfiguration((Polly2Component) component).setOperation((org.apache.camel.component.aws2.polly.Polly2Operations) value); return true;
            case "outputFormat": getOrCreateConfiguration((Polly2Component) component).setOutputFormat((software.amazon.awssdk.services.polly.model.OutputFormat) value); return true;
            case "overrideEndpoint": getOrCreateConfiguration((Polly2Component) component).setOverrideEndpoint((boolean) value); return true;
            case "pojoRequest": getOrCreateConfiguration((Polly2Component) component).setPojoRequest((boolean) value); return true;
            case "region": getOrCreateConfiguration((Polly2Component) component).setRegion((java.lang.String) value); return true;
            case "s3Bucket": getOrCreateConfiguration((Polly2Component) component).setS3Bucket((java.lang.String) value); return true;
            case "s3KeyPrefix": getOrCreateConfiguration((Polly2Component) component).setS3KeyPrefix((java.lang.String) value); return true;
            case "sampleRate": getOrCreateConfiguration((Polly2Component) component).setSampleRate((java.lang.String) value); return true;
            case "snsTopicArn": getOrCreateConfiguration((Polly2Component) component).setSnsTopicArn((java.lang.String) value); return true;
            case "taskId": getOrCreateConfiguration((Polly2Component) component).setTaskId((java.lang.String) value); return true;
            case "textType": getOrCreateConfiguration((Polly2Component) component).setTextType((software.amazon.awssdk.services.polly.model.TextType) value); return true;
            case "uriEndpointOverride": getOrCreateConfiguration((Polly2Component) component).setUriEndpointOverride((java.lang.String) value); return true;
            case "voiceId": getOrCreateConfiguration((Polly2Component) component).setVoiceId((software.amazon.awssdk.services.polly.model.VoiceId) value); return true;
            case "autowiredEnabled": ((Polly2Component) component).setAutowiredEnabled((boolean) value); return true;
            case "pollyClient": getOrCreateConfiguration((Polly2Component) component).setPollyClient((software.amazon.awssdk.services.polly.PollyClient) value); return true;
            case "healthCheckConsumerEnabled": ((Polly2Component) component).setHealthCheckConsumerEnabled((boolean) value); return true;
            case "healthCheckProducerEnabled": ((Polly2Component) component).setHealthCheckProducerEnabled((boolean) value); return true;
            case "proxyHost": getOrCreateConfiguration((Polly2Component) component).setProxyHost((java.lang.String) value); return true;
            case "proxyPort": getOrCreateConfiguration((Polly2Component) component).setProxyPort((java.lang.Integer) value); return true;
            case "proxyProtocol": getOrCreateConfiguration((Polly2Component) component).setProxyProtocol((software.amazon.awssdk.core.Protocol) value); return true;
            case "accessKey": getOrCreateConfiguration((Polly2Component) component).setAccessKey((java.lang.String) value); return true;
            case "profileCredentialsName": getOrCreateConfiguration((Polly2Component) component).setProfileCredentialsName((java.lang.String) value); return true;
            case "secretKey": getOrCreateConfiguration((Polly2Component) component).setSecretKey((java.lang.String) value); return true;
            case "sessionToken": getOrCreateConfiguration((Polly2Component) component).setSessionToken((java.lang.String) value); return true;
            case "trustAllCertificates": getOrCreateConfiguration((Polly2Component) component).setTrustAllCertificates((boolean) value); return true;
            case "useDefaultCredentialsProvider": getOrCreateConfiguration((Polly2Component) component).setUseDefaultCredentialsProvider((boolean) value); return true;
            case "useProfileCredentialsProvider": getOrCreateConfiguration((Polly2Component) component).setUseProfileCredentialsProvider((boolean) value); return true;
            case "useSessionCredentials": getOrCreateConfiguration((Polly2Component) component).setUseSessionCredentials((boolean) value); return true;
            default: return false;
            }
        }
    }
}