/* Generated by camel build tools - do NOT edit this file! */
/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.processing.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Perform document understanding and search using IBM Watson Discovery
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface WatsonDiscoveryEndpointBuilderFactory {

    /**
     * Builder for endpoint for the IBM Watson Discovery component.
     */
    public interface WatsonDiscoveryEndpointBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedWatsonDiscoveryEndpointBuilder advanced() {
            return (AdvancedWatsonDiscoveryEndpointBuilder) this;
        }

        /**
         * The Watson Discovery project ID.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: common
         * 
         * @param projectId the value to set
         * @return the dsl builder
         */
        default WatsonDiscoveryEndpointBuilder projectId(String projectId) {
            doSetProperty("projectId", projectId);
            return this;
        }
        /**
         * The service endpoint URL. If not specified, the default URL will be
         * used.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: common
         * 
         * @param serviceUrl the value to set
         * @return the dsl builder
         */
        default WatsonDiscoveryEndpointBuilder serviceUrl(String serviceUrl) {
            doSetProperty("serviceUrl", serviceUrl);
            return this;
        }
        /**
         * The API version date (format: YYYY-MM-DD).
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Default: 2023-03-31
         * Group: common
         * 
         * @param version the value to set
         * @return the dsl builder
         */
        default WatsonDiscoveryEndpointBuilder version(String version) {
            doSetProperty("version", version);
            return this;
        }
        /**
         * The collection ID for operations that require it.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Group: producer
         * 
         * @param collectionId the value to set
         * @return the dsl builder
         */
        default WatsonDiscoveryEndpointBuilder collectionId(String collectionId) {
            doSetProperty("collectionId", collectionId);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option is a:
         * <code>org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default WatsonDiscoveryEndpointBuilder operation(org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryOperations operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The operation to perform.
         * 
         * The option will be converted to a
         * <code>org.apache.camel.component.ibm.watson.discovery.WatsonDiscoveryOperations</code> type.
         * 
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default WatsonDiscoveryEndpointBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The IBM Cloud API key for authentication.
         * 
         * The option is a: <code>java.lang.String</code> type.
         * 
         * Required: true
         * Group: security
         * 
         * @param apiKey the value to set
         * @return the dsl builder
         */
        default WatsonDiscoveryEndpointBuilder apiKey(String apiKey) {
            doSetProperty("apiKey", apiKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the IBM Watson Discovery component.
     */
    public interface AdvancedWatsonDiscoveryEndpointBuilder
            extends
                EndpointProducerBuilder {
        default WatsonDiscoveryEndpointBuilder basic() {
            return (WatsonDiscoveryEndpointBuilder) this;
        }

        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonDiscoveryEndpointBuilder lazyStartProducer(boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a <code>boolean</code> type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedWatsonDiscoveryEndpointBuilder lazyStartProducer(String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    public interface WatsonDiscoveryBuilders {
        /**
         * IBM Watson Discovery (camel-ibm-watson-discovery)
         * Perform document understanding and search using IBM Watson Discovery
         * 
         * Category: ai,cloud
         * Since: 4.16
         * Maven coordinates: org.apache.camel:camel-ibm-watson-discovery
         * 
         * @return the dsl builder for the headers' name.
         */
        default WatsonDiscoveryHeaderNameBuilder ibmWatsonDiscovery() {
            return WatsonDiscoveryHeaderNameBuilder.INSTANCE;
        }
        /**
         * IBM Watson Discovery (camel-ibm-watson-discovery)
         * Perform document understanding and search using IBM Watson Discovery
         * 
         * Category: ai,cloud
         * Since: 4.16
         * Maven coordinates: org.apache.camel:camel-ibm-watson-discovery
         * 
         * Syntax: <code>ibm-watson-discovery:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param path label
         * @return the dsl builder
         */
        default WatsonDiscoveryEndpointBuilder ibmWatsonDiscovery(String path) {
            return WatsonDiscoveryEndpointBuilderFactory.endpointBuilder("ibm-watson-discovery", path);
        }
        /**
         * IBM Watson Discovery (camel-ibm-watson-discovery)
         * Perform document understanding and search using IBM Watson Discovery
         * 
         * Category: ai,cloud
         * Since: 4.16
         * Maven coordinates: org.apache.camel:camel-ibm-watson-discovery
         * 
         * Syntax: <code>ibm-watson-discovery:label</code>
         * 
         * Path parameter: label (required)
         * Logical name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path label
         * @return the dsl builder
         */
        default WatsonDiscoveryEndpointBuilder ibmWatsonDiscovery(String componentName, String path) {
            return WatsonDiscoveryEndpointBuilderFactory.endpointBuilder(componentName, path);
        }

    }
    /**
     * The builder of headers' name for the IBM Watson Discovery component.
     */
    public static class WatsonDiscoveryHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final WatsonDiscoveryHeaderNameBuilder INSTANCE = new WatsonDiscoveryHeaderNameBuilder();

        /**
         * The operation to perform.
         * 
         * The option is a: {@code WatsonDiscoveryOperations} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonDiscoveryOperation}.
         */
        public String iBMWatsonDiscoveryOperation() {
            return "CamelIBMWatsonDiscoveryOperation";
        }
        /**
         * The natural language query to execute.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonDiscoveryQuery}.
         */
        public String iBMWatsonDiscoveryQuery() {
            return "CamelIBMWatsonDiscoveryQuery";
        }
        /**
         * The number of results to return.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonDiscoveryCount}.
         */
        public String iBMWatsonDiscoveryCount() {
            return "CamelIBMWatsonDiscoveryCount";
        }
        /**
         * The filter to apply to the query.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonDiscoveryFilter}.
         */
        public String iBMWatsonDiscoveryFilter() {
            return "CamelIBMWatsonDiscoveryFilter";
        }
        /**
         * The collection ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonDiscoveryCollectionId}.
         */
        public String iBMWatsonDiscoveryCollectionId() {
            return "CamelIBMWatsonDiscoveryCollectionId";
        }
        /**
         * The collection name.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonDiscoveryCollectionName}.
         */
        public String iBMWatsonDiscoveryCollectionName() {
            return "CamelIBMWatsonDiscoveryCollectionName";
        }
        /**
         * The collection description.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonDiscoveryCollectionDescription}.
         */
        public String iBMWatsonDiscoveryCollectionDescription() {
            return "CamelIBMWatsonDiscoveryCollectionDescription";
        }
        /**
         * The document ID.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code IBMWatsonDiscoveryDocumentId}.
         */
        public String iBMWatsonDiscoveryDocumentId() {
            return "CamelIBMWatsonDiscoveryDocumentId";
        }
        /**
         * The document file.
         * 
         * The option is a: {@code java.io.InputStream} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonDiscoveryDocumentFile}.
         */
        public String iBMWatsonDiscoveryDocumentFile() {
            return "CamelIBMWatsonDiscoveryDocumentFile";
        }
        /**
         * The document filename.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonDiscoveryDocumentFilename}.
         */
        public String iBMWatsonDiscoveryDocumentFilename() {
            return "CamelIBMWatsonDiscoveryDocumentFilename";
        }
        /**
         * The document content type.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * IBMWatsonDiscoveryDocumentContentType}.
         */
        public String iBMWatsonDiscoveryDocumentContentType() {
            return "CamelIBMWatsonDiscoveryDocumentContentType";
        }
    }
    static WatsonDiscoveryEndpointBuilder endpointBuilder(String componentName, String path) {
        class WatsonDiscoveryEndpointBuilderImpl extends AbstractEndpointBuilder implements WatsonDiscoveryEndpointBuilder, AdvancedWatsonDiscoveryEndpointBuilder {
            public WatsonDiscoveryEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new WatsonDiscoveryEndpointBuilderImpl(path);
    }
}