/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.impl.DatagramPacketImpl;
import io.vertx.core.datagram.impl.DatagramSocketImpl;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.net.impl.VertxHandler;
import java.net.InetSocketAddress;

final class DatagramServerHandler
extends VertxHandler<DatagramSocketImpl.Connection> {
    private final DatagramSocketImpl socket;

    DatagramServerHandler(DatagramSocketImpl socket) {
        this.socket = socket;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.setConnection(this.socket.createConnection(ctx));
    }

    @Override
    protected void handleMessage(DatagramSocketImpl.Connection server, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
        server.handlePacket((DatagramPacket)msg);
    }

    @Override
    protected Object decode(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof io.netty.channel.socket.DatagramPacket) {
            io.netty.channel.socket.DatagramPacket packet = (io.netty.channel.socket.DatagramPacket)msg;
            ByteBuf content = (ByteBuf)packet.content();
            if (content.isDirect()) {
                content = DatagramServerHandler.safeBuffer(content, allocator);
            }
            return new DatagramPacketImpl((InetSocketAddress)packet.sender(), Buffer.buffer(content));
        }
        return msg;
    }
}

