/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.bridge;

import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class AMQPBridgeMetrics {
    private final AMQPBridgeMetrics parent;
    private static final AtomicLongFieldUpdater<AMQPBridgeMetrics> MESSAGES_SENT_UPDATER = AtomicLongFieldUpdater.newUpdater(AMQPBridgeMetrics.class, "messagesSent");
    private static final AtomicLongFieldUpdater<AMQPBridgeMetrics> MESSAGES_RECEIVED_UPDATER = AtomicLongFieldUpdater.newUpdater(AMQPBridgeMetrics.class, "messagesReceived");
    private volatile long messagesSent;
    private volatile long messagesReceived;

    public AMQPBridgeMetrics() {
        this(null);
    }

    private AMQPBridgeMetrics(AMQPBridgeMetrics parent) {
        this.parent = parent;
    }

    public long getMessagesSent() {
        return this.messagesSent;
    }

    public long getMessagesReceived() {
        return this.messagesReceived;
    }

    AMQPBridgeMetrics newPolicyMetrics() {
        return new AMQPBridgeMetrics(this);
    }

    ReceiverMetrics newReceiverMetrics() {
        return new ReceiverMetrics(this);
    }

    SenderMetrics newSenderMetrics() {
        return new SenderMetrics(this);
    }

    private void incrementMessagesSent() {
        MESSAGES_SENT_UPDATER.incrementAndGet(this);
        if (this.parent != null) {
            this.parent.incrementMessagesSent();
        }
    }

    private void incrementMessagesReceived() {
        MESSAGES_RECEIVED_UPDATER.incrementAndGet(this);
        if (this.parent != null) {
            this.parent.incrementMessagesReceived();
        }
    }

    public static class ReceiverMetrics {
        private static final AtomicLongFieldUpdater<ReceiverMetrics> MESSAGES_RECEIVED_UPDATER = AtomicLongFieldUpdater.newUpdater(ReceiverMetrics.class, "messagesReceived");
        private final AMQPBridgeMetrics parent;
        private volatile long messagesReceived;

        private ReceiverMetrics(AMQPBridgeMetrics parent) {
            this.parent = parent;
        }

        public long getMessagesReceived() {
            return this.messagesReceived;
        }

        public void incrementMessagesReceived() {
            MESSAGES_RECEIVED_UPDATER.incrementAndGet(this);
            this.parent.incrementMessagesReceived();
        }
    }

    public static class SenderMetrics {
        private static final AtomicLongFieldUpdater<SenderMetrics> MESSAGES_SENT_UPDATER = AtomicLongFieldUpdater.newUpdater(SenderMetrics.class, "messagesSent");
        private final AMQPBridgeMetrics parent;
        private volatile long messagesSent;

        private SenderMetrics(AMQPBridgeMetrics parent) {
            this.parent = parent;
        }

        public long getMessagesSent() {
            return this.messagesSent;
        }

        public void incrementMessagesSent() {
            MESSAGES_SENT_UPDATER.incrementAndGet(this);
            this.parent.incrementMessagesSent();
        }
    }
}

