/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.internal;

import java.nio.charset.Charset;
import java.util.Objects;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Fields;

public class CachedQueryFields
extends Fields {
    private final String _query;
    private final Charset _charset;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CachedQueryFields getCached(Request request, Charset charset) {
        String query = request.getHttpURI().getQuery();
        Object object = request.getAttribute(CachedQueryFields.class.getName());
        if (!(object instanceof CachedQueryFields)) return null;
        CachedQueryFields cached = (CachedQueryFields)((Object)object);
        if (!Objects.equals(query, cached._query)) return null;
        if (!Objects.equals(charset, cached._charset)) return null;
        CachedQueryFields cachedQueryFields = cached;
        return cachedQueryFields;
    }

    public static void setCached(Request request, CachedQueryFields fields) {
        request.setAttribute(CachedQueryFields.class.getName(), (Object)fields);
    }

    public CachedQueryFields(String query, Charset charset) {
        super(true);
        this._query = query;
        this._charset = charset;
    }

    public String getQuery() {
        return this._query;
    }

    public Charset getCharset() {
        return this._charset;
    }
}

