/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.camel.model.Block;
import org.apache.camel.model.CopyableDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.OutputNode;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.spi.Metadata;

@Metadata(label="eip,routing,error")
@XmlRootElement(name="onFallback")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class OnFallbackDefinition
extends OptionalIdentifiedDefinition<OnFallbackDefinition>
implements CopyableDefinition<OnFallbackDefinition>,
Block,
OutputNode {
    @XmlTransient
    private ProcessorDefinition<?> parent;
    @XmlAttribute
    @Metadata(label="advanced", defaultValue="false", javaType="java.lang.Boolean")
    private String fallbackViaNetwork;
    @XmlElementRef
    private List<ProcessorDefinition<?>> outputs = new ArrayList();

    public OnFallbackDefinition() {
    }

    protected OnFallbackDefinition(OnFallbackDefinition source) {
        super(source);
        this.parent = source.parent;
        this.fallbackViaNetwork = source.fallbackViaNetwork;
        this.outputs = ProcessorDefinitionHelper.deepCopyDefinitions(source.outputs);
    }

    @Override
    public OnFallbackDefinition copyDefinition() {
        return new OnFallbackDefinition(this);
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        this.outputs = outputs;
    }

    public String toString() {
        if (Boolean.toString(true).equals(this.fallbackViaNetwork)) {
            return "OnFallbackViaNetwork[" + String.valueOf(this.getOutputs()) + "]";
        }
        if (this.fallbackViaNetwork == null || Boolean.toString(false).equals(this.fallbackViaNetwork)) {
            return "OnFallback[" + String.valueOf(this.getOutputs()) + "]";
        }
        return "OnFallback[viaNetwork=" + this.fallbackViaNetwork + "," + String.valueOf(this.getOutputs()) + "]";
    }

    public String getShortName() {
        return "onFallback";
    }

    public String getLabel() {
        Object name = Boolean.toString(true).equals(this.fallbackViaNetwork) ? "OnFallbackViaNetwork" : (this.fallbackViaNetwork == null || Boolean.toString(false).equals(this.fallbackViaNetwork) ? "onFallback" : "onFallback(viaNetwork=" + this.fallbackViaNetwork + ")");
        return this.getOutputs().stream().map(ProcessorDefinition::getLabel).collect(Collectors.joining(",", (String)name + "[", "]"));
    }

    public String getFallbackViaNetwork() {
        return this.fallbackViaNetwork;
    }

    public void setFallbackViaNetwork(String fallbackViaNetwork) {
        this.fallbackViaNetwork = fallbackViaNetwork;
    }

    @Override
    public ProcessorDefinition<?> getParent() {
        return this.parent;
    }

    public void setParent(ProcessorDefinition<?> parent) {
        this.parent = parent;
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        this.outputs.add(output);
    }
}

