/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task.budget;

import java.time.Duration;
import java.time.Instant;
import org.apache.camel.support.task.budget.TimeBudget;

public class TimeBoundedBudget
implements TimeBudget {
    public static final long UNLIMITED_DURATION = -1L;
    private final long initialDelay;
    private final long interval;
    private final long maxDuration;
    private final Instant startTime;

    TimeBoundedBudget(long initialDelay, long interval, long maxDuration) {
        this.initialDelay = initialDelay;
        this.interval = interval;
        this.maxDuration = maxDuration;
        this.startTime = Instant.now();
    }

    @Override
    public long maxDuration() {
        return this.maxDuration;
    }

    @Override
    public long initialDelay() {
        return this.initialDelay;
    }

    @Override
    public long interval() {
        return this.interval;
    }

    @Override
    public boolean canContinue() {
        if (this.maxDuration == -1L) {
            return true;
        }
        return this.elapsed().toMillis() < this.maxDuration;
    }

    @Override
    public boolean next() {
        return true;
    }

    @Override
    public Duration elapsed() {
        return Duration.between(this.startTime, Instant.now());
    }
}

