/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.codec.impl;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.codec.Data;
import org.apache.qpid.proton.codec.impl.ArrayElement;
import org.apache.qpid.proton.codec.impl.AtomicElement;
import org.apache.qpid.proton.codec.impl.Element;

class SymbolElement
extends AtomicElement<Symbol> {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private final Symbol _value;

    SymbolElement(Element parent, Element prev, Symbol s) {
        super(parent, prev);
        this._value = s;
    }

    @Override
    public int size() {
        int length = this._value.length();
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (length > 255) {
                    parent.setConstructorType(ArrayElement.LARGE);
                    return 4 + length;
                }
                return 1 + length;
            }
            return 4 + length;
        }
        if (length > 255) {
            return 5 + length;
        }
        return 2 + length;
    }

    @Override
    public Symbol getValue() {
        return this._value;
    }

    @Override
    public Data.DataType getDataType() {
        return Data.DataType.SYMBOL;
    }

    @Override
    public int encode(ByteBuffer b) {
        int size = this.size();
        if (b.remaining() < size) {
            return 0;
        }
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.SMALL) {
                b.put((byte)this._value.length());
            } else {
                b.putInt(this._value.length());
            }
        } else if (this._value.length() <= 255) {
            b.put((byte)-93);
            b.put((byte)this._value.length());
        } else {
            b.put((byte)-77);
            b.put((byte)this._value.length());
        }
        b.put(this._value.toString().getBytes(ASCII));
        return size;
    }
}

