/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.req;

import java.util.ArrayList;
import org.apache.datasketches.memory.Buffer;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableBuffer;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.req.FloatBuffer;
import org.apache.datasketches.req.ReqCompactor;
import org.apache.datasketches.req.ReqSketch;

class ReqSerDe {
    private static final byte SER_VER = 1;
    private static final byte FAMILY_ID = 17;

    ReqSerDe() {
    }

    static ReqSketch heapify(Memory mem) {
        Buffer buff = mem.asBuffer();
        byte preInts = buff.getByte();
        byte serVer = buff.getByte();
        assert (serVer == 1);
        byte familyId = buff.getByte();
        assert (familyId == 17);
        int flags = buff.getByte() & 0xFF;
        boolean empty = (flags & 4) > 0;
        boolean hra = (flags & 8) > 0;
        boolean rawItems = (flags & 0x10) > 0;
        boolean lvl0Sorted = (flags & 0x20) > 0;
        int k = buff.getShort() & 0xFFFF;
        int numCompactors = buff.getByte() & 0xFF;
        int numRawItems = buff.getByte() & 0xFF;
        SerDeFormat deserFormat = ReqSerDe.getDeserFormat(empty, rawItems, numCompactors);
        switch (deserFormat) {
            case EMPTY: {
                assert (preInts == 2);
                return new ReqSketch(k, hra, null);
            }
            case RAWITEMS: {
                assert (preInts == 2);
                ReqSketch sk = new ReqSketch(k, hra, null);
                for (int i = 0; i < numRawItems; ++i) {
                    sk.update(buff.getFloat());
                }
                return sk;
            }
            case EXACT: {
                assert (preInts == 2);
                Compactor compactor = ReqSerDe.extractCompactor(buff, lvl0Sorted, hra);
                long totalN = compactor.count;
                float minItem = compactor.minItem;
                float maxItem = compactor.maxItem;
                ArrayList<ReqCompactor> compactors = new ArrayList<ReqCompactor>();
                compactors.add(compactor.reqCompactor);
                ReqSketch sk = new ReqSketch(k, hra, totalN, minItem, maxItem, compactors);
                sk.setMaxNomSize(sk.computeMaxNomSize());
                sk.setRetainedItems(sk.computeTotalRetainedItems());
                return sk;
            }
        }
        assert (preInts == 4);
        long totalN = buff.getLong();
        float minItem = buff.getFloat();
        float maxItem = buff.getFloat();
        ArrayList<ReqCompactor> compactors = new ArrayList<ReqCompactor>();
        for (int i = 0; i < numCompactors; ++i) {
            boolean level0sorted = i == 0 ? lvl0Sorted : true;
            Compactor compactor = ReqSerDe.extractCompactor(buff, level0sorted, hra);
            compactors.add(compactor.reqCompactor);
        }
        ReqSketch sk = new ReqSketch(k, hra, totalN, minItem, maxItem, compactors);
        sk.setMaxNomSize(sk.computeMaxNomSize());
        sk.setRetainedItems(sk.computeTotalRetainedItems());
        return sk;
    }

    static final Compactor extractCompactor(Buffer buff, boolean lvl0Sorted, boolean hra) {
        long state = buff.getLong();
        float sectionSizeFlt = buff.getFloat();
        int sectionSize = Math.round(sectionSizeFlt);
        byte lgWt = buff.getByte();
        byte numSections = buff.getByte();
        buff.incrementPosition(2L);
        int count = buff.getInt();
        float[] arr = new float[count];
        buff.getFloatArray(arr, 0, count);
        float minItem = Float.MAX_VALUE;
        float maxItem = Float.MIN_VALUE;
        for (int i = 0; i < count; ++i) {
            minItem = Math.min(minItem, arr[i]);
            maxItem = Math.max(maxItem, arr[i]);
        }
        int delta = 2 * sectionSize * numSections;
        int nomCap = 2 * delta;
        int cap = Math.max(count, nomCap);
        FloatBuffer fltBuf = FloatBuffer.reconstruct(arr, count, cap, delta, lvl0Sorted, hra);
        ReqCompactor reqCompactor = new ReqCompactor(lgWt, hra, state, sectionSizeFlt, numSections, fltBuf);
        return new Compactor(reqCompactor, minItem, maxItem, count);
    }

    private static byte getFlags(ReqSketch sk) {
        boolean rawItems = sk.getN() <= 4L;
        boolean level0Sorted = sk.getCompactors().get(0).getBuffer().isSorted();
        int flags = (sk.isEmpty() ? 4 : 0) | (sk.getHighRankAccuracyMode() ? 8 : 0) | (rawItems ? 16 : 0) | (level0Sorted ? 32 : 0);
        return (byte)flags;
    }

    static SerDeFormat getSerFormat(ReqSketch sk) {
        if (sk.isEmpty()) {
            return SerDeFormat.EMPTY;
        }
        if (sk.getN() <= 4L) {
            return SerDeFormat.RAWITEMS;
        }
        if (sk.getNumLevels() == 1) {
            return SerDeFormat.EXACT;
        }
        return SerDeFormat.ESTIMATION;
    }

    private static SerDeFormat getDeserFormat(boolean empty, boolean rawItems, int numCompactors) {
        if (numCompactors <= 1) {
            if (empty) {
                return SerDeFormat.EMPTY;
            }
            if (rawItems) {
                return SerDeFormat.RAWITEMS;
            }
            return SerDeFormat.EXACT;
        }
        return SerDeFormat.ESTIMATION;
    }

    static byte[] toByteArray(ReqSketch sk) {
        SerDeFormat serDeFormat = ReqSerDe.getSerFormat(sk);
        int bytes = ReqSerDe.getSerBytes(sk, serDeFormat);
        byte[] arr = new byte[bytes];
        WritableBuffer wbuf = WritableMemory.writableWrap((byte[])arr).asWritableBuffer();
        byte preInts = (byte)(serDeFormat == SerDeFormat.ESTIMATION ? 4 : 2);
        byte flags = ReqSerDe.getFlags(sk);
        int numCompactors = (byte)(sk.isEmpty() ? 0 : (byte)sk.getNumLevels());
        int numRawItems = sk.getN() <= 4L ? (int)((int)sk.getN()) : 0;
        wbuf.putByte(preInts);
        wbuf.putByte((byte)1);
        wbuf.putByte((byte)17);
        wbuf.putByte(flags);
        wbuf.putShort((short)sk.getK());
        wbuf.putByte((byte)numCompactors);
        wbuf.putByte((byte)numRawItems);
        switch (serDeFormat) {
            case EMPTY: {
                assert (wbuf.getPosition() == (long)bytes);
                return arr;
            }
            case RAWITEMS: {
                ReqCompactor c0 = sk.getCompactors().get(0);
                FloatBuffer fbuf = c0.getBuffer();
                for (int i = 0; i < numRawItems; ++i) {
                    wbuf.putFloat(fbuf.getItem(i));
                }
                assert (wbuf.getPosition() == (long)bytes);
                return arr;
            }
            case EXACT: {
                ReqCompactor c0 = sk.getCompactors().get(0);
                wbuf.putByteArray(c0.toByteArray(), 0, c0.getSerializationBytes());
                assert (wbuf.getPosition() == (long)bytes);
                return arr;
            }
        }
        wbuf.putLong(sk.getN());
        wbuf.putFloat(sk.getMinItem());
        wbuf.putFloat(sk.getMaxItem());
        for (int i = 0; i < numCompactors; ++i) {
            ReqCompactor c = sk.getCompactors().get(i);
            wbuf.putByteArray(c.toByteArray(), 0, c.getSerializationBytes());
        }
        assert (wbuf.getPosition() == (long)bytes) : wbuf.getPosition() + ", " + bytes;
        return arr;
    }

    static int getSerBytes(ReqSketch sk, SerDeFormat serDeFormat) {
        switch (serDeFormat) {
            case EMPTY: {
                return 8;
            }
            case RAWITEMS: {
                return sk.getCompactors().get(0).getBuffer().getCount() * 4 + 8;
            }
            case EXACT: {
                return sk.getCompactors().get(0).getSerializationBytes() + 8;
            }
        }
        int cBytes = 0;
        for (int i = 0; i < sk.getNumLevels(); ++i) {
            cBytes += sk.getCompactors().get(i).getSerializationBytes();
        }
        return cBytes + 24;
    }

    static class Compactor {
        ReqCompactor reqCompactor;
        float minItem;
        float maxItem;
        int count;

        Compactor(ReqCompactor reqCompactor, float minItem, float maxItem, int count) {
            this.reqCompactor = reqCompactor;
            this.minItem = minItem;
            this.maxItem = maxItem;
            this.count = count;
        }
    }

    static enum SerDeFormat {
        EMPTY,
        RAWITEMS,
        EXACT,
        ESTIMATION;

    }
}

