/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Range;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.file.FileOperations;
import org.apache.accumulo.core.file.FileSKVIterator;
import org.apache.accumulo.core.file.FileSKVWriter;
import org.apache.accumulo.core.file.rfile.RFileOperations;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iteratorsImpl.system.MultiIterator;
import org.apache.accumulo.core.metadata.TabletFile;
import org.apache.accumulo.server.ServerContext;
import org.apache.accumulo.server.conf.TableConfiguration;
import org.apache.accumulo.server.fs.VolumeManager;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.WritableComparable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final SecureRandom random = new SecureRandom();
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    private static Path createTmpDir(ServerContext context, String tabletDirectory) throws IOException {
        VolumeManager fs = context.getVolumeManager();
        Path result = null;
        while (result == null) {
            result = new Path(tabletDirectory + "/tmp/idxReduce_" + String.format("%09d", random.nextInt(Integer.MAX_VALUE)));
            try {
                fs.getFileStatus(result);
                result = null;
            }
            catch (FileNotFoundException fileNotFoundException) {
                fs.mkdirs(result);
                if (fs.createNewFile(new Path(result, "__reserve"))) continue;
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<String> reduceFiles(ServerContext context, TableConfiguration tableConf, Text prevEndRow, Text endRow, Collection<String> mapFiles, int maxFiles, Path tmpDir, int pass) throws IOException {
        ArrayList<String> paths = new ArrayList<String>(mapFiles);
        if (paths.size() <= maxFiles) {
            return paths;
        }
        String newDir = String.format("%s/pass_%04d", tmpDir, pass);
        int start = 0;
        ArrayList<String> outFiles = new ArrayList<String>();
        int count = 0;
        block15: while (start < paths.size()) {
            int end = Math.min(maxFiles + start, paths.size());
            List<String> inFiles = paths.subList(start, end);
            start = end;
            String newMapFile = String.format("%s/%04d.%s", newDir, count++, "rf");
            outFiles.add(newMapFile);
            FileSystem ns = context.getVolumeManager().getFileSystemByPath(new Path(newMapFile));
            FileSKVWriter writer = new RFileOperations().newWriterBuilder().forFile(newMapFile, ns, ns.getConf(), tableConf.getCryptoService()).withTableConfiguration((AccumuloConfiguration)tableConf).build();
            writer.startDefaultLocalityGroup();
            ArrayList<FileSKVIterator> iters = new ArrayList<FileSKVIterator>(inFiles.size());
            FileSKVIterator reader = null;
            try {
                for (String string : inFiles) {
                    ns = context.getVolumeManager().getFileSystemByPath(new Path(string));
                    reader = FileOperations.getInstance().newIndexReaderBuilder().forFile(string, ns, ns.getConf(), tableConf.getCryptoService()).withTableConfiguration((AccumuloConfiguration)tableConf).build();
                    iters.add(reader);
                }
                MultiIterator mmfi = new MultiIterator(iters, true);
                while (mmfi.hasTop()) {
                    boolean lteEndRow;
                    Key key = mmfi.getTopKey();
                    boolean gtPrevEndRow = prevEndRow == null || key.compareRow(prevEndRow) > 0;
                    boolean bl = lteEndRow = endRow == null || key.compareRow(endRow) <= 0;
                    if (gtPrevEndRow && lteEndRow) {
                        writer.append(key, new Value());
                    }
                    if (!lteEndRow) continue block15;
                    mmfi.next();
                }
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                }
                for (SortedKeyValueIterator sortedKeyValueIterator : iters) {
                    try {
                        if (sortedKeyValueIterator == null) continue;
                        ((FileSKVIterator)sortedKeyValueIterator).close();
                    }
                    catch (IOException e) {
                        log.error("{}", (Object)e.getMessage(), (Object)e);
                    }
                }
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                    throw e;
                }
            }
        }
        return FileUtil.reduceFiles(context, tableConf, prevEndRow, endRow, outFiles, maxFiles, tmpDir, pass + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double estimatePercentageLTE(ServerContext context, TableConfiguration tableConf, String tabletDir, Text prevEndRow, Text endRow, Collection<String> mapFiles, Text splitRow) throws IOException {
        double d;
        long numKeys;
        ArrayList<FileSKVIterator> readers;
        Path tmpDir;
        block8: {
            tmpDir = null;
            int maxToOpen = context.getConfiguration().getCount(Property.TSERV_TABLET_SPLIT_FINDMIDPOINT_MAXOPEN);
            readers = new ArrayList<FileSKVIterator>(mapFiles.size());
            if (mapFiles.size() > maxToOpen) {
                tmpDir = FileUtil.createTmpDir(context, tabletDir);
                log.debug("Too many indexes ({}) to open at once for {} {}, reducing in tmpDir = {}", new Object[]{mapFiles.size(), endRow, prevEndRow, tmpDir});
                long t1 = System.currentTimeMillis();
                mapFiles = FileUtil.reduceFiles(context, tableConf, prevEndRow, endRow, mapFiles, maxToOpen, tmpDir, 0);
                long t2 = System.currentTimeMillis();
                log.debug("Finished reducing indexes for {} {} in {}", new Object[]{endRow, prevEndRow, String.format("%6.2f secs", (double)(t2 - t1) / 1000.0)});
            }
            if (prevEndRow == null) {
                prevEndRow = new Text();
            }
            if ((numKeys = FileUtil.countIndexEntries(context, tableConf, prevEndRow, endRow, mapFiles, true, readers)) != 0L) break block8;
            double t2 = 0.5;
            FileUtil.cleanupIndexOp(tmpDir, context.getVolumeManager(), readers);
            return t2;
        }
        try {
            ArrayList<FileSKVIterator> iters = new ArrayList<FileSKVIterator>(readers);
            MultiIterator mmfi = new MultiIterator(iters, true);
            while (mmfi.hasTop() && mmfi.getTopKey().compareRow(prevEndRow) <= 0) {
                mmfi.next();
            }
            int numLte = 0;
            while (mmfi.hasTop() && mmfi.getTopKey().compareRow(splitRow) <= 0) {
                ++numLte;
                mmfi.next();
            }
            if ((long)numLte > numKeys) {
                throw new RuntimeException("numLte > numKeys " + numLte + " " + numKeys + " " + String.valueOf(prevEndRow) + " " + String.valueOf(endRow) + " " + String.valueOf(splitRow) + " " + String.valueOf(mapFiles));
            }
            d = (double)(numLte + 1) / (double)(numKeys + 2L);
        }
        catch (Throwable throwable) {
            FileUtil.cleanupIndexOp(tmpDir, context.getVolumeManager(), readers);
            throw throwable;
        }
        FileUtil.cleanupIndexOp(tmpDir, context.getVolumeManager(), readers);
        return d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SortedMap<Double, Key> findMidPoint(ServerContext context, TableConfiguration tableConf, String tabletDirectory, Text prevEndRow, Text endRow, Collection<String> mapFiles, double minSplit, boolean useIndex) throws IOException {
        TreeMap<Double, Key> treeMap;
        long numKeys;
        long t1;
        ArrayList<FileSKVIterator> readers;
        Path tmpDir;
        block13: {
            block14: {
                Collection<String> origMapFiles = mapFiles;
                tmpDir = null;
                int maxToOpen = context.getConfiguration().getCount(Property.TSERV_TABLET_SPLIT_FINDMIDPOINT_MAXOPEN);
                readers = new ArrayList<FileSKVIterator>(mapFiles.size());
                if (mapFiles.size() > maxToOpen) {
                    if (!useIndex) {
                        throw new IOException("Cannot find mid point using data files, too many " + mapFiles.size());
                    }
                    tmpDir = FileUtil.createTmpDir(context, tabletDirectory);
                    log.debug("Too many indexes ({}) to open at once for {} {}, reducing in tmpDir = {}", new Object[]{mapFiles.size(), endRow, prevEndRow, tmpDir});
                    t1 = System.currentTimeMillis();
                    mapFiles = FileUtil.reduceFiles(context, tableConf, prevEndRow, endRow, mapFiles, maxToOpen, tmpDir, 0);
                    long t2 = System.currentTimeMillis();
                    log.debug("Finished reducing indexes for {} {} in {}", new Object[]{endRow, prevEndRow, String.format("%6.2f secs", (double)(t2 - t1) / 1000.0)});
                }
                if (prevEndRow == null) {
                    prevEndRow = new Text();
                }
                t1 = System.currentTimeMillis();
                numKeys = FileUtil.countIndexEntries(context, tableConf, prevEndRow, endRow, mapFiles, tmpDir == null ? useIndex : false, readers);
                if (numKeys != 0L) break block13;
                if (!useIndex) break block14;
                log.warn("Failed to find mid point using indexes, falling back to data files which is slower. No entries between {} and {} for {}", new Object[]{prevEndRow, endRow, mapFiles});
                SortedMap<Double, Key> sortedMap = FileUtil.findMidPoint(context, tableConf, tabletDirectory, prevEndRow, endRow, origMapFiles, minSplit, false);
                FileUtil.cleanupIndexOp(tmpDir, context.getVolumeManager(), readers);
                return sortedMap;
            }
            SortedMap<Double, Key> sortedMap = Collections.emptySortedMap();
            FileUtil.cleanupIndexOp(tmpDir, context.getVolumeManager(), readers);
            return sortedMap;
        }
        try {
            ArrayList<FileSKVIterator> iters = new ArrayList<FileSKVIterator>(readers);
            MultiIterator mmfi = new MultiIterator(iters, true);
            while (mmfi.hasTop() && mmfi.getTopKey().compareRow(prevEndRow) <= 0) {
                mmfi.next();
            }
            TreeMap<Double, Key> ret = new TreeMap<Double, Key>();
            Key lastKey = null;
            Key keyBeforeMidPoint = null;
            long keyBeforeMidPointPosition = 0L;
            for (long keysRead = 0L; keysRead < numKeys / 2L; ++keysRead) {
                if (lastKey != null && !lastKey.equals(mmfi.getTopKey(), PartialKey.ROW) && (double)(keysRead - 1L) / (double)numKeys >= minSplit) {
                    keyBeforeMidPoint = new Key(lastKey);
                    keyBeforeMidPointPosition = keysRead - 1L;
                }
                if (lastKey == null) {
                    lastKey = new Key();
                }
                lastKey.set(mmfi.getTopKey());
                mmfi.next();
            }
            if (keyBeforeMidPoint != null) {
                ret.put((double)keyBeforeMidPointPosition / (double)numKeys, keyBeforeMidPoint);
            }
            long t2 = System.currentTimeMillis();
            log.debug(String.format("Found midPoint from indexes in %6.2f secs.%n", (double)(t2 - t1) / 1000.0));
            ret.put(0.5, mmfi.getTopKey());
            for (Key key : ret.values()) {
                boolean inRange = key.compareRow(prevEndRow) > 0 && (endRow == null || key.compareRow(endRow) < 1);
                if (inRange) continue;
                throw new IOException("Found mid point is not in range " + String.valueOf(key) + " " + String.valueOf(prevEndRow) + " " + String.valueOf(endRow) + " " + String.valueOf(mapFiles));
            }
            treeMap = ret;
        }
        catch (Throwable throwable) {
            FileUtil.cleanupIndexOp(tmpDir, context.getVolumeManager(), readers);
            throw throwable;
        }
        FileUtil.cleanupIndexOp(tmpDir, context.getVolumeManager(), readers);
        return treeMap;
    }

    protected static void cleanupIndexOp(Path tmpDir, VolumeManager fs, ArrayList<FileSKVIterator> readers) throws IOException {
        for (FileSKVIterator r : readers) {
            try {
                if (r == null) continue;
                r.close();
            }
            catch (IOException e) {
                log.error("{}", (Object)e.getMessage(), (Object)e);
            }
        }
        if (tmpDir != null) {
            FileSystem actualFs = fs.getFileSystemByPath(tmpDir);
            if (actualFs.exists(tmpDir)) {
                fs.deleteRecursively(tmpDir);
                return;
            }
            log.error("Did not delete tmp dir because it wasn't a tmp dir {}", (Object)tmpDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long countIndexEntries(ServerContext context, TableConfiguration tableConf, Text prevEndRow, Text endRow, Collection<String> mapFiles, boolean useIndex, ArrayList<FileSKVIterator> readers) throws IOException {
        long numKeys = 0L;
        for (String file : mapFiles) {
            FileSKVIterator reader = null;
            Path path = new Path(file);
            FileSystem ns = context.getVolumeManager().getFileSystemByPath(path);
            try {
                reader = useIndex ? FileOperations.getInstance().newIndexReaderBuilder().forFile(path.toString(), ns, ns.getConf(), tableConf.getCryptoService()).withTableConfiguration((AccumuloConfiguration)tableConf).build() : FileOperations.getInstance().newScanReaderBuilder().forFile(path.toString(), ns, ns.getConf(), tableConf.getCryptoService()).withTableConfiguration((AccumuloConfiguration)tableConf).overRange(new Range(prevEndRow, false, null, true), Set.of(), false).build();
                while (reader.hasTop()) {
                    Key key = (Key)reader.getTopKey();
                    if (endRow != null && key.compareRow(endRow) > 0) {
                        break;
                    }
                    if (prevEndRow == null || key.compareRow(prevEndRow) > 0) {
                        ++numKeys;
                    }
                    reader.next();
                }
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                }
            }
            if (useIndex) {
                readers.add(FileOperations.getInstance().newIndexReaderBuilder().forFile(path.toString(), ns, ns.getConf(), tableConf.getCryptoService()).withTableConfiguration((AccumuloConfiguration)tableConf).build());
                continue;
            }
            readers.add(FileOperations.getInstance().newScanReaderBuilder().forFile(path.toString(), ns, ns.getConf(), tableConf.getCryptoService()).withTableConfiguration((AccumuloConfiguration)tableConf).overRange(new Range(prevEndRow, false, null, true), Set.of(), false).build());
        }
        return numKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<TabletFile, FileInfo> tryToGetFirstAndLastRows(ServerContext context, TableConfiguration tableConf, Set<TabletFile> mapfiles) {
        HashMap<TabletFile, FileInfo> mapFilesInfo = new HashMap<TabletFile, FileInfo>();
        long t1 = System.currentTimeMillis();
        for (TabletFile mapfile : mapfiles) {
            FileSKVIterator reader = null;
            FileSystem ns = context.getVolumeManager().getFileSystemByPath(mapfile.getPath());
            try {
                reader = FileOperations.getInstance().newReaderBuilder().forFile(mapfile.getPathStr(), ns, ns.getConf(), tableConf.getCryptoService()).withTableConfiguration((AccumuloConfiguration)tableConf).build();
                Key firstKey = reader.getFirstKey();
                if (firstKey == null) continue;
                mapFilesInfo.put(mapfile, new FileInfo(firstKey, reader.getLastKey()));
            }
            catch (IOException ioe) {
                log.warn("Failed to read map file to determine first and last key : " + String.valueOf(mapfile), (Throwable)ioe);
            }
            finally {
                if (reader == null) continue;
                try {
                    reader.close();
                }
                catch (IOException ioe) {
                    log.warn("failed to close " + String.valueOf(mapfile), (Throwable)ioe);
                }
            }
        }
        long t2 = System.currentTimeMillis();
        log.debug(String.format("Found first and last keys for %d map files in %6.2f secs", mapfiles.size(), (double)(t2 - t1) / 1000.0));
        return mapFilesInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WritableComparable<Key> findLastKey(ServerContext context, TableConfiguration tableConf, Collection<TabletFile> mapFiles) throws IOException {
        Key lastKey = null;
        for (TabletFile file : mapFiles) {
            FileSystem ns = context.getVolumeManager().getFileSystemByPath(file.getPath());
            FileSKVIterator reader = FileOperations.getInstance().newReaderBuilder().forFile(file.getPathStr(), ns, ns.getConf(), tableConf.getCryptoService()).withTableConfiguration((AccumuloConfiguration)tableConf).seekToBeginning().build();
            try {
                if (!reader.hasTop()) continue;
                Key key = reader.getLastKey();
                if (lastKey != null && key.compareTo(lastKey) <= 0) continue;
                lastKey = key;
            }
            finally {
                try {
                    if (reader == null) continue;
                    reader.close();
                }
                catch (IOException e) {
                    log.error("{}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
        return lastKey;
    }

    public static Collection<String> toPathStrings(Collection<TabletFile> files) {
        return files.stream().map(TabletFile::getPathStr).collect(Collectors.toList());
    }

    public static class FileInfo {
        Key firstKey = new Key();
        Key lastKey = new Key();

        public FileInfo(Key firstKey, Key lastKey) {
            this.firstKey = firstKey;
            this.lastKey = lastKey;
        }

        public Text getFirstRow() {
            return this.firstKey.getRow();
        }

        public Text getLastRow() {
            return this.lastKey.getRow();
        }
    }
}

