/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.conf;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.SiteConfiguration;
import org.apache.accumulo.server.ServerDirs;
import org.apache.accumulo.server.conf.CheckServerConfig;
import org.apache.accumulo.server.fs.VolumeManagerImpl;
import org.apache.accumulo.start.spi.KeywordExecutable;
import org.apache.hadoop.conf.Configuration;

@AutoService(value={KeywordExecutable.class})
public class CheckAccumuloProperties
implements KeywordExecutable {
    public String keyword() {
        return "check-accumulo-properties";
    }

    public String description() {
        return "Checks the provided Accumulo configuration file for errors. This only checks the contents of the file and not any running Accumulo system, so it can be used prior to init, but only performs a subset of the checks done by " + new CheckServerConfig().keyword();
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="intentional user-provided path")
    public void execute(String[] args) throws IOException {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)("Expected 1 argument (the properties file path), got " + args.length));
        Configuration hadoopConfig = new Configuration();
        SiteConfiguration siteConfig = SiteConfiguration.fromFile((File)new File(args[0])).build();
        VolumeManagerImpl.get((AccumuloConfiguration)siteConfig, hadoopConfig);
        new ServerDirs((AccumuloConfiguration)siteConfig, hadoopConfig);
    }
}

