/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tserverOps;

import java.nio.charset.StandardCharsets;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.fate.zookeeper.ServiceLock;
import org.apache.accumulo.core.fate.zookeeper.ZooReaderWriter;
import org.apache.accumulo.core.fate.zookeeper.ZooUtil;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.util.HostAndPort;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.server.manager.LiveTServerSet;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownTServer
extends ManagerRepo {
    private static final long serialVersionUID = 2L;
    private static final Logger log = LoggerFactory.getLogger(ShutdownTServer.class);
    private final HostAndPort hostAndPort;
    private final String serverSession;
    private final boolean force;

    public ShutdownTServer(TServerInstance server, boolean force) {
        this.hostAndPort = server.getHostAndPort();
        this.serverSession = server.getSession();
        this.force = force;
    }

    @Override
    public long isReady(long tid, Manager manager) {
        LiveTServerSet.TServerConnection connection;
        TServerInstance server = new TServerInstance(this.hostAndPort, this.serverSession);
        if (this.force) {
            return 0L;
        }
        manager.shutdownTServer(server);
        if (manager.onlineTabletServers().contains(server) && (connection = manager.getConnection(server)) != null) {
            try {
                TabletServerStatus status = connection.getTableMap(false);
                if (status.tableMap != null && status.tableMap.isEmpty()) {
                    log.info("tablet server hosts no tablets {}", (Object)server);
                    connection.halt(manager.getManagerLock());
                    log.info("tablet server asked to halt {}", (Object)server);
                    return 0L;
                }
                log.info("tablet server {} still has tablets for tables: {}", (Object)server, status.tableMap == null ? "null" : status.tableMap.keySet());
            }
            catch (TTransportException status) {
            }
            catch (Exception ex) {
                log.error("Error talking to tablet server {}: ", (Object)server, (Object)ex);
            }
            return 1000L;
        }
        return 0L;
    }

    @Override
    public Repo<Manager> call(long tid, Manager manager) throws Exception {
        if (this.force) {
            ZooReaderWriter zoo = manager.getContext().getZooReaderWriter();
            ServiceLock.ServiceLockPath path = ServiceLock.path((String)(manager.getZooKeeperRoot() + "/tservers/" + String.valueOf(this.hostAndPort)));
            ServiceLock.deleteLock((ZooReaderWriter)zoo, (ServiceLock.ServiceLockPath)path);
            path = ServiceLock.path((String)(manager.getZooKeeperRoot() + "/dead/tservers/" + String.valueOf(this.hostAndPort)));
            zoo.putPersistentData(path.toString(), "forced down".getBytes(StandardCharsets.UTF_8), ZooUtil.NodeExistsPolicy.OVERWRITE);
        }
        return null;
    }

    @Override
    public void undo(long tid, Manager m) {
    }
}

