/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.tableOps.merge;

import org.apache.accumulo.core.clientImpl.AcceptableThriftTableOperationException;
import org.apache.accumulo.core.clientImpl.thrift.TableOperation;
import org.apache.accumulo.core.clientImpl.thrift.TableOperationExceptionType;
import org.apache.accumulo.core.data.NamespaceId;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.fate.Repo;
import org.apache.accumulo.core.metadata.RootTable;
import org.apache.accumulo.core.util.TextUtil;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.manager.tableOps.ManagerRepo;
import org.apache.accumulo.manager.tableOps.Utils;
import org.apache.accumulo.manager.tableOps.merge.TableRangeOpWait;
import org.apache.accumulo.server.manager.state.MergeInfo;
import org.apache.accumulo.server.manager.state.MergeState;
import org.apache.hadoop.io.BinaryComparable;
import org.apache.hadoop.io.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableRangeOp
extends ManagerRepo {
    private static final Logger log = LoggerFactory.getLogger(TableRangeOp.class);
    private static final long serialVersionUID = 1L;
    private final TableId tableId;
    private final NamespaceId namespaceId;
    private final byte[] startRow;
    private final byte[] endRow;
    private final MergeInfo.Operation op;

    @Override
    public long isReady(long tid, Manager env) throws Exception {
        return Utils.reserveNamespace(env, this.namespaceId, tid, false, true, TableOperation.MERGE) + Utils.reserveTable(env, this.tableId, tid, true, true, TableOperation.MERGE);
    }

    public TableRangeOp(MergeInfo.Operation op, NamespaceId namespaceId, TableId tableId, Text startRow, Text endRow) {
        this.tableId = tableId;
        this.namespaceId = namespaceId;
        this.startRow = TextUtil.getBytes((Text)startRow);
        this.endRow = TextUtil.getBytes((Text)endRow);
        this.op = op;
    }

    @Override
    public Repo<Manager> call(long tid, Manager env) throws Exception {
        Text end;
        if (RootTable.ID.equals((Object)this.tableId) && MergeInfo.Operation.MERGE.equals((Object)this.op)) {
            log.warn("Attempt to merge tablets for {} does nothing. It is not splittable.", (Object)RootTable.NAME);
        }
        Text start = this.startRow.length == 0 ? null : new Text(this.startRow);
        Text text = end = this.endRow.length == 0 ? null : new Text(this.endRow);
        if (start != null && end != null && start.compareTo((BinaryComparable)end) >= 0) {
            throw new AcceptableThriftTableOperationException(this.tableId.canonical(), null, TableOperation.MERGE, TableOperationExceptionType.BAD_RANGE, "start row must be less than end row");
        }
        env.mustBeOnline(this.tableId);
        MergeInfo info = env.getMergeInfo(this.tableId);
        if (info.getState() == MergeState.NONE) {
            KeyExtent range = new KeyExtent(this.tableId, end, start);
            env.setMergeState(new MergeInfo(range, this.op), MergeState.STARTED);
        }
        return new TableRangeOpWait(this.namespaceId, this.tableId);
    }

    @Override
    public void undo(long tid, Manager env) throws Exception {
        MergeInfo mergeInfo = env.getMergeInfo(this.tableId);
        if (mergeInfo.getState() != MergeState.NONE) {
            log.info("removing merge information {}", (Object)mergeInfo);
        }
        env.clearMergeState(this.tableId);
        Utils.unreserveNamespace(env, this.namespaceId, tid, false);
        Utils.unreserveTable(env, this.tableId, tid, true);
    }
}

