/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.manager.replication;

import com.google.common.base.Preconditions;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Iterator;
import java.util.Set;
import org.apache.accumulo.core.clientImpl.thrift.ThriftSecurityException;
import org.apache.accumulo.core.fate.zookeeper.ZooReader;
import org.apache.accumulo.core.metadata.TServerInstance;
import org.apache.accumulo.core.replication.thrift.ReplicationCoordinator;
import org.apache.accumulo.core.replication.thrift.ReplicationCoordinatorErrorCode;
import org.apache.accumulo.core.replication.thrift.ReplicationCoordinatorException;
import org.apache.accumulo.core.securityImpl.thrift.TCredentials;
import org.apache.accumulo.manager.Manager;
import org.apache.accumulo.server.security.AuditedSecurityOperation;
import org.apache.thrift.TException;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class ManagerReplicationCoordinator
implements ReplicationCoordinator.Iface {
    private static final SecureRandom random = new SecureRandom();
    private static final Logger log = LoggerFactory.getLogger(ManagerReplicationCoordinator.class);
    private final Manager manager;
    private final ZooReader reader;
    private final AuditedSecurityOperation security;

    public ManagerReplicationCoordinator(Manager manager) {
        this(manager, manager.getContext().getZooReader());
    }

    protected ManagerReplicationCoordinator(Manager manager, ZooReader reader) {
        this.manager = manager;
        this.reader = reader;
        this.security = manager.getContext().getSecurityOperation();
    }

    public String getServicerAddress(String remoteTableId, TCredentials creds) throws ReplicationCoordinatorException, TException {
        String replServiceAddr;
        try {
            this.security.authenticateUser(this.manager.getContext().rpcCreds(), creds);
        }
        catch (ThriftSecurityException e) {
            log.error("{} failed to authenticate for replication to {}", (Object)creds.getPrincipal(), (Object)remoteTableId);
            throw new ReplicationCoordinatorException(ReplicationCoordinatorErrorCode.CANNOT_AUTHENTICATE, "Could not authenticate " + creds.getPrincipal());
        }
        Set<TServerInstance> tservers = this.manager.onlineTabletServers();
        if (tservers.isEmpty()) {
            throw new ReplicationCoordinatorException(ReplicationCoordinatorErrorCode.NO_AVAILABLE_SERVERS, "No tservers are available for replication");
        }
        TServerInstance tserver = this.getRandomTServer(tservers, random.nextInt(tservers.size()));
        try {
            replServiceAddr = new String(this.reader.getData(this.manager.getZooKeeperRoot() + "/replication/tservers/" + tserver.getHostPort()), StandardCharsets.UTF_8);
        }
        catch (InterruptedException | KeeperException e) {
            log.error("Could not fetch replication service port for tserver", e);
            throw new ReplicationCoordinatorException(ReplicationCoordinatorErrorCode.SERVICE_CONFIGURATION_UNAVAILABLE, "Could not determine port for replication service running at " + tserver.getHostPort());
        }
        return replServiceAddr;
    }

    protected TServerInstance getRandomTServer(Set<TServerInstance> tservers, int offset) {
        Preconditions.checkArgument((tservers.size() > offset ? 1 : 0) != 0, (Object)"Must provide an offset less than the size of the set");
        Iterator<TServerInstance> iter = tservers.iterator();
        while (offset > 0) {
            iter.next();
            --offset;
        }
        return iter.next();
    }
}

