/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.format;

import java.util.Map;
import java.util.Optional;
import org.apache.accumulo.core.client.BatchWriter;
import org.apache.accumulo.core.client.MutationsRejectedException;
import org.apache.accumulo.core.data.ConstraintViolationSummary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.Mutation;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.security.ColumnVisibility;
import org.apache.accumulo.core.util.format.DefaultFormatter;
import org.apache.accumulo.core.util.format.FormatterConfig;
import org.apache.accumulo.shell.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleterFormatter
extends DefaultFormatter {
    private static final Logger log = LoggerFactory.getLogger(DeleterFormatter.class);
    private BatchWriter writer;
    private Shell shellState;
    private boolean force;
    private boolean stop;

    public DeleterFormatter(BatchWriter writer, Iterable<Map.Entry<Key, Value>> scanner, FormatterConfig config, Shell shellState, boolean force) {
        super.initialize(scanner, config);
        this.writer = writer;
        this.shellState = shellState;
        this.force = force;
        this.stop = false;
    }

    public boolean hasNext() {
        block4: {
            if (this.getScannerIterator().hasNext() && !this.stop) {
                return true;
            }
            try {
                this.writer.close();
            }
            catch (MutationsRejectedException e) {
                log.error(e.toString());
                if (!Shell.log.isTraceEnabled()) break block4;
                for (ConstraintViolationSummary cvs : e.getConstraintViolationSummaries()) {
                    log.trace(cvs.toString());
                }
            }
        }
        return false;
    }

    public String next() {
        String action;
        String entryStr;
        block4: {
            Map.Entry next = (Map.Entry)this.getScannerIterator().next();
            entryStr = DeleterFormatter.formatEntry((Map.Entry)next, (boolean)this.isDoTimestamps());
            Optional<Boolean> confirm = this.force ? Optional.of(true) : this.shellState.confirm("Delete { " + entryStr + " } ? ");
            this.stop = confirm.isEmpty();
            action = "SKIPPED";
            if (confirm.orElse(false).booleanValue()) {
                Key key = (Key)next.getKey();
                Mutation m = new Mutation(key.getRow());
                m.putDelete(key.getColumnFamily(), key.getColumnQualifier(), new ColumnVisibility(key.getColumnVisibility()), key.getTimestamp());
                try {
                    this.writer.addMutation(m);
                    action = "DELETED";
                }
                catch (MutationsRejectedException e) {
                    log.error(e.toString());
                    if (!Shell.log.isTraceEnabled()) break block4;
                    for (ConstraintViolationSummary cvs : e.getConstraintViolationSummaries()) {
                        log.trace(cvs.toString());
                    }
                }
            }
        }
        this.shellState.getWriter().print(String.format("[%s] %s%n", action, entryStr));
        return null;
    }
}

