/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public class Validator<T> {
    public static final Optional<String> OK = Optional.empty();
    private final Function<T, Optional<String>> validateFunction;
    private volatile T lastValidated = null;

    public Validator(Function<T, Optional<String>> validateFunction) {
        this.validateFunction = Objects.requireNonNull(validateFunction);
    }

    public final T validate(T argument) {
        T lastValidatedSnapshot = this.lastValidated;
        if (lastValidatedSnapshot != null && Objects.equals(argument, lastValidatedSnapshot)) {
            return argument;
        }
        this.validateFunction.apply(argument).ifPresent(msg -> {
            throw new IllegalArgumentException((String)msg);
        });
        this.lastValidated = argument;
        return argument;
    }

    public final Validator<T> and(Validator<T> other) {
        if (other == null) {
            return this;
        }
        return new Validator<Object>(arg -> this.validateFunction.apply(arg).or(() -> other.validateFunction.apply(arg)));
    }

    public final Validator<T> or(Validator<T> other) {
        if (other == null) {
            return this;
        }
        return new Validator<Object>(arg -> this.validateFunction.apply(arg).isEmpty() ? OK : other.validateFunction.apply(arg));
    }

    public final Validator<T> not() {
        return new Validator<Object>(arg -> this.validateFunction.apply(arg).isPresent() ? OK : Optional.of("Validation should have failed with: Invalid argument " + String.valueOf(arg)));
    }
}

