/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.util;

import java.io.IOException;

public class ShutdownUtil {
    public static boolean isShutdownInProgress() {
        try {
            Runtime.getRuntime().removeShutdownHook(new Thread(() -> {}));
        }
        catch (IllegalStateException ise) {
            return true;
        }
        return false;
    }

    public static boolean isIOException(Throwable e) {
        if (e == null) {
            return false;
        }
        if (e instanceof IOException) {
            return true;
        }
        for (Throwable suppressed : e.getSuppressed()) {
            if (!ShutdownUtil.isIOException(suppressed)) continue;
            return true;
        }
        return ShutdownUtil.isIOException(e.getCause());
    }

    public static boolean wasCausedByHadoopShutdown(Exception e) {
        return ShutdownUtil.isShutdownInProgress() && ShutdownUtil.isIOException(e);
    }
}

