/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.iterators.user;

import java.io.IOException;
import java.util.Map;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.PartialKey;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.IteratorEnvironment;
import org.apache.accumulo.core.iterators.OptionDescriber;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;
import org.apache.accumulo.core.iterators.user.CfCqSliceOpts;
import org.apache.accumulo.core.iterators.user.SeekingFilter;

public class CfCqSliceSeekingFilter
extends SeekingFilter
implements OptionDescriber {
    private static final SeekingFilter.FilterResult SKIP_TO_HINT = SeekingFilter.FilterResult.of(false, SeekingFilter.AdvanceResult.USE_HINT);
    private static final SeekingFilter.FilterResult SKIP_TO_NEXT = SeekingFilter.FilterResult.of(false, SeekingFilter.AdvanceResult.NEXT);
    private static final SeekingFilter.FilterResult SKIP_TO_NEXT_ROW = SeekingFilter.FilterResult.of(false, SeekingFilter.AdvanceResult.NEXT_ROW);
    private static final SeekingFilter.FilterResult SKIP_TO_NEXT_CF = SeekingFilter.FilterResult.of(false, SeekingFilter.AdvanceResult.NEXT_CF);
    private static final SeekingFilter.FilterResult INCLUDE_AND_NEXT = SeekingFilter.FilterResult.of(true, SeekingFilter.AdvanceResult.NEXT);
    private static final SeekingFilter.FilterResult INCLUDE_AND_NEXT_CF = SeekingFilter.FilterResult.of(true, SeekingFilter.AdvanceResult.NEXT_CF);
    private CfCqSliceOpts cso;

    @Override
    public void init(SortedKeyValueIterator<Key, Value> source, Map<String, String> options, IteratorEnvironment env) throws IOException {
        super.init(source, options, env);
        this.cso = new CfCqSliceOpts(options);
    }

    @Override
    public SeekingFilter.FilterResult filter(Key k, Value v) {
        int maxCfCmp;
        if (this.cso.minCf.getLength() > 0) {
            int minCfCmp = k.compareColumnFamily(this.cso.minCf);
            if (minCfCmp < 0) {
                return SKIP_TO_HINT;
            }
            if (minCfCmp == 0 && !this.cso.minInclusive) {
                return SKIP_TO_NEXT;
            }
        }
        if (this.cso.maxCf.getLength() > 0 && ((maxCfCmp = k.compareColumnFamily(this.cso.maxCf)) > 0 || maxCfCmp == 0 && !this.cso.maxInclusive)) {
            return SKIP_TO_NEXT_ROW;
        }
        if (this.cso.minCq.getLength() > 0) {
            int minCqCmp = k.compareColumnQualifier(this.cso.minCq);
            if (minCqCmp < 0) {
                return SKIP_TO_HINT;
            }
            if (minCqCmp == 0 && !this.cso.minInclusive) {
                return SKIP_TO_NEXT;
            }
        }
        if (this.cso.maxCq.getLength() > 0) {
            int maxCqCmp = k.compareColumnQualifier(this.cso.maxCq);
            if (maxCqCmp > 0 || maxCqCmp == 0 && !this.cso.maxInclusive) {
                return SKIP_TO_NEXT_CF;
            }
            if (maxCqCmp == 0) {
                return INCLUDE_AND_NEXT_CF;
            }
        }
        return INCLUDE_AND_NEXT;
    }

    @Override
    public Key getNextKeyHint(Key k, Value v) throws IllegalArgumentException {
        int minCqCmp;
        int minCfCmp;
        if (this.cso.minCf.getLength() > 0 && (minCfCmp = k.compareColumnFamily(this.cso.minCf)) < 0) {
            Key hint = new Key(k.getRow(), this.cso.minCf);
            return this.cso.minInclusive ? hint : hint.followingKey(PartialKey.ROW_COLFAM);
        }
        if (this.cso.minCq.getLength() > 0 && (minCqCmp = k.compareColumnQualifier(this.cso.minCq)) < 0) {
            Key hint = new Key(k.getRow(), k.getColumnFamily(), this.cso.minCq);
            return this.cso.minInclusive ? hint : hint.followingKey(PartialKey.ROW_COLFAM_COLQUAL);
        }
        throw new IllegalArgumentException("Don't know how to provide hint for key " + String.valueOf(k));
    }

    @Override
    public SortedKeyValueIterator<Key, Value> deepCopy(IteratorEnvironment env) {
        CfCqSliceSeekingFilter o = (CfCqSliceSeekingFilter)super.deepCopy(env);
        o.cso = new CfCqSliceOpts(this.cso);
        return o;
    }

    @Override
    public OptionDescriber.IteratorOptions describeOptions() {
        return new CfCqSliceOpts.Describer().describeOptions();
    }

    @Override
    public boolean validateOptions(Map<String, String> options) {
        return new CfCqSliceOpts.Describer().validateOptions(options);
    }
}

