/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.gc;

import java.util.Objects;

public class GcCandidate
implements Comparable<GcCandidate> {
    private final long uid;
    private final String path;

    public GcCandidate(String path, long uid) {
        this.path = path;
        this.uid = uid;
    }

    public String getPath() {
        return this.path;
    }

    public long getUid() {
        return this.uid;
    }

    public int hashCode() {
        return Objects.hash(this.path, this.uid);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof GcCandidate) {
            GcCandidate candidate = (GcCandidate)obj;
            return this.uid == candidate.getUid() && this.path.equals(candidate.getPath());
        }
        return false;
    }

    @Override
    public int compareTo(GcCandidate candidate) {
        int cmp = this.path.compareTo(candidate.getPath());
        if (cmp == 0) {
            return Long.compare(this.uid, candidate.getUid());
        }
        return cmp;
    }

    public String toString() {
        return this.path + ", UUID: " + this.uid;
    }
}

