/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.fate.zookeeper;

import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.accumulo.core.data.InstanceId;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;

public class ZooUtil {
    private static final DateTimeFormatter fmt = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss 'UTC' yyyy");
    public static final List<ACL> PRIVATE = new ArrayList<ACL>();
    public static final List<ACL> PUBLIC;

    public static String getRoot(InstanceId instanceId) {
        return "/accumulo/" + String.valueOf(instanceId);
    }

    public static void recursiveDelete(ZooKeeper zooKeeper, String zPath, NodeMissingPolicy policy) throws KeeperException, InterruptedException {
        if (policy == NodeMissingPolicy.CREATE) {
            throw new IllegalArgumentException(policy.name() + " is invalid for this operation");
        }
        try {
            for (String child : zooKeeper.getChildren(zPath, null)) {
                ZooUtil.recursiveDelete(zooKeeper, zPath + "/" + child, NodeMissingPolicy.SKIP);
            }
            zooKeeper.delete(zPath, -1);
        }
        catch (KeeperException e) {
            if (e.code() == KeeperException.Code.NOTEMPTY) {
                ZooUtil.recursiveDelete(zooKeeper, zPath, policy);
            }
            if (policy == NodeMissingPolicy.SKIP && e.code() == KeeperException.Code.NONODE) {
                return;
            }
            throw e;
        }
    }

    public static String printStat(Stat stat) {
        if (stat == null) {
            return "null";
        }
        return "\ncZxid = " + String.format("0x%x", stat.getCzxid()) + "\nctime = " + ZooUtil.getFmtTime(stat.getCtime()) + "\nmZxid = " + String.format("0x%x", stat.getMzxid()) + "\nmtime = " + ZooUtil.getFmtTime(stat.getMtime()) + "\npZxid = " + String.format("0x%x", stat.getPzxid()) + "\ncversion = " + stat.getCversion() + "\ndataVersion = " + stat.getVersion() + "\naclVersion = " + stat.getAversion() + "\nephemeralOwner = " + String.format("0x%x", stat.getEphemeralOwner()) + "\ndataLength = " + stat.getDataLength() + "\nnumChildren = " + stat.getNumChildren();
    }

    private static String getFmtTime(long epoch) {
        OffsetDateTime timestamp = OffsetDateTime.ofInstant(Instant.ofEpochMilli(epoch), ZoneOffset.UTC);
        return fmt.format(timestamp);
    }

    public static Id getZkDigestAuthId(String secret) {
        try {
            String scheme = "digest";
            String auth = DigestAuthenticationProvider.generateDigest((String)("accumulo:" + secret));
            return new Id("digest", auth);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException("Could not generate ZooKeeper digest string", ex);
        }
    }

    public static void digestAuth(ZooKeeper zoo, String secret) {
        ZooUtil.auth(zoo, "digest", ("accumulo:" + secret).getBytes(StandardCharsets.UTF_8));
    }

    public static void auth(ZooKeeper zoo, String scheme, byte[] auth) {
        zoo.addAuthInfo(scheme, auth);
    }

    static {
        PRIVATE.addAll(ZooDefs.Ids.CREATOR_ALL_ACL);
        PUBLIC = new ArrayList<ACL>();
        PUBLIC.addAll(PRIVATE);
        PUBLIC.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
    }

    public static enum NodeMissingPolicy {
        SKIP,
        CREATE,
        FAIL;

    }

    public static class LockID {
        public long eid;
        public String path;
        public String node;

        public LockID(String root, String serializedLID) {
            String[] sa = serializedLID.split("\\$");
            int lastSlash = sa[0].lastIndexOf(47);
            if (sa.length != 2 || lastSlash < 0) {
                throw new IllegalArgumentException("Malformed serialized lock id " + serializedLID);
            }
            this.path = lastSlash == 0 ? root : root + "/" + sa[0].substring(0, lastSlash);
            this.node = sa[0].substring(lastSlash + 1);
            this.eid = new BigInteger(sa[1], 16).longValue();
        }

        public LockID(String path, String node, long eid) {
            this.path = path;
            this.node = node;
            this.eid = eid;
        }

        public String serialize(String root) {
            return this.path.substring(root.length()) + "/" + this.node + "$" + Long.toHexString(this.eid);
        }

        public String toString() {
            return " path = " + this.path + " node = " + this.node + " eid = " + Long.toHexString(this.eid);
        }
    }

    public static enum NodeExistsPolicy {
        SKIP,
        OVERWRITE,
        FAIL;

    }
}

