/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.clientImpl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.accumulo.core.client.TableNotFoundException;
import org.apache.accumulo.core.client.admin.ActiveScan;
import org.apache.accumulo.core.client.admin.ScanState;
import org.apache.accumulo.core.client.admin.ScanType;
import org.apache.accumulo.core.clientImpl.ClientContext;
import org.apache.accumulo.core.data.Column;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.TabletId;
import org.apache.accumulo.core.dataImpl.KeyExtent;
import org.apache.accumulo.core.dataImpl.TabletIdImpl;
import org.apache.accumulo.core.dataImpl.thrift.IterInfo;
import org.apache.accumulo.core.dataImpl.thrift.TColumn;
import org.apache.accumulo.core.security.Authorizations;

public class ActiveScanImpl
extends ActiveScan {
    private final long scanId;
    private final String client;
    private final String tableName;
    private final long age;
    private final long idle;
    private final ScanType type;
    private final ScanState state;
    private final KeyExtent extent;
    private final List<Column> columns;
    private final List<String> ssiList;
    private final Map<String, Map<String, String>> ssio;
    private final String user;
    private final Authorizations authorizations;

    ActiveScanImpl(ClientContext context, org.apache.accumulo.core.tabletserver.thrift.ActiveScan activeScan) throws TableNotFoundException {
        this.scanId = activeScan.scanId;
        this.client = activeScan.client;
        this.user = activeScan.user;
        this.age = activeScan.age;
        this.idle = activeScan.idleTime;
        this.tableName = context.getTableName(TableId.of(activeScan.tableId));
        this.type = ScanType.valueOf(activeScan.getType().name());
        this.state = ScanState.valueOf(activeScan.state.name());
        this.extent = KeyExtent.fromThrift(activeScan.extent);
        this.authorizations = new Authorizations(activeScan.authorizations);
        this.columns = new ArrayList<Column>(activeScan.columns.size());
        for (TColumn tcolumn : activeScan.columns) {
            this.columns.add(new Column(tcolumn));
        }
        this.ssiList = new ArrayList<String>();
        for (IterInfo ii : activeScan.ssiList) {
            this.ssiList.add(ii.iterName + "=" + ii.priority + "," + ii.className);
        }
        this.ssio = activeScan.ssio;
    }

    @Override
    public long getScanid() {
        return this.scanId;
    }

    @Override
    public String getClient() {
        return this.client;
    }

    @Override
    public String getUser() {
        return this.user;
    }

    @Override
    public String getTable() {
        return this.tableName;
    }

    @Override
    public long getAge() {
        return this.age;
    }

    @Override
    public long getLastContactTime() {
        return this.idle;
    }

    @Override
    public ScanType getType() {
        return this.type;
    }

    @Override
    public ScanState getState() {
        return this.state;
    }

    @Override
    public TabletId getTablet() {
        return new TabletIdImpl(this.extent);
    }

    @Override
    public List<Column> getColumns() {
        return this.columns;
    }

    @Override
    public List<String> getSsiList() {
        return this.ssiList;
    }

    @Override
    public Map<String, Map<String, String>> getSsio() {
        return this.ssio;
    }

    @Override
    public Authorizations getAuthorizations() {
        return this.authorizations;
    }

    @Override
    public long getIdleTime() {
        return this.idle;
    }
}

