/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.lexicoder;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.accumulo.core.client.lexicoder.AbstractLexicoder;
import org.apache.accumulo.core.client.lexicoder.Lexicoder;
import org.apache.accumulo.core.clientImpl.lexicoder.ByteUtils;

public class SequenceLexicoder<E>
extends AbstractLexicoder<List<E>> {
    private static final byte[] EMPTY_ELEMENT = new byte[0];
    private final Lexicoder<E> elementLexicoder;

    public SequenceLexicoder(Lexicoder<E> elementLexicoder) {
        this.elementLexicoder = Objects.requireNonNull(elementLexicoder, "elementLexicoder");
    }

    @Override
    public byte[] encode(List<E> v) {
        byte[][] encElements = new byte[v.size() + 1][];
        int index = 0;
        for (E element : v) {
            encElements[index++] = ByteUtils.escape(this.elementLexicoder.encode(element));
        }
        encElements[v.size()] = EMPTY_ELEMENT;
        return ByteUtils.concat(encElements);
    }

    @Override
    protected List<E> decodeUnchecked(byte[] b, int offset, int len) {
        byte[][] escapedElements = ByteUtils.split(b, offset, len);
        assert (escapedElements.length > 0) : "ByteUtils.split always returns a minimum of 1 element, even for empty input";
        byte[] lastElement = escapedElements[escapedElements.length - 1];
        if (lastElement.length > 0) {
            throw new IllegalArgumentException(lastElement.length + " trailing bytes found at end of list");
        }
        ArrayList decodedElements = new ArrayList(escapedElements.length - 1);
        for (int i = 0; i < escapedElements.length - 1; ++i) {
            byte[] escapedElement = escapedElements[i];
            byte[] unescapedElement = ByteUtils.unescape(escapedElement);
            decodedElements.add(this.elementLexicoder.decode(unescapedElement));
        }
        return decodedElements;
    }
}

