/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.core.client.admin.compaction;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.accumulo.core.client.PluginEnvironment;
import org.apache.accumulo.core.client.admin.compaction.CompactableFile;
import org.apache.accumulo.core.client.sample.SamplerConfiguration;
import org.apache.accumulo.core.client.summary.SummarizerConfiguration;
import org.apache.accumulo.core.client.summary.Summary;
import org.apache.accumulo.core.data.Key;
import org.apache.accumulo.core.data.TableId;
import org.apache.accumulo.core.data.Value;
import org.apache.accumulo.core.iterators.SortedKeyValueIterator;

public interface CompactionSelector {
    public void init(InitParameters var1);

    public Selection select(SelectionParameters var1);

    public static class Selection {
        private final Collection<CompactableFile> filesToCompact;

        public Selection(Collection<CompactableFile> filesToCompact) {
            this.filesToCompact = Set.copyOf(filesToCompact);
        }

        public Collection<CompactableFile> getFilesToCompact() {
            return this.filesToCompact;
        }
    }

    public static interface SelectionParameters {
        public PluginEnvironment getEnvironment();

        public Collection<CompactableFile> getAvailableFiles();

        public Collection<Summary> getSummaries(Collection<CompactableFile> var1, Predicate<SummarizerConfiguration> var2);

        public TableId getTableId();

        public Optional<SortedKeyValueIterator<Key, Value>> getSample(CompactableFile var1, SamplerConfiguration var2);
    }

    public static interface InitParameters {
        public Map<String, String> getOptions();

        public TableId getTableId();

        public PluginEnvironment getEnvironment();
    }
}

