/*
 *   Copyright 1999 Bent Bagger (OZ6BL)
 *              All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
        download.c

        Determines whether or not a file should be downloaded from the
        satellite
*/

#define ID_STRING "$Id: download.c,v 1.1 1999/10/20 17:51:11 bent Exp $"
#define VERSION_STRING "(version 1.0 by oz6bl)"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "download.h"
#include "header.h"

LOADLIST *autoload_list = NULL;
FILE     *autof;
 
/* 'ThisFileShouldBeDownloaded' is called from pb.c whenever a new complete
   directory entry is received from the satellite. 
  
   Entry: HEADER *hdr points to a structure containg the decoded file header 
          items. THis structure is defined in 'header.h'.

   Exit: return value = 0 ('false') - this file should not be downloaded
                        -1 ('true') - this file should be downloaded

   Note that the download management is done purely by pb.c

*/


int ThisFileShouldBeDownloaded(HEADER *hdr) {
    LOADLIST *ll ;
    ll = autoload_list;
        for (;;ll = ll->next) {
            if (ll == NULL) break;
            if (ll->dest[0] != '\0' && ! strstr (hdr->destination, ll->dest)) continue;
            if (ll->src [0] != '\0' && ! strstr (hdr->source,      ll->src))  continue;
            if (! strstr (hdr->title,       ll->title)) continue;
            if (! strstr (hdr->keyWords,    ll->key))   continue;
            if (hdr->fileSize >             ll->size)   continue;
            return (-1) ;
        }
    return (0) ;
}

/* 'InitializeDownload' is called at program start to perform the necessary 
   setup activities.

   It may be called during program execution to re-initialize 

*/

void InitializeDownload(void) {

if ((autof = fopen ("autoload.dat", "r")) != NULL) {
                LOADLIST *ll = NULL;
                for (;;) {
                        if (feof (autof)) break;

                        autoload_list = malloc (sizeof (LOADLIST));
                        autoload_list->next = ll;
                        ll = autoload_list;

                        fscanf (autof, "%s %s %s %s %d\n", ll->dest, ll->src,
                                ll->title, ll->key, &ll->size);

                        if (ll->dest  [0] == '*') ll->dest  [0] = '\0';
                        if (ll->src   [0] == '*') ll->src   [0] = '\0';
                        if (ll->title [0] == '*') ll->title [0] = '\0';
                        if (ll->key   [0] == '*') ll->key   [0] = '\0';
                        if (ll->size      == 0)   ll->size      = 0xFFFFFFFF;
                }
                fclose (autof);
        }
} 
