'
'  This program inputs a series of SAR images in a "CMAP format" and
' displays them in movie fashion.  If the number of images to load and
' display isn't specified on the command-line, you're prompted for it.
' The files must be named SAR.1, SAR.2, SAR.3, ... .  The images must not
' be larger than 800 pixels in range or 584 pixels in cross range.'
'
'  If you press the F1 key while the images are being displayed, you will
' be put in a manual mode where the next image isn't displayed until you
' press a key.  In this mode, pressing ESCape terminates the program and
' pressing F1 again takes you back to "continuous display mode."  In the
' continuous display mode, execution terminates when all images have been
' displayed in the current loop if you press a key during the loop.  If
' you don't press a key during the continuous loop, display recycles back
' to the first image and the movie begins again.
'
DECLARE FUNCTION TEMPDIR$(N AS INTEGER)
DECLARE FUNCTION EXIST%(FILE$)
DECLARE FUNCTION FLOF&(HANDLE AS INTEGER)
DECLARE FUNCTION FSEEK&(HANDLE AS INTEGER)
'
'  This is an include file to be used with the FINDVESA subroutine in
' FINDVESA.SUB.  If you're using this file and the FINDVESA subroutine
' within QB's interpreter, you need to use /L on QB's command-line.  If
' you're working from DOS, make sure you LINK with QB.LIB.
'
TYPE REGISTERS
AX AS INTEGER
BX AS INTEGER
CX AS INTEGER
DX AS INTEGER
BP AS INTEGER
SI AS INTEGER
DI AS INTEGER
FLAGS AS INTEGER
DS AS INTEGER
ES AS INTEGER
END TYPE
TYPE RES
STYPE AS INTEGER
BITP AS INTEGER
HS AS INTEGER
VS AS INTEGER
VER AS DOUBLE
PAGES AS INTEGER
MEM AS LONG
MTYPE AS STRING*1
WINA AS INTEGER
WINB AS INTEGER
GRAN AS LONG
SIZE AS LONG
ASEG AS LONG
BSEG AS LONG
MEMMOD AS INTEGER
REDPOS AS INTEGER
GREENPOS AS INTEGER
BLUEPOS AS INTEGER
REDBITS AS INTEGER
GREENBITS AS INTEGER
BLUEBITS AS INTEGER
RESBITS AS INTEGER
DIRECTCOL AS INTEGER
END TYPE
COMMON SHARED /REGS/INREGS AS REGISTERS,OUTREGS AS REGISTERS
COMMON SHARED /SVGA/SINFO AS RES
COMMON SHARED /FIO/FIOCODE() AS LONG
SINFO.STYPE=0
SINFO.MTYPE=""
SINFO.PAGES=0
DIM N AS INTEGER,R AS INTEGER,G AS INTEGER,K AS LONG,I AS INTEGER,J AS INTEGER
DIM B AS LONG,MAN AS INTEGER,OSDATA AS INTEGER,OSBF AS INTEGER,SMBF AS INTEGER
DIM Y AS LONG,NX AS INTEGER,NY AS INTEGER,HR AS INTEGER,X AS LONG,L AS LONG
DIM VR AS INTEGER,WINNUM AS INTEGER,NWIN AS INTEGER,NXLONG AS LONG
DIM NLEFT AS INTEGER,NTOP AS INTEGER,EXCESS AS LONG,HRLONG AS LONG
DIM VRLONG AS LONG,WINADD AS INTEGER,NBLOCK AS INTEGER,HANDLE1 AS INTEGER
DIM FIOCODE(1 TO 17) AS LONG,OX AS INTEGER,HANDLE AS INTEGER,FLOCNEW AS LONG
DIM BEX AS LONG,SMDATA AS INTEGER,OSVID AS INTEGER
DEF SEG=VARSEG(FIOCODE(1))
OX=VARPTR(FIOCODE(1))
POKE OX,&H55                                          'PUSH BP
POKE OX+1,&H89 : POKE OX+2,&HE5                       'MOV BP,SP
POKE OX+3,&H1E                                        'PUSH DS
POKE OX+4,&HB8 : POKE OX+5,0 : POKE OX+6,&H3C         'MOV AX,[function]
POKE OX+7,&HBB : POKE OX+8,0 : POKE OX+9,0            'MOV BX,[HANDLE]
POKE OX+10,&HB9 : POKE OX+11,0 : POKE OX+12,0         'MOV CX,[bytes/attributes]
POKE OX+13,&HBA : POKE OX+14,0 : POKE OX+15,0         'MOV DX,[segment]
POKE OX+16,&H8E : POKE OX+17,&HDA                     'MOV DS,DX
POKE OX+18,&HBA : POKE OX+19,&HBB : POKE OX+20,&HAA   'MOV DX,[offset]
POKE OX+21,&HCD : POKE OX+22,&H21                     'INT 21
POKE OX+23,&H89 : POKE OX+24,&HC3                     'MOV BX,AX
POKE OX+25,&H9F                                       'LAHF
POKE OX+26,&H1F                                       'POP DS
POKE OX+27,&H8B : POKE OX+28,&H7E : POKE OX+29,6      'MOV DI,[BP+6]
POKE OX+30,&H89 : POKE OX+31,&H15                     'MOV [DI],DX
POKE OX+32,&H8B : POKE OX+33,&H7E : POKE OX+34,8      'MOV DI,[BP+8]
POKE OX+35,&H89 : POKE OX+36,&H1D                     'MOV [DI],BX
POKE OX+37,&H8B : POKE OX+38,&H7E : POKE OX+39,&HA    'MOV DI,[BP+A]
POKE OX+40,&H89 : POKE OX+41,5                        'MOV [DI],AX
POKE OX+42,&H5D                                       'POP BP
POKE OX+43,&HCA : POKE OX+44,6 : POKE OX+45,0         'RETF 6
OX=OX+46
POKE OX,&H55                                          'PUSH BP
POKE OX+1,&H89 : POKE OX+2,&HE5                       'MOV BP,SP
POKE OX+3,&HB8 : POKE OX+4,&H16 : POKE OX+5,&H12      'MOV AX,1216
POKE OX+6,&HBB : POKE OX+7,0 : POKE OX+8,0            'MOV BX,[#]
POKE OX+9,&HCD : POKE OX+10,&H2F                      'INT 2F
POKE OX+11,&H9F                                       'LAHF
POKE OX+12,&H8B : POKE OX+13,&H5E : POKE OX+14,6      'MOV BX,[BP+6]
POKE OX+15,&H89 : POKE OX+16,7                        'MOV [BX],AX
POKE OX+17,&H5D                                       'POP BP
POKE OX+18,&HCA : POKE OX+19,2 : POKE OX+20,0         'RETF 2
DEF SEG
'
'  Get number of images to load and make sure at least the first one
' exists.
'
CLS
SCREEN 0
WIDTH 80
N=VAL(COMMAND$)
WHILE N<1
INPUT "How many images do you have";N
CLS
WEND
K=1&
IF EXIST("SAR.1")<>1 THEN GOTO FILESDONE
'
'  Get size of images from first one.  (This must not change from one file
' to the next.)
'
CALL FOPEN("SAR.1",HANDLE,2)
IF HANDLE=0 THEN GOTO NOHANDLE
CALL FREAD(HANDLE,2&,VARSEG(NX),VARPTR(NX))
CALL FREAD(HANDLE,2&,VARSEG(NY),VARPTR(NY))
CALL FCLOSE(HANDLE)
'
'  Determine what video mode is required and make settings accordingly.
'
MODE$="13" : WINADD=&HA000 : SINFO.GRAN=64000& : HR=320 : VR=200
IF NX>320 OR NY>184 THEN HR=640 : VR=480
IF NX>640 OR NY>464 THEN HR=800 : VR=600
'
'  Watch out for images being too big.
'
IF NX>800 OR NY>584 THEN HR=0 : VR=0
IF HR>320 OR VR>200 THEN
'
'  An SVGA mode is required.  See if necessary video characteristics exist
' and get them.
'
SINFO.STYPE=1 : SINFO.MTYPE="G"
CALL FINDVESA(MODE$,HR,VR,8)
IF MODE$="-1" THEN
'
'  256-color video mode with 800 x 600 or less resolution couldn't be
' found.  See if there's a 1,024 x 768 mode available.
'
HR=1024 : VR=768
CALL FINDVESA(MODE$,HR,VR,8)
END IF
'
'  Get video buffer address and SVGA window granularity.
'
WINADD=0
IF MODE$<>"-1" THEN
IF (SINFO.WINA AND 1%)=1 AND (SINFO.WINA AND 4%)=4 THEN
IF SINFO.ASEG>32767& THEN SINFO.ASEG=SINFO.ASEG-65536&
WINADD=CINT(SINFO.ASEG) : WINNUM=0
ELSEIF (SINFO.WINB AND 1%)=1 AND (SINFO.WINB AND 4%)=4 THEN
IF SINFO.BSEG>32767& THEN SINFO.BSEG=SINFO.BSEG-65536&
WINADD=CINT(SINFO.BSEG) : WINNUM=1
END IF
IF SINFO.STYPE<0 THEN MODE$="-1"
END IF
SINFO.GRAN=SINFO.GRAN*1024&
END IF
'
'  If suitable video mode couldn't be found, abort.
'
IF HR=0 OR VR=0 OR MODE$="-1" OR WINADD=0 OR SINFO.GRAN>65536& THEN GOTO CANTDO
HRLONG=CLNG(HR) : VRLONG=CLNG(VR)
'
'  Images will be centered on screen, allowing at least 8 rows for image
' numbers to be displayed at the top.
'
NLEFT=INT(CSNG(HR-NX)/2+.001) : NTOP=INT(CSNG(VR-NY)/2+.001)
'
'  Use crude scheme to figure out how much of a delay to use between
' image displays.
'
DELAY=VAL(ENVIRON$("DELAY"))
IF DELAY=0 THEN
TM$=TIME$
T0=3600*VAL(MID$(TM$,1,2))+60*VAL(MID$(TM$,4,2))+VAL(MID$(TM$,7,2))
FOR K=1& TO 280000&
LOCATE 1,30
PRINT "Determining CPU speed."
NEXT K
TM$=TIME$
DELAY=3600*VAL(MID$(TM$,1,2))+60*VAL(MID$(TM$,4,2))+VAL(MID$(TM$,7,2))-T0
DELAY=DELAY/4
END IF
IF DELAY<0 THEN DELAY=0
'
'  Load image data into "virtual" memory.
'
LOCATE 3,34
PRINT "Loading data."
'
'  Watch out for a partial video bank being required.
'
EXCESS=SINFO.GRAN-((HRLONG*VRLONG) MOD SINFO.GRAN) : EXCESS=EXCESS MOD SINFO.GRAN
'
'  Define array storing zero-pad data (for filling partial video bank).
'
IF EXCESS>0& THEN DIM ZERO(1 TO EXCESS\2&) AS INTEGER
'
'  Get number of 65,535-byte blocks in window granularity and excess.  (If
' there's more than one, there's a problem.)
'
NBLOCK=INT(SINFO.GRAN/65535&+.001) : BEX=SINFO.GRAN-65535&*CLNG(NBLOCK)
IF NBLOCK>1 THEN GOTO CANTDO
IF NTOP>0 THEN
'
'  Define line of zeroes for padding top of images.
'
BFLINE$=""
FOR I=1 TO HR
BFLINE$=BFLINE$+CHR$(0)
NEXT I
END IF
LPLINE$=""
IF NLEFT>0 THEN
'
'  Define partial line of zeroes to left of image.
'
FOR I=1 TO NLEFT
LPLINE$=LPLINE$+CHR$(0)
NEXT I
END IF
RPLINE$=""
IF NX+NLEFT<HR THEN
'
'  Do same for right side of image.
'
FOR I=NX+NLEFT+1 TO HR
RPLINE$=RPLINE$+CHR$(0)
NEXT I
END IF
'
'  Define NX-long variable to hold line of image data.
'
ILINE$=""
FOR I=1 TO NX
ILINE$=ILINE$+CHR$(0)
NEXT I
SMBF=VARSEG(BFLINE$) : OSBF=SADD(BFLINE$)
SMDATA=VARSEG(ILINE$) : OSDATA=SADD(ILINE$)
'
'  Get directory to store temporary files.
'
TEMPPATH$=TEMPDIR$(N)
'
'  Input image data and write it to temporary files.
'
NXLONG=CLNG(NX)
FOR K=1& TO N
F$="SAR."+LTRIM$(STR$(K))
IF EXIST(F$)<>1 THEN GOTO FILESDONE
'
' Pad image space with zeroes at top.  (The "IF NTOP" test shouldn't be
' necessary.  Call me paranoid.)
'
CALL FOPEN(TEMPPATH$+"FILE."+LTRIM$(STR$(K)),HANDLE1,1)
IF HANDLE1=0 THEN GOTO NOHANDLE
IF NTOP>0 THEN
FOR J=1 TO NTOP
CALL FWRITE(HANDLE1,HRLONG,SMBF,OSBF)
NEXT J
END IF
'
'  Open Kth image file.
'
CALL FOPEN(F$,HANDLE,2)
IF HANDLE=0 THEN CALL FCLOSE(HANDLE1) : GOTO NOHANDLE
FOR J=1 TO NY
'
'  First line of data in file is bottom row of image; data has to go into
' temporary file in reverse order.
'
CALL FPOINT(HANDLE,12&+NXLONG*CLNG(NY-J),FLOCNEW)
'
'  Put image data for current row in ILINE$ string.
'
CALL FREAD(HANDLE,NXLONG,SMDATA,OSDATA)
'
'  Pad image row with spaces and put in temporary file.
'
DLINE$=LPLINE$+ILINE$+RPLINE$
CALL FWRITE(HANDLE1,HRLONG,VARSEG(DLINE$),SADD(DLINE$))
NEXT J
CALL FCLOSE(HANDLE)
'
'  Data for image K is in "virtual" memory.  Pad bottom portion of image
' space with zeroes if there's space.  (Again, I'm being paranoid with the
' "IF NY+NTOP" test.)
'
IF NY+NTOP<VR THEN
FOR J=NY+NTOP+1 TO VR
CALL FWRITE(HANDLE1,HRLONG,SMBF,OSBF)
NEXT J
END IF
IF EXCESS>0& THEN
'
'  Pad partial bank with zeros.
'
CALL FWRITE(HANDLE1,EXCESS,VARSEG(ZERO(1)),VARPTR(ZERO(1)))
END IF
CALL FCLOSE(HANDLE1)
NEXT K
GOTO GOTFILES
FILESDONE:
'
'  Don't you just love error checks in the middle of everything?
'
N=CINT(K-1&)
IF N>0 THEN GOTO GOTFILES
PRINT
PRINT "You don't have any SAR image files to display."
PRINT
GOTO QUIT
GOTFILES:
'
'  Beep to let human know files are input.
'
BEEP
'
'  Here comes some fun.  The images will be labelled as they're displayed.
' This requires a character set.  In mode 13, such a character set exists
' and could just be used with PRINT.  However, although the character set
' also exists in an SVGA mode, PRINT won't work then.  So, rather than do
' more decision-making than necessary in the process of displaying the
' images, mode 13's character set is used just for the specific numeric
' labels needed.  This character data is PRINTed on the screen in mode 13
' and then transferred to the appropriate "virtual" memory locations.
' That way, mode 13's character set can be used regardless of the actual
' video mode used to display the images.
'
SCREEN 13
'
'  The pelmask register is used to keep character generation from being
' visible to human.
'
OUT &H3C6,0
FOR K=1& TO N
CALL FOPEN(TEMPPATH$+"FILE."+LTRIM$(STR$(K)),HANDLE1,0)
IF HANDLE1=0 THEN GOTO NOHANDLE
LOCATE 1,1
PRINT K
FOR Y=0& TO 7&
VLINE$=""
FOR X=0& TO 23&
VLINE$=VLINE$+CHR$(POINT(X,Y))
NEXT X
CALL FPOINT(HANDLE1,Y*HRLONG,FLOCNEW)
CALL FWRITE(HANDLE1,24&,VARSEG(VLINE$),SADD(VLINE$))
NEXT Y
CALL FCLOSE(HANDLE1)
NEXT K
'
'  If mode 13 is actually to be used to display the images, well, it's
' already set.  If not, set appropriate video mode.
'
IF MODE$<>"13" THEN
INREGS.AX=&H4F02
INREGS.BX=VAL("&H"+MODE$)
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
END IF
'
'  Define color palette.
'
DATA 0,0,0,20,0,0,21,0,0,22,0,0,23,0,0,24,0,0,25,0,0,26,0,0
DATA 27,0,0,28,0,0,29,0,0,30,0,0,31,0,0,32,0,0,33,0,0,34,0,0
DATA 35,0,0,36,0,0,37,0,0,38,0,0,39,0,0,40,0,0,41,0,0,42,0,0
DATA 43,0,0,44,0,0,45,0,0,46,0,0,47,0,0,48,0,0,49,0,0,50,0,0
DATA 51,0,0,52,0,0,53,0,0,54,0,0,55,0,0,56,0,0,57,0,0,58,0,0
DATA 59,0,0,60,0,0,61,0,0,62,0,0,63,0,0,63,20,0,63,21,0,63,22,0
DATA 63,23,0,63,24,0,63,25,0,63,26,0,63,27,0,63,28,0,63,29,0,63,30,0
DATA 63,31,0,63,32,0,63,33,0,63,34,0,63,35,0,63,36,0,63,37,0,63,38,0
DATA 63,39,0,63,40,0,63,41,0,63,42,0,63,43,0,63,44,0,63,45,0,63,46,0
DATA 63,47,0,63,48,0,63,49,0,63,50,0,63,51,0,63,52,0,63,53,0,63,54,0
DATA 63,55,0,63,56,0,63,57,0,63,58,0,63,59,0,63,60,0,63,61,0,63,62,0
DATA 63,63,0,62,63,0,61,63,0,60,63,0,59,63,0,58,63,0,57,63,0,56,63,0
DATA 55,63,0,54,63,0,53,63,0,52,63,0,51,63,0,50,63,0,49,63,0,48,63,0
DATA 47,63,0,46,63,0,45,63,0,44,63,0,43,63,0,42,63,0,41,63,0,40,63,0
DATA 39,63,0,38,63,0,37,63,0,36,63,0,35,63,0,34,63,0,33,63,0,32,63,0
DATA 31,63,0,30,63,0,29,63,0,28,63,0,27,63,0,26,63,0,25,63,0,24,63,0
DATA 23,63,0,22,63,0,21,63,0,20,63,0,19,63,0,18,63,0,17,63,0,16,63,0
DATA 15,63,0,14,63,0,13,63,0,12,63,0,11,63,0,10,63,0,9,63,0,8,63,0
DATA 7,63,0,6,63,0,5,63,0,4,63,0,3,63,0,2,63,0,1,63,0,0,63,0
DATA 0,63,20,0,63,21,0,63,22,0,63,23,0,63,24,0,63,25,0,63,26,0,63,27
DATA 0,63,28,0,63,29,0,63,30,0,63,31,0,63,32,0,63,33,0,63,34,0,63,35
DATA 0,63,36,0,63,37,0,63,38,0,63,39,0,63,40,0,63,41,0,63,42,0,63,43
DATA 0,63,44,0,63,45,0,63,46,0,63,47,0,63,48,0,63,49,0,63,50,0,63,51
DATA 0,63,52,0,63,53,0,63,54,0,63,55,0,63,56,0,63,57,0,63,58,0,63,59
DATA 0,63,60,0,63,61,0,63,62,0,63,63,0,59,63,0,58,63,0,57,63,0,56,63
DATA 0,55,63,0,54,63,0,53,63,0,52,63,0,51,63,0,50,63,0,49,63,0,48,63
DATA 0,47,63,0,46,63,0,45,63,0,44,63,0,43,63,0,42,63,0,41,63,0,40,63
DATA 0,39,63,0,38,63,0,37,63,0,36,63,0,35,63,0,34,63,0,33,63,0,32,63
DATA 0,31,63,0,30,63,0,29,63,0,28,63,0,27,63,0,26,63,0,25,63,0,24,63
DATA 0,23,63,0,22,63,0,21,63,0,20,63,0,19,63,0,18,63,0,17,63,0,16,63
DATA 0,15,63,0,14,63,0,13,63,0,12,63,0,11,63,0,10,63,0,9,63,0,8,63
DATA 0,7,63,0,6,63,0,5,63,0,4,63,0,3,63,0,2,63,0,1,63,0,0,63
OUT &H3C8,0
FOR I=0 TO 255
READ R,G,B
OUT &H3C9,R
OUT &H3C9,G
OUT &H3C9,B
NEXT I
'
'  MAN becomes nonzero when you press F1 to go into manual mode and is
' reset back to 0 when you go back into continuous mode.
'
MAN=0
'
'  Get number of video windows/banks necessary to store/display video
' data.
'
NWINS=CSNG(HR)*CSNG(VR)/SINFO.GRAN
NWIN=INT(NWINS+.001) : IF ABS(NWINS-NWIN)>.0001 THEN NWIN=NWIN+1
'
'  Set up F1 keystroke processing.
'
ON KEY(1) GOSUB MANUAL
KEY(1) ON
'
'  Reset pelmask register so screen data is visible.
'
OUT &H3C6,255
'
'  Begin movie.
'
WHILE INKEY$=""
'
'  T1 is for the purpose of outputting the frames per second at the end.
' (And that's only done if DELAY = 0.  Even then, it will be pretty much
' meaningless if you've been using the "manual mode" feature during the
' final cycle.)
'
T1=TIMER
FOR K=1& TO N
CALL FOPEN(TEMPPATH$+"FILE."+LTRIM$(STR$(K)),HANDLE1,2)
IF HANDLE1=0 THEN GOTO NOHANDLE
'
'  Video bank numbers are zero-based.
'
FOR I=0 TO NWIN-1
IF MODE$<>"13" THEN
'
'  SVGA mode is in effect.  Perform bank switch and don't let F1-press
' interfere with it.
'
KEY(1) OFF
INREGS.AX=&H4F05
INREGS.BX=WINNUM
INREGS.DX=I
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
KEY(1) ON
END IF
'
'  Transfer Ith bank of video data from "virtual" memory to video memory.
'
OSVID=0
IF NBLOCK=1 THEN
CALL FREAD(HANDLE1,65535&,WINADD,0)
OSVID=-1
END IF
IF BEX>0& THEN CALL FREAD(HANDLE1,BEX,WINADD,OSVID)
NEXT I
CALL FCLOSE(HANDLE1)
'
'  Delay next image display temporarily unless manual mode is in effect--
' in which case next image display is delayed indefinitely.
'
IF MAN=0 THEN
FOR L=1& TO CLNG(DELAY*40000) : NEXT L
ELSE
10 A$=INKEY$ : IF A$="" THEN GOTO 10
'
'  Manual mode is in effect; watch out for ESC-press.
'
IF A$=CHR$(27) THEN GOTO KILLFILES
END IF
20 NEXT K
T1=TIMER-T1
WEND
KILLFILES:
'
'  Time to quit.  Reset video mode and delete temporary files.
'
SCREEN 0
WIDTH 80
IF MODE$<>"13" THEN
'
'  This is because QB doesn't recover from SVGA modes gracefully.
'
INREGS.AX=3
CALL INTERRUPTX(&H10,INREGS,OUTREGS)
END IF
FOR I=1 TO N
KILL TEMPPATH$+"FILE."+LTRIM$(STR$(I))
NEXT I
IF DELAY=0 AND MAN=0 THEN
PRINT
PRINT LTRIM$(STR$(CDBL(N)/T1));" frames per second"
PRINT
END IF
GOTO QUIT
CANTDO:
PRINT
PRINT "This program won't work with your images and this computer."
PRINT
GOTO QUIT
PRINT
NOHANDLE:
PRINT
PRINT "Couldn't open file."
PRINT
QUIT:
END
MANUAL:
IF MAN=0 THEN
MAN=1
ELSE
MAN=0
RETURN 20
END IF
RETURN
'$INCLUDE: 'EXIST.FUN'
'$INCLUDE: 'FINDVESA.SUB'
'$INCLUDE: 'FIO.BAS'
'
'  This function gets the name of the directory to store temporary
' files and gets the FILES= parameter as set by CONFIG.SYS to make a crude
' estimate of the maximum number of temporary files allowed.
'
FUNCTION TEMPDIR$(N AS INTEGER)
DIM CF AS INTEGER,OS AS INTEGER,MAXFILES AS INTEGER
VMSDIR$=UCASE$(LTRIM$(RTRIM$(ENVIRON$("VMSDIR"))))
IF VMSDIR$="" THEN
VMSDIR$=UCASE$(LTRIM$(RTRIM$(ENVIRON$("TEMP"))))
IF VMSDIR$="" THEN
VMSDIR$=UCASE$(LTRIM$(RTRIM$(ENVIRON$("TMP"))))
IF VMSDIR$="" THEN
VMSDIR$="C:\"
IF EXIST(VMSDIR$+"QBVMS.DAT")=3 THEN
PRINT
PRINT "  Your environment doesn't specify a VMSDIR parameter to use for tempor";
PRINT "ary"
PRINT "files, nor does it specify TEMP or TMP parameters; and you don't appear";
PRINT " to"
PRINT "have a disk C to use as a default."
PRINT
STOP
END IF
END IF
END IF
END IF
IF RIGHT$(VMSDIR$,1)<>"\" THEN VMSDIR$=VMSDIR$+"\"
'
'  Get FILES= parameter as specified in CONFIG.SYS.
'
DEF SEG=VARSEG(FIOCODE(1))
OS=VARPTR(FIOCODE(1))+46
FOR MAXFILES=0 TO 255
POKE OS+7,MAXFILES
CALL ABSOLUTE(CF,OS)
CF=(CF AND &HFF00&)/256
IF (CF AND 1%)=1 THEN EXIT FOR
NEXT MAXFILES
DEF SEG
MAXFILES=MAXFILES-10
IF MAXFILES<N THEN
PRINT
PRINT "You need to increase the FILES= parameter in your CONFIG.SYS to ";
PRINT N+10;" or add/modify the PerVMFiles= setting in the [386Enh] section"
PRINT "of \WINDOWS\SYSTEM.INI."
PRINT
STOP
END IF
TEMPDIR$=VMSDIR$
END FUNCTION
