'
'  This program converts the files SAR.1 to SAR."N", where N is specified
' on the command-line, to the files SAR001.BMP to SAR"N".BMP (where "N"
' here is always a three-digit number).
'
DECLARE FUNCTION EXIST%(FILE$)
DIM I AS INTEGER,N AS INTEGER,RC AS INTEGER
'
'  Get number of files to process.  (If it isn't positive, don't do
' anything.)
'
N=VAL(COMMAND$)
'
'  Restrict N.
'
IF N>999 THEN N=999
IF N>0 THEN
'
'  Make bmp files.
'
FOR I=1 TO N
OFILE$=LTRIM$(STR$(I))
IFILE$="SAR."+OFILE$
CALL SAR2BMP(IFILE$,RC)
IF I<100 THEN OFILE$="0"+OFILE$
IF I<10 THEN OFILE$="0"+OFILE$
OFILE$="SAR"+OFILE$+".BMP"
IF RC=0 THEN
IF EXIST(OFILE$)=1 THEN KILL OFILE$
NAME "SAR.BMP" AS OFILE$
ELSE
PRINT "Couldn't make ";OFILE$;"."
END IF
NEXT I
ELSE
PRINT
PRINT "Thanks for the exercise."
END IF
END
'
'  This subroutine parses an input string S$ into the separate strings S1$
' and S2$, based on the delimiting string DL$. On return, S1$ and S2$
' will contain no leading or trailling spaces.
'
SUB PARSE(S$,DL$,S1$,S2$)
SI$=LTRIM$(RTRIM$(S$))
N=LEN(SI$)
S1$=SI$
S2$=""
IF N=0 THEN GOTO TERM
I=INSTR(SI$,DL$)
IF I=0 THEN GOTO TERM
S1$=RTRIM$(MID$(SI$,1,I-1))
S2$=LTRIM$(MID$(SI$,I+LEN(DL$),N-I-LEN(DL$)+1))
TERM:
END SUB

'
'  This routine subroutine generates an 8-bit bmp file (SAR.BMP) from a
' SAR image file (FILE$ in parameter list).  If RC is returned as anything
' but 0, the bmp file didn't get created.  It requires the following
' DECLARE statement.
'
'   DECLARE FUNCTION EXIST%(FILE$)
'
SUB SAR2BMP(FILE$,RC AS INTEGER)
DIM HLEN AS LONG,OFFS AS LONG,BITS AS INTEGER,PLANES AS INTEGER,J AS INTEGER
DIM ZPAD AS LONG,ATTR AS STRING*1,PALVAR(1 TO 3) AS STRING*1,W AS LONG,H AS LONG
DIM NBYTES AS LONG,LOFILE AS LONG,BM AS STRING*2,I AS INTEGER,NX AS INTEGER
DIM ZERO AS STRING*1,WOUT AS LONG,NY AS INTEGER,IPIXEL AS INTEGER
'
'  Open file if it exists.
'
IF EXIST(FILE$)=1 THEN
RC=0
OPEN FILE$ FOR BINARY AS #1
'
'  Get width and height of image.
'
GET#1,,NX
GET#1,,NY
W=CLNG(NX) : H=CLNG(NY)
'
'  Find out if file stores 8-byte complex data, 4-byte real data, or one-
' byte pixel data.
'
IPIXEL=0
IF W*H*4&+72&=LOF(1) THEN IPIXEL=1
IF W*H*8&+72&=LOF(1) THEN IPIXEL=2
'
'  If it's not byte data, it must be pixelized.  That involves reading the
' data in before reading it again to make the BMP.
'
IF IPIXEL<>0 THEN
SEEK #1,73
PMIN=1E20
PMAX=-1E20
FOR J=1 TO NY
FOR I=1 TO NX
IMAG=0
GET#1,,PIXEL
IF IPIXEL=2 THEN GET#1,,IMAG
PIXEL=SQR(PIXEL^2+IMAG^2)
IF PIXEL>0 AND PIXEL<PMIN THEN PMIN=PIXEL
IF PIXEL>PMAX THEN PMAX=PIXEL
NEXT I
NEXT J
BIN=(PMAX-PMIN)/254
'
'  Okay, the data necessary for later pixelization is available.  Position
' file pointer.
'
SEEK #1,73
ELSE
SEEK #1,13
END IF
'
'  WOUT is used because BMP width must be multiple of 4.
'
WOUT=4&*INT(CSNG(W+3&)/4+.001)
'
'  Define some static parameters.
'
OFFS=1078&
NBYTES=WOUT*H
LOFILE=NBYTES+OFFS
HLEN=40&
BITS=8
PLANES=1
ZPAD=0&
BM="BM"
ZERO=CHR$(0)
'
'  Define palette data.
'
DATA 0,0,0,20,0,0,21,0,0,22,0,0,23,0,0,24,0,0,25,0,0,26,0,0
DATA 27,0,0,28,0,0,29,0,0,30,0,0,31,0,0,32,0,0,33,0,0,34,0,0
DATA 35,0,0,36,0,0,37,0,0,38,0,0,39,0,0,40,0,0,41,0,0,42,0,0
DATA 43,0,0,44,0,0,45,0,0,46,0,0,47,0,0,48,0,0,49,0,0,50,0,0
DATA 51,0,0,52,0,0,53,0,0,54,0,0,55,0,0,56,0,0,57,0,0,58,0,0
DATA 59,0,0,60,0,0,61,0,0,62,0,0,63,0,0,63,20,0,63,21,0,63,22,0
DATA 63,23,0,63,24,0,63,25,0,63,26,0,63,27,0,63,28,0,63,29,0,63,30,0
DATA 63,31,0,63,32,0,63,33,0,63,34,0,63,35,0,63,36,0,63,37,0,63,38,0
DATA 63,39,0,63,40,0,63,41,0,63,42,0,63,43,0,63,44,0,63,45,0,63,46,0
DATA 63,47,0,63,48,0,63,49,0,63,50,0,63,51,0,63,52,0,63,53,0,63,54,0
DATA 63,55,0,63,56,0,63,57,0,63,58,0,63,59,0,63,60,0,63,61,0,63,62,0
DATA 63,63,0,62,63,0,61,63,0,60,63,0,59,63,0,58,63,0,57,63,0,56,63,0
DATA 55,63,0,54,63,0,53,63,0,52,63,0,51,63,0,50,63,0,49,63,0,48,63,0
DATA 47,63,0,46,63,0,45,63,0,44,63,0,43,63,0,42,63,0,41,63,0,40,63,0
DATA 39,63,0,38,63,0,37,63,0,36,63,0,35,63,0,34,63,0,33,63,0,32,63,0
DATA 31,63,0,30,63,0,29,63,0,28,63,0,27,63,0,26,63,0,25,63,0,24,63,0
DATA 23,63,0,22,63,0,21,63,0,20,63,0,19,63,0,18,63,0,17,63,0,16,63,0
DATA 15,63,0,14,63,0,13,63,0,12,63,0,11,63,0,10,63,0,9,63,0,8,63,0
DATA 7,63,0,6,63,0,5,63,0,4,63,0,3,63,0,2,63,0,1,63,0,0,63,0
DATA 0,63,20,0,63,21,0,63,22,0,63,23,0,63,24,0,63,25,0,63,26,0,63,27
DATA 0,63,28,0,63,29,0,63,30,0,63,31,0,63,32,0,63,33,0,63,34,0,63,35
DATA 0,63,36,0,63,37,0,63,38,0,63,39,0,63,40,0,63,41,0,63,42,0,63,43
DATA 0,63,44,0,63,45,0,63,46,0,63,47,0,63,48,0,63,49,0,63,50,0,63,51
DATA 0,63,52,0,63,53,0,63,54,0,63,55,0,63,56,0,63,57,0,63,58,0,63,59
DATA 0,63,60,0,63,61,0,63,62,0,63,63,0,59,63,0,58,63,0,57,63,0,56,63
DATA 0,55,63,0,54,63,0,53,63,0,52,63,0,51,63,0,50,63,0,49,63,0,48,63
DATA 0,47,63,0,46,63,0,45,63,0,44,63,0,43,63,0,42,63,0,41,63,0,40,63
DATA 0,39,63,0,38,63,0,37,63,0,36,63,0,35,63,0,34,63,0,33,63,0,32,63
DATA 0,31,63,0,30,63,0,29,63,0,28,63,0,27,63,0,26,63,0,25,63,0,24,63
DATA 0,23,63,0,22,63,0,21,63,0,20,63,0,19,63,0,18,63,0,17,63,0,16,63
DATA 0,15,63,0,14,63,0,13,63,0,12,63,0,11,63,0,10,63,0,9,63,0,8,63
DATA 0,7,63,0,6,63,0,5,63,0,4,63,0,3,63,0,2,63,0,1,63,0,0,63
'
'  Open bmp file and generate header.
'
OPEN "SAR.BMP" FOR BINARY AS #2
PUT#2,,BM
PUT#2,,LOFILE
PUT#2,,ZPAD
PUT#2,,OFFS
PUT#2,,HLEN
PUT#2,,W
PUT#2,,H
PUT#2,,PLANES
PUT#2,,BITS
PUT#2,,ZPAD
PUT#2,,NBYTES
FOR I=1 TO 4
PUT#2,,ZPAD
NEXT I
'
'  Generate 24-bit palette.  (Scale 6-bit values in DATA statements to 8-
' bit values.)
'
RESTORE
FOR I=0 TO 255
'
'  BMP files store palette data in reverse order from the standard video
' palette.
'
FOR J=1 TO 3
READ PALDATA
PALVAR(J)=CHR$(INT(255*PALDATA/63))
NEXT J
FOR J=3 TO 1 STEP -1
PUT#2,,PALVAR(J)
NEXT J
PUT#2,,ZERO
NEXT I
'
'  Get and write image data.  (The SAR image file already stores data in
' the BMP last-row-first order.)
'
FOR J=1 TO H
FOR I=1 TO W
IF IPIXEL=0 THEN
GET#1,,ATTR
ELSE
IMAG=0
GET#1,,PIXEL
IF IPIXEL=2 THEN GET#1,,IMAG
PIXEL=SQR(PIXEL^2+IMAG^2)
ATTR=CHR$(0)
IF PIXEL>=PMIN THEN ATTR=CHR$(INT((PIXEL-PMIN)/BIN+.001)+1)
END IF
PUT#2,,ATTR
NEXT I
IF WOUT>W THEN
'
'  Pad scan line to 32-bit boundary.
'
FOR I=W+1& TO WOUT
PUT#2,,ZERO
NEXT I
END IF
NEXT J
CLOSE #1
CLOSE #2
ELSE
RC=1
END IF
END SUB
'
'  This function can be used by QB/Qbasic programs to determine if a file
' (FILE$ in the parameter list) exists.  It returns an INTEGER 0 if the
' file doesn't exist, 1 if it does, 3 if the path-specification (if
' included in the file name) is invalid (which may for all intents and
' purposes be the same as the file not existing), and 2 if the function,
' for some reason, cannot determine whether or not the file exists.
'
'  Your MAIN routine must include the following DECLARE statement.
'
'   DECLARE FUNCTION EXIST%(FILE$)
'
DEFINT E
FUNCTION EXIST%(FILE$)
'
'  Alias input file name with F$ and make latter asciiz string.
'
F$=RTRIM$(LTRIM$(FILE$))+CHR$(0)
'
'  Set up machine code to open file for read-only access and call it.
'
DIM MCODE(1 TO 21) AS INTEGER,AX AS INTEGER,CF AS INTEGER,SM AS INTEGER
DIM OS AS INTEGER,OSC AS INTEGER
SM=VARSEG(F$) : OS=SADD(F$)
DEF SEG=VARSEG(MCODE(1))
OSC=VARPTR(MCODE(1))
POKE OSC,&H55                                         'PUSH BP
POKE OSC+1,&H89 : POKE OSC+2,&HE5                     'MOV BP,SP
POKE OSC+3,&HB8 : POKE OSC+4,0 : POKE OSC+5,&H3D      'MOV AX,3D00
POKE OSC+6,&HBB                                       'MOV BX,[SM]
POKE OSC+7,SM AND &HFF
POKE OSC+8,(SM AND &HFF00&)/256
POKE OSC+9,&H8E : POKE OSC+10,&HDB                    'MOV DS,BX
POKE OSC+11,&HBA                                      'MOV DX,[OS]
POKE OSC+12,OS AND &HFF
POKE OSC+13,(OS AND &HFF00&)/256
POKE OSC+14,&HCD : POKE OSC+15,&H21                   'INT 21
POKE OSC+16,&H89 : POKE OSC+17,&HC3                   'MOV BX,AX
POKE OSC+18,&H9F                                      'LAHF
POKE OSC+19,&H8B : POKE OSC+20,&H7E : POKE OSC+21,6   'MOV DI,[BP+6]
POKE OSC+22,&H89 : POKE OSC+23,&H1D                   'MOV [DI],BX
POKE OSC+24,&H8B : POKE OSC+25,&H7E : POKE OSC+26,8   'MOV DI,[BP+8]
POKE OSC+27,&H89 : POKE OSC+28,5                      'MOV [DI],AX
POKE OSC+29,&H5D                                      'POP BP
POKE OSC+30,&HCA : POKE OSC+31,4 : POKE OSC+32,0      'RETF 4
'
'  The following is to close the file (thus freeing the handle) if a file
' gets opened.
'
POKE OSC+33,&HB4 : POKE OSC+34,&H3E                   'MOV AH,3E
POKE OSC+35,&HBB : POKE OSC+36,0 : POKE OSC+37,0      'MOV BX,[HANDLE]
POKE OSC+38,&HCD : POKE OSC+39,&H21                   'INT 21
POKE OSC+40,&HCB                                      'RETF
CALL ABSOLUTE(CF,AX,OSC)
'
'  Get carry flag.  If it's zero, file exists.  If it's not zero,
' file either doesn't or interrupt call failed for some other reason.
'
CF=((CF AND &HFF00&)/256) AND 1%
IF CF=0 THEN
'
'  File exists.  Close it, set function value, and return.  (The values
' originally put at offsets 36 and 37 in the machine code were dummy.
' They're made real here, now that the file handle is known.)
'
POKE OSC+36,AX AND &HFF : POKE OSC+37,(AX AND &HFF00&)/256
CALL ABSOLUTE(OSC+33)
EX=1                         'Temporary function value
ELSE
'
'  Interrupt call couldn't find file.  Find out why (look at the value of
' AX returned).
'
IF AX=2 THEN
'
'  It apparently failed because file doesn't exist.  Set function value
' and return.
'
EX=0
ELSE
'
'  Interrupt call failed for some other reason.  Set function value to 2
' and return.  An exception is if the reason for failure is an invalid
' path-specification.  In that event, the file certainly doesn't exist.
' However, in that special case, set function value to 3 (which is the
' value of the error code in this case).
'
EX=2 : IF AX=3 THEN EX=AX
END IF
END IF
DEF SEG
EXIST=EX
END FUNCTION
DEFSNG E
