'
'  This function can be used by QB/Qbasic programs to determine if a file
' (FILE$ in the parameter list) exists.  It returns an INTEGER 0 if the
' file doesn't exist, 1 if it does, 3 if the path-specification (if
' included in the file name) is invalid (which may for all intents and
' purposes be the same as the file not existing), and 2 if the function,
' for some reason, cannot determine whether or not the file exists.
'
'  Your MAIN routine must include the following DECLARE statement.
'
'   DECLARE FUNCTION EXIST%(FILE$)
'
DEFINT E
FUNCTION EXIST%(FILE$)
'
'  Alias input file name with F$ and make latter asciiz string.
'
F$=RTRIM$(LTRIM$(FILE$))+CHR$(0)
'
'  Set up machine code to open file for read-only access and call it.
'
DIM MCODE(1 TO 21) AS INTEGER,AX AS INTEGER,CF AS INTEGER,SM AS INTEGER
DIM OS AS INTEGER,OSC AS INTEGER
SM=VARSEG(F$) : OS=SADD(F$)
DEF SEG=VARSEG(MCODE(1))
OSC=VARPTR(MCODE(1))
POKE OSC,&H55                                         'PUSH BP
POKE OSC+1,&H89 : POKE OSC+2,&HE5                     'MOV BP,SP
POKE OSC+3,&HB8 : POKE OSC+4,0 : POKE OSC+5,&H3D      'MOV AX,3D00
POKE OSC+6,&HBB                                       'MOV BX,[SM]
POKE OSC+7,SM AND &HFF
POKE OSC+8,(SM AND &HFF00&)/256
POKE OSC+9,&H8E : POKE OSC+10,&HDB                    'MOV DS,BX
POKE OSC+11,&HBA                                      'MOV DX,[OS]
POKE OSC+12,OS AND &HFF
POKE OSC+13,(OS AND &HFF00&)/256
POKE OSC+14,&HCD : POKE OSC+15,&H21                   'INT 21
POKE OSC+16,&H89 : POKE OSC+17,&HC3                   'MOV BX,AX
POKE OSC+18,&H9F                                      'LAHF
POKE OSC+19,&H8B : POKE OSC+20,&H7E : POKE OSC+21,6   'MOV DI,[BP+6]
POKE OSC+22,&H89 : POKE OSC+23,&H1D                   'MOV [DI],BX
POKE OSC+24,&H8B : POKE OSC+25,&H7E : POKE OSC+26,8   'MOV DI,[BP+8]
POKE OSC+27,&H89 : POKE OSC+28,5                      'MOV [DI],AX
POKE OSC+29,&H5D                                      'POP BP
POKE OSC+30,&HCA : POKE OSC+31,4 : POKE OSC+32,0      'RETF 4
'
'  The following is to close the file (thus freeing the handle) if a file
' gets opened.
'
POKE OSC+33,&HB4 : POKE OSC+34,&H3E                   'MOV AH,3E
POKE OSC+35,&HBB : POKE OSC+36,0 : POKE OSC+37,0      'MOV BX,[HANDLE]
POKE OSC+38,&HCD : POKE OSC+39,&H21                   'INT 21
POKE OSC+40,&HCB                                      'RETF
CALL ABSOLUTE(CF,AX,OSC)
'
'  Get carry flag.  If it's zero, file exists.  If it's not zero,
' file either doesn't or interrupt call failed for some other reason.
'
CF=((CF AND &HFF00&)/256) AND 1%
IF CF=0 THEN
'
'  File exists.  Close it, set function value, and return.  (The values
' originally put at offsets 36 and 37 in the machine code were dummy.
' They're made real here, now that the file handle is known.)
'
POKE OSC+36,AX AND &HFF : POKE OSC+37,(AX AND &HFF00&)/256
CALL ABSOLUTE(OSC+33)
EX=1                         'Temporary function value
ELSE
'
'  Interrupt call couldn't find file.  Find out why (look at the value of
' AX returned).
'
IF AX=2 THEN
'
'  It apparently failed because file doesn't exist.  Set function value
' and return.
'
EX=0
ELSE
'
'  Interrupt call failed for some other reason.  Set function value to 2
' and return.  An exception is if the reason for failure is an invalid
' path-specification.  In that event, the file certainly doesn't exist.
' However, in that special case, set function value to 3 (which is the
' value of the error code in this case).
'
EX=2 : IF AX=3 THEN EX=AX
END IF
END IF
DEF SEG
EXIST=EX
END FUNCTION
DEFSNG E
