/*
 * $Id$
 *
 * Copyright (c) 1997 Andrew G. Morgan <morgan@parc.power.net>
 *
 * This file contains the functions that create and duplicate
 * audit records.
 */

#include "audit.h"

/* p145 - get a fresh unused audit template */

aud_rec_t aud_init_record(void)
{
    struct __aud_rec_s *record = __aud_malloc(sizeof(struct __aud_rec_s),
					      __AUD_MAGIC_RECORD);

    if (record != NULL) {
	/* reset */
	memset(record, 0, sizeof(record));
	record->magic = __AUD_MAGIC_RECORD;
    } else {
	/* despite the fact that malloc will do this we have to be sure. */
	errno = ENOMEM;
    }

    return record;
}

/* p124 - duplicate an audit record - returns pointer to new record or NULL */

aud_rec_t aud_dup_record(aud_rec_t original_d)
{
    errno = ENOSYS;
    return NULL;
}

/* p162 - verify the syntactical correctness of an audit record -
   returns 0(success) -1(failure) */

int aud_valid(aud_rec_t ar)
{
    errno = ENOSYS;
    return -1;
}

/*
 * $Log$
 */
