/*
 * r8a7791 processor support - PFC hardware block.
 *
 * Copyright (C) 2013 Renesas Electronics Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 */

#include <linux/kernel.h>

#include "core.h"
#include "sh_pfc.h"

#define PORT_GP_26(bank, fn, sfx)					\
	PORT_GP_1(bank, 0,  fn, sfx), PORT_GP_1(bank, 1,  fn, sfx),	\
	PORT_GP_1(bank, 2,  fn, sfx), PORT_GP_1(bank, 3,  fn, sfx),	\
	PORT_GP_1(bank, 4,  fn, sfx), PORT_GP_1(bank, 5,  fn, sfx),	\
	PORT_GP_1(bank, 6,  fn, sfx), PORT_GP_1(bank, 7,  fn, sfx),	\
	PORT_GP_1(bank, 8,  fn, sfx), PORT_GP_1(bank, 9,  fn, sfx),	\
	PORT_GP_1(bank, 10, fn, sfx), PORT_GP_1(bank, 11, fn, sfx),	\
	PORT_GP_1(bank, 12, fn, sfx), PORT_GP_1(bank, 13, fn, sfx),	\
	PORT_GP_1(bank, 14, fn, sfx), PORT_GP_1(bank, 15, fn, sfx),	\
	PORT_GP_1(bank, 16, fn, sfx), PORT_GP_1(bank, 17, fn, sfx),	\
	PORT_GP_1(bank, 18, fn, sfx), PORT_GP_1(bank, 19, fn, sfx),	\
	PORT_GP_1(bank, 20, fn, sfx), PORT_GP_1(bank, 21, fn, sfx),	\
	PORT_GP_1(bank, 22, fn, sfx), PORT_GP_1(bank, 23, fn, sfx),	\
	PORT_GP_1(bank, 24, fn, sfx), PORT_GP_1(bank, 25, fn, sfx)

#define CPU_ALL_PORT(fn, sfx)						\
	PORT_GP_32(0, fn, sfx),						\
	PORT_GP_26(1, fn, sfx),						\
	PORT_GP_32(2, fn, sfx),						\
	PORT_GP_32(3, fn, sfx),						\
	PORT_GP_32(4, fn, sfx),						\
	PORT_GP_32(5, fn, sfx),						\
	PORT_GP_32(6, fn, sfx),						\
	PORT_GP_26(7, fn, sfx)

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	GP_ALL(DATA),
	PINMUX_DATA_END,

	PINMUX_FUNCTION_BEGIN,
	GP_ALL(FN),

	/* GPSR0 */
	FN_IP0_0, FN_IP0_1, FN_IP0_2, FN_IP0_3, FN_IP0_4, FN_IP0_5,
	FN_IP0_6, FN_IP0_7, FN_IP0_8, FN_IP0_9, FN_IP0_10, FN_IP0_11,
	FN_IP0_12, FN_IP0_13, FN_IP0_14, FN_IP0_15, FN_IP0_18_16, FN_IP0_20_19,
	FN_IP0_22_21, FN_IP0_24_23, FN_IP0_26_25, FN_IP0_28_27, FN_IP0_30_29,
	FN_IP1_1_0, FN_IP1_3_2, FN_IP1_5_4, FN_IP1_7_6, FN_IP1_10_8,
	FN_IP1_13_11, FN_IP1_16_14, FN_IP1_19_17, FN_IP1_22_20,

	/* GPSR1 */
	FN_IP1_25_23, FN_IP1_28_26, FN_IP1_31_29, FN_IP2_2_0, FN_IP2_4_3,
	FN_IP2_6_5, FN_IP2_9_7, FN_IP2_12_10, FN_IP2_15_13, FN_IP2_18_16,
	FN_IP2_20_19, FN_IP2_22_21, FN_EX_CS0_N, FN_IP2_24_23, FN_IP2_26_25,
	FN_IP2_29_27, FN_IP3_2_0, FN_IP3_5_3, FN_IP3_8_6, FN_RD_N,
	FN_IP3_11_9, FN_IP3_13_12, FN_IP3_15_14 , FN_IP3_17_16 , FN_IP3_19_18,
	FN_IP3_21_20,

	/* GPSR2 */
	FN_IP3_27_25, FN_IP3_30_28, FN_IP4_1_0, FN_IP4_4_2, FN_IP4_7_5,
	FN_IP4_9_8, FN_IP4_12_10, FN_IP4_15_13, FN_IP4_18_16, FN_IP4_19,
	FN_IP4_20, FN_IP4_21, FN_IP4_23_22, FN_IP4_25_24, FN_IP4_27_26,
	FN_IP4_30_28, FN_IP5_2_0, FN_IP5_5_3, FN_IP5_8_6, FN_IP5_11_9,
	FN_IP5_14_12, FN_IP5_16_15, FN_IP5_19_17, FN_IP5_21_20, FN_IP5_23_22,
	FN_IP5_25_24, FN_IP5_28_26, FN_IP5_31_29, FN_AUDIO_CLKA, FN_IP6_2_0,
	FN_IP6_5_3, FN_IP6_7_6,

	/* GPSR3 */
	FN_IP7_5_3, FN_IP7_8_6, FN_IP7_10_9, FN_IP7_12_11, FN_IP7_14_13,
	FN_IP7_16_15, FN_IP7_18_17, FN_IP7_20_19, FN_IP7_23_21, FN_IP7_26_24,
	FN_IP7_29_27, FN_IP8_2_0, FN_IP8_5_3, FN_IP8_8_6, FN_IP8_11_9,
	FN_IP8_14_12, FN_IP8_17_15, FN_IP8_20_18, FN_IP8_23_21, FN_IP8_25_24,
	FN_IP8_27_26, FN_IP8_30_28, FN_IP9_2_0, FN_IP9_5_3, FN_IP9_6, FN_IP9_7,
	FN_IP9_10_8, FN_IP9_11, FN_IP9_12, FN_IP9_15_13, FN_IP9_16,
	FN_IP9_18_17,

	/* GPSR4 */
	FN_VI0_CLK, FN_IP9_20_19, FN_IP9_22_21, FN_IP9_24_23, FN_IP9_26_25,
	FN_VI0_DATA0_VI0_B0, FN_VI0_DATA1_VI0_B1, FN_VI0_DATA2_VI0_B2,
	FN_IP9_28_27, FN_VI0_DATA4_VI0_B4, FN_VI0_DATA5_VI0_B5,
	FN_VI0_DATA6_VI0_B6, FN_VI0_DATA7_VI0_B7, FN_IP9_31_29, FN_IP10_2_0,
	FN_IP10_5_3, FN_IP10_8_6, FN_IP10_11_9, FN_IP10_14_12, FN_IP10_16_15,
	FN_IP10_18_17, FN_IP10_21_19, FN_IP10_24_22, FN_IP10_26_25,
	FN_IP10_28_27, FN_IP10_31_29, FN_IP11_2_0, FN_IP11_5_3, FN_IP11_8_6,
	FN_IP15_1_0, FN_IP15_3_2, FN_IP15_5_4,

	/* GPSR5 */
	FN_IP11_11_9, FN_IP11_14_12, FN_IP11_16_15, FN_IP11_18_17, FN_IP11_19,
	FN_IP11_20, FN_IP11_21, FN_IP11_22, FN_IP11_23, FN_IP11_24,
	FN_IP11_25, FN_IP11_26, FN_IP11_27, FN_IP11_29_28, FN_IP11_31_30,
	FN_IP12_1_0, FN_IP12_3_2, FN_IP12_6_4, FN_IP12_9_7, FN_IP12_12_10,
	FN_IP12_15_13, FN_IP12_17_16, FN_IP12_19_18, FN_IP12_21_20,
	FN_IP12_23_22, FN_IP12_26_24, FN_IP12_29_27, FN_IP13_2_0, FN_IP13_4_3,
	FN_IP13_6_5, FN_IP13_9_7, FN_IP3_24_22,

	/* GPSR6 */
	FN_IP13_10, FN_IP13_11, FN_IP13_12, FN_IP13_13, FN_IP13_14,
	FN_IP13_15, FN_IP13_18_16, FN_IP13_21_19,
	FN_IP13_22, FN_IP13_24_23, FN_SD1_CLK,
	FN_IP13_25, FN_IP13_26, FN_IP13_27, FN_IP13_30_28, FN_IP14_1_0,
	FN_IP14_2, FN_IP14_3, FN_IP14_4, FN_IP14_5, FN_IP14_6, FN_IP14_7,
	FN_IP14_10_8, FN_IP14_13_11, FN_IP14_16_14, FN_IP14_19_17,
	FN_IP14_22_20, FN_IP14_25_23, FN_IP14_28_26, FN_IP14_31_29,
	FN_USB1_OVC, FN_DU0_DOTCLKIN,

	/* GPSR7 */
	FN_IP15_17_15, FN_IP15_20_18, FN_IP15_23_21, FN_IP15_26_24,
	FN_IP15_29_27, FN_IP16_2_0, FN_IP16_5_3, FN_IP16_7_6, FN_IP16_9_8,
	FN_IP16_11_10, FN_IP6_9_8, FN_IP6_11_10, FN_IP6_13_12, FN_IP6_15_14,
	FN_IP6_18_16, FN_IP6_20_19, FN_IP6_23_21, FN_IP6_26_24, FN_IP6_29_27,
	FN_IP7_2_0, FN_IP15_8_6, FN_IP15_11_9, FN_IP15_14_12,
	FN_USB0_PWEN, FN_USB0_OVC, FN_USB1_PWEN,

	/* IPSR0 */
	FN_D0, FN_D1, FN_D2, FN_D3, FN_D4, FN_D5, FN_D6, FN_D7, FN_D8,
	FN_D9, FN_D10, FN_D11, FN_D12, FN_D13, FN_D14, FN_D15,
	FN_A0, FN_ATAWR0_N_C, FN_MSIOF0_SCK_B, FN_SCL0_C, FN_PWM2_B,
	FN_A1, FN_MSIOF0_SYNC_B, FN_A2, FN_MSIOF0_SS1_B,
	FN_A3, FN_MSIOF0_SS2_B, FN_A4, FN_MSIOF0_TXD_B,
	FN_A5, FN_MSIOF0_RXD_B, FN_A6, FN_MSIOF1_SCK,

	/* IPSR1 */
	FN_A7, FN_MSIOF1_SYNC, FN_A8, FN_MSIOF1_SS1, FN_SCL0,
	FN_A9, FN_MSIOF1_SS2, FN_SDA0,
	FN_A10, FN_MSIOF1_TXD, FN_MSIOF1_TXD_D,
	FN_A11, FN_MSIOF1_RXD, FN_SCL3_D, FN_MSIOF1_RXD_D,
	FN_A12, FN_FMCLK, FN_SDA3_D, FN_MSIOF1_SCK_D,
	FN_A13, FN_ATAG0_N_C, FN_BPFCLK, FN_MSIOF1_SS1_D,
	FN_A14, FN_ATADIR0_N_C, FN_FMIN, FN_FMIN_C, FN_MSIOF1_SYNC_D,
	FN_A15, FN_BPFCLK_C,
	FN_A16, FN_DREQ2_B, FN_FMCLK_C, FN_SCIFA1_SCK_B,
	FN_A17, FN_DACK2_B, FN_SDA0_C,
	FN_A18, FN_DREQ1, FN_SCIFA1_RXD_C, FN_SCIFB1_RXD_C,

	/* IPSR2 */
	FN_A19, FN_DACK1, FN_SCIFA1_TXD_C, FN_SCIFB1_TXD_C, FN_SCIFB1_SCK_B,
	FN_A20, FN_SPCLK,
	FN_A21, FN_ATAWR0_N_B, FN_MOSI_IO0,
	FN_A22, FN_MISO_IO1, FN_FMCLK_B, FN_TX0, FN_SCIFA0_TXD,
	FN_A23, FN_IO2, FN_BPFCLK_B, FN_RX0, FN_SCIFA0_RXD,
	FN_A24, FN_DREQ2, FN_IO3, FN_TX1, FN_SCIFA1_TXD,
	FN_A25, FN_DACK2, FN_SSL, FN_DREQ1_C, FN_RX1, FN_SCIFA1_RXD,
	FN_CS0_N, FN_ATAG0_N_B, FN_SCL1,
	FN_CS1_N_A26, FN_ATADIR0_N_B, FN_SDA1,
	FN_EX_CS1_N, FN_MSIOF2_SCK,
	FN_EX_CS2_N, FN_ATAWR0_N, FN_MSIOF2_SYNC,
	FN_EX_CS3_N, FN_ATADIR0_N, FN_MSIOF2_TXD, FN_ATAG0_N, FN_EX_WAIT1,

	/* IPSR3 */
	FN_EX_CS4_N, FN_ATARD0_N, FN_MSIOF2_RXD, FN_EX_WAIT2,
	FN_EX_CS5_N, FN_ATACS00_N, FN_MSIOF2_SS1, FN_HRX1_B,
	FN_SCIFB1_RXD_B, FN_PWM1, FN_TPU_TO1,
	FN_BS_N, FN_ATACS10_N, FN_MSIOF2_SS2, FN_HTX1_B,
	FN_SCIFB1_TXD_B, FN_PWM2, FN_TPU_TO2,
	FN_RD_WR_N, FN_HRX2_B, FN_FMIN_B, FN_SCIFB0_RXD_B, FN_DREQ1_D,
	FN_WE0_N, FN_HCTS2_N_B, FN_SCIFB0_TXD_B,
	FN_WE1_N, FN_ATARD0_N_B, FN_HTX2_B, FN_SCIFB0_RTS_N_B,
	FN_EX_WAIT0, FN_HRTS2_N_B, FN_SCIFB0_CTS_N_B,
	FN_DREQ0, FN_PWM3, FN_TPU_TO3,
	FN_DACK0, FN_DRACK0, FN_REMOCON,
	FN_SPEEDIN, FN_HSCK0_C, FN_HSCK2_C, FN_SCIFB0_SCK_B,
	FN_SCIFB2_SCK_B, FN_DREQ2_C, FN_HTX2_D,
	FN_SSI_SCK0129, FN_HRX0_C, FN_HRX2_C, FN_SCIFB0_RXD_C, FN_SCIFB2_RXD_C,
	FN_SSI_WS0129, FN_HTX0_C, FN_HTX2_C, FN_SCIFB0_TXD_C, FN_SCIFB2_TXD_C,

	/* IPSR4 */
	FN_SSI_SDATA0, FN_SCL0_B, FN_SCL7_B, FN_MSIOF2_SCK_C,
	FN_SSI_SCK1, FN_SDA0_B, FN_SDA7_B, FN_MSIOF2_SYNC_C, FN_GLO_I0_D,
	FN_SSI_WS1, FN_SCL1_B, FN_SCL8_B, FN_MSIOF2_TXD_C, FN_GLO_I1_D,
	FN_SSI_SDATA1, FN_SDA1_B, FN_SDA8_B, FN_MSIOF2_RXD_C,
	FN_SSI_SCK2, FN_SCL2, FN_GPS_CLK_B, FN_GLO_Q0_D, FN_HSCK1_E,
	FN_SSI_WS2, FN_SDA2, FN_GPS_SIGN_B, FN_RX2_E,
	FN_GLO_Q1_D, FN_HCTS1_N_E,
	FN_SSI_SDATA2, FN_GPS_MAG_B, FN_TX2_E, FN_HRTS1_N_E,
	FN_SSI_SCK34, FN_SSI_WS34, FN_SSI_SDATA3,
	FN_SSI_SCK4, FN_GLO_SS_D,
	FN_SSI_WS4, FN_GLO_RFON_D,
	FN_SSI_SDATA4, FN_MSIOF2_SCK_D,
	FN_SSI_SCK5, FN_MSIOF1_SCK_C, FN_TS_SDATA0, FN_GLO_I0,
	FN_MSIOF2_SYNC_D, FN_VI1_R2_B,

	/* IPSR5 */
	FN_SSI_WS5, FN_MSIOF1_SYNC_C, FN_TS_SCK0, FN_GLO_I1,
	FN_MSIOF2_TXD_D, FN_VI1_R3_B,
	FN_SSI_SDATA5, FN_MSIOF1_TXD_C, FN_TS_SDEN0, FN_GLO_Q0,
	FN_MSIOF2_SS1_D, FN_VI1_R4_B,
	FN_SSI_SCK6, FN_MSIOF1_RXD_C, FN_TS_SPSYNC0, FN_GLO_Q1,
	FN_MSIOF2_RXD_D, FN_VI1_R5_B,
	FN_SSI_WS6, FN_GLO_SCLK, FN_MSIOF2_SS2_D, FN_VI1_R6_B,
	FN_SSI_SDATA6, FN_STP_IVCXO27_0_B, FN_GLO_SDATA, FN_VI1_R7_B,
	FN_SSI_SCK78, FN_STP_ISCLK_0_B, FN_GLO_SS,
	FN_SSI_WS78, FN_TX0_D, FN_STP_ISD_0_B, FN_GLO_RFON,
	FN_SSI_SDATA7, FN_RX0_D, FN_STP_ISEN_0_B,
	FN_SSI_SDATA8, FN_TX1_D, FN_STP_ISSYNC_0_B,
	FN_SSI_SCK9, FN_RX1_D, FN_GLO_SCLK_D,
	FN_SSI_WS9, FN_TX3_D, FN_CAN0_TX_D, FN_GLO_SDATA_D,
	FN_SSI_SDATA9, FN_RX3_D, FN_CAN0_RX_D,

	/* IPSR6 */
	FN_AUDIO_CLKB, FN_STP_OPWM_0_B, FN_MSIOF1_SCK_B,
	FN_SCIF_CLK, FN_BPFCLK_E,
	FN_AUDIO_CLKC, FN_SCIFB0_SCK_C, FN_MSIOF1_SYNC_B, FN_RX2,
	FN_SCIFA2_RXD, FN_FMIN_E,
	FN_AUDIO_CLKOUT, FN_MSIOF1_SS1_B, FN_TX2, FN_SCIFA2_TXD,
	FN_IRQ0, FN_SCIFB1_RXD_D, FN_INTC_IRQ0_N,
	FN_IRQ1, FN_SCIFB1_SCK_C, FN_INTC_IRQ1_N,
	FN_IRQ2, FN_SCIFB1_TXD_D, FN_INTC_IRQ2_N,
	FN_IRQ3, FN_SCL4_C, FN_MSIOF2_TXD_E, FN_INTC_IRQ3_N,
	FN_IRQ4, FN_HRX1_C, FN_SDA4_C, FN_MSIOF2_RXD_E, FN_INTC_IRQ4_N,
	FN_IRQ5, FN_HTX1_C, FN_SCL1_E, FN_MSIOF2_SCK_E,
	FN_IRQ6, FN_HSCK1_C, FN_MSIOF1_SS2_B, FN_SDA1_E, FN_MSIOF2_SYNC_E,
	FN_IRQ7, FN_HCTS1_N_C, FN_MSIOF1_TXD_B, FN_GPS_CLK_C, FN_GPS_CLK_D,
	FN_IRQ8, FN_HRTS1_N_C, FN_MSIOF1_RXD_B, FN_GPS_SIGN_C, FN_GPS_SIGN_D,

	/* IPSR7 */
	FN_IRQ9, FN_DU1_DOTCLKIN_B, FN_CAN_CLK_D, FN_GPS_MAG_C,
	FN_SCIF_CLK_B, FN_GPS_MAG_D,
	FN_DU1_DR0, FN_LCDOUT0, FN_VI1_DATA0_B, FN_TX0_B,
	FN_SCIFA0_TXD_B, FN_MSIOF2_SCK_B,
	FN_DU1_DR1, FN_LCDOUT1, FN_VI1_DATA1_B, FN_RX0_B,
	FN_SCIFA0_RXD_B, FN_MSIOF2_SYNC_B,
	FN_DU1_DR2, FN_LCDOUT2, FN_SSI_SCK0129_B,
	FN_DU1_DR3, FN_LCDOUT3, FN_SSI_WS0129_B,
	FN_DU1_DR4, FN_LCDOUT4, FN_SSI_SDATA0_B,
	FN_DU1_DR5, FN_LCDOUT5, FN_SSI_SCK1_B,
	FN_DU1_DR6, FN_LCDOUT6, FN_SSI_WS1_B,
	FN_DU1_DR7, FN_LCDOUT7, FN_SSI_SDATA1_B,
	FN_DU1_DG0, FN_LCDOUT8, FN_VI1_DATA2_B, FN_TX1_B,
	FN_SCIFA1_TXD_B, FN_MSIOF2_SS1_B,
	FN_DU1_DG1, FN_LCDOUT9, FN_VI1_DATA3_B, FN_RX1_B,
	FN_SCIFA1_RXD_B, FN_MSIOF2_SS2_B,
	FN_DU1_DG2, FN_LCDOUT10, FN_VI1_DATA4_B, FN_SCIF1_SCK_B,
	FN_SCIFA1_SCK, FN_SSI_SCK78_B,

	/* IPSR8 */
	FN_DU1_DG3, FN_LCDOUT11, FN_VI1_DATA5_B, FN_SSI_WS78_B,
	FN_DU1_DG4, FN_LCDOUT12, FN_VI1_DATA6_B, FN_HRX0_B,
	FN_SCIFB2_RXD_B, FN_SSI_SDATA7_B,
	FN_DU1_DG5, FN_LCDOUT13, FN_VI1_DATA7_B, FN_HCTS0_N_B,
	FN_SCIFB2_TXD_B, FN_SSI_SDATA8_B,
	FN_DU1_DG6, FN_LCDOUT14, FN_HRTS0_N_B,
	FN_SCIFB2_CTS_N_B, FN_SSI_SCK9_B,
	FN_DU1_DG7, FN_LCDOUT15, FN_HTX0_B, FN_SCIFB2_RTS_N_B, FN_SSI_WS9_B,
	FN_DU1_DB0, FN_LCDOUT16, FN_VI1_CLK_B, FN_TX2_B,
	FN_SCIFA2_TXD_B, FN_MSIOF2_TXD_B,
	FN_DU1_DB1, FN_LCDOUT17, FN_VI1_HSYNC_N_B, FN_RX2_B,
	FN_SCIFA2_RXD_B, FN_MSIOF2_RXD_B,
	FN_DU1_DB2, FN_LCDOUT18, FN_VI1_VSYNC_N_B, FN_SCIF2_SCK_B,
	FN_SCIFA2_SCK, FN_SSI_SDATA9_B,
	FN_DU1_DB3, FN_LCDOUT19, FN_VI1_CLKENB_B,
	FN_DU1_DB4, FN_LCDOUT20, FN_VI1_FIELD_B, FN_CAN1_RX,
	FN_DU1_DB5, FN_LCDOUT21, FN_TX3, FN_SCIFA3_TXD, FN_CAN1_TX,

	/* IPSR9 */
	FN_DU1_DB6, FN_LCDOUT22, FN_SCL3_C, FN_RX3, FN_SCIFA3_RXD,
	FN_DU1_DB7, FN_LCDOUT23, FN_SDA3_C, FN_SCIF3_SCK, FN_SCIFA3_SCK,
	FN_DU1_DOTCLKIN, FN_QSTVA_QVS,
	FN_DU1_DOTCLKOUT0, FN_QCLK,
	FN_DU1_DOTCLKOUT1, FN_QSTVB_QVE, FN_CAN0_TX,
	FN_TX3_B, FN_SCL2_B, FN_PWM4,
	FN_DU1_EXHSYNC_DU1_HSYNC, FN_QSTH_QHS,
	FN_DU1_EXVSYNC_DU1_VSYNC, FN_QSTB_QHE,
	FN_DU1_EXODDF_DU1_ODDF_DISP_CDE, FN_QCPV_QDE,
	FN_CAN0_RX, FN_RX3_B, FN_SDA2_B,
	FN_DU1_DISP, FN_QPOLA,
	FN_DU1_CDE, FN_QPOLB, FN_PWM4_B,
	FN_VI0_CLKENB, FN_TX4, FN_SCIFA4_TXD, FN_TS_SDATA0_D,
	FN_VI0_FIELD, FN_RX4, FN_SCIFA4_RXD, FN_TS_SCK0_D,
	FN_VI0_HSYNC_N, FN_TX5, FN_SCIFA5_TXD, FN_TS_SDEN0_D,
	FN_VI0_VSYNC_N, FN_RX5, FN_SCIFA5_RXD, FN_TS_SPSYNC0_D,
	FN_VI0_DATA3_VI0_B3, FN_SCIF3_SCK_B, FN_SCIFA3_SCK_B,
	FN_VI0_G0, FN_SCL8, FN_STP_IVCXO27_0_C, FN_SCL4,
	FN_HCTS2_N, FN_SCIFB2_CTS_N, FN_ATAWR1_N,

	/* IPSR10 */
	FN_VI0_G1, FN_SDA8, FN_STP_ISCLK_0_C, FN_SDA4,
	FN_HRTS2_N, FN_SCIFB2_RTS_N, FN_ATADIR1_N,
	FN_VI0_G2, FN_VI2_HSYNC_N, FN_STP_ISD_0_C, FN_SCL3_B,
	FN_HSCK2, FN_SCIFB2_SCK, FN_ATARD1_N,
	FN_VI0_G3, FN_VI2_VSYNC_N, FN_STP_ISEN_0_C, FN_SDA3_B,
	FN_HRX2, FN_SCIFB2_RXD, FN_ATACS01_N,
	FN_VI0_G4, FN_VI2_CLKENB, FN_STP_ISSYNC_0_C,
	FN_HTX2, FN_SCIFB2_TXD, FN_SCIFB0_SCK_D,
	FN_VI0_G5, FN_VI2_FIELD, FN_STP_OPWM_0_C, FN_FMCLK_D,
	FN_CAN0_TX_E, FN_HTX1_D, FN_SCIFB0_TXD_D,
	FN_VI0_G6, FN_VI2_CLK, FN_BPFCLK_D,
	FN_VI0_G7, FN_VI2_DATA0, FN_FMIN_D,
	FN_VI0_R0, FN_VI2_DATA1, FN_GLO_I0_B,
	FN_TS_SDATA0_C, FN_ATACS11_N,
	FN_VI0_R1, FN_VI2_DATA2, FN_GLO_I1_B,
	FN_TS_SCK0_C, FN_ATAG1_N,
	FN_VI0_R2, FN_VI2_DATA3, FN_GLO_Q0_B, FN_TS_SDEN0_C,
	FN_VI0_R3, FN_VI2_DATA4, FN_GLO_Q1_B, FN_TS_SPSYNC0_C,
	FN_VI0_R4, FN_VI2_DATA5, FN_GLO_SCLK_B, FN_TX0_C, FN_SCL1_D,

	/* IPSR11 */
	FN_VI0_R5, FN_VI2_DATA6, FN_GLO_SDATA_B, FN_RX0_C, FN_SDA1_D,
	FN_VI0_R6, FN_VI2_DATA7, FN_GLO_SS_B, FN_TX1_C, FN_SCL4_B,
	FN_VI0_R7, FN_GLO_RFON_B, FN_RX1_C, FN_CAN0_RX_E,
	FN_SDA4_B, FN_HRX1_D, FN_SCIFB0_RXD_D,
	FN_VI1_HSYNC_N, FN_AVB_RXD0, FN_TS_SDATA0_B, FN_TX4_B, FN_SCIFA4_TXD_B,
	FN_VI1_VSYNC_N, FN_AVB_RXD1, FN_TS_SCK0_B, FN_RX4_B, FN_SCIFA4_RXD_B,
	FN_VI1_CLKENB, FN_AVB_RXD2, FN_TS_SDEN0_B,
	FN_VI1_FIELD, FN_AVB_RXD3, FN_TS_SPSYNC0_B,
	FN_VI1_CLK, FN_AVB_RXD4, FN_VI1_DATA0, FN_AVB_RXD5,
	FN_VI1_DATA1, FN_AVB_RXD6, FN_VI1_DATA2, FN_AVB_RXD7,
	FN_VI1_DATA3, FN_AVB_RX_ER, FN_VI1_DATA4, FN_AVB_MDIO,
	FN_VI1_DATA5, FN_AVB_RX_DV, FN_VI1_DATA6, FN_AVB_MAGIC,
	FN_VI1_DATA7, FN_AVB_MDC,
	FN_ETH_MDIO, FN_AVB_RX_CLK, FN_SCL2_C,
	FN_ETH_CRS_DV, FN_AVB_LINK, FN_SDA2_C,

	/* IPSR12 */
	FN_ETH_RX_ER, FN_AVB_CRS, FN_SCL3, FN_SCL7,
	FN_ETH_RXD0, FN_AVB_PHY_INT, FN_SDA3, FN_SDA7,
	FN_ETH_RXD1, FN_AVB_GTXREFCLK, FN_CAN0_TX_C,
	FN_SCL2_D, FN_MSIOF1_RXD_E,
	FN_ETH_LINK, FN_AVB_TXD0, FN_CAN0_RX_C, FN_SDA2_D, FN_MSIOF1_SCK_E,
	FN_ETH_REFCLK, FN_AVB_TXD1, FN_SCIFA3_RXD_B,
	FN_CAN1_RX_C, FN_MSIOF1_SYNC_E,
	FN_ETH_TXD1, FN_AVB_TXD2, FN_SCIFA3_TXD_B,
	FN_CAN1_TX_C, FN_MSIOF1_TXD_E,
	FN_ETH_TX_EN, FN_AVB_TXD3, FN_TCLK1_B, FN_CAN_CLK_B,
	FN_ETH_MAGIC, FN_AVB_TXD4, FN_IETX_C,
	FN_ETH_TXD0, FN_AVB_TXD5, FN_IECLK_C,
	FN_ETH_MDC, FN_AVB_TXD6, FN_IERX_C,
	FN_STP_IVCXO27_0, FN_AVB_TXD7, FN_SCIFB2_TXD_D,
	FN_ADIDATA_B, FN_MSIOF0_SYNC_C,
	FN_STP_ISCLK_0, FN_AVB_TX_EN, FN_SCIFB2_RXD_D,
	FN_ADICS_SAMP_B, FN_MSIOF0_SCK_C,

	/* IPSR13 */
	FN_STP_ISD_0, FN_AVB_TX_ER, FN_SCIFB2_SCK_C,
	FN_ADICLK_B, FN_MSIOF0_SS1_C,
	FN_STP_ISEN_0, FN_AVB_TX_CLK, FN_ADICHS0_B, FN_MSIOF0_SS2_C,
	FN_STP_ISSYNC_0, FN_AVB_COL, FN_ADICHS1_B, FN_MSIOF0_RXD_C,
	FN_STP_OPWM_0, FN_AVB_GTX_CLK, FN_PWM0_B,
	FN_ADICHS2_B, FN_MSIOF0_TXD_C,
	FN_SD0_CLK, FN_SPCLK_B, FN_SD0_CMD, FN_MOSI_IO0_B,
	FN_SD0_DATA0, FN_MISO_IO1_B, FN_SD0_DATA1, FN_IO2_B,
	FN_SD0_DATA2, FN_IO3_B, FN_SD0_DATA3, FN_SSL_B,
	FN_SD0_CD, FN_MMC_D6_B, FN_SIM0_RST_B, FN_CAN0_RX_F,
	FN_SCIFA5_TXD_B, FN_TX3_C,
	FN_SD0_WP, FN_MMC_D7_B, FN_SIM0_D_B, FN_CAN0_TX_F,
	FN_SCIFA5_RXD_B, FN_RX3_C,
	FN_SD1_CMD, FN_REMOCON_B, FN_SD1_DATA0, FN_SPEEDIN_B,
	FN_SD1_DATA1, FN_IETX_B, FN_SD1_DATA2, FN_IECLK_B,
	FN_SD1_DATA3, FN_IERX_B,
	FN_SD1_CD, FN_PWM0, FN_TPU_TO0, FN_SCL1_C,

	/* IPSR14 */
	FN_SD1_WP, FN_PWM1_B, FN_SDA1_C,
	FN_SD2_CLK, FN_MMC_CLK, FN_SD2_CMD, FN_MMC_CMD,
	FN_SD2_DATA0, FN_MMC_D0, FN_SD2_DATA1, FN_MMC_D1,
	FN_SD2_DATA2, FN_MMC_D2, FN_SD2_DATA3, FN_MMC_D3,
	FN_SD2_CD, FN_MMC_D4, FN_SCL8_C, FN_TX5_B, FN_SCIFA5_TXD_C,
	FN_SD2_WP, FN_MMC_D5, FN_SDA8_C, FN_RX5_B, FN_SCIFA5_RXD_C,
	FN_MSIOF0_SCK, FN_RX2_C, FN_ADIDATA, FN_VI1_CLK_C, FN_VI1_G0_B,
	FN_MSIOF0_SYNC, FN_TX2_C, FN_ADICS_SAMP, FN_VI1_CLKENB_C, FN_VI1_G1_B,
	FN_MSIOF0_TXD, FN_ADICLK, FN_VI1_FIELD_C, FN_VI1_G2_B,
	FN_MSIOF0_RXD, FN_ADICHS0, FN_VI1_DATA0_C, FN_VI1_G3_B,
	FN_MSIOF0_SS1, FN_MMC_D6, FN_ADICHS1, FN_TX0_E,
	FN_VI1_HSYNC_N_C, FN_SCL7_C, FN_VI1_G4_B,
	FN_MSIOF0_SS2, FN_MMC_D7, FN_ADICHS2, FN_RX0_E,
	FN_VI1_VSYNC_N_C, FN_SDA7_C, FN_VI1_G5_B,

	/* IPSR15 */
	FN_SIM0_RST, FN_IETX, FN_CAN1_TX_D,
	FN_SIM0_CLK, FN_IECLK, FN_CAN_CLK_C,
	FN_SIM0_D, FN_IERX, FN_CAN1_RX_D,
	FN_GPS_CLK, FN_DU1_DOTCLKIN_C, FN_AUDIO_CLKB_B,
	FN_PWM5_B, FN_SCIFA3_TXD_C,
	FN_GPS_SIGN, FN_TX4_C, FN_SCIFA4_TXD_C, FN_PWM5,
	FN_VI1_G6_B, FN_SCIFA3_RXD_C,
	FN_GPS_MAG, FN_RX4_C, FN_SCIFA4_RXD_C, FN_PWM6,
	FN_VI1_G7_B, FN_SCIFA3_SCK_C,
	FN_HCTS0_N, FN_SCIFB0_CTS_N, FN_GLO_I0_C, FN_TCLK1, FN_VI1_DATA1_C,
	FN_HRTS0_N, FN_SCIFB0_RTS_N, FN_GLO_I1_C, FN_VI1_DATA2_C,
	FN_HSCK0, FN_SCIFB0_SCK, FN_GLO_Q0_C, FN_CAN_CLK,
	FN_TCLK2, FN_VI1_DATA3_C,
	FN_HRX0, FN_SCIFB0_RXD, FN_GLO_Q1_C, FN_CAN0_RX_B, FN_VI1_DATA4_C,
	FN_HTX0, FN_SCIFB0_TXD, FN_GLO_SCLK_C, FN_CAN0_TX_B, FN_VI1_DATA5_C,

	/* IPSR16 */
	FN_HRX1, FN_SCIFB1_RXD, FN_VI1_R0_B, FN_GLO_SDATA_C, FN_VI1_DATA6_C,
	FN_HTX1, FN_SCIFB1_TXD, FN_VI1_R1_B, FN_GLO_SS_C, FN_VI1_DATA7_C,
	FN_HSCK1, FN_SCIFB1_SCK, FN_MLB_CLK, FN_GLO_RFON_C,
	FN_HCTS1_N, FN_SCIFB1_CTS_N, FN_MLB_SIG, FN_CAN1_TX_B,
	FN_HRTS1_N, FN_SCIFB1_RTS_N, FN_MLB_DAT, FN_CAN1_RX_B,

	/* MOD_SEL */
	FN_SEL_SCIF1_0, FN_SEL_SCIF1_1, FN_SEL_SCIF1_2, FN_SEL_SCIF1_3,
	FN_SEL_SCIFB_0, FN_SEL_SCIFB_1, FN_SEL_SCIFB_2, FN_SEL_SCIFB_3,
	FN_SEL_SCIFB2_0, FN_SEL_SCIFB2_1, FN_SEL_SCIFB2_2, FN_SEL_SCIFB2_3,
	FN_SEL_SCIFB1_0, FN_SEL_SCIFB1_1, FN_SEL_SCIFB1_2, FN_SEL_SCIFB1_3,
	FN_SEL_SCIFA1_0, FN_SEL_SCIFA1_1, FN_SEL_SCIFA1_2,
	FN_SEL_SSI9_0, FN_SEL_SSI9_1,
	FN_SEL_SCFA_0, FN_SEL_SCFA_1,
	FN_SEL_QSP_0, FN_SEL_QSP_1,
	FN_SEL_SSI7_0, FN_SEL_SSI7_1,
	FN_SEL_HSCIF1_0, FN_SEL_HSCIF1_1, FN_SEL_HSCIF1_2, FN_SEL_HSCIF1_3,
	FN_SEL_HSCIF1_4,
	FN_SEL_VI1_0, FN_SEL_VI1_1, FN_SEL_VI1_2,
	FN_SEL_TMU1_0, FN_SEL_TMU1_1,
	FN_SEL_LBS_0, FN_SEL_LBS_1, FN_SEL_LBS_2, FN_SEL_LBS_3,
	FN_SEL_TSIF0_0, FN_SEL_TSIF0_1, FN_SEL_TSIF0_2, FN_SEL_TSIF0_3,
	FN_SEL_SOF0_0, FN_SEL_SOF0_1, FN_SEL_SOF0_2,

	/* MOD_SEL2 */
	FN_SEL_SCIF0_0, FN_SEL_SCIF0_1, FN_SEL_SCIF0_2, FN_SEL_SCIF0_3,
	FN_SEL_SCIF0_4,
	FN_SEL_SCIF_0, FN_SEL_SCIF_1,
	FN_SEL_CAN0_0, FN_SEL_CAN0_1, FN_SEL_CAN0_2, FN_SEL_CAN0_3,
	FN_SEL_CAN0_4, FN_SEL_CAN0_5,
	FN_SEL_CAN1_0, FN_SEL_CAN1_1, FN_SEL_CAN1_2, FN_SEL_CAN1_3,
	FN_SEL_SCIFA2_0, FN_SEL_SCIFA2_1,
	FN_SEL_SCIF4_0, FN_SEL_SCIF4_1, FN_SEL_SCIF4_2,
	FN_SEL_ADG_0, FN_SEL_ADG_1,
	FN_SEL_FM_0, FN_SEL_FM_1, FN_SEL_FM_2, FN_SEL_FM_3, FN_SEL_FM_4,
	FN_SEL_SCIFA5_0, FN_SEL_SCIFA5_1, FN_SEL_SCIFA5_2,
	FN_SEL_GPS_0, FN_SEL_GPS_1, FN_SEL_GPS_2, FN_SEL_GPS_3,
	FN_SEL_SCIFA4_0, FN_SEL_SCIFA4_1, FN_SEL_SCIFA4_2,
	FN_SEL_SCIFA3_0, FN_SEL_SCIFA3_1, FN_SEL_SCIFA3_2,
	FN_SEL_SIM_0, FN_SEL_SIM_1,
	FN_SEL_SSI8_0, FN_SEL_SSI8_1,

	/* MOD_SEL3 */
	FN_SEL_HSCIF2_0, FN_SEL_HSCIF2_1, FN_SEL_HSCIF2_2, FN_SEL_HSCIF2_3,
	FN_SEL_CANCLK_0, FN_SEL_CANCLK_1, FN_SEL_CANCLK_2, FN_SEL_CANCLK_3,
	FN_SEL_IIC8_0, FN_SEL_IIC8_1, FN_SEL_IIC8_2,
	FN_SEL_IIC7_0, FN_SEL_IIC7_1, FN_SEL_IIC7_2,
	FN_SEL_IIC4_0, FN_SEL_IIC4_1, FN_SEL_IIC4_2,
	FN_SEL_IIC3_0, FN_SEL_IIC3_1, FN_SEL_IIC3_2, FN_SEL_IIC3_3,
	FN_SEL_SCIF3_0, FN_SEL_SCIF3_1, FN_SEL_SCIF3_2, FN_SEL_SCIF3_3,
	FN_SEL_IEB_0, FN_SEL_IEB_1, FN_SEL_IEB_2,
	FN_SEL_MMC_0, FN_SEL_MMC_1,
	FN_SEL_SCIF5_0, FN_SEL_SCIF5_1,
	FN_SEL_IIC2_0, FN_SEL_IIC2_1, FN_SEL_IIC2_2, FN_SEL_IIC2_3,
	FN_SEL_IIC1_0, FN_SEL_IIC1_1, FN_SEL_IIC1_2, FN_SEL_IIC1_3,
	FN_SEL_IIC1_4,
	FN_SEL_IIC0_0, FN_SEL_IIC0_1, FN_SEL_IIC0_2,

	/* MOD_SEL4 */
	FN_SEL_SOF1_0, FN_SEL_SOF1_1, FN_SEL_SOF1_2, FN_SEL_SOF1_3,
	FN_SEL_SOF1_4,
	FN_SEL_HSCIF0_0, FN_SEL_HSCIF0_1, FN_SEL_HSCIF0_2,
	FN_SEL_DIS_0, FN_SEL_DIS_1, FN_SEL_DIS_2,
	FN_SEL_RAD_0, FN_SEL_RAD_1,
	FN_SEL_RCN_0, FN_SEL_RCN_1,
	FN_SEL_RSP_0, FN_SEL_RSP_1,
	FN_SEL_SCIF2_0, FN_SEL_SCIF2_1, FN_SEL_SCIF2_2, FN_SEL_SCIF2_3,
	FN_SEL_SCIF2_4,
	FN_SEL_SOF2_0, FN_SEL_SOF2_1, FN_SEL_SOF2_2, FN_SEL_SOF2_3,
	FN_SEL_SOF2_4,
	FN_SEL_SSI1_0, FN_SEL_SSI1_1,
	FN_SEL_SSI0_0, FN_SEL_SSI0_1,
	FN_SEL_SSP_0, FN_SEL_SSP_1, FN_SEL_SSP_2,
	PINMUX_FUNCTION_END,

	PINMUX_MARK_BEGIN,

	EX_CS0_N_MARK, RD_N_MARK,

	AUDIO_CLKA_MARK,

	VI0_CLK_MARK, VI0_DATA0_VI0_B0_MARK, VI0_DATA1_VI0_B1_MARK,
	VI0_DATA2_VI0_B2_MARK, VI0_DATA4_VI0_B4_MARK, VI0_DATA5_VI0_B5_MARK,
	VI0_DATA6_VI0_B6_MARK, VI0_DATA7_VI0_B7_MARK,

	SD1_CLK_MARK,

	USB0_PWEN_MARK, USB0_OVC_MARK, USB1_PWEN_MARK, USB1_OVC_MARK,
	DU0_DOTCLKIN_MARK,

	/* IPSR0 */
	D0_MARK, D1_MARK, D2_MARK, D3_MARK, D4_MARK, D5_MARK,
	D6_MARK, D7_MARK, D8_MARK,
	D9_MARK, D10_MARK, D11_MARK, D12_MARK, D13_MARK, D14_MARK, D15_MARK,
	A0_MARK, ATAWR0_N_C_MARK, MSIOF0_SCK_B_MARK, SCL0_C_MARK, PWM2_B_MARK,
	A1_MARK, MSIOF0_SYNC_B_MARK, A2_MARK, MSIOF0_SS1_B_MARK,
	A3_MARK, MSIOF0_SS2_B_MARK, A4_MARK, MSIOF0_TXD_B_MARK,
	A5_MARK, MSIOF0_RXD_B_MARK, A6_MARK, MSIOF1_SCK_MARK,

	/* IPSR1 */
	A7_MARK, MSIOF1_SYNC_MARK, A8_MARK, MSIOF1_SS1_MARK, SCL0_MARK,
	A9_MARK, MSIOF1_SS2_MARK, SDA0_MARK,
	A10_MARK, MSIOF1_TXD_MARK, MSIOF1_TXD_D_MARK,
	A11_MARK, MSIOF1_RXD_MARK, SCL3_D_MARK, MSIOF1_RXD_D_MARK,
	A12_MARK, FMCLK_MARK, SDA3_D_MARK, MSIOF1_SCK_D_MARK,
	A13_MARK, ATAG0_N_C_MARK, BPFCLK_MARK, MSIOF1_SS1_D_MARK,
	A14_MARK, ATADIR0_N_C_MARK, FMIN_MARK, FMIN_C_MARK, MSIOF1_SYNC_D_MARK,
	A15_MARK, BPFCLK_C_MARK,
	A16_MARK, DREQ2_B_MARK, FMCLK_C_MARK, SCIFA1_SCK_B_MARK,
	A17_MARK, DACK2_B_MARK, SDA0_C_MARK,
	A18_MARK, DREQ1_MARK, SCIFA1_RXD_C_MARK, SCIFB1_RXD_C_MARK,

	/* IPSR2 */
	A19_MARK, DACK1_MARK, SCIFA1_TXD_C_MARK,
	SCIFB1_TXD_C_MARK, SCIFB1_SCK_B_MARK,
	A20_MARK, SPCLK_MARK,
	A21_MARK, ATAWR0_N_B_MARK, MOSI_IO0_MARK,
	A22_MARK, MISO_IO1_MARK, FMCLK_B_MARK, TX0_MARK, SCIFA0_TXD_MARK,
	A23_MARK, IO2_MARK, BPFCLK_B_MARK, RX0_MARK, SCIFA0_RXD_MARK,
	A24_MARK, DREQ2_MARK, IO3_MARK, TX1_MARK, SCIFA1_TXD_MARK,
	A25_MARK, DACK2_MARK, SSL_MARK, DREQ1_C_MARK,
	RX1_MARK, SCIFA1_RXD_MARK,
	CS0_N_MARK, ATAG0_N_B_MARK, SCL1_MARK,
	CS1_N_A26_MARK, ATADIR0_N_B_MARK, SDA1_MARK,
	EX_CS1_N_MARK, MSIOF2_SCK_MARK,
	EX_CS2_N_MARK, ATAWR0_N_MARK, MSIOF2_SYNC_MARK,
	EX_CS3_N_MARK, ATADIR0_N_MARK, MSIOF2_TXD_MARK,
	ATAG0_N_MARK, EX_WAIT1_MARK,

	/* IPSR3 */
	EX_CS4_N_MARK, ATARD0_N_MARK, MSIOF2_RXD_MARK, EX_WAIT2_MARK,
	EX_CS5_N_MARK, ATACS00_N_MARK, MSIOF2_SS1_MARK, HRX1_B_MARK,
	SCIFB1_RXD_B_MARK, PWM1_MARK, TPU_TO1_MARK,
	BS_N_MARK, ATACS10_N_MARK, MSIOF2_SS2_MARK, HTX1_B_MARK,
	SCIFB1_TXD_B_MARK, PWM2_MARK, TPU_TO2_MARK,
	RD_WR_N_MARK, HRX2_B_MARK, FMIN_B_MARK,
	SCIFB0_RXD_B_MARK, DREQ1_D_MARK,
	WE0_N_MARK, HCTS2_N_B_MARK, SCIFB0_TXD_B_MARK,
	WE1_N_MARK, ATARD0_N_B_MARK, HTX2_B_MARK, SCIFB0_RTS_N_B_MARK,
	EX_WAIT0_MARK, HRTS2_N_B_MARK, SCIFB0_CTS_N_B_MARK,
	DREQ0_MARK, PWM3_MARK, TPU_TO3_MARK,
	DACK0_MARK, DRACK0_MARK, REMOCON_MARK,
	SPEEDIN_MARK, HSCK0_C_MARK, HSCK2_C_MARK, SCIFB0_SCK_B_MARK,
	SCIFB2_SCK_B_MARK, DREQ2_C_MARK, HTX2_D_MARK,
	SSI_SCK0129_MARK, HRX0_C_MARK, HRX2_C_MARK,
	SCIFB0_RXD_C_MARK, SCIFB2_RXD_C_MARK,
	SSI_WS0129_MARK, HTX0_C_MARK, HTX2_C_MARK,
	SCIFB0_TXD_C_MARK, SCIFB2_TXD_C_MARK,

	/* IPSR4 */
	SSI_SDATA0_MARK, SCL0_B_MARK, SCL7_B_MARK, MSIOF2_SCK_C_MARK,
	SSI_SCK1_MARK, SDA0_B_MARK, SDA7_B_MARK,
	MSIOF2_SYNC_C_MARK, GLO_I0_D_MARK,
	SSI_WS1_MARK, SCL1_B_MARK, SCL8_B_MARK,
	MSIOF2_TXD_C_MARK, GLO_I1_D_MARK,
	SSI_SDATA1_MARK, SDA1_B_MARK, SDA8_B_MARK, MSIOF2_RXD_C_MARK,
	SSI_SCK2_MARK, SCL2_MARK, GPS_CLK_B_MARK, GLO_Q0_D_MARK, HSCK1_E_MARK,
	SSI_WS2_MARK, SDA2_MARK, GPS_SIGN_B_MARK, RX2_E_MARK,
	GLO_Q1_D_MARK, HCTS1_N_E_MARK,
	SSI_SDATA2_MARK, GPS_MAG_B_MARK, TX2_E_MARK, HRTS1_N_E_MARK,
	SSI_SCK34_MARK, SSI_WS34_MARK, SSI_SDATA3_MARK,
	SSI_SCK4_MARK, GLO_SS_D_MARK,
	SSI_WS4_MARK, GLO_RFON_D_MARK,
	SSI_SDATA4_MARK, MSIOF2_SCK_D_MARK,
	SSI_SCK5_MARK, MSIOF1_SCK_C_MARK, TS_SDATA0_MARK, GLO_I0_MARK,
	MSIOF2_SYNC_D_MARK, VI1_R2_B_MARK,

	/* IPSR5 */
	SSI_WS5_MARK, MSIOF1_SYNC_C_MARK, TS_SCK0_MARK, GLO_I1_MARK,
	MSIOF2_TXD_D_MARK, VI1_R3_B_MARK,
	SSI_SDATA5_MARK, MSIOF1_TXD_C_MARK, TS_SDEN0_MARK, GLO_Q0_MARK,
	MSIOF2_SS1_D_MARK, VI1_R4_B_MARK,
	SSI_SCK6_MARK, MSIOF1_RXD_C_MARK, TS_SPSYNC0_MARK, GLO_Q1_MARK,
	MSIOF2_RXD_D_MARK, VI1_R5_B_MARK,
	SSI_WS6_MARK, GLO_SCLK_MARK, MSIOF2_SS2_D_MARK, VI1_R6_B_MARK,
	SSI_SDATA6_MARK, STP_IVCXO27_0_B_MARK, GLO_SDATA_MARK, VI1_R7_B_MARK,
	SSI_SCK78_MARK, STP_ISCLK_0_B_MARK, GLO_SS_MARK,
	SSI_WS78_MARK, TX0_D_MARK, STP_ISD_0_B_MARK, GLO_RFON_MARK,
	SSI_SDATA7_MARK, RX0_D_MARK, STP_ISEN_0_B_MARK,
	SSI_SDATA8_MARK, TX1_D_MARK, STP_ISSYNC_0_B_MARK,
	SSI_SCK9_MARK, RX1_D_MARK, GLO_SCLK_D_MARK,
	SSI_WS9_MARK, TX3_D_MARK, CAN0_TX_D_MARK, GLO_SDATA_D_MARK,
	SSI_SDATA9_MARK, RX3_D_MARK, CAN0_RX_D_MARK,

	/* IPSR6 */
	AUDIO_CLKB_MARK, STP_OPWM_0_B_MARK, MSIOF1_SCK_B_MARK,
	SCIF_CLK_MARK, BPFCLK_E_MARK,
	AUDIO_CLKC_MARK, SCIFB0_SCK_C_MARK, MSIOF1_SYNC_B_MARK, RX2_MARK,
	SCIFA2_RXD_MARK, FMIN_E_MARK,
	AUDIO_CLKOUT_MARK, MSIOF1_SS1_B_MARK, TX2_MARK, SCIFA2_TXD_MARK,
	IRQ0_MARK, SCIFB1_RXD_D_MARK, INTC_IRQ0_N_MARK,
	IRQ1_MARK, SCIFB1_SCK_C_MARK, INTC_IRQ1_N_MARK,
	IRQ2_MARK, SCIFB1_TXD_D_MARK, INTC_IRQ2_N_MARK,
	IRQ3_MARK, SCL4_C_MARK, MSIOF2_TXD_E_MARK, INTC_IRQ3_N_MARK,
	IRQ4_MARK, HRX1_C_MARK, SDA4_C_MARK,
	MSIOF2_RXD_E_MARK, INTC_IRQ4_N_MARK,
	IRQ5_MARK, HTX1_C_MARK, SCL1_E_MARK, MSIOF2_SCK_E_MARK,
	IRQ6_MARK, HSCK1_C_MARK, MSIOF1_SS2_B_MARK,
	SDA1_E_MARK, MSIOF2_SYNC_E_MARK,
	IRQ7_MARK, HCTS1_N_C_MARK, MSIOF1_TXD_B_MARK,
	GPS_CLK_C_MARK, GPS_CLK_D_MARK,
	IRQ8_MARK, HRTS1_N_C_MARK, MSIOF1_RXD_B_MARK,
	GPS_SIGN_C_MARK, GPS_SIGN_D_MARK,

	/* IPSR7 */
	IRQ9_MARK, DU1_DOTCLKIN_B_MARK, CAN_CLK_D_MARK, GPS_MAG_C_MARK,
	SCIF_CLK_B_MARK, GPS_MAG_D_MARK,
	DU1_DR0_MARK, LCDOUT0_MARK, VI1_DATA0_B_MARK, TX0_B_MARK,
	SCIFA0_TXD_B_MARK, MSIOF2_SCK_B_MARK,
	DU1_DR1_MARK, LCDOUT1_MARK, VI1_DATA1_B_MARK, RX0_B_MARK,
	SCIFA0_RXD_B_MARK, MSIOF2_SYNC_B_MARK,
	DU1_DR2_MARK, LCDOUT2_MARK, SSI_SCK0129_B_MARK,
	DU1_DR3_MARK, LCDOUT3_MARK, SSI_WS0129_B_MARK,
	DU1_DR4_MARK, LCDOUT4_MARK, SSI_SDATA0_B_MARK,
	DU1_DR5_MARK, LCDOUT5_MARK, SSI_SCK1_B_MARK,
	DU1_DR6_MARK, LCDOUT6_MARK, SSI_WS1_B_MARK,
	DU1_DR7_MARK, LCDOUT7_MARK, SSI_SDATA1_B_MARK,
	DU1_DG0_MARK, LCDOUT8_MARK, VI1_DATA2_B_MARK, TX1_B_MARK,
	SCIFA1_TXD_B_MARK, MSIOF2_SS1_B_MARK,
	DU1_DG1_MARK, LCDOUT9_MARK, VI1_DATA3_B_MARK, RX1_B_MARK,
	SCIFA1_RXD_B_MARK, MSIOF2_SS2_B_MARK,
	DU1_DG2_MARK, LCDOUT10_MARK, VI1_DATA4_B_MARK, SCIF1_SCK_B_MARK,
	SCIFA1_SCK_MARK, SSI_SCK78_B_MARK,

	/* IPSR8 */
	DU1_DG3_MARK, LCDOUT11_MARK, VI1_DATA5_B_MARK, SSI_WS78_B_MARK,
	DU1_DG4_MARK, LCDOUT12_MARK, VI1_DATA6_B_MARK, HRX0_B_MARK,
	SCIFB2_RXD_B_MARK, SSI_SDATA7_B_MARK,
	DU1_DG5_MARK, LCDOUT13_MARK, VI1_DATA7_B_MARK, HCTS0_N_B_MARK,
	SCIFB2_TXD_B_MARK, SSI_SDATA8_B_MARK,
	DU1_DG6_MARK, LCDOUT14_MARK, HRTS0_N_B_MARK,
	SCIFB2_CTS_N_B_MARK, SSI_SCK9_B_MARK,
	DU1_DG7_MARK, LCDOUT15_MARK, HTX0_B_MARK,
	SCIFB2_RTS_N_B_MARK, SSI_WS9_B_MARK,
	DU1_DB0_MARK, LCDOUT16_MARK, VI1_CLK_B_MARK, TX2_B_MARK,
	SCIFA2_TXD_B_MARK, MSIOF2_TXD_B_MARK,
	DU1_DB1_MARK, LCDOUT17_MARK, VI1_HSYNC_N_B_MARK, RX2_B_MARK,
	SCIFA2_RXD_B_MARK, MSIOF2_RXD_B_MARK,
	DU1_DB2_MARK, LCDOUT18_MARK, VI1_VSYNC_N_B_MARK, SCIF2_SCK_B_MARK,
	SCIFA2_SCK_MARK, SSI_SDATA9_B_MARK,
	DU1_DB3_MARK, LCDOUT19_MARK, VI1_CLKENB_B_MARK,
	DU1_DB4_MARK, LCDOUT20_MARK, VI1_FIELD_B_MARK, CAN1_RX_MARK,
	DU1_DB5_MARK, LCDOUT21_MARK, TX3_MARK, SCIFA3_TXD_MARK, CAN1_TX_MARK,

	/* IPSR9 */
	DU1_DB6_MARK, LCDOUT22_MARK, SCL3_C_MARK, RX3_MARK, SCIFA3_RXD_MARK,
	DU1_DB7_MARK, LCDOUT23_MARK, SDA3_C_MARK,
	SCIF3_SCK_MARK, SCIFA3_SCK_MARK,
	DU1_DOTCLKIN_MARK, QSTVA_QVS_MARK,
	DU1_DOTCLKOUT0_MARK, QCLK_MARK,
	DU1_DOTCLKOUT1_MARK, QSTVB_QVE_MARK, CAN0_TX_MARK,
	TX3_B_MARK, SCL2_B_MARK, PWM4_MARK,
	DU1_EXHSYNC_DU1_HSYNC_MARK, QSTH_QHS_MARK,
	DU1_EXVSYNC_DU1_VSYNC_MARK, QSTB_QHE_MARK,
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK, QCPV_QDE_MARK,
	CAN0_RX_MARK, RX3_B_MARK, SDA2_B_MARK,
	DU1_DISP_MARK, QPOLA_MARK,
	DU1_CDE_MARK, QPOLB_MARK, PWM4_B_MARK,
	VI0_CLKENB_MARK, TX4_MARK, SCIFA4_TXD_MARK, TS_SDATA0_D_MARK,
	VI0_FIELD_MARK, RX4_MARK, SCIFA4_RXD_MARK, TS_SCK0_D_MARK,
	VI0_HSYNC_N_MARK, TX5_MARK, SCIFA5_TXD_MARK, TS_SDEN0_D_MARK,
	VI0_VSYNC_N_MARK, RX5_MARK, SCIFA5_RXD_MARK, TS_SPSYNC0_D_MARK,
	VI0_DATA3_VI0_B3_MARK, SCIF3_SCK_B_MARK, SCIFA3_SCK_B_MARK,
	VI0_G0_MARK, SCL8_MARK, STP_IVCXO27_0_C_MARK, SCL4_MARK,
	HCTS2_N_MARK, SCIFB2_CTS_N_MARK, ATAWR1_N_MARK,

	/* IPSR10 */
	VI0_G1_MARK, SDA8_MARK, STP_ISCLK_0_C_MARK, SDA4_MARK,
	HRTS2_N_MARK, SCIFB2_RTS_N_MARK, ATADIR1_N_MARK,
	VI0_G2_MARK, VI2_HSYNC_N_MARK, STP_ISD_0_C_MARK, SCL3_B_MARK,
	HSCK2_MARK, SCIFB2_SCK_MARK, ATARD1_N_MARK,
	VI0_G3_MARK, VI2_VSYNC_N_MARK, STP_ISEN_0_C_MARK, SDA3_B_MARK,
	HRX2_MARK, SCIFB2_RXD_MARK, ATACS01_N_MARK,
	VI0_G4_MARK, VI2_CLKENB_MARK, STP_ISSYNC_0_C_MARK,
	HTX2_MARK, SCIFB2_TXD_MARK, SCIFB0_SCK_D_MARK,
	VI0_G5_MARK, VI2_FIELD_MARK, STP_OPWM_0_C_MARK, FMCLK_D_MARK,
	CAN0_TX_E_MARK, HTX1_D_MARK, SCIFB0_TXD_D_MARK,
	VI0_G6_MARK, VI2_CLK_MARK, BPFCLK_D_MARK,
	VI0_G7_MARK, VI2_DATA0_MARK, FMIN_D_MARK,
	VI0_R0_MARK, VI2_DATA1_MARK, GLO_I0_B_MARK,
	TS_SDATA0_C_MARK, ATACS11_N_MARK,
	VI0_R1_MARK, VI2_DATA2_MARK, GLO_I1_B_MARK,
	TS_SCK0_C_MARK, ATAG1_N_MARK,
	VI0_R2_MARK, VI2_DATA3_MARK, GLO_Q0_B_MARK, TS_SDEN0_C_MARK,
	VI0_R3_MARK, VI2_DATA4_MARK, GLO_Q1_B_MARK, TS_SPSYNC0_C_MARK,
	VI0_R4_MARK, VI2_DATA5_MARK, GLO_SCLK_B_MARK, TX0_C_MARK, SCL1_D_MARK,

	/* IPSR11 */
	VI0_R5_MARK, VI2_DATA6_MARK, GLO_SDATA_B_MARK, RX0_C_MARK, SDA1_D_MARK,
	VI0_R6_MARK, VI2_DATA7_MARK, GLO_SS_B_MARK, TX1_C_MARK, SCL4_B_MARK,
	VI0_R7_MARK, GLO_RFON_B_MARK, RX1_C_MARK, CAN0_RX_E_MARK,
	SDA4_B_MARK, HRX1_D_MARK, SCIFB0_RXD_D_MARK,
	VI1_HSYNC_N_MARK, AVB_RXD0_MARK, TS_SDATA0_B_MARK,
	TX4_B_MARK, SCIFA4_TXD_B_MARK,
	VI1_VSYNC_N_MARK, AVB_RXD1_MARK, TS_SCK0_B_MARK,
	RX4_B_MARK, SCIFA4_RXD_B_MARK,
	VI1_CLKENB_MARK, AVB_RXD2_MARK, TS_SDEN0_B_MARK,
	VI1_FIELD_MARK, AVB_RXD3_MARK, TS_SPSYNC0_B_MARK,
	VI1_CLK_MARK, AVB_RXD4_MARK, VI1_DATA0_MARK, AVB_RXD5_MARK,
	VI1_DATA1_MARK, AVB_RXD6_MARK, VI1_DATA2_MARK, AVB_RXD7_MARK,
	VI1_DATA3_MARK, AVB_RX_ER_MARK, VI1_DATA4_MARK, AVB_MDIO_MARK,
	VI1_DATA5_MARK, AVB_RX_DV_MARK, VI1_DATA6_MARK, AVB_MAGIC_MARK,
	VI1_DATA7_MARK, AVB_MDC_MARK,
	ETH_MDIO_MARK, AVB_RX_CLK_MARK, SCL2_C_MARK,
	ETH_CRS_DV_MARK, AVB_LINK_MARK, SDA2_C_MARK,

	/* IPSR12 */
	ETH_RX_ER_MARK, AVB_CRS_MARK, SCL3_MARK, SCL7_MARK,
	ETH_RXD0_MARK, AVB_PHY_INT_MARK, SDA3_MARK, SDA7_MARK,
	ETH_RXD1_MARK, AVB_GTXREFCLK_MARK, CAN0_TX_C_MARK,
	SCL2_D_MARK, MSIOF1_RXD_E_MARK,
	ETH_LINK_MARK, AVB_TXD0_MARK, CAN0_RX_C_MARK,
	SDA2_D_MARK, MSIOF1_SCK_E_MARK,
	ETH_REFCLK_MARK, AVB_TXD1_MARK, SCIFA3_RXD_B_MARK,
	CAN1_RX_C_MARK, MSIOF1_SYNC_E_MARK,
	ETH_TXD1_MARK, AVB_TXD2_MARK, SCIFA3_TXD_B_MARK,
	CAN1_TX_C_MARK, MSIOF1_TXD_E_MARK,
	ETH_TX_EN_MARK, AVB_TXD3_MARK, TCLK1_B_MARK, CAN_CLK_B_MARK,
	ETH_MAGIC_MARK, AVB_TXD4_MARK, IETX_C_MARK,
	ETH_TXD0_MARK, AVB_TXD5_MARK, IECLK_C_MARK,
	ETH_MDC_MARK, AVB_TXD6_MARK, IERX_C_MARK,
	STP_IVCXO27_0_MARK, AVB_TXD7_MARK, SCIFB2_TXD_D_MARK,
	ADIDATA_B_MARK, MSIOF0_SYNC_C_MARK,
	STP_ISCLK_0_MARK, AVB_TX_EN_MARK, SCIFB2_RXD_D_MARK,
	ADICS_SAMP_B_MARK, MSIOF0_SCK_C_MARK,

	/* IPSR13 */
	STP_ISD_0_MARK, AVB_TX_ER_MARK, SCIFB2_SCK_C_MARK,
	ADICLK_B_MARK, MSIOF0_SS1_C_MARK,
	STP_ISEN_0_MARK, AVB_TX_CLK_MARK, ADICHS0_B_MARK, MSIOF0_SS2_C_MARK,
	STP_ISSYNC_0_MARK, AVB_COL_MARK, ADICHS1_B_MARK, MSIOF0_RXD_C_MARK,
	STP_OPWM_0_MARK, AVB_GTX_CLK_MARK, PWM0_B_MARK,
	ADICHS2_B_MARK, MSIOF0_TXD_C_MARK,
	SD0_CLK_MARK, SPCLK_B_MARK, SD0_CMD_MARK, MOSI_IO0_B_MARK,
	SD0_DATA0_MARK, MISO_IO1_B_MARK, SD0_DATA1_MARK, IO2_B_MARK,
	SD0_DATA2_MARK, IO3_B_MARK, SD0_DATA3_MARK, SSL_B_MARK,
	SD0_CD_MARK, MMC_D6_B_MARK, SIM0_RST_B_MARK, CAN0_RX_F_MARK,
	SCIFA5_TXD_B_MARK, TX3_C_MARK,
	SD0_WP_MARK, MMC_D7_B_MARK, SIM0_D_B_MARK, CAN0_TX_F_MARK,
	SCIFA5_RXD_B_MARK, RX3_C_MARK,
	SD1_CMD_MARK, REMOCON_B_MARK, SD1_DATA0_MARK, SPEEDIN_B_MARK,
	SD1_DATA1_MARK, IETX_B_MARK, SD1_DATA2_MARK, IECLK_B_MARK,
	SD1_DATA3_MARK, IERX_B_MARK,
	SD1_CD_MARK, PWM0_MARK, TPU_TO0_MARK, SCL1_C_MARK,

	/* IPSR14 */
	SD1_WP_MARK, PWM1_B_MARK, SDA1_C_MARK,
	SD2_CLK_MARK, MMC_CLK_MARK, SD2_CMD_MARK, MMC_CMD_MARK,
	SD2_DATA0_MARK, MMC_D0_MARK, SD2_DATA1_MARK, MMC_D1_MARK,
	SD2_DATA2_MARK, MMC_D2_MARK, SD2_DATA3_MARK, MMC_D3_MARK,
	SD2_CD_MARK, MMC_D4_MARK, SCL8_C_MARK, TX5_B_MARK, SCIFA5_TXD_C_MARK,
	SD2_WP_MARK, MMC_D5_MARK, SDA8_C_MARK, RX5_B_MARK, SCIFA5_RXD_C_MARK,
	MSIOF0_SCK_MARK, RX2_C_MARK, ADIDATA_MARK,
	VI1_CLK_C_MARK, VI1_G0_B_MARK,
	MSIOF0_SYNC_MARK, TX2_C_MARK, ADICS_SAMP_MARK,
	VI1_CLKENB_C_MARK, VI1_G1_B_MARK,
	MSIOF0_TXD_MARK, ADICLK_MARK, VI1_FIELD_C_MARK, VI1_G2_B_MARK,
	MSIOF0_RXD_MARK, ADICHS0_MARK, VI1_DATA0_C_MARK, VI1_G3_B_MARK,
	MSIOF0_SS1_MARK, MMC_D6_MARK, ADICHS1_MARK, TX0_E_MARK,
	VI1_HSYNC_N_C_MARK, SCL7_C_MARK, VI1_G4_B_MARK,
	MSIOF0_SS2_MARK, MMC_D7_MARK, ADICHS2_MARK, RX0_E_MARK,
	VI1_VSYNC_N_C_MARK, SDA7_C_MARK, VI1_G5_B_MARK,

	/* IPSR15 */
	SIM0_RST_MARK, IETX_MARK, CAN1_TX_D_MARK,
	SIM0_CLK_MARK, IECLK_MARK, CAN_CLK_C_MARK,
	SIM0_D_MARK, IERX_MARK, CAN1_RX_D_MARK,
	GPS_CLK_MARK, DU1_DOTCLKIN_C_MARK, AUDIO_CLKB_B_MARK,
	PWM5_B_MARK, SCIFA3_TXD_C_MARK,
	GPS_SIGN_MARK, TX4_C_MARK, SCIFA4_TXD_C_MARK, PWM5_MARK,
	VI1_G6_B_MARK, SCIFA3_RXD_C_MARK,
	GPS_MAG_MARK, RX4_C_MARK, SCIFA4_RXD_C_MARK, PWM6_MARK,
	VI1_G7_B_MARK, SCIFA3_SCK_C_MARK,
	HCTS0_N_MARK, SCIFB0_CTS_N_MARK, GLO_I0_C_MARK,
	TCLK1_MARK, VI1_DATA1_C_MARK,
	HRTS0_N_MARK, SCIFB0_RTS_N_MARK, GLO_I1_C_MARK, VI1_DATA2_C_MARK,
	HSCK0_MARK, SCIFB0_SCK_MARK, GLO_Q0_C_MARK, CAN_CLK_MARK,
	TCLK2_MARK, VI1_DATA3_C_MARK,
	HRX0_MARK, SCIFB0_RXD_MARK, GLO_Q1_C_MARK,
	CAN0_RX_B_MARK, VI1_DATA4_C_MARK,
	HTX0_MARK, SCIFB0_TXD_MARK, GLO_SCLK_C_MARK,
	CAN0_TX_B_MARK, VI1_DATA5_C_MARK,

	/* IPSR16 */
	HRX1_MARK, SCIFB1_RXD_MARK, VI1_R0_B_MARK,
	GLO_SDATA_C_MARK, VI1_DATA6_C_MARK,
	HTX1_MARK, SCIFB1_TXD_MARK, VI1_R1_B_MARK,
	GLO_SS_C_MARK, VI1_DATA7_C_MARK,
	HSCK1_MARK, SCIFB1_SCK_MARK, MLB_CLK_MARK, GLO_RFON_C_MARK,
	HCTS1_N_MARK, SCIFB1_CTS_N_MARK, MLB_SIG_MARK, CAN1_TX_B_MARK,
	HRTS1_N_MARK, SCIFB1_RTS_N_MARK, MLB_DAT_MARK, CAN1_RX_B_MARK,
	PINMUX_MARK_END,
};

static const u16 pinmux_data[] = {
	PINMUX_DATA_GP_ALL(), /* PINMUX_DATA(GP_M_N_DATA, GP_M_N_FN...), */

	PINMUX_DATA(EX_CS0_N_MARK, FN_EX_CS0_N),
	PINMUX_DATA(RD_N_MARK, FN_RD_N),
	PINMUX_DATA(AUDIO_CLKA_MARK, FN_AUDIO_CLKA),
	PINMUX_DATA(VI0_CLK_MARK, FN_VI0_CLK),
	PINMUX_DATA(VI0_DATA0_VI0_B0_MARK, FN_VI0_DATA0_VI0_B0),
	PINMUX_DATA(VI0_DATA1_VI0_B1_MARK, FN_VI0_DATA1_VI0_B1),
	PINMUX_DATA(VI0_DATA2_VI0_B2_MARK, FN_VI0_DATA2_VI0_B2),
	PINMUX_DATA(VI0_DATA4_VI0_B4_MARK, FN_VI0_DATA4_VI0_B4),
	PINMUX_DATA(VI0_DATA5_VI0_B5_MARK, FN_VI0_DATA5_VI0_B5),
	PINMUX_DATA(VI0_DATA6_VI0_B6_MARK, FN_VI0_DATA6_VI0_B6),
	PINMUX_DATA(VI0_DATA7_VI0_B7_MARK, FN_VI0_DATA7_VI0_B7),
	PINMUX_DATA(USB0_PWEN_MARK, FN_USB0_PWEN),
	PINMUX_DATA(USB0_OVC_MARK, FN_USB0_OVC),
	PINMUX_DATA(USB1_PWEN_MARK, FN_USB1_PWEN),
	PINMUX_DATA(USB1_OVC_MARK, FN_USB1_OVC),
	PINMUX_DATA(DU0_DOTCLKIN_MARK, FN_DU0_DOTCLKIN),
	PINMUX_DATA(SD1_CLK_MARK, FN_SD1_CLK),

	/* IPSR0 */
	PINMUX_IPSR_DATA(IP0_0, D0),
	PINMUX_IPSR_DATA(IP0_1, D1),
	PINMUX_IPSR_DATA(IP0_2, D2),
	PINMUX_IPSR_DATA(IP0_3, D3),
	PINMUX_IPSR_DATA(IP0_4, D4),
	PINMUX_IPSR_DATA(IP0_5, D5),
	PINMUX_IPSR_DATA(IP0_6, D6),
	PINMUX_IPSR_DATA(IP0_7, D7),
	PINMUX_IPSR_DATA(IP0_8, D8),
	PINMUX_IPSR_DATA(IP0_9, D9),
	PINMUX_IPSR_DATA(IP0_10, D10),
	PINMUX_IPSR_DATA(IP0_11, D11),
	PINMUX_IPSR_DATA(IP0_12, D12),
	PINMUX_IPSR_DATA(IP0_13, D13),
	PINMUX_IPSR_DATA(IP0_14, D14),
	PINMUX_IPSR_DATA(IP0_15, D15),
	PINMUX_IPSR_DATA(IP0_18_16, A0),
	PINMUX_IPSR_MSEL(IP0_18_16, ATAWR0_N_C, SEL_LBS_2),
	PINMUX_IPSR_MSEL(IP0_18_16, MSIOF0_SCK_B, SEL_SOF0_1),
	PINMUX_IPSR_MSEL(IP0_18_16, SCL0_C, SEL_IIC0_2),
	PINMUX_IPSR_DATA(IP0_18_16, PWM2_B),
	PINMUX_IPSR_DATA(IP0_20_19, A1),
	PINMUX_IPSR_MSEL(IP0_20_19, MSIOF0_SYNC_B, SEL_SOF0_1),
	PINMUX_IPSR_DATA(IP0_22_21, A2),
	PINMUX_IPSR_MSEL(IP0_22_21, MSIOF0_SS1_B, SEL_SOF0_1),
	PINMUX_IPSR_DATA(IP0_24_23, A3),
	PINMUX_IPSR_MSEL(IP0_24_23, MSIOF0_SS2_B, SEL_SOF0_1),
	PINMUX_IPSR_DATA(IP0_26_25, A4),
	PINMUX_IPSR_MSEL(IP0_26_25, MSIOF0_TXD_B, SEL_SOF0_1),
	PINMUX_IPSR_DATA(IP0_28_27, A5),
	PINMUX_IPSR_MSEL(IP0_28_27, MSIOF0_RXD_B, SEL_SOF0_1),
	PINMUX_IPSR_DATA(IP0_30_29, A6),
	PINMUX_IPSR_MSEL(IP0_30_29, MSIOF1_SCK, SEL_SOF1_0),

	/* IPSR1 */
	PINMUX_IPSR_DATA(IP1_1_0, A7),
	PINMUX_IPSR_MSEL(IP1_1_0, MSIOF1_SYNC, SEL_SOF1_0),
	PINMUX_IPSR_DATA(IP1_3_2, A8),
	PINMUX_IPSR_MSEL(IP1_3_2, MSIOF1_SS1, SEL_SOF1_0),
	PINMUX_IPSR_MSEL(IP1_3_2, SCL0, SEL_IIC0_0),
	PINMUX_IPSR_DATA(IP1_5_4, A9),
	PINMUX_IPSR_MSEL(IP1_5_4, MSIOF1_SS2, SEL_SOF1_0),
	PINMUX_IPSR_MSEL(IP1_5_4, SDA0, SEL_IIC0_0),
	PINMUX_IPSR_DATA(IP1_7_6, A10),
	PINMUX_IPSR_MSEL(IP1_7_6, MSIOF1_TXD, SEL_SOF1_0),
	PINMUX_IPSR_MSEL(IP1_7_6, MSIOF1_TXD_D, SEL_SOF1_3),
	PINMUX_IPSR_DATA(IP1_10_8, A11),
	PINMUX_IPSR_MSEL(IP1_10_8, MSIOF1_RXD, SEL_SOF1_0),
	PINMUX_IPSR_MSEL(IP1_10_8, SCL3_D, SEL_IIC3_3),
	PINMUX_IPSR_MSEL(IP1_10_8, MSIOF1_RXD_D, SEL_SOF1_3),
	PINMUX_IPSR_DATA(IP1_13_11, A12),
	PINMUX_IPSR_MSEL(IP1_13_11, FMCLK, SEL_FM_0),
	PINMUX_IPSR_MSEL(IP1_13_11, SDA3_D, SEL_IIC3_3),
	PINMUX_IPSR_MSEL(IP1_13_11, MSIOF1_SCK_D, SEL_SOF1_3),
	PINMUX_IPSR_DATA(IP1_16_14, A13),
	PINMUX_IPSR_MSEL(IP1_16_14, ATAG0_N_C, SEL_LBS_2),
	PINMUX_IPSR_MSEL(IP1_16_14, BPFCLK, SEL_FM_0),
	PINMUX_IPSR_MSEL(IP1_16_14, MSIOF1_SS1_D, SEL_SOF1_3),
	PINMUX_IPSR_DATA(IP1_19_17, A14),
	PINMUX_IPSR_MSEL(IP1_19_17, ATADIR0_N_C, SEL_LBS_2),
	PINMUX_IPSR_MSEL(IP1_19_17, FMIN, SEL_FM_0),
	PINMUX_IPSR_MSEL(IP1_19_17, FMIN_C, SEL_FM_2),
	PINMUX_IPSR_MSEL(IP1_19_17, MSIOF1_SYNC_D, SEL_SOF1_3),
	PINMUX_IPSR_DATA(IP1_22_20, A15),
	PINMUX_IPSR_MSEL(IP1_22_20, BPFCLK_C, SEL_FM_2),
	PINMUX_IPSR_DATA(IP1_25_23, A16),
	PINMUX_IPSR_MSEL(IP1_25_23, DREQ2_B, SEL_LBS_1),
	PINMUX_IPSR_MSEL(IP1_25_23, FMCLK_C, SEL_FM_2),
	PINMUX_IPSR_MSEL(IP1_25_23, SCIFA1_SCK_B, SEL_SCIFA1_1),
	PINMUX_IPSR_DATA(IP1_28_26, A17),
	PINMUX_IPSR_MSEL(IP1_28_26, DACK2_B, SEL_LBS_1),
	PINMUX_IPSR_MSEL(IP1_28_26, SDA0_C, SEL_IIC0_2),
	PINMUX_IPSR_DATA(IP1_31_29, A18),
	PINMUX_IPSR_MSEL(IP1_31_29, DREQ1, SEL_LBS_0),
	PINMUX_IPSR_MSEL(IP1_31_29, SCIFA1_RXD_C, SEL_SCIFA1_2),
	PINMUX_IPSR_MSEL(IP1_31_29, SCIFB1_RXD_C, SEL_SCIFB1_2),

	/* IPSR2 */
	PINMUX_IPSR_DATA(IP2_2_0, A19),
	PINMUX_IPSR_DATA(IP2_2_0, DACK1),
	PINMUX_IPSR_MSEL(IP2_2_0, SCIFA1_TXD_C, SEL_SCIFA1_2),
	PINMUX_IPSR_MSEL(IP2_2_0, SCIFB1_TXD_C, SEL_SCIFB1_2),
	PINMUX_IPSR_MSEL(IP2_2_0, SCIFB1_SCK_B, SEL_SCIFB1_1),
	PINMUX_IPSR_DATA(IP2_2_0, A20),
	PINMUX_IPSR_MSEL(IP2_4_3, SPCLK, SEL_QSP_0),
	PINMUX_IPSR_DATA(IP2_6_5, A21),
	PINMUX_IPSR_MSEL(IP2_6_5, ATAWR0_N_B, SEL_LBS_1),
	PINMUX_IPSR_MSEL(IP2_6_5, MOSI_IO0, SEL_QSP_0),
	PINMUX_IPSR_DATA(IP2_9_7, A22),
	PINMUX_IPSR_MSEL(IP2_9_7, MISO_IO1, SEL_QSP_0),
	PINMUX_IPSR_MSEL(IP2_9_7, FMCLK_B, SEL_FM_1),
	PINMUX_IPSR_MSEL(IP2_9_7, TX0, SEL_SCIF0_0),
	PINMUX_IPSR_MSEL(IP2_9_7, SCIFA0_TXD, SEL_SCFA_0),
	PINMUX_IPSR_DATA(IP2_12_10, A23),
	PINMUX_IPSR_MSEL(IP2_12_10, IO2, SEL_QSP_0),
	PINMUX_IPSR_MSEL(IP2_12_10, BPFCLK_B, SEL_FM_1),
	PINMUX_IPSR_MSEL(IP2_12_10, RX0, SEL_SCIF0_0),
	PINMUX_IPSR_MSEL(IP2_12_10, SCIFA0_RXD, SEL_SCFA_0),
	PINMUX_IPSR_DATA(IP2_15_13, A24),
	PINMUX_IPSR_MSEL(IP2_15_13, DREQ2, SEL_LBS_0),
	PINMUX_IPSR_MSEL(IP2_15_13, IO3, SEL_QSP_0),
	PINMUX_IPSR_MSEL(IP2_15_13, TX1, SEL_SCIF1_0),
	PINMUX_IPSR_MSEL(IP2_15_13, SCIFA1_TXD, SEL_SCIFA1_0),
	PINMUX_IPSR_DATA(IP2_18_16, A25),
	PINMUX_IPSR_MSEL(IP2_18_16, DACK2, SEL_LBS_0),
	PINMUX_IPSR_MSEL(IP2_18_16, SSL, SEL_QSP_0),
	PINMUX_IPSR_MSEL(IP2_18_16, DREQ1_C, SEL_LBS_2),
	PINMUX_IPSR_MSEL(IP2_18_16, RX1, SEL_SCIF1_0),
	PINMUX_IPSR_MSEL(IP2_18_16, SCIFA1_RXD, SEL_SCIFA1_0),
	PINMUX_IPSR_DATA(IP2_20_19, CS0_N),
	PINMUX_IPSR_MSEL(IP2_20_19, ATAG0_N_B, SEL_LBS_1),
	PINMUX_IPSR_MSEL(IP2_20_19, SCL1, SEL_IIC1_0),
	PINMUX_IPSR_DATA(IP2_22_21, CS1_N_A26),
	PINMUX_IPSR_MSEL(IP2_22_21, ATADIR0_N_B, SEL_LBS_1),
	PINMUX_IPSR_MSEL(IP2_22_21, SDA1, SEL_IIC1_0),
	PINMUX_IPSR_DATA(IP2_24_23, EX_CS1_N),
	PINMUX_IPSR_MSEL(IP2_24_23, MSIOF2_SCK, SEL_SOF2_0),
	PINMUX_IPSR_DATA(IP2_26_25, EX_CS2_N),
	PINMUX_IPSR_MSEL(IP2_26_25, ATAWR0_N, SEL_LBS_0),
	PINMUX_IPSR_MSEL(IP2_26_25, MSIOF2_SYNC, SEL_SOF2_0),
	PINMUX_IPSR_DATA(IP2_29_27, EX_CS3_N),
	PINMUX_IPSR_MSEL(IP2_29_27, ATADIR0_N, SEL_LBS_0),
	PINMUX_IPSR_MSEL(IP2_29_27, MSIOF2_TXD, SEL_SOF2_0),
	PINMUX_IPSR_MSEL(IP2_29_27, ATAG0_N, SEL_LBS_0),
	PINMUX_IPSR_DATA(IP2_29_27, EX_WAIT1),

	/* IPSR3 */
	PINMUX_IPSR_DATA(IP3_2_0, EX_CS4_N),
	PINMUX_IPSR_MSEL(IP3_2_0, ATARD0_N, SEL_LBS_0),
	PINMUX_IPSR_MSEL(IP3_2_0, MSIOF2_RXD, SEL_SOF2_0),
	PINMUX_IPSR_DATA(IP3_2_0, EX_WAIT2),
	PINMUX_IPSR_DATA(IP3_5_3, EX_CS5_N),
	PINMUX_IPSR_DATA(IP3_5_3, ATACS00_N),
	PINMUX_IPSR_MSEL(IP3_5_3, MSIOF2_SS1, SEL_SOF2_0),
	PINMUX_IPSR_MSEL(IP3_5_3, HRX1_B, SEL_HSCIF1_1),
	PINMUX_IPSR_MSEL(IP3_5_3, SCIFB1_RXD_B, SEL_SCIFB1_1),
	PINMUX_IPSR_DATA(IP3_5_3, PWM1),
	PINMUX_IPSR_DATA(IP3_5_3, TPU_TO1),
	PINMUX_IPSR_DATA(IP3_8_6, BS_N),
	PINMUX_IPSR_DATA(IP3_8_6, ATACS10_N),
	PINMUX_IPSR_MSEL(IP3_8_6, MSIOF2_SS2, SEL_SOF2_0),
	PINMUX_IPSR_MSEL(IP3_8_6, HTX1_B, SEL_HSCIF1_1),
	PINMUX_IPSR_MSEL(IP3_8_6, SCIFB1_TXD_B, SEL_SCIFB1_1),
	PINMUX_IPSR_DATA(IP3_8_6, PWM2),
	PINMUX_IPSR_DATA(IP3_8_6, TPU_TO2),
	PINMUX_IPSR_DATA(IP3_11_9, RD_WR_N),
	PINMUX_IPSR_MSEL(IP3_11_9, HRX2_B, SEL_HSCIF2_1),
	PINMUX_IPSR_MSEL(IP3_11_9, FMIN_B, SEL_FM_1),
	PINMUX_IPSR_MSEL(IP3_11_9, SCIFB0_RXD_B, SEL_SCIFB_1),
	PINMUX_IPSR_MSEL(IP3_11_9, DREQ1_D, SEL_LBS_1),
	PINMUX_IPSR_DATA(IP3_13_12, WE0_N),
	PINMUX_IPSR_MSEL(IP3_13_12, HCTS2_N_B, SEL_HSCIF2_1),
	PINMUX_IPSR_MSEL(IP3_13_12, SCIFB0_TXD_B, SEL_SCIFB_1),
	PINMUX_IPSR_DATA(IP3_15_14, WE1_N),
	PINMUX_IPSR_MSEL(IP3_15_14, ATARD0_N_B, SEL_LBS_1),
	PINMUX_IPSR_MSEL(IP3_15_14, HTX2_B, SEL_HSCIF2_1),
	PINMUX_IPSR_MSEL(IP3_15_14, SCIFB0_RTS_N_B, SEL_SCIFB_1),
	PINMUX_IPSR_DATA(IP3_17_16, EX_WAIT0),
	PINMUX_IPSR_MSEL(IP3_17_16, HRTS2_N_B, SEL_HSCIF2_1),
	PINMUX_IPSR_MSEL(IP3_17_16, SCIFB0_CTS_N_B, SEL_SCIFB_1),
	PINMUX_IPSR_DATA(IP3_19_18, DREQ0),
	PINMUX_IPSR_DATA(IP3_19_18, PWM3),
	PINMUX_IPSR_DATA(IP3_19_18, TPU_TO3),
	PINMUX_IPSR_DATA(IP3_21_20, DACK0),
	PINMUX_IPSR_DATA(IP3_21_20, DRACK0),
	PINMUX_IPSR_MSEL(IP3_21_20, REMOCON, SEL_RCN_0),
	PINMUX_IPSR_MSEL(IP3_24_22, SPEEDIN, SEL_RSP_0),
	PINMUX_IPSR_MSEL(IP3_24_22, HSCK0_C, SEL_HSCIF0_2),
	PINMUX_IPSR_MSEL(IP3_24_22, HSCK2_C, SEL_HSCIF2_2),
	PINMUX_IPSR_MSEL(IP3_24_22, SCIFB0_SCK_B, SEL_SCIFB_1),
	PINMUX_IPSR_MSEL(IP3_24_22, SCIFB2_SCK_B, SEL_SCIFB2_1),
	PINMUX_IPSR_MSEL(IP3_24_22, DREQ2_C, SEL_LBS_2),
	PINMUX_IPSR_MSEL(IP3_30_28, HTX2_C, SEL_HSCIF2_2),
	PINMUX_IPSR_MSEL(IP3_27_25, SSI_SCK0129, SEL_SSI0_0),
	PINMUX_IPSR_MSEL(IP3_27_25, HRX0_C, SEL_HSCIF0_2),
	PINMUX_IPSR_MSEL(IP3_27_25, HRX2_C, SEL_HSCIF2_2),
	PINMUX_IPSR_MSEL(IP3_27_25, SCIFB0_RXD_C, SEL_SCIFB_2),
	PINMUX_IPSR_MSEL(IP3_27_25, SCIFB2_RXD_C, SEL_SCIFB2_2),
	PINMUX_IPSR_MSEL(IP3_30_28, SSI_WS0129, SEL_SSI0_0),
	PINMUX_IPSR_MSEL(IP3_30_28, HTX0_C, SEL_HSCIF0_2),
	PINMUX_IPSR_MSEL(IP3_30_28, HTX2_C, SEL_HSCIF2_2),
	PINMUX_IPSR_MSEL(IP3_30_28, SCIFB0_TXD_C, SEL_SCIFB_2),
	PINMUX_IPSR_MSEL(IP3_30_28, SCIFB2_TXD_C, SEL_SCIFB2_2),

	/* IPSR4 */
	PINMUX_IPSR_MSEL(IP4_1_0, SSI_SDATA0, SEL_SSI0_0),
	PINMUX_IPSR_MSEL(IP4_1_0, SCL0_B, SEL_IIC0_1),
	PINMUX_IPSR_MSEL(IP4_1_0, SCL7_B, SEL_IIC7_1),
	PINMUX_IPSR_MSEL(IP4_1_0, MSIOF2_SCK_C, SEL_SOF2_2),
	PINMUX_IPSR_MSEL(IP4_4_2, SSI_SCK1, SEL_SSI1_0),
	PINMUX_IPSR_MSEL(IP4_4_2, SDA0_B, SEL_IIC0_1),
	PINMUX_IPSR_MSEL(IP4_4_2, SDA7_B, SEL_IIC7_1),
	PINMUX_IPSR_MSEL(IP4_4_2, MSIOF2_SYNC_C, SEL_SOF2_2),
	PINMUX_IPSR_MSEL(IP4_4_2, GLO_I0_D, SEL_GPS_3),
	PINMUX_IPSR_MSEL(IP4_7_5, SSI_WS1, SEL_SSI1_0),
	PINMUX_IPSR_MSEL(IP4_7_5, SCL1_B, SEL_IIC1_1),
	PINMUX_IPSR_MSEL(IP4_7_5, SCL8_B, SEL_IIC8_1),
	PINMUX_IPSR_MSEL(IP4_7_5, MSIOF2_TXD_C, SEL_SOF2_2),
	PINMUX_IPSR_MSEL(IP4_7_5, GLO_I1_D, SEL_GPS_3),
	PINMUX_IPSR_MSEL(IP4_9_8, SSI_SDATA1, SEL_SSI1_0),
	PINMUX_IPSR_MSEL(IP4_9_8, SDA1_B, SEL_IIC1_1),
	PINMUX_IPSR_MSEL(IP4_9_8, SDA8_B, SEL_IIC8_1),
	PINMUX_IPSR_MSEL(IP4_9_8, MSIOF2_RXD_C, SEL_SOF2_2),
	PINMUX_IPSR_DATA(IP4_12_10, SSI_SCK2),
	PINMUX_IPSR_MSEL(IP4_12_10, SCL2, SEL_IIC2_0),
	PINMUX_IPSR_MSEL(IP4_12_10, GPS_CLK_B, SEL_GPS_1),
	PINMUX_IPSR_MSEL(IP4_12_10, GLO_Q0_D, SEL_GPS_3),
	PINMUX_IPSR_DATA(IP4_15_13, SSI_WS2),
	PINMUX_IPSR_MSEL(IP4_15_13, SDA2, SEL_IIC2_0),
	PINMUX_IPSR_MSEL(IP4_15_13, GPS_SIGN_B, SEL_GPS_1),
	PINMUX_IPSR_MSEL(IP4_15_13, RX2_E, SEL_SCIF2_4),
	PINMUX_IPSR_MSEL(IP4_15_13, GLO_Q1_D, SEL_GPS_3),
	PINMUX_IPSR_DATA(IP4_18_16, SSI_SDATA2),
	PINMUX_IPSR_MSEL(IP4_18_16, GPS_MAG_B, SEL_GPS_1),
	PINMUX_IPSR_MSEL(IP4_18_16, TX2_E, SEL_SCIF2_4),
	PINMUX_IPSR_DATA(IP4_19, SSI_SCK34),
	PINMUX_IPSR_DATA(IP4_20, SSI_WS34),
	PINMUX_IPSR_DATA(IP4_21, SSI_SDATA3),
	PINMUX_IPSR_DATA(IP4_23_22, SSI_SCK4),
	PINMUX_IPSR_MSEL(IP4_23_22, GLO_SS_D, SEL_GPS_3),
	PINMUX_IPSR_DATA(IP4_25_24, SSI_WS4),
	PINMUX_IPSR_MSEL(IP4_25_24, GLO_RFON_D, SEL_GPS_3),
	PINMUX_IPSR_DATA(IP4_27_26, SSI_SDATA4),
	PINMUX_IPSR_MSEL(IP4_27_26, MSIOF2_SCK_D, SEL_SOF2_3),
	PINMUX_IPSR_DATA(IP4_30_28, SSI_SCK5),
	PINMUX_IPSR_MSEL(IP4_30_28, MSIOF1_SCK_C, SEL_SOF1_2),
	PINMUX_IPSR_MSEL(IP4_30_28, TS_SDATA0, SEL_TSIF0_0),
	PINMUX_IPSR_MSEL(IP4_30_28, GLO_I0, SEL_GPS_0),
	PINMUX_IPSR_MSEL(IP4_30_28, MSIOF2_SYNC_D, SEL_SOF2_3),
	PINMUX_IPSR_DATA(IP4_30_28, VI1_R2_B),

	/* IPSR5 */
	PINMUX_IPSR_DATA(IP5_2_0, SSI_WS5),
	PINMUX_IPSR_MSEL(IP5_2_0, MSIOF1_SYNC_C, SEL_SOF1_2),
	PINMUX_IPSR_MSEL(IP5_2_0, TS_SCK0, SEL_TSIF0_0),
	PINMUX_IPSR_MSEL(IP5_2_0, GLO_I1, SEL_GPS_0),
	PINMUX_IPSR_MSEL(IP5_2_0, MSIOF2_TXD_D, SEL_SOF2_3),
	PINMUX_IPSR_DATA(IP5_2_0, VI1_R3_B),
	PINMUX_IPSR_DATA(IP5_5_3, SSI_SDATA5),
	PINMUX_IPSR_MSEL(IP5_5_3, MSIOF1_TXD_C, SEL_SOF1_2),
	PINMUX_IPSR_MSEL(IP5_5_3, TS_SDEN0, SEL_TSIF0_0),
	PINMUX_IPSR_MSEL(IP5_5_3, GLO_Q0, SEL_GPS_0),
	PINMUX_IPSR_MSEL(IP5_5_3, MSIOF2_SS1_D, SEL_SOF2_3),
	PINMUX_IPSR_DATA(IP5_5_3, VI1_R4_B),
	PINMUX_IPSR_DATA(IP5_8_6, SSI_SCK6),
	PINMUX_IPSR_MSEL(IP5_8_6, MSIOF1_RXD_C, SEL_SOF1_2),
	PINMUX_IPSR_MSEL(IP5_8_6, TS_SPSYNC0, SEL_TSIF0_0),
	PINMUX_IPSR_MSEL(IP5_8_6, GLO_Q1, SEL_GPS_0),
	PINMUX_IPSR_MSEL(IP5_8_6, MSIOF2_RXD_D, SEL_SOF2_3),
	PINMUX_IPSR_DATA(IP5_8_6, VI1_R5_B),
	PINMUX_IPSR_DATA(IP5_11_9, SSI_WS6),
	PINMUX_IPSR_MSEL(IP5_11_9, GLO_SCLK, SEL_GPS_0),
	PINMUX_IPSR_MSEL(IP5_11_9, MSIOF2_SS2_D, SEL_SOF2_3),
	PINMUX_IPSR_DATA(IP5_11_9, VI1_R6_B),
	PINMUX_IPSR_DATA(IP5_14_12, SSI_SDATA6),
	PINMUX_IPSR_MSEL(IP5_14_12, STP_IVCXO27_0_B, SEL_SSP_1),
	PINMUX_IPSR_MSEL(IP5_14_12, GLO_SDATA, SEL_GPS_0),
	PINMUX_IPSR_DATA(IP5_14_12, VI1_R7_B),
	PINMUX_IPSR_MSEL(IP5_16_15, SSI_SCK78, SEL_SSI7_0),
	PINMUX_IPSR_MSEL(IP5_16_15, STP_ISCLK_0_B, SEL_SSP_1),
	PINMUX_IPSR_MSEL(IP5_16_15, GLO_SS, SEL_GPS_0),
	PINMUX_IPSR_MSEL(IP5_19_17, SSI_WS78, SEL_SSI7_0),
	PINMUX_IPSR_MSEL(IP5_19_17, TX0_D, SEL_SCIF0_3),
	PINMUX_IPSR_MSEL(IP5_19_17, STP_ISD_0_B, SEL_SSP_1),
	PINMUX_IPSR_MSEL(IP5_19_17, GLO_RFON, SEL_GPS_0),
	PINMUX_IPSR_MSEL(IP5_21_20, SSI_SDATA7, SEL_SSI7_0),
	PINMUX_IPSR_MSEL(IP5_21_20, RX0_D, SEL_SCIF0_3),
	PINMUX_IPSR_MSEL(IP5_21_20, STP_ISEN_0_B, SEL_SSP_1),
	PINMUX_IPSR_MSEL(IP5_23_22, SSI_SDATA8, SEL_SSI8_0),
	PINMUX_IPSR_MSEL(IP5_23_22, TX1_D, SEL_SCIF1_3),
	PINMUX_IPSR_MSEL(IP5_23_22, STP_ISSYNC_0_B, SEL_SSP_1),
	PINMUX_IPSR_MSEL(IP5_25_24, SSI_SCK9, SEL_SSI9_0),
	PINMUX_IPSR_MSEL(IP5_25_24, RX1_D, SEL_SCIF1_3),
	PINMUX_IPSR_MSEL(IP5_25_24, GLO_SCLK_D, SEL_GPS_3),
	PINMUX_IPSR_MSEL(IP5_28_26, SSI_WS9, SEL_SSI9_0),
	PINMUX_IPSR_MSEL(IP5_28_26, TX3_D, SEL_SCIF3_3),
	PINMUX_IPSR_MSEL(IP5_28_26, CAN0_TX_D, SEL_CAN0_3),
	PINMUX_IPSR_MSEL(IP5_28_26, GLO_SDATA_D, SEL_GPS_3),
	PINMUX_IPSR_MSEL(IP5_31_29, SSI_SDATA9, SEL_SSI9_0),
	PINMUX_IPSR_MSEL(IP5_31_29, RX3_D, SEL_SCIF3_3),
	PINMUX_IPSR_MSEL(IP5_31_29, CAN0_RX_D, SEL_CAN0_3),

	/* IPSR6 */
	PINMUX_IPSR_MSEL(IP6_2_0, AUDIO_CLKB, SEL_ADG_0),
	PINMUX_IPSR_MSEL(IP6_2_0, STP_OPWM_0_B, SEL_SSP_1),
	PINMUX_IPSR_MSEL(IP6_2_0, MSIOF1_SCK_B, SEL_SOF1_1),
	PINMUX_IPSR_MSEL(IP6_2_0, SCIF_CLK, SEL_SCIF_0),
	PINMUX_IPSR_MSEL(IP6_2_0, BPFCLK_E, SEL_FM_4),
	PINMUX_IPSR_DATA(IP6_5_3, AUDIO_CLKC),
	PINMUX_IPSR_MSEL(IP6_5_3, SCIFB0_SCK_C, SEL_SCIFB_2),
	PINMUX_IPSR_MSEL(IP6_5_3, MSIOF1_SYNC_B, SEL_SOF1_1),
	PINMUX_IPSR_MSEL(IP6_5_3, RX2, SEL_SCIF2_0),
	PINMUX_IPSR_MSEL(IP6_5_3, SCIFA2_RXD, SEL_SCIFA2_0),
	PINMUX_IPSR_MSEL(IP6_5_3, FMIN_E, SEL_FM_4),
	PINMUX_IPSR_DATA(IP6_7_6, AUDIO_CLKOUT),
	PINMUX_IPSR_MSEL(IP6_7_6, MSIOF1_SS1_B, SEL_SOF1_1),
	PINMUX_IPSR_MSEL(IP6_5_3, TX2, SEL_SCIF2_0),
	PINMUX_IPSR_MSEL(IP6_7_6, SCIFA2_TXD, SEL_SCIFA2_0),
	PINMUX_IPSR_DATA(IP6_9_8, IRQ0),
	PINMUX_IPSR_MSEL(IP6_9_8, SCIFB1_RXD_D, SEL_SCIFB1_3),
	PINMUX_IPSR_DATA(IP6_9_8, INTC_IRQ0_N),
	PINMUX_IPSR_DATA(IP6_11_10, IRQ1),
	PINMUX_IPSR_MSEL(IP6_11_10, SCIFB1_SCK_C, SEL_SCIFB1_2),
	PINMUX_IPSR_DATA(IP6_11_10, INTC_IRQ1_N),
	PINMUX_IPSR_DATA(IP6_13_12, IRQ2),
	PINMUX_IPSR_MSEL(IP6_13_12, SCIFB1_TXD_D, SEL_SCIFB1_3),
	PINMUX_IPSR_DATA(IP6_13_12, INTC_IRQ2_N),
	PINMUX_IPSR_DATA(IP6_15_14, IRQ3),
	PINMUX_IPSR_MSEL(IP6_15_14, SCL4_C, SEL_IIC4_2),
	PINMUX_IPSR_MSEL(IP6_15_14, MSIOF2_TXD_E, SEL_SOF2_4),
	PINMUX_IPSR_DATA(IP6_15_14, INTC_IRQ4_N),
	PINMUX_IPSR_DATA(IP6_18_16, IRQ4),
	PINMUX_IPSR_MSEL(IP6_18_16, HRX1_C, SEL_HSCIF1_2),
	PINMUX_IPSR_MSEL(IP6_18_16, SDA4_C, SEL_IIC4_2),
	PINMUX_IPSR_MSEL(IP6_18_16, MSIOF2_RXD_E, SEL_SOF2_4),
	PINMUX_IPSR_DATA(IP6_18_16, INTC_IRQ4_N),
	PINMUX_IPSR_DATA(IP6_20_19, IRQ5),
	PINMUX_IPSR_MSEL(IP6_20_19, HTX1_C, SEL_HSCIF1_2),
	PINMUX_IPSR_MSEL(IP6_20_19, SCL1_E, SEL_IIC1_4),
	PINMUX_IPSR_MSEL(IP6_20_19, MSIOF2_SCK_E, SEL_SOF2_4),
	PINMUX_IPSR_DATA(IP6_23_21, IRQ6),
	PINMUX_IPSR_MSEL(IP6_23_21, HSCK1_C, SEL_HSCIF1_2),
	PINMUX_IPSR_MSEL(IP6_23_21, MSIOF1_SS2_B, SEL_SOF1_1),
	PINMUX_IPSR_MSEL(IP6_23_21, SDA1_E, SEL_IIC1_4),
	PINMUX_IPSR_MSEL(IP6_23_21, MSIOF2_SYNC_E, SEL_SOF2_4),
	PINMUX_IPSR_DATA(IP6_26_24, IRQ7),
	PINMUX_IPSR_MSEL(IP6_26_24, HCTS1_N_C, SEL_HSCIF1_2),
	PINMUX_IPSR_MSEL(IP6_26_24, MSIOF1_TXD_B, SEL_SOF1_1),
	PINMUX_IPSR_MSEL(IP6_26_24, GPS_CLK_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP6_26_24, GPS_CLK_D, SEL_GPS_3),
	PINMUX_IPSR_DATA(IP6_29_27, IRQ8),
	PINMUX_IPSR_MSEL(IP6_29_27, HRTS1_N_C, SEL_HSCIF1_2),
	PINMUX_IPSR_MSEL(IP6_29_27, MSIOF1_RXD_B, SEL_SOF1_1),
	PINMUX_IPSR_MSEL(IP6_29_27, GPS_SIGN_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP6_29_27, GPS_SIGN_D, SEL_GPS_3),

	/* IPSR7 */
	PINMUX_IPSR_DATA(IP7_2_0, IRQ9),
	PINMUX_IPSR_MSEL(IP7_2_0, DU1_DOTCLKIN_B, SEL_DIS_1),
	PINMUX_IPSR_MSEL(IP7_2_0, CAN_CLK_D, SEL_CANCLK_3),
	PINMUX_IPSR_MSEL(IP7_2_0, GPS_MAG_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP7_2_0, SCIF_CLK_B, SEL_SCIF_1),
	PINMUX_IPSR_MSEL(IP7_2_0, GPS_MAG_D, SEL_GPS_3),
	PINMUX_IPSR_DATA(IP7_5_3, DU1_DR0),
	PINMUX_IPSR_DATA(IP7_5_3, LCDOUT0),
	PINMUX_IPSR_MSEL(IP7_5_3, VI1_DATA0_B, SEL_VI1_1),
	PINMUX_IPSR_MSEL(IP7_5_3, TX0_B, SEL_SCIF0_1),
	PINMUX_IPSR_MSEL(IP7_5_3, SCIFA0_TXD_B, SEL_SCFA_1),
	PINMUX_IPSR_MSEL(IP7_5_3, MSIOF2_SCK_B, SEL_SOF2_1),
	PINMUX_IPSR_DATA(IP7_8_6, DU1_DR1),
	PINMUX_IPSR_DATA(IP7_8_6, LCDOUT1),
	PINMUX_IPSR_MSEL(IP7_8_6, VI1_DATA1_B, SEL_VI1_1),
	PINMUX_IPSR_MSEL(IP7_8_6, RX0_B, SEL_SCIF0_1),
	PINMUX_IPSR_MSEL(IP7_8_6, SCIFA0_RXD_B, SEL_SCFA_1),
	PINMUX_IPSR_MSEL(IP7_8_6, MSIOF2_SYNC_B, SEL_SOF2_1),
	PINMUX_IPSR_DATA(IP7_10_9, DU1_DR2),
	PINMUX_IPSR_DATA(IP7_10_9, LCDOUT2),
	PINMUX_IPSR_MSEL(IP7_10_9, SSI_SCK0129_B, SEL_SSI0_1),
	PINMUX_IPSR_DATA(IP7_12_11, DU1_DR3),
	PINMUX_IPSR_DATA(IP7_12_11, LCDOUT3),
	PINMUX_IPSR_MSEL(IP7_12_11, SSI_WS0129_B, SEL_SSI0_1),
	PINMUX_IPSR_DATA(IP7_14_13, DU1_DR4),
	PINMUX_IPSR_DATA(IP7_14_13, LCDOUT4),
	PINMUX_IPSR_MSEL(IP7_14_13, SSI_SDATA0_B, SEL_SSI0_1),
	PINMUX_IPSR_DATA(IP7_16_15, DU1_DR5),
	PINMUX_IPSR_DATA(IP7_16_15, LCDOUT5),
	PINMUX_IPSR_MSEL(IP7_16_15, SSI_SCK1_B, SEL_SSI1_1),
	PINMUX_IPSR_DATA(IP7_18_17, DU1_DR6),
	PINMUX_IPSR_DATA(IP7_18_17, LCDOUT6),
	PINMUX_IPSR_MSEL(IP7_18_17, SSI_WS1_B, SEL_SSI1_1),
	PINMUX_IPSR_DATA(IP7_20_19, DU1_DR7),
	PINMUX_IPSR_DATA(IP7_20_19, LCDOUT7),
	PINMUX_IPSR_MSEL(IP7_20_19, SSI_SDATA1_B, SEL_SSI1_1),
	PINMUX_IPSR_DATA(IP7_23_21, DU1_DG0),
	PINMUX_IPSR_DATA(IP7_23_21, LCDOUT8),
	PINMUX_IPSR_MSEL(IP7_23_21, VI1_DATA2_B, SEL_VI1_1),
	PINMUX_IPSR_MSEL(IP7_23_21, TX1_B, SEL_SCIF1_1),
	PINMUX_IPSR_MSEL(IP7_23_21, SCIFA1_TXD_B, SEL_SCIFA1_1),
	PINMUX_IPSR_MSEL(IP7_23_21, MSIOF2_SS1_B, SEL_SOF2_1),
	PINMUX_IPSR_DATA(IP7_26_24, DU1_DG1),
	PINMUX_IPSR_DATA(IP7_26_24, LCDOUT9),
	PINMUX_IPSR_MSEL(IP7_26_24, VI1_DATA3_B, SEL_VI1_1),
	PINMUX_IPSR_MSEL(IP7_26_24, RX1_B, SEL_SCIF1_1),
	PINMUX_IPSR_MSEL(IP7_26_24, SCIFA1_RXD_B, SEL_SCIFA1_1),
	PINMUX_IPSR_MSEL(IP7_26_24, MSIOF2_SS2_B, SEL_SOF2_1),
	PINMUX_IPSR_DATA(IP7_29_27, DU1_DG2),
	PINMUX_IPSR_DATA(IP7_29_27, LCDOUT10),
	PINMUX_IPSR_MSEL(IP7_29_27, VI1_DATA4_B, SEL_VI1_1),
	PINMUX_IPSR_DATA(IP7_29_27, SCIF1_SCK_B),
	PINMUX_IPSR_MSEL(IP7_29_27, SCIFA1_SCK, SEL_SCIFA1_0),
	PINMUX_IPSR_MSEL(IP7_29_27, SSI_SCK78_B, SEL_SSI7_1),

	/* IPSR8 */
	PINMUX_IPSR_DATA(IP8_2_0, DU1_DG3),
	PINMUX_IPSR_DATA(IP8_2_0, LCDOUT11),
	PINMUX_IPSR_MSEL(IP8_2_0, VI1_DATA5_B, SEL_VI1_1),
	PINMUX_IPSR_MSEL(IP8_2_0, SSI_WS78_B, SEL_SSI7_1),
	PINMUX_IPSR_DATA(IP8_5_3, DU1_DG4),
	PINMUX_IPSR_DATA(IP8_5_3, LCDOUT12),
	PINMUX_IPSR_MSEL(IP8_5_3, VI1_DATA6_B, SEL_VI1_1),
	PINMUX_IPSR_MSEL(IP8_5_3, HRX0_B, SEL_HSCIF0_1),
	PINMUX_IPSR_MSEL(IP8_5_3, SCIFB2_RXD_B, SEL_SCIFB2_1),
	PINMUX_IPSR_MSEL(IP8_5_3, SSI_SDATA7_B, SEL_SSI7_1),
	PINMUX_IPSR_DATA(IP8_8_6, DU1_DG5),
	PINMUX_IPSR_DATA(IP8_8_6, LCDOUT13),
	PINMUX_IPSR_MSEL(IP8_8_6, VI1_DATA7_B, SEL_VI1_1),
	PINMUX_IPSR_MSEL(IP8_8_6, HCTS0_N_B, SEL_HSCIF0_1),
	PINMUX_IPSR_MSEL(IP8_8_6, SCIFB2_TXD_B, SEL_SCIFB2_1),
	PINMUX_IPSR_MSEL(IP8_8_6, SSI_SDATA8_B, SEL_SSI8_1),
	PINMUX_IPSR_DATA(IP8_11_9, DU1_DG6),
	PINMUX_IPSR_DATA(IP8_11_9, LCDOUT14),
	PINMUX_IPSR_MSEL(IP8_11_9, HRTS0_N_B, SEL_HSCIF0_1),
	PINMUX_IPSR_MSEL(IP8_11_9, SCIFB2_CTS_N_B, SEL_SCIFB2_1),
	PINMUX_IPSR_MSEL(IP8_11_9, SSI_SCK9_B, SEL_SSI9_1),
	PINMUX_IPSR_DATA(IP8_14_12, DU1_DG7),
	PINMUX_IPSR_DATA(IP8_14_12, LCDOUT15),
	PINMUX_IPSR_MSEL(IP8_14_12, HTX0_B, SEL_HSCIF0_1),
	PINMUX_IPSR_MSEL(IP8_14_12, SCIFB2_RTS_N_B, SEL_SCIFB2_1),
	PINMUX_IPSR_MSEL(IP8_14_12, SSI_WS9_B, SEL_SSI9_1),
	PINMUX_IPSR_DATA(IP8_17_15, DU1_DB0),
	PINMUX_IPSR_DATA(IP8_17_15, LCDOUT16),
	PINMUX_IPSR_MSEL(IP8_17_15, VI1_CLK_B, SEL_VI1_1),
	PINMUX_IPSR_MSEL(IP8_17_15, TX2_B, SEL_SCIF2_1),
	PINMUX_IPSR_MSEL(IP8_17_15, SCIFA2_TXD_B, SEL_SCIFA2_1),
	PINMUX_IPSR_MSEL(IP8_17_15, MSIOF2_TXD_B, SEL_SOF2_1),
	PINMUX_IPSR_DATA(IP8_20_18, DU1_DB1),
	PINMUX_IPSR_DATA(IP8_20_18, LCDOUT17),
	PINMUX_IPSR_MSEL(IP8_20_18, VI1_HSYNC_N_B, SEL_VI1_1),
	PINMUX_IPSR_MSEL(IP8_20_18, RX2_B, SEL_SCIF2_1),
	PINMUX_IPSR_MSEL(IP8_20_18, SCIFA2_RXD_B, SEL_SCIFA2_1),
	PINMUX_IPSR_MSEL(IP8_20_18, MSIOF2_RXD_B, SEL_SOF2_1),
	PINMUX_IPSR_DATA(IP8_23_21, DU1_DB2),
	PINMUX_IPSR_DATA(IP8_23_21, LCDOUT18),
	PINMUX_IPSR_MSEL(IP8_23_21, VI1_VSYNC_N_B, SEL_VI1_1),
	PINMUX_IPSR_DATA(IP8_23_21, SCIF2_SCK_B),
	PINMUX_IPSR_MSEL(IP8_23_21, SCIFA2_SCK, SEL_SCIFA2_1),
	PINMUX_IPSR_MSEL(IP8_23_21, SSI_SDATA9_B, SEL_SSI9_1),
	PINMUX_IPSR_DATA(IP8_25_24, DU1_DB3),
	PINMUX_IPSR_DATA(IP8_25_24, LCDOUT19),
	PINMUX_IPSR_MSEL(IP8_25_24, VI1_CLKENB_B, SEL_VI1_1),
	PINMUX_IPSR_DATA(IP8_27_26, DU1_DB4),
	PINMUX_IPSR_DATA(IP8_27_26, LCDOUT20),
	PINMUX_IPSR_MSEL(IP8_27_26, VI1_FIELD_B, SEL_VI1_1),
	PINMUX_IPSR_MSEL(IP8_27_26, CAN1_RX, SEL_CAN1_0),
	PINMUX_IPSR_DATA(IP8_30_28, DU1_DB5),
	PINMUX_IPSR_DATA(IP8_30_28, LCDOUT21),
	PINMUX_IPSR_MSEL(IP8_30_28, TX3, SEL_SCIF3_0),
	PINMUX_IPSR_MSEL(IP8_30_28, SCIFA3_TXD, SEL_SCIFA3_0),
	PINMUX_IPSR_MSEL(IP8_30_28, CAN1_TX, SEL_CAN1_0),

	/* IPSR9 */
	PINMUX_IPSR_DATA(IP9_2_0, DU1_DB6),
	PINMUX_IPSR_DATA(IP9_2_0, LCDOUT22),
	PINMUX_IPSR_MSEL(IP9_2_0, SCL3_C, SEL_IIC3_2),
	PINMUX_IPSR_MSEL(IP9_2_0, RX3, SEL_SCIF3_0),
	PINMUX_IPSR_MSEL(IP9_2_0, SCIFA3_RXD, SEL_SCIFA3_0),
	PINMUX_IPSR_DATA(IP9_5_3, DU1_DB7),
	PINMUX_IPSR_DATA(IP9_5_3, LCDOUT23),
	PINMUX_IPSR_MSEL(IP9_5_3, SDA3_C, SEL_IIC3_2),
	PINMUX_IPSR_MSEL(IP9_5_3, SCIF3_SCK, SEL_SCIF3_0),
	PINMUX_IPSR_MSEL(IP9_5_3, SCIFA3_SCK, SEL_SCIFA3_0),
	PINMUX_IPSR_MSEL(IP9_6, DU1_DOTCLKIN, SEL_DIS_0),
	PINMUX_IPSR_DATA(IP9_6, QSTVA_QVS),
	PINMUX_IPSR_DATA(IP9_7, DU1_DOTCLKOUT0),
	PINMUX_IPSR_DATA(IP9_7, QCLK),
	PINMUX_IPSR_DATA(IP9_10_8, DU1_DOTCLKOUT1),
	PINMUX_IPSR_DATA(IP9_10_8, QSTVB_QVE),
	PINMUX_IPSR_MSEL(IP9_10_8, CAN0_TX, SEL_CAN0_0),
	PINMUX_IPSR_MSEL(IP9_10_8, TX3_B, SEL_SCIF3_1),
	PINMUX_IPSR_MSEL(IP9_10_8, SCL2_B, SEL_IIC2_1),
	PINMUX_IPSR_DATA(IP9_10_8, PWM4),
	PINMUX_IPSR_DATA(IP9_11, DU1_EXHSYNC_DU1_HSYNC),
	PINMUX_IPSR_DATA(IP9_11, QSTH_QHS),
	PINMUX_IPSR_DATA(IP9_12, DU1_EXVSYNC_DU1_VSYNC),
	PINMUX_IPSR_DATA(IP9_12, QSTB_QHE),
	PINMUX_IPSR_DATA(IP9_15_13, DU1_EXODDF_DU1_ODDF_DISP_CDE),
	PINMUX_IPSR_DATA(IP9_15_13, QCPV_QDE),
	PINMUX_IPSR_MSEL(IP9_15_13, CAN0_RX, SEL_CAN0_0),
	PINMUX_IPSR_MSEL(IP9_15_13, RX3_B, SEL_SCIF3_1),
	PINMUX_IPSR_MSEL(IP9_15_13, SDA2_B, SEL_IIC2_1),
	PINMUX_IPSR_DATA(IP9_16, DU1_DISP),
	PINMUX_IPSR_DATA(IP9_16, QPOLA),
	PINMUX_IPSR_DATA(IP9_18_17, DU1_CDE),
	PINMUX_IPSR_DATA(IP9_18_17, QPOLB),
	PINMUX_IPSR_DATA(IP9_18_17, PWM4_B),
	PINMUX_IPSR_DATA(IP9_20_19, VI0_CLKENB),
	PINMUX_IPSR_MSEL(IP9_20_19, TX4, SEL_SCIF4_0),
	PINMUX_IPSR_MSEL(IP9_20_19, SCIFA4_TXD, SEL_SCIFA4_0),
	PINMUX_IPSR_MSEL(IP9_20_19, TS_SDATA0_D, SEL_TSIF0_3),
	PINMUX_IPSR_DATA(IP9_22_21, VI0_FIELD),
	PINMUX_IPSR_MSEL(IP9_22_21, RX4, SEL_SCIF4_0),
	PINMUX_IPSR_MSEL(IP9_22_21, SCIFA4_RXD, SEL_SCIFA4_0),
	PINMUX_IPSR_MSEL(IP9_22_21, TS_SCK0_D, SEL_TSIF0_3),
	PINMUX_IPSR_DATA(IP9_24_23, VI0_HSYNC_N),
	PINMUX_IPSR_MSEL(IP9_24_23, TX5, SEL_SCIF5_0),
	PINMUX_IPSR_MSEL(IP9_24_23, SCIFA5_TXD, SEL_SCIFA5_0),
	PINMUX_IPSR_MSEL(IP9_24_23, TS_SDEN0_D, SEL_TSIF0_3),
	PINMUX_IPSR_DATA(IP9_26_25, VI0_VSYNC_N),
	PINMUX_IPSR_MSEL(IP9_26_25, RX5, SEL_SCIF5_0),
	PINMUX_IPSR_MSEL(IP9_26_25, SCIFA5_RXD, SEL_SCIFA5_0),
	PINMUX_IPSR_MSEL(IP9_26_25, TS_SPSYNC0_D, SEL_TSIF0_3),
	PINMUX_IPSR_DATA(IP9_28_27, VI0_DATA3_VI0_B3),
	PINMUX_IPSR_MSEL(IP9_28_27, SCIF3_SCK_B, SEL_SCIF3_1),
	PINMUX_IPSR_MSEL(IP9_28_27, SCIFA3_SCK_B, SEL_SCIFA3_1),
	PINMUX_IPSR_DATA(IP9_31_29, VI0_G0),
	PINMUX_IPSR_MSEL(IP9_31_29, SCL8, SEL_IIC8_0),
	PINMUX_IPSR_MSEL(IP9_31_29, STP_IVCXO27_0_C, SEL_SSP_2),
	PINMUX_IPSR_MSEL(IP9_31_29, SCL4, SEL_IIC4_0),
	PINMUX_IPSR_MSEL(IP9_31_29, HCTS2_N, SEL_HSCIF2_0),
	PINMUX_IPSR_MSEL(IP9_31_29, SCIFB2_CTS_N, SEL_SCIFB2_0),
	PINMUX_IPSR_DATA(IP9_31_29, ATAWR1_N),

	/* IPSR10 */
	PINMUX_IPSR_DATA(IP10_2_0, VI0_G1),
	PINMUX_IPSR_MSEL(IP10_2_0, SDA8, SEL_IIC8_0),
	PINMUX_IPSR_MSEL(IP10_2_0, STP_ISCLK_0_C, SEL_SSP_2),
	PINMUX_IPSR_MSEL(IP10_2_0, SDA4, SEL_IIC4_0),
	PINMUX_IPSR_MSEL(IP10_2_0, HRTS2_N, SEL_HSCIF2_0),
	PINMUX_IPSR_MSEL(IP10_2_0, SCIFB2_RTS_N, SEL_SCIFB2_0),
	PINMUX_IPSR_DATA(IP10_2_0, ATADIR1_N),
	PINMUX_IPSR_DATA(IP10_5_3, VI0_G2),
	PINMUX_IPSR_DATA(IP10_5_3, VI2_HSYNC_N),
	PINMUX_IPSR_MSEL(IP10_5_3, STP_ISD_0_C, SEL_SSP_2),
	PINMUX_IPSR_MSEL(IP10_5_3, SCL3_B, SEL_IIC3_1),
	PINMUX_IPSR_MSEL(IP10_5_3, HSCK2, SEL_HSCIF2_0),
	PINMUX_IPSR_MSEL(IP10_5_3, SCIFB2_SCK, SEL_SCIFB2_0),
	PINMUX_IPSR_DATA(IP10_5_3, ATARD1_N),
	PINMUX_IPSR_DATA(IP10_8_6, VI0_G3),
	PINMUX_IPSR_DATA(IP10_8_6, VI2_VSYNC_N),
	PINMUX_IPSR_MSEL(IP10_8_6, STP_ISEN_0_C, SEL_SSP_2),
	PINMUX_IPSR_MSEL(IP10_8_6, SDA3_B, SEL_IIC3_1),
	PINMUX_IPSR_MSEL(IP10_8_6, HRX2, SEL_HSCIF2_0),
	PINMUX_IPSR_MSEL(IP10_8_6, SCIFB2_RXD, SEL_SCIFB2_0),
	PINMUX_IPSR_DATA(IP10_8_6, ATACS01_N),
	PINMUX_IPSR_DATA(IP10_11_9, VI0_G4),
	PINMUX_IPSR_DATA(IP10_11_9, VI2_CLKENB),
	PINMUX_IPSR_MSEL(IP10_11_9, STP_ISSYNC_0_C, SEL_SSP_2),
	PINMUX_IPSR_MSEL(IP10_11_9, HTX2, SEL_HSCIF2_0),
	PINMUX_IPSR_MSEL(IP10_11_9, SCIFB2_TXD, SEL_SCIFB2_0),
	PINMUX_IPSR_MSEL(IP10_11_9, SCIFB0_SCK_D, SEL_SCIFB_3),
	PINMUX_IPSR_DATA(IP10_14_12, VI0_G5),
	PINMUX_IPSR_DATA(IP10_14_12, VI2_FIELD),
	PINMUX_IPSR_MSEL(IP10_14_12, STP_OPWM_0_C, SEL_SSP_2),
	PINMUX_IPSR_MSEL(IP10_14_12, FMCLK_D, SEL_FM_3),
	PINMUX_IPSR_MSEL(IP10_14_12, CAN0_TX_E, SEL_CAN0_4),
	PINMUX_IPSR_MSEL(IP10_14_12, HTX1_D, SEL_HSCIF1_3),
	PINMUX_IPSR_MSEL(IP10_14_12, SCIFB0_TXD_D, SEL_SCIFB_3),
	PINMUX_IPSR_DATA(IP10_16_15, VI0_G6),
	PINMUX_IPSR_DATA(IP10_16_15, VI2_CLK),
	PINMUX_IPSR_MSEL(IP10_16_15, BPFCLK_D, SEL_FM_3),
	PINMUX_IPSR_DATA(IP10_18_17, VI0_G7),
	PINMUX_IPSR_DATA(IP10_18_17, VI2_DATA0),
	PINMUX_IPSR_MSEL(IP10_18_17, FMIN_D, SEL_FM_3),
	PINMUX_IPSR_DATA(IP10_21_19, VI0_R0),
	PINMUX_IPSR_DATA(IP10_21_19, VI2_DATA1),
	PINMUX_IPSR_MSEL(IP10_21_19, GLO_I0_B, SEL_GPS_1),
	PINMUX_IPSR_MSEL(IP10_21_19, TS_SDATA0_C, SEL_TSIF0_2),
	PINMUX_IPSR_DATA(IP10_21_19, ATACS11_N),
	PINMUX_IPSR_DATA(IP10_24_22, VI0_R1),
	PINMUX_IPSR_DATA(IP10_24_22, VI2_DATA2),
	PINMUX_IPSR_MSEL(IP10_24_22, GLO_I1_B, SEL_GPS_1),
	PINMUX_IPSR_MSEL(IP10_24_22, TS_SCK0_C, SEL_TSIF0_2),
	PINMUX_IPSR_DATA(IP10_24_22, ATAG1_N),
	PINMUX_IPSR_DATA(IP10_26_25, VI0_R2),
	PINMUX_IPSR_DATA(IP10_26_25, VI2_DATA3),
	PINMUX_IPSR_MSEL(IP10_26_25, GLO_Q0_B, SEL_GPS_1),
	PINMUX_IPSR_MSEL(IP10_26_25, TS_SDEN0_C, SEL_TSIF0_2),
	PINMUX_IPSR_DATA(IP10_28_27, VI0_R3),
	PINMUX_IPSR_DATA(IP10_28_27, VI2_DATA4),
	PINMUX_IPSR_MSEL(IP10_28_27, GLO_Q1_B, SEL_GPS_1),
	PINMUX_IPSR_MSEL(IP10_28_27, TS_SPSYNC0_C, SEL_TSIF0_2),
	PINMUX_IPSR_DATA(IP10_31_29, VI0_R4),
	PINMUX_IPSR_DATA(IP10_31_29, VI2_DATA5),
	PINMUX_IPSR_MSEL(IP10_31_29, GLO_SCLK_B, SEL_GPS_1),
	PINMUX_IPSR_MSEL(IP10_31_29, TX0_C, SEL_SCIF0_2),
	PINMUX_IPSR_MSEL(IP10_31_29, SCL1_D, SEL_IIC1_3),

	/* IPSR11 */
	PINMUX_IPSR_DATA(IP11_2_0, VI0_R5),
	PINMUX_IPSR_DATA(IP11_2_0, VI2_DATA6),
	PINMUX_IPSR_MSEL(IP11_2_0, GLO_SDATA_B, SEL_GPS_1),
	PINMUX_IPSR_MSEL(IP11_2_0, RX0_C, SEL_SCIF0_2),
	PINMUX_IPSR_MSEL(IP11_2_0, SDA1_D, SEL_IIC1_3),
	PINMUX_IPSR_DATA(IP11_5_3, VI0_R6),
	PINMUX_IPSR_DATA(IP11_5_3, VI2_DATA7),
	PINMUX_IPSR_MSEL(IP11_5_3, GLO_SS_B, SEL_GPS_1),
	PINMUX_IPSR_MSEL(IP11_5_3, TX1_C, SEL_SCIF1_2),
	PINMUX_IPSR_MSEL(IP11_5_3, SCL4_B, SEL_IIC4_1),
	PINMUX_IPSR_DATA(IP11_8_6, VI0_R7),
	PINMUX_IPSR_MSEL(IP11_8_6, GLO_RFON_B, SEL_GPS_1),
	PINMUX_IPSR_MSEL(IP11_8_6, RX1_C, SEL_SCIF1_2),
	PINMUX_IPSR_MSEL(IP11_8_6, CAN0_RX_E, SEL_CAN0_4),
	PINMUX_IPSR_MSEL(IP11_8_6, SDA4_B, SEL_IIC4_1),
	PINMUX_IPSR_MSEL(IP11_8_6, HRX1_D, SEL_HSCIF1_3),
	PINMUX_IPSR_MSEL(IP11_8_6, SCIFB0_RXD_D, SEL_SCIFB_3),
	PINMUX_IPSR_MSEL(IP11_11_9, VI1_HSYNC_N, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_11_9, AVB_RXD0),
	PINMUX_IPSR_MSEL(IP11_11_9, TS_SDATA0_B, SEL_TSIF0_1),
	PINMUX_IPSR_MSEL(IP11_11_9, TX4_B, SEL_SCIF4_1),
	PINMUX_IPSR_MSEL(IP11_11_9, SCIFA4_TXD_B, SEL_SCIFA4_1),
	PINMUX_IPSR_MSEL(IP11_14_12, VI1_VSYNC_N, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_14_12, AVB_RXD1),
	PINMUX_IPSR_MSEL(IP11_14_12, TS_SCK0_B, SEL_TSIF0_1),
	PINMUX_IPSR_MSEL(IP11_14_12, RX4_B, SEL_SCIF4_1),
	PINMUX_IPSR_MSEL(IP11_14_12, SCIFA4_RXD_B, SEL_SCIFA4_1),
	PINMUX_IPSR_MSEL(IP11_16_15, VI1_CLKENB, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_16_15, AVB_RXD2),
	PINMUX_IPSR_MSEL(IP11_16_15, TS_SDEN0_B, SEL_TSIF0_1),
	PINMUX_IPSR_MSEL(IP11_18_17, VI1_FIELD, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_18_17, AVB_RXD3),
	PINMUX_IPSR_MSEL(IP11_18_17, TS_SPSYNC0_B, SEL_TSIF0_1),
	PINMUX_IPSR_MSEL(IP11_19, VI1_CLK, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_19, AVB_RXD4),
	PINMUX_IPSR_MSEL(IP11_20, VI1_DATA0, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_20, AVB_RXD5),
	PINMUX_IPSR_MSEL(IP11_21, VI1_DATA1, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_21, AVB_RXD6),
	PINMUX_IPSR_MSEL(IP11_22, VI1_DATA2, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_22, AVB_RXD7),
	PINMUX_IPSR_MSEL(IP11_23, VI1_DATA3, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_23, AVB_RX_ER),
	PINMUX_IPSR_MSEL(IP11_24, VI1_DATA4, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_24, AVB_MDIO),
	PINMUX_IPSR_MSEL(IP11_25, VI1_DATA5, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_25, AVB_RX_DV),
	PINMUX_IPSR_MSEL(IP11_26, VI1_DATA6, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_26, AVB_MAGIC),
	PINMUX_IPSR_MSEL(IP11_27, VI1_DATA7, SEL_VI1_0),
	PINMUX_IPSR_DATA(IP11_27, AVB_MDC),
	PINMUX_IPSR_DATA(IP11_29_28, ETH_MDIO),
	PINMUX_IPSR_DATA(IP11_29_28, AVB_RX_CLK),
	PINMUX_IPSR_MSEL(IP11_29_28, SCL2_C, SEL_IIC2_2),
	PINMUX_IPSR_DATA(IP11_31_30, ETH_CRS_DV),
	PINMUX_IPSR_DATA(IP11_31_30, AVB_LINK),
	PINMUX_IPSR_MSEL(IP11_31_30, SDA2_C, SEL_IIC2_2),

	/* IPSR12 */
	PINMUX_IPSR_DATA(IP12_1_0, ETH_RX_ER),
	PINMUX_IPSR_DATA(IP12_1_0, AVB_CRS),
	PINMUX_IPSR_MSEL(IP12_1_0, SCL3, SEL_IIC3_0),
	PINMUX_IPSR_MSEL(IP12_1_0, SCL7, SEL_IIC7_0),
	PINMUX_IPSR_DATA(IP12_3_2, ETH_RXD0),
	PINMUX_IPSR_DATA(IP12_3_2, AVB_PHY_INT),
	PINMUX_IPSR_MSEL(IP12_3_2, SDA3, SEL_IIC3_0),
	PINMUX_IPSR_MSEL(IP12_3_2, SDA7, SEL_IIC7_0),
	PINMUX_IPSR_DATA(IP12_6_4, ETH_RXD1),
	PINMUX_IPSR_DATA(IP12_6_4, AVB_GTXREFCLK),
	PINMUX_IPSR_MSEL(IP12_6_4, CAN0_TX_C, SEL_CAN0_2),
	PINMUX_IPSR_MSEL(IP12_6_4, SCL2_D, SEL_IIC2_3),
	PINMUX_IPSR_MSEL(IP12_6_4, MSIOF1_RXD_E, SEL_SOF1_4),
	PINMUX_IPSR_DATA(IP12_9_7, ETH_LINK),
	PINMUX_IPSR_DATA(IP12_9_7, AVB_TXD0),
	PINMUX_IPSR_MSEL(IP12_9_7, CAN0_RX_C, SEL_CAN0_2),
	PINMUX_IPSR_MSEL(IP12_9_7, SDA2_D, SEL_IIC2_3),
	PINMUX_IPSR_MSEL(IP12_9_7, MSIOF1_SCK_E, SEL_SOF1_4),
	PINMUX_IPSR_DATA(IP12_12_10, ETH_REFCLK),
	PINMUX_IPSR_DATA(IP12_12_10, AVB_TXD1),
	PINMUX_IPSR_MSEL(IP12_12_10, SCIFA3_RXD_B, SEL_SCIFA3_1),
	PINMUX_IPSR_MSEL(IP12_12_10, CAN1_RX_C, SEL_CAN1_2),
	PINMUX_IPSR_MSEL(IP12_12_10, MSIOF1_SYNC_E, SEL_SOF1_4),
	PINMUX_IPSR_DATA(IP12_15_13, ETH_TXD1),
	PINMUX_IPSR_DATA(IP12_15_13, AVB_TXD2),
	PINMUX_IPSR_MSEL(IP12_15_13, SCIFA3_TXD_B, SEL_SCIFA3_1),
	PINMUX_IPSR_MSEL(IP12_15_13, CAN1_TX_C, SEL_CAN1_2),
	PINMUX_IPSR_MSEL(IP12_15_13, MSIOF1_TXD_E, SEL_SOF1_4),
	PINMUX_IPSR_DATA(IP12_17_16, ETH_TX_EN),
	PINMUX_IPSR_DATA(IP12_17_16, AVB_TXD3),
	PINMUX_IPSR_MSEL(IP12_17_16, TCLK1_B, SEL_TMU1_0),
	PINMUX_IPSR_MSEL(IP12_17_16, CAN_CLK_B, SEL_CANCLK_1),
	PINMUX_IPSR_DATA(IP12_19_18, ETH_MAGIC),
	PINMUX_IPSR_DATA(IP12_19_18, AVB_TXD4),
	PINMUX_IPSR_MSEL(IP12_19_18, IETX_C, SEL_IEB_2),
	PINMUX_IPSR_DATA(IP12_21_20, ETH_TXD0),
	PINMUX_IPSR_DATA(IP12_21_20, AVB_TXD5),
	PINMUX_IPSR_MSEL(IP12_21_20, IECLK_C, SEL_IEB_2),
	PINMUX_IPSR_DATA(IP12_23_22, ETH_MDC),
	PINMUX_IPSR_DATA(IP12_23_22, AVB_TXD6),
	PINMUX_IPSR_MSEL(IP12_23_22, IERX_C, SEL_IEB_2),
	PINMUX_IPSR_MSEL(IP12_26_24, STP_IVCXO27_0, SEL_SSP_0),
	PINMUX_IPSR_DATA(IP12_26_24, AVB_TXD7),
	PINMUX_IPSR_MSEL(IP12_26_24, SCIFB2_TXD_D, SEL_SCIFB2_3),
	PINMUX_IPSR_MSEL(IP12_26_24, ADIDATA_B, SEL_RAD_1),
	PINMUX_IPSR_MSEL(IP12_26_24, MSIOF0_SYNC_C, SEL_SOF0_2),
	PINMUX_IPSR_MSEL(IP12_29_27, STP_ISCLK_0, SEL_SSP_0),
	PINMUX_IPSR_DATA(IP12_29_27, AVB_TX_EN),
	PINMUX_IPSR_MSEL(IP12_29_27, SCIFB2_RXD_D, SEL_SCIFB2_3),
	PINMUX_IPSR_MSEL(IP12_29_27, ADICS_SAMP_B, SEL_RAD_1),
	PINMUX_IPSR_MSEL(IP12_29_27, MSIOF0_SCK_C, SEL_SOF0_2),

	/* IPSR13 */
	PINMUX_IPSR_MSEL(IP13_2_0, STP_ISD_0, SEL_SSP_0),
	PINMUX_IPSR_DATA(IP13_2_0, AVB_TX_ER),
	PINMUX_IPSR_MSEL(IP13_2_0, SCIFB2_SCK_C, SEL_SCIFB2_2),
	PINMUX_IPSR_MSEL(IP13_2_0, ADICLK_B, SEL_RAD_1),
	PINMUX_IPSR_MSEL(IP13_2_0, MSIOF0_SS1_C, SEL_SOF0_2),
	PINMUX_IPSR_MSEL(IP13_4_3, STP_ISEN_0, SEL_SSP_0),
	PINMUX_IPSR_DATA(IP13_4_3, AVB_TX_CLK),
	PINMUX_IPSR_MSEL(IP13_4_3, ADICHS0_B, SEL_RAD_1),
	PINMUX_IPSR_MSEL(IP13_4_3, MSIOF0_SS2_C, SEL_SOF0_2),
	PINMUX_IPSR_MSEL(IP13_6_5, STP_ISSYNC_0, SEL_SSP_0),
	PINMUX_IPSR_DATA(IP13_6_5, AVB_COL),
	PINMUX_IPSR_MSEL(IP13_6_5, ADICHS1_B, SEL_RAD_1),
	PINMUX_IPSR_MSEL(IP13_6_5, MSIOF0_RXD_C, SEL_SOF0_2),
	PINMUX_IPSR_MSEL(IP13_9_7, STP_OPWM_0, SEL_SSP_0),
	PINMUX_IPSR_DATA(IP13_9_7, AVB_GTX_CLK),
	PINMUX_IPSR_DATA(IP13_9_7, PWM0_B),
	PINMUX_IPSR_MSEL(IP13_9_7, ADICHS2_B, SEL_RAD_1),
	PINMUX_IPSR_MSEL(IP13_9_7, MSIOF0_TXD_C, SEL_SOF0_2),
	PINMUX_IPSR_DATA(IP13_10, SD0_CLK),
	PINMUX_IPSR_MSEL(IP13_10, SPCLK_B, SEL_QSP_1),
	PINMUX_IPSR_DATA(IP13_11, SD0_CMD),
	PINMUX_IPSR_MSEL(IP13_11, MOSI_IO0_B, SEL_QSP_1),
	PINMUX_IPSR_DATA(IP13_12, SD0_DATA0),
	PINMUX_IPSR_MSEL(IP13_12, MISO_IO1_B, SEL_QSP_1),
	PINMUX_IPSR_DATA(IP13_13, SD0_DATA1),
	PINMUX_IPSR_MSEL(IP13_13, IO2_B, SEL_QSP_1),
	PINMUX_IPSR_DATA(IP13_14, SD0_DATA2),
	PINMUX_IPSR_MSEL(IP13_14, IO3_B, SEL_QSP_1),
	PINMUX_IPSR_DATA(IP13_15, SD0_DATA3),
	PINMUX_IPSR_MSEL(IP13_15, SSL_B, SEL_QSP_1),
	PINMUX_IPSR_DATA(IP13_18_16, SD0_CD),
	PINMUX_IPSR_MSEL(IP13_18_16, MMC_D6_B, SEL_MMC_1),
	PINMUX_IPSR_MSEL(IP13_18_16, SIM0_RST_B, SEL_SIM_1),
	PINMUX_IPSR_MSEL(IP13_18_16, CAN0_RX_F, SEL_CAN0_5),
	PINMUX_IPSR_MSEL(IP13_18_16, SCIFA5_TXD_B, SEL_SCIFA5_1),
	PINMUX_IPSR_MSEL(IP13_18_16, TX3_C, SEL_SCIF3_2),
	PINMUX_IPSR_DATA(IP13_21_19, SD0_WP),
	PINMUX_IPSR_MSEL(IP13_21_19, MMC_D7_B, SEL_MMC_1),
	PINMUX_IPSR_MSEL(IP13_21_19, SIM0_D_B, SEL_SIM_1),
	PINMUX_IPSR_MSEL(IP13_21_19, CAN0_TX_F, SEL_CAN0_5),
	PINMUX_IPSR_MSEL(IP13_21_19, SCIFA5_RXD_B, SEL_SCIFA5_1),
	PINMUX_IPSR_MSEL(IP13_21_19, RX3_C, SEL_SCIF3_2),
	PINMUX_IPSR_DATA(IP13_22, SD1_CMD),
	PINMUX_IPSR_MSEL(IP13_22, REMOCON_B, SEL_RCN_1),
	PINMUX_IPSR_DATA(IP13_24_23, SD1_DATA0),
	PINMUX_IPSR_MSEL(IP13_24_23, SPEEDIN_B, SEL_RSP_1),
	PINMUX_IPSR_DATA(IP13_25, SD1_DATA1),
	PINMUX_IPSR_MSEL(IP13_25, IETX_B, SEL_IEB_1),
	PINMUX_IPSR_DATA(IP13_26, SD1_DATA2),
	PINMUX_IPSR_MSEL(IP13_26, IECLK_B, SEL_IEB_1),
	PINMUX_IPSR_DATA(IP13_27, SD1_DATA3),
	PINMUX_IPSR_MSEL(IP13_27, IERX_B, SEL_IEB_1),
	PINMUX_IPSR_DATA(IP13_30_28, SD1_CD),
	PINMUX_IPSR_DATA(IP13_30_28, PWM0),
	PINMUX_IPSR_DATA(IP13_30_28, TPU_TO0),
	PINMUX_IPSR_MSEL(IP13_30_28, SCL1_C, SEL_IIC1_2),

	/* IPSR14 */
	PINMUX_IPSR_DATA(IP14_1_0, SD1_WP),
	PINMUX_IPSR_DATA(IP14_1_0, PWM1_B),
	PINMUX_IPSR_MSEL(IP14_1_0, SDA1_C, SEL_IIC1_2),
	PINMUX_IPSR_DATA(IP14_2, SD2_CLK),
	PINMUX_IPSR_DATA(IP14_2, MMC_CLK),
	PINMUX_IPSR_DATA(IP14_3, SD2_CMD),
	PINMUX_IPSR_DATA(IP14_3, MMC_CMD),
	PINMUX_IPSR_DATA(IP14_4, SD2_DATA0),
	PINMUX_IPSR_DATA(IP14_4, MMC_D0),
	PINMUX_IPSR_DATA(IP14_5, SD2_DATA1),
	PINMUX_IPSR_DATA(IP14_5, MMC_D1),
	PINMUX_IPSR_DATA(IP14_6, SD2_DATA2),
	PINMUX_IPSR_DATA(IP14_6, MMC_D2),
	PINMUX_IPSR_DATA(IP14_7, SD2_DATA3),
	PINMUX_IPSR_DATA(IP14_7, MMC_D3),
	PINMUX_IPSR_DATA(IP14_10_8, SD2_CD),
	PINMUX_IPSR_DATA(IP14_10_8, MMC_D4),
	PINMUX_IPSR_MSEL(IP14_10_8, SCL8_C, SEL_IIC8_2),
	PINMUX_IPSR_MSEL(IP14_10_8, TX5_B, SEL_SCIF5_1),
	PINMUX_IPSR_MSEL(IP14_10_8, SCIFA5_TXD_C, SEL_SCIFA5_2),
	PINMUX_IPSR_DATA(IP14_13_11, SD2_WP),
	PINMUX_IPSR_DATA(IP14_13_11, MMC_D5),
	PINMUX_IPSR_MSEL(IP14_13_11, SDA8_C, SEL_IIC8_2),
	PINMUX_IPSR_MSEL(IP14_13_11, RX5_B, SEL_SCIF5_1),
	PINMUX_IPSR_MSEL(IP14_13_11, SCIFA5_RXD_C, SEL_SCIFA5_2),
	PINMUX_IPSR_MSEL(IP14_16_14, MSIOF0_SCK, SEL_SOF0_0),
	PINMUX_IPSR_MSEL(IP14_16_14, RX2_C, SEL_SCIF2_2),
	PINMUX_IPSR_MSEL(IP14_16_14, ADIDATA, SEL_RAD_0),
	PINMUX_IPSR_MSEL(IP14_16_14, VI1_CLK_C, SEL_VI1_2),
	PINMUX_IPSR_DATA(IP14_16_14, VI1_G0_B),
	PINMUX_IPSR_MSEL(IP14_19_17, MSIOF0_SYNC, SEL_SOF0_0),
	PINMUX_IPSR_MSEL(IP14_19_17, TX2_C, SEL_SCIF2_2),
	PINMUX_IPSR_MSEL(IP14_19_17, ADICS_SAMP, SEL_RAD_0),
	PINMUX_IPSR_MSEL(IP14_19_17, VI1_CLKENB_C, SEL_VI1_2),
	PINMUX_IPSR_DATA(IP14_19_17, VI1_G1_B),
	PINMUX_IPSR_MSEL(IP14_22_20, MSIOF0_TXD, SEL_SOF0_0),
	PINMUX_IPSR_MSEL(IP14_22_20, ADICLK, SEL_RAD_0),
	PINMUX_IPSR_MSEL(IP14_22_20, VI1_FIELD_C, SEL_VI1_2),
	PINMUX_IPSR_DATA(IP14_22_20, VI1_G2_B),
	PINMUX_IPSR_MSEL(IP14_25_23, MSIOF0_RXD, SEL_SOF0_0),
	PINMUX_IPSR_MSEL(IP14_25_23, ADICHS0, SEL_RAD_0),
	PINMUX_IPSR_MSEL(IP14_25_23, VI1_DATA0_C, SEL_VI1_2),
	PINMUX_IPSR_DATA(IP14_25_23, VI1_G3_B),
	PINMUX_IPSR_MSEL(IP14_28_26, MSIOF0_SS1, SEL_SOF0_0),
	PINMUX_IPSR_MSEL(IP14_28_26, MMC_D6, SEL_MMC_0),
	PINMUX_IPSR_MSEL(IP14_28_26, ADICHS1, SEL_RAD_0),
	PINMUX_IPSR_MSEL(IP14_28_26, TX0_E, SEL_SCIF0_4),
	PINMUX_IPSR_MSEL(IP14_28_26, VI1_HSYNC_N_C, SEL_VI1_2),
	PINMUX_IPSR_MSEL(IP14_28_26, SCL7_C, SEL_IIC7_2),
	PINMUX_IPSR_DATA(IP14_28_26, VI1_G4_B),
	PINMUX_IPSR_MSEL(IP14_31_29, MSIOF0_SS2, SEL_SOF0_0),
	PINMUX_IPSR_MSEL(IP14_31_29, MMC_D7, SEL_MMC_0),
	PINMUX_IPSR_MSEL(IP14_31_29, ADICHS2, SEL_RAD_0),
	PINMUX_IPSR_MSEL(IP14_31_29, RX0_E, SEL_SCIF0_4),
	PINMUX_IPSR_MSEL(IP14_31_29, VI1_VSYNC_N_C, SEL_VI1_2),
	PINMUX_IPSR_MSEL(IP14_31_29, SDA7_C, SEL_IIC7_2),
	PINMUX_IPSR_DATA(IP14_31_29, VI1_G5_B),

	/* IPSR15 */
	PINMUX_IPSR_MSEL(IP15_1_0, SIM0_RST, SEL_SIM_0),
	PINMUX_IPSR_MSEL(IP15_1_0, IETX, SEL_IEB_0),
	PINMUX_IPSR_MSEL(IP15_1_0, CAN1_TX_D, SEL_CAN1_3),
	PINMUX_IPSR_DATA(IP15_3_2, SIM0_CLK),
	PINMUX_IPSR_MSEL(IP15_3_2, IECLK, SEL_IEB_0),
	PINMUX_IPSR_MSEL(IP15_3_2, CAN_CLK_C, SEL_CANCLK_2),
	PINMUX_IPSR_MSEL(IP15_5_4, SIM0_D, SEL_SIM_0),
	PINMUX_IPSR_MSEL(IP15_5_4, IERX, SEL_IEB_0),
	PINMUX_IPSR_MSEL(IP15_5_4, CAN1_RX_D, SEL_CAN1_3),
	PINMUX_IPSR_MSEL(IP15_8_6, GPS_CLK, SEL_GPS_0),
	PINMUX_IPSR_MSEL(IP15_8_6, DU1_DOTCLKIN_C, SEL_DIS_2),
	PINMUX_IPSR_MSEL(IP15_8_6, AUDIO_CLKB_B, SEL_ADG_1),
	PINMUX_IPSR_DATA(IP15_8_6, PWM5_B),
	PINMUX_IPSR_MSEL(IP15_8_6, SCIFA3_TXD_C, SEL_SCIFA3_2),
	PINMUX_IPSR_MSEL(IP15_11_9, GPS_SIGN, SEL_GPS_0),
	PINMUX_IPSR_MSEL(IP15_11_9, TX4_C, SEL_SCIF4_2),
	PINMUX_IPSR_MSEL(IP15_11_9, SCIFA4_TXD_C, SEL_SCIFA4_2),
	PINMUX_IPSR_DATA(IP15_11_9, PWM5),
	PINMUX_IPSR_DATA(IP15_11_9, VI1_G6_B),
	PINMUX_IPSR_MSEL(IP15_11_9, SCIFA3_RXD_C, SEL_SCIFA3_2),
	PINMUX_IPSR_MSEL(IP15_14_12, GPS_MAG, SEL_GPS_0),
	PINMUX_IPSR_MSEL(IP15_14_12, RX4_C, SEL_SCIF4_2),
	PINMUX_IPSR_MSEL(IP15_14_12, SCIFA4_RXD_C, SEL_SCIFA4_2),
	PINMUX_IPSR_DATA(IP15_14_12, PWM6),
	PINMUX_IPSR_DATA(IP15_14_12, VI1_G7_B),
	PINMUX_IPSR_MSEL(IP15_14_12, SCIFA3_SCK_C, SEL_SCIFA3_2),
	PINMUX_IPSR_MSEL(IP15_17_15, HCTS0_N, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP15_17_15, SCIFB0_CTS_N, SEL_SCIFB_0),
	PINMUX_IPSR_MSEL(IP15_17_15, GLO_I0_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP15_17_15, TCLK1, SEL_TMU1_0),
	PINMUX_IPSR_MSEL(IP15_17_15, VI1_DATA1_C, SEL_VI1_2),
	PINMUX_IPSR_MSEL(IP15_20_18, HRTS0_N, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP15_20_18, SCIFB0_RTS_N, SEL_SCIFB_0),
	PINMUX_IPSR_MSEL(IP15_20_18, GLO_I1_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP15_20_18, VI1_DATA2_C, SEL_VI1_2),
	PINMUX_IPSR_MSEL(IP15_23_21, HSCK0, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP15_23_21, SCIFB0_SCK, SEL_SCIFB_0),
	PINMUX_IPSR_MSEL(IP15_23_21, GLO_Q0_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP15_23_21, CAN_CLK, SEL_CANCLK_0),
	PINMUX_IPSR_DATA(IP15_23_21, TCLK2),
	PINMUX_IPSR_MSEL(IP15_23_21, VI1_DATA3_C, SEL_VI1_2),
	PINMUX_IPSR_MSEL(IP15_26_24, HRX0, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP15_26_24, SCIFB0_RXD, SEL_SCIFB_0),
	PINMUX_IPSR_MSEL(IP15_26_24, GLO_Q1_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP15_26_24, CAN0_RX_B, SEL_CAN0_1),
	PINMUX_IPSR_MSEL(IP15_26_24, VI1_DATA4_C, SEL_VI1_2),
	PINMUX_IPSR_MSEL(IP15_29_27, HTX0, SEL_HSCIF0_0),
	PINMUX_IPSR_MSEL(IP15_29_27, SCIFB0_TXD, SEL_SCIFB_0),
	PINMUX_IPSR_MSEL(IP15_29_27, GLO_SCLK_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP15_29_27, CAN0_TX_B, SEL_CAN0_1),
	PINMUX_IPSR_MSEL(IP15_29_27, VI1_DATA5_C, SEL_VI1_2),

	/* IPSR16 */
	PINMUX_IPSR_MSEL(IP16_2_0, HRX1, SEL_HSCIF1_0),
	PINMUX_IPSR_MSEL(IP16_2_0, SCIFB1_RXD, SEL_SCIFB1_0),
	PINMUX_IPSR_DATA(IP16_2_0, VI1_R0_B),
	PINMUX_IPSR_MSEL(IP16_2_0, GLO_SDATA_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP16_2_0, VI1_DATA6_C, SEL_VI1_2),
	PINMUX_IPSR_MSEL(IP16_5_3, HTX1, SEL_HSCIF1_0),
	PINMUX_IPSR_MSEL(IP16_5_3, SCIFB1_TXD, SEL_SCIFB1_0),
	PINMUX_IPSR_DATA(IP16_5_3, VI1_R1_B),
	PINMUX_IPSR_MSEL(IP16_5_3, GLO_SS_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP16_5_3, VI1_DATA7_C, SEL_VI1_2),
	PINMUX_IPSR_MSEL(IP16_7_6, HSCK1, SEL_HSCIF1_0),
	PINMUX_IPSR_MSEL(IP16_7_6, SCIFB1_SCK, SEL_SCIFB1_0),
	PINMUX_IPSR_DATA(IP16_7_6, MLB_CLK),
	PINMUX_IPSR_MSEL(IP16_7_6, GLO_RFON_C, SEL_GPS_2),
	PINMUX_IPSR_MSEL(IP16_9_8, HCTS1_N, SEL_HSCIF1_0),
	PINMUX_IPSR_DATA(IP16_9_8, SCIFB1_CTS_N),
	PINMUX_IPSR_DATA(IP16_9_8, MLB_SIG),
	PINMUX_IPSR_MSEL(IP16_9_8, CAN1_TX_B, SEL_CAN1_1),
	PINMUX_IPSR_MSEL(IP16_11_10, HRTS1_N, SEL_HSCIF1_0),
	PINMUX_IPSR_DATA(IP16_11_10, SCIFB1_RTS_N),
	PINMUX_IPSR_DATA(IP16_11_10, MLB_DAT),
	PINMUX_IPSR_MSEL(IP16_11_10, CAN1_RX_B, SEL_CAN1_1),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	PINMUX_GPIO_GP_ALL(),
};

/* - Audio Clock ------------------------------------------------------------ */
static const unsigned int audio_clk_a_pins[] = {
	/* CLK */
	RCAR_GP_PIN(2, 28),
};

static const unsigned int audio_clk_a_mux[] = {
	AUDIO_CLKA_MARK,
};

static const unsigned int audio_clk_b_pins[] = {
	/* CLK */
	RCAR_GP_PIN(2, 29),
};

static const unsigned int audio_clk_b_mux[] = {
	AUDIO_CLKB_MARK,
};

static const unsigned int audio_clk_b_b_pins[] = {
	/* CLK */
	RCAR_GP_PIN(7, 20),
};

static const unsigned int audio_clk_b_b_mux[] = {
	AUDIO_CLKB_B_MARK,
};

static const unsigned int audio_clk_c_pins[] = {
	/* CLK */
	RCAR_GP_PIN(2, 30),
};

static const unsigned int audio_clk_c_mux[] = {
	AUDIO_CLKC_MARK,
};

static const unsigned int audio_clkout_pins[] = {
	/* CLK */
	RCAR_GP_PIN(2, 31),
};

static const unsigned int audio_clkout_mux[] = {
	AUDIO_CLKOUT_MARK,
};

/* - CAN -------------------------------------------------------------------- */

static const unsigned int can0_data_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(3, 26), RCAR_GP_PIN(3, 29),
};

static const unsigned int can0_data_mux[] = {
	CAN0_TX_MARK, CAN0_RX_MARK,
};

static const unsigned int can0_data_b_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(7, 4), RCAR_GP_PIN(7, 3),
};

static const unsigned int can0_data_b_mux[] = {
	CAN0_TX_B_MARK, CAN0_RX_B_MARK,
};

static const unsigned int can0_data_c_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(5, 17), RCAR_GP_PIN(5, 18),
};

static const unsigned int can0_data_c_mux[] = {
	CAN0_TX_C_MARK,	CAN0_RX_C_MARK,
};

static const unsigned int can0_data_d_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(2, 26), RCAR_GP_PIN(2, 27),
};

static const unsigned int can0_data_d_mux[] = {
	CAN0_TX_D_MARK, CAN0_RX_D_MARK,
};

static const unsigned int can0_data_e_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(4, 18), RCAR_GP_PIN(4, 28),
};

static const unsigned int can0_data_e_mux[] = {
	CAN0_TX_E_MARK, CAN0_RX_E_MARK,
};

static const unsigned int can0_data_f_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(6, 7), RCAR_GP_PIN(6, 6),
};

static const unsigned int can0_data_f_mux[] = {
	CAN0_TX_F_MARK, CAN0_RX_F_MARK,
};

static const unsigned int can1_data_pins[] = {
	/* TX, RX */
	 RCAR_GP_PIN(3, 21), RCAR_GP_PIN(3, 20),
};

static const unsigned int can1_data_mux[] = {
	CAN1_TX_MARK, CAN1_RX_MARK,
};

static const unsigned int can1_data_b_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(7, 8), RCAR_GP_PIN(7, 9),
};

static const unsigned int can1_data_b_mux[] = {
	CAN1_TX_B_MARK, CAN1_RX_B_MARK,
};

static const unsigned int can1_data_c_pins[] = {
	/* TX, RX */
	RCAR_GP_PIN(5, 20), RCAR_GP_PIN(5, 19),
};

static const unsigned int can1_data_c_mux[] = {
	CAN1_TX_C_MARK, CAN1_RX_C_MARK,
};

static const unsigned int can1_data_d_pins[] = {
	/* TX, RX */
	 RCAR_GP_PIN(4, 29), RCAR_GP_PIN(4, 31),
};

static const unsigned int can1_data_d_mux[] = {
	CAN1_TX_D_MARK, CAN1_RX_D_MARK,
};

static const unsigned int can_clk_pins[] = {
	/* CLK */
	RCAR_GP_PIN(7, 2),
};

static const unsigned int can_clk_mux[] = {
	CAN_CLK_MARK,
};

static const unsigned int can_clk_b_pins[] = {
	/* CLK */
	RCAR_GP_PIN(5, 21),
};

static const unsigned int can_clk_b_mux[] = {
	CAN_CLK_B_MARK,
};

static const unsigned int can_clk_c_pins[] = {
	/* CLK */
	RCAR_GP_PIN(4, 30),
};

static const unsigned int can_clk_c_mux[] = {
	CAN_CLK_C_MARK,
};

static const unsigned int can_clk_d_pins[] = {
	/* CLK */
	RCAR_GP_PIN(7, 19),
};

static const unsigned int can_clk_d_mux[] = {
	CAN_CLK_D_MARK,
};

/* - DU --------------------------------------------------------------------- */
static const unsigned int du_rgb666_pins[] = {
	/* R[7:2], G[7:2], B[7:2] */
	RCAR_GP_PIN(3, 7),  RCAR_GP_PIN(3, 6),  RCAR_GP_PIN(3, 5),
	RCAR_GP_PIN(3, 4),  RCAR_GP_PIN(3, 3),  RCAR_GP_PIN(3, 2),
	RCAR_GP_PIN(3, 15), RCAR_GP_PIN(3, 14), RCAR_GP_PIN(3, 13),
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 11), RCAR_GP_PIN(3, 10),
	RCAR_GP_PIN(3, 23), RCAR_GP_PIN(3, 22), RCAR_GP_PIN(3, 21),
	RCAR_GP_PIN(3, 20), RCAR_GP_PIN(3, 19), RCAR_GP_PIN(3, 18),
};
static const unsigned int du_rgb666_mux[] = {
	DU1_DR7_MARK, DU1_DR6_MARK, DU1_DR5_MARK, DU1_DR4_MARK,
	DU1_DR3_MARK, DU1_DR2_MARK,
	DU1_DG7_MARK, DU1_DG6_MARK, DU1_DG5_MARK, DU1_DG4_MARK,
	DU1_DG3_MARK, DU1_DG2_MARK,
	DU1_DB7_MARK, DU1_DB6_MARK, DU1_DB5_MARK, DU1_DB4_MARK,
	DU1_DB3_MARK, DU1_DB2_MARK,
};
static const unsigned int du_rgb888_pins[] = {
	/* R[7:0], G[7:0], B[7:0] */
	RCAR_GP_PIN(3, 7),  RCAR_GP_PIN(3, 6),  RCAR_GP_PIN(3, 5),
	RCAR_GP_PIN(3, 4),  RCAR_GP_PIN(3, 3),  RCAR_GP_PIN(3, 2),
	RCAR_GP_PIN(3, 1),  RCAR_GP_PIN(3, 0),
	RCAR_GP_PIN(3, 15), RCAR_GP_PIN(3, 14), RCAR_GP_PIN(3, 13),
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 11), RCAR_GP_PIN(3, 10),
	RCAR_GP_PIN(3, 9),  RCAR_GP_PIN(3, 8),
	RCAR_GP_PIN(3, 23), RCAR_GP_PIN(3, 22), RCAR_GP_PIN(3, 21),
	RCAR_GP_PIN(3, 20), RCAR_GP_PIN(3, 19), RCAR_GP_PIN(3, 18),
	RCAR_GP_PIN(3, 17), RCAR_GP_PIN(3, 16),
};
static const unsigned int du_rgb888_mux[] = {
	DU1_DR7_MARK, DU1_DR6_MARK, DU1_DR5_MARK, DU1_DR4_MARK,
	DU1_DR3_MARK, DU1_DR2_MARK, DU1_DR1_MARK, DU1_DR0_MARK,
	DU1_DG7_MARK, DU1_DG6_MARK, DU1_DG5_MARK, DU1_DG4_MARK,
	DU1_DG3_MARK, DU1_DG2_MARK, DU1_DG1_MARK, DU1_DG0_MARK,
	DU1_DB7_MARK, DU1_DB6_MARK, DU1_DB5_MARK, DU1_DB4_MARK,
	DU1_DB3_MARK, DU1_DB2_MARK, DU1_DB1_MARK, DU1_DB0_MARK,
};
static const unsigned int du_clk_out_0_pins[] = {
	/* CLKOUT */
	RCAR_GP_PIN(3, 25),
};
static const unsigned int du_clk_out_0_mux[] = {
	DU1_DOTCLKOUT0_MARK
};
static const unsigned int du_clk_out_1_pins[] = {
	/* CLKOUT */
	RCAR_GP_PIN(3, 26),
};
static const unsigned int du_clk_out_1_mux[] = {
	DU1_DOTCLKOUT1_MARK
};
static const unsigned int du_sync_pins[] = {
	/* EXVSYNC/VSYNC, EXHSYNC/HSYNC */
	RCAR_GP_PIN(3, 28), RCAR_GP_PIN(3, 27),
};
static const unsigned int du_sync_mux[] = {
	DU1_EXVSYNC_DU1_VSYNC_MARK, DU1_EXHSYNC_DU1_HSYNC_MARK
};
static const unsigned int du_oddf_pins[] = {
	/* EXDISP/EXODDF/EXCDE */
	RCAR_GP_PIN(3, 29),
};
static const unsigned int du_oddf_mux[] = {
	DU1_EXODDF_DU1_ODDF_DISP_CDE_MARK,
};
static const unsigned int du_cde_pins[] = {
	/* CDE */
	RCAR_GP_PIN(3, 31),
};
static const unsigned int du_cde_mux[] = {
	DU1_CDE_MARK,
};
static const unsigned int du_disp_pins[] = {
	/* DISP */
	RCAR_GP_PIN(3, 30),
};
static const unsigned int du_disp_mux[] = {
	DU1_DISP_MARK,
};
static const unsigned int du0_clk_in_pins[] = {
	/* CLKIN */
	RCAR_GP_PIN(6, 31),
};
static const unsigned int du0_clk_in_mux[] = {
	DU0_DOTCLKIN_MARK
};
static const unsigned int du1_clk_in_pins[] = {
	/* CLKIN */
	RCAR_GP_PIN(3, 24),
};
static const unsigned int du1_clk_in_mux[] = {
	DU1_DOTCLKIN_MARK
};
static const unsigned int du1_clk_in_b_pins[] = {
	/* CLKIN */
	RCAR_GP_PIN(7, 19),
};
static const unsigned int du1_clk_in_b_mux[] = {
	DU1_DOTCLKIN_B_MARK,
};
static const unsigned int du1_clk_in_c_pins[] = {
	/* CLKIN */
	RCAR_GP_PIN(7, 20),
};
static const unsigned int du1_clk_in_c_mux[] = {
	DU1_DOTCLKIN_C_MARK,
};
/* - ETH -------------------------------------------------------------------- */
static const unsigned int eth_link_pins[] = {
	/* LINK */
	RCAR_GP_PIN(5, 18),
};
static const unsigned int eth_link_mux[] = {
	ETH_LINK_MARK,
};
static const unsigned int eth_magic_pins[] = {
	/* MAGIC */
	RCAR_GP_PIN(5, 22),
};
static const unsigned int eth_magic_mux[] = {
	ETH_MAGIC_MARK,
};
static const unsigned int eth_mdio_pins[] = {
	/* MDC, MDIO */
	RCAR_GP_PIN(5, 24), RCAR_GP_PIN(5, 13),
};
static const unsigned int eth_mdio_mux[] = {
	ETH_MDC_MARK, ETH_MDIO_MARK,
};
static const unsigned int eth_rmii_pins[] = {
	/* RXD[0:1], RX_ER, CRS_DV, TXD[0:1], TX_EN, REF_CLK */
	RCAR_GP_PIN(5, 16), RCAR_GP_PIN(5, 17), RCAR_GP_PIN(5, 15),
	RCAR_GP_PIN(5, 14), RCAR_GP_PIN(5, 23), RCAR_GP_PIN(5, 20),
	RCAR_GP_PIN(5, 21), RCAR_GP_PIN(5, 19),
};
static const unsigned int eth_rmii_mux[] = {
	ETH_RXD0_MARK, ETH_RXD1_MARK, ETH_RX_ER_MARK, ETH_CRS_DV_MARK,
	ETH_TXD0_MARK, ETH_TXD1_MARK, ETH_TX_EN_MARK, ETH_REFCLK_MARK,
};

/* - HSCIF0 ----------------------------------------------------------------- */
static const unsigned int hscif0_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(7, 3), RCAR_GP_PIN(7, 4),
};
static const unsigned int hscif0_data_mux[] = {
	HRX0_MARK, HTX0_MARK,
};
static const unsigned int hscif0_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(7, 2),
};
static const unsigned int hscif0_clk_mux[] = {
	HSCK0_MARK,
};
static const unsigned int hscif0_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(7, 1), RCAR_GP_PIN(7, 0),
};
static const unsigned int hscif0_ctrl_mux[] = {
	HRTS0_N_MARK, HCTS0_N_MARK,
};
static const unsigned int hscif0_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 15),
};
static const unsigned int hscif0_data_b_mux[] = {
	HRX0_B_MARK, HTX0_B_MARK,
};
static const unsigned int hscif0_ctrl_b_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(3, 14), RCAR_GP_PIN(3, 13),
};
static const unsigned int hscif0_ctrl_b_mux[] = {
	HRTS0_N_B_MARK, HCTS0_N_B_MARK,
};
static const unsigned int hscif0_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(2, 0), RCAR_GP_PIN(2, 1),
};
static const unsigned int hscif0_data_c_mux[] = {
	HRX0_C_MARK, HTX0_C_MARK,
};
static const unsigned int hscif0_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(5, 31),
};
static const unsigned int hscif0_clk_c_mux[] = {
	HSCK0_C_MARK,
};
/* - HSCIF1 ----------------------------------------------------------------- */
static const unsigned int hscif1_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(7, 5), RCAR_GP_PIN(7, 6),
};
static const unsigned int hscif1_data_mux[] = {
	HRX1_MARK, HTX1_MARK,
};
static const unsigned int hscif1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(7, 7),
};
static const unsigned int hscif1_clk_mux[] = {
	HSCK1_MARK,
};
static const unsigned int hscif1_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(7, 9), RCAR_GP_PIN(7, 8),
};
static const unsigned int hscif1_ctrl_mux[] = {
	HRTS1_N_MARK, HCTS1_N_MARK,
};
static const unsigned int hscif1_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(1, 17), RCAR_GP_PIN(1, 18),
};
static const unsigned int hscif1_data_b_mux[] = {
	HRX1_B_MARK, HTX1_B_MARK,
};
static const unsigned int hscif1_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(7, 14), RCAR_GP_PIN(7, 15),
};
static const unsigned int hscif1_data_c_mux[] = {
	HRX1_C_MARK, HTX1_C_MARK,
};
static const unsigned int hscif1_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(7, 16),
};
static const unsigned int hscif1_clk_c_mux[] = {
	HSCK1_C_MARK,
};
static const unsigned int hscif1_ctrl_c_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(7, 18), RCAR_GP_PIN(7, 17),
};
static const unsigned int hscif1_ctrl_c_mux[] = {
	HRTS1_N_C_MARK, HCTS1_N_C_MARK,
};
static const unsigned int hscif1_data_d_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 28), RCAR_GP_PIN(4, 18),
};
static const unsigned int hscif1_data_d_mux[] = {
	HRX1_D_MARK, HTX1_D_MARK,
};
static const unsigned int hscif1_data_e_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(7, 14), RCAR_GP_PIN(7, 15),
};
static const unsigned int hscif1_data_e_mux[] = {
	HRX1_C_MARK, HTX1_C_MARK,
};
static const unsigned int hscif1_clk_e_pins[] = {
	/* SCK */
	RCAR_GP_PIN(2, 6),
};
static const unsigned int hscif1_clk_e_mux[] = {
	HSCK1_E_MARK,
};
static const unsigned int hscif1_ctrl_e_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(2, 8), RCAR_GP_PIN(2, 7),
};
static const unsigned int hscif1_ctrl_e_mux[] = {
	HRTS1_N_E_MARK, HCTS1_N_E_MARK,
};
/* - HSCIF2 ----------------------------------------------------------------- */
static const unsigned int hscif2_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 16), RCAR_GP_PIN(4, 17),
};
static const unsigned int hscif2_data_mux[] = {
	HRX2_MARK, HTX2_MARK,
};
static const unsigned int hscif2_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 15),
};
static const unsigned int hscif2_clk_mux[] = {
	HSCK2_MARK,
};
static const unsigned int hscif2_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(4, 14), RCAR_GP_PIN(4, 13),
};
static const unsigned int hscif2_ctrl_mux[] = {
	HRTS2_N_MARK, HCTS2_N_MARK,
};
static const unsigned int hscif2_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(1, 20), RCAR_GP_PIN(1, 22),
};
static const unsigned int hscif2_data_b_mux[] = {
	HRX2_B_MARK, HTX2_B_MARK,
};
static const unsigned int hscif2_ctrl_b_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(1, 23), RCAR_GP_PIN(1, 21),
};
static const unsigned int hscif2_ctrl_b_mux[] = {
	HRTS2_N_B_MARK, HCTS2_N_B_MARK,
};
static const unsigned int hscif2_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(2, 0), RCAR_GP_PIN(2, 1),
};
static const unsigned int hscif2_data_c_mux[] = {
	HRX2_C_MARK, HTX2_C_MARK,
};
static const unsigned int hscif2_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(5, 31),
};
static const unsigned int hscif2_clk_c_mux[] = {
	HSCK2_C_MARK,
};
static const unsigned int hscif2_data_d_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(1, 20), RCAR_GP_PIN(5, 31),
};
static const unsigned int hscif2_data_d_mux[] = {
	HRX2_B_MARK, HTX2_D_MARK,
};
/* - I2C0 ------------------------------------------------------------------- */
static const unsigned int i2c0_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(0, 24), RCAR_GP_PIN(0, 25),
};
static const unsigned int i2c0_mux[] = {
	SCL0_MARK, SDA0_MARK,
};
static const unsigned int i2c0_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(2, 2), RCAR_GP_PIN(2, 3),
};
static const unsigned int i2c0_b_mux[] = {
	SCL0_B_MARK, SDA0_B_MARK,
};
static const unsigned int i2c0_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(0, 16), RCAR_GP_PIN(1, 1),
};
static const unsigned int i2c0_c_mux[] = {
	SCL0_C_MARK, SDA0_C_MARK,
};
/* - I2C1 ------------------------------------------------------------------- */
static const unsigned int i2c1_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(1, 10), RCAR_GP_PIN(1, 11),
};
static const unsigned int i2c1_mux[] = {
	SCL1_MARK, SDA1_MARK,
};
static const unsigned int i2c1_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(2, 4), RCAR_GP_PIN(2, 5),
};
static const unsigned int i2c1_b_mux[] = {
	SCL1_B_MARK, SDA1_B_MARK,
};
static const unsigned int i2c1_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(6, 14), RCAR_GP_PIN(6, 15),
};
static const unsigned int i2c1_c_mux[] = {
	SCL1_C_MARK, SDA1_C_MARK,
};
static const unsigned int i2c1_d_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 25), RCAR_GP_PIN(4, 26),
};
static const unsigned int i2c1_d_mux[] = {
	SCL1_D_MARK, SDA1_D_MARK,
};
static const unsigned int i2c1_e_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(7, 15), RCAR_GP_PIN(7, 16),
};
static const unsigned int i2c1_e_mux[] = {
	SCL1_E_MARK, SDA1_E_MARK,
};
/* - I2C2 ------------------------------------------------------------------- */
static const unsigned int i2c2_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(2, 6), RCAR_GP_PIN(2, 7),
};
static const unsigned int i2c2_mux[] = {
	SCL2_MARK, SDA2_MARK,
};
static const unsigned int i2c2_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(3, 26), RCAR_GP_PIN(3, 29),
};
static const unsigned int i2c2_b_mux[] = {
	SCL2_B_MARK, SDA2_B_MARK,
};
static const unsigned int i2c2_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(5, 13), RCAR_GP_PIN(5, 14),
};
static const unsigned int i2c2_c_mux[] = {
	SCL2_C_MARK, SDA2_C_MARK,
};
static const unsigned int i2c2_d_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(5, 17), RCAR_GP_PIN(5, 18),
};
static const unsigned int i2c2_d_mux[] = {
	SCL2_D_MARK, SDA2_D_MARK,
};
/* - I2C3 ------------------------------------------------------------------- */
static const unsigned int i2c3_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(5, 15), RCAR_GP_PIN(5, 16),
};
static const unsigned int i2c3_mux[] = {
	SCL3_MARK, SDA3_MARK,
};
static const unsigned int i2c3_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 15), RCAR_GP_PIN(4, 16),
};
static const unsigned int i2c3_b_mux[] = {
	SCL3_B_MARK, SDA3_B_MARK,
};
static const unsigned int i2c3_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(3, 22), RCAR_GP_PIN(3, 23),
};
static const unsigned int i2c3_c_mux[] = {
	SCL3_C_MARK, SDA3_C_MARK,
};
static const unsigned int i2c3_d_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(0, 27), RCAR_GP_PIN(0, 28),
};
static const unsigned int i2c3_d_mux[] = {
	SCL3_D_MARK, SDA3_D_MARK,
};
/* - I2C4 ------------------------------------------------------------------- */
static const unsigned int i2c4_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 13), RCAR_GP_PIN(4, 14),
};
static const unsigned int i2c4_mux[] = {
	SCL4_MARK, SDA4_MARK,
};
static const unsigned int i2c4_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 27), RCAR_GP_PIN(4, 28),
};
static const unsigned int i2c4_b_mux[] = {
	SCL4_B_MARK, SDA4_B_MARK,
};
static const unsigned int i2c4_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(7, 13), RCAR_GP_PIN(7, 14),
};
static const unsigned int i2c4_c_mux[] = {
	SCL4_C_MARK, SDA4_C_MARK,
};
/* - I2C7 ------------------------------------------------------------------- */
static const unsigned int i2c7_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(5, 15), RCAR_GP_PIN(5, 16),
};
static const unsigned int i2c7_mux[] = {
	SCL7_MARK, SDA7_MARK,
};
static const unsigned int i2c7_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(2, 2), RCAR_GP_PIN(2, 3),
};
static const unsigned int i2c7_b_mux[] = {
	SCL7_B_MARK, SDA7_B_MARK,
};
static const unsigned int i2c7_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(6, 28), RCAR_GP_PIN(6, 29),
};
static const unsigned int i2c7_c_mux[] = {
	SCL7_C_MARK, SDA7_C_MARK,
};
/* - I2C8 ------------------------------------------------------------------- */
static const unsigned int i2c8_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(4, 13), RCAR_GP_PIN(4, 14),
};
static const unsigned int i2c8_mux[] = {
	SCL8_MARK, SDA8_MARK,
};
static const unsigned int i2c8_b_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(2, 4), RCAR_GP_PIN(2, 5),
};
static const unsigned int i2c8_b_mux[] = {
	SCL8_B_MARK, SDA8_B_MARK,
};
static const unsigned int i2c8_c_pins[] = {
	/* SCL, SDA */
	RCAR_GP_PIN(6, 22), RCAR_GP_PIN(6, 23),
};
static const unsigned int i2c8_c_mux[] = {
	SCL8_C_MARK, SDA8_C_MARK,
};
/* - INTC ------------------------------------------------------------------- */
static const unsigned int intc_irq0_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(7, 10),
};
static const unsigned int intc_irq0_mux[] = {
	IRQ0_MARK,
};
static const unsigned int intc_irq1_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(7, 11),
};
static const unsigned int intc_irq1_mux[] = {
	IRQ1_MARK,
};
static const unsigned int intc_irq2_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(7, 12),
};
static const unsigned int intc_irq2_mux[] = {
	IRQ2_MARK,
};
static const unsigned int intc_irq3_pins[] = {
	/* IRQ */
	RCAR_GP_PIN(7, 13),
};
static const unsigned int intc_irq3_mux[] = {
	IRQ3_MARK,
};
/* - MLB+ ------------------------------------------------------------------- */
static const unsigned int mlb_3pin_pins[] = {
	RCAR_GP_PIN(7, 7), RCAR_GP_PIN(7, 8), RCAR_GP_PIN(7, 9),
};
static const unsigned int mlb_3pin_mux[] = {
	MLB_CLK_MARK, MLB_SIG_MARK, MLB_DAT_MARK,
};
/* - MMCIF ------------------------------------------------------------------ */
static const unsigned int mmc_data1_pins[] = {
	/* D[0] */
	RCAR_GP_PIN(6, 18),
};
static const unsigned int mmc_data1_mux[] = {
	MMC_D0_MARK,
};
static const unsigned int mmc_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(6, 18), RCAR_GP_PIN(6, 19),
	RCAR_GP_PIN(6, 20), RCAR_GP_PIN(6, 21),
};
static const unsigned int mmc_data4_mux[] = {
	MMC_D0_MARK, MMC_D1_MARK, MMC_D2_MARK, MMC_D3_MARK,
};
static const unsigned int mmc_data8_pins[] = {
	/* D[0:7] */
	RCAR_GP_PIN(6, 18), RCAR_GP_PIN(6, 19),
	RCAR_GP_PIN(6, 20), RCAR_GP_PIN(6, 21),
	RCAR_GP_PIN(6, 22), RCAR_GP_PIN(6, 23),
	RCAR_GP_PIN(6, 28), RCAR_GP_PIN(6, 29),
};
static const unsigned int mmc_data8_mux[] = {
	MMC_D0_MARK, MMC_D1_MARK, MMC_D2_MARK, MMC_D3_MARK,
	MMC_D4_MARK, MMC_D5_MARK, MMC_D6_MARK, MMC_D7_MARK,
};
static const unsigned int mmc_ctrl_pins[] = {
	/* CLK, CMD */
	RCAR_GP_PIN(6, 16), RCAR_GP_PIN(6, 17),
};
static const unsigned int mmc_ctrl_mux[] = {
	MMC_CLK_MARK, MMC_CMD_MARK,
};
/* - MSIOF0 ----------------------------------------------------------------- */
static const unsigned int msiof0_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(6, 24),
};
static const unsigned int msiof0_clk_mux[] = {
	MSIOF0_SCK_MARK,
};
static const unsigned int msiof0_sync_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(6, 25),
};
static const unsigned int msiof0_sync_mux[] = {
	MSIOF0_SYNC_MARK,
};
static const unsigned int msiof0_ss1_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(6, 28),
};
static const unsigned int msiof0_ss1_mux[] = {
	MSIOF0_SS1_MARK,
};
static const unsigned int msiof0_ss2_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(6, 29),
};
static const unsigned int msiof0_ss2_mux[] = {
	MSIOF0_SS2_MARK,
};
static const unsigned int msiof0_rx_pins[] = {
	/* RXD */
	RCAR_GP_PIN(6, 27),
};
static const unsigned int msiof0_rx_mux[] = {
	MSIOF0_RXD_MARK,
};
static const unsigned int msiof0_tx_pins[] = {
	/* TXD */
	RCAR_GP_PIN(6, 26),
};
static const unsigned int msiof0_tx_mux[] = {
	MSIOF0_TXD_MARK,
};

static const unsigned int msiof0_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 16),
};
static const unsigned int msiof0_clk_b_mux[] = {
	MSIOF0_SCK_B_MARK,
};
static const unsigned int msiof0_sync_b_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(0, 17),
};
static const unsigned int msiof0_sync_b_mux[] = {
	MSIOF0_SYNC_B_MARK,
};
static const unsigned int msiof0_ss1_b_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(0, 18),
};
static const unsigned int msiof0_ss1_b_mux[] = {
	MSIOF0_SS1_B_MARK,
};
static const unsigned int msiof0_ss2_b_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(0, 19),
};
static const unsigned int msiof0_ss2_b_mux[] = {
	MSIOF0_SS2_B_MARK,
};
static const unsigned int msiof0_rx_b_pins[] = {
	/* RXD */
	RCAR_GP_PIN(0, 21),
};
static const unsigned int msiof0_rx_b_mux[] = {
	MSIOF0_RXD_B_MARK,
};
static const unsigned int msiof0_tx_b_pins[] = {
	/* TXD */
	RCAR_GP_PIN(0, 20),
};
static const unsigned int msiof0_tx_b_mux[] = {
	MSIOF0_TXD_B_MARK,
};

static const unsigned int msiof0_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(5, 26),
};
static const unsigned int msiof0_clk_c_mux[] = {
	MSIOF0_SCK_C_MARK,
};
static const unsigned int msiof0_sync_c_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(5, 25),
};
static const unsigned int msiof0_sync_c_mux[] = {
	MSIOF0_SYNC_C_MARK,
};
static const unsigned int msiof0_ss1_c_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(5, 27),
};
static const unsigned int msiof0_ss1_c_mux[] = {
	MSIOF0_SS1_C_MARK,
};
static const unsigned int msiof0_ss2_c_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(5, 28),
};
static const unsigned int msiof0_ss2_c_mux[] = {
	MSIOF0_SS2_C_MARK,
};
static const unsigned int msiof0_rx_c_pins[] = {
	/* RXD */
	RCAR_GP_PIN(5, 29),
};
static const unsigned int msiof0_rx_c_mux[] = {
	MSIOF0_RXD_C_MARK,
};
static const unsigned int msiof0_tx_c_pins[] = {
	/* TXD */
	RCAR_GP_PIN(5, 30),
};
static const unsigned int msiof0_tx_c_mux[] = {
	MSIOF0_TXD_C_MARK,
};
/* - MSIOF1 ----------------------------------------------------------------- */
static const unsigned int msiof1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 22),
};
static const unsigned int msiof1_clk_mux[] = {
	MSIOF1_SCK_MARK,
};
static const unsigned int msiof1_sync_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(0, 23),
};
static const unsigned int msiof1_sync_mux[] = {
	MSIOF1_SYNC_MARK,
};
static const unsigned int msiof1_ss1_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(0, 24),
};
static const unsigned int msiof1_ss1_mux[] = {
	MSIOF1_SS1_MARK,
};
static const unsigned int msiof1_ss2_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(0, 25),
};
static const unsigned int msiof1_ss2_mux[] = {
	MSIOF1_SS2_MARK,
};
static const unsigned int msiof1_rx_pins[] = {
	/* RXD */
	RCAR_GP_PIN(0, 27),
};
static const unsigned int msiof1_rx_mux[] = {
	MSIOF1_RXD_MARK,
};
static const unsigned int msiof1_tx_pins[] = {
	/* TXD */
	RCAR_GP_PIN(0, 26),
};
static const unsigned int msiof1_tx_mux[] = {
	MSIOF1_TXD_MARK,
};

static const unsigned int msiof1_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(2, 29),
};
static const unsigned int msiof1_clk_b_mux[] = {
	MSIOF1_SCK_B_MARK,
};
static const unsigned int msiof1_sync_b_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(2, 30),
};
static const unsigned int msiof1_sync_b_mux[] = {
	MSIOF1_SYNC_B_MARK,
};
static const unsigned int msiof1_ss1_b_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(2, 31),
};
static const unsigned int msiof1_ss1_b_mux[] = {
	MSIOF1_SS1_B_MARK,
};
static const unsigned int msiof1_ss2_b_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(7, 16),
};
static const unsigned int msiof1_ss2_b_mux[] = {
	MSIOF1_SS2_B_MARK,
};
static const unsigned int msiof1_rx_b_pins[] = {
	/* RXD */
	RCAR_GP_PIN(7, 18),
};
static const unsigned int msiof1_rx_b_mux[] = {
	MSIOF1_RXD_B_MARK,
};
static const unsigned int msiof1_tx_b_pins[] = {
	/* TXD */
	RCAR_GP_PIN(7, 17),
};
static const unsigned int msiof1_tx_b_mux[] = {
	MSIOF1_TXD_B_MARK,
};

static const unsigned int msiof1_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(2, 15),
};
static const unsigned int msiof1_clk_c_mux[] = {
	MSIOF1_SCK_C_MARK,
};
static const unsigned int msiof1_sync_c_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(2, 16),
};
static const unsigned int msiof1_sync_c_mux[] = {
	MSIOF1_SYNC_C_MARK,
};
static const unsigned int msiof1_rx_c_pins[] = {
	/* RXD */
	RCAR_GP_PIN(2, 18),
};
static const unsigned int msiof1_rx_c_mux[] = {
	MSIOF1_RXD_C_MARK,
};
static const unsigned int msiof1_tx_c_pins[] = {
	/* TXD */
	RCAR_GP_PIN(2, 17),
};
static const unsigned int msiof1_tx_c_mux[] = {
	MSIOF1_TXD_C_MARK,
};

static const unsigned int msiof1_clk_d_pins[] = {
	/* SCK */
	RCAR_GP_PIN(0, 28),
};
static const unsigned int msiof1_clk_d_mux[] = {
	MSIOF1_SCK_D_MARK,
};
static const unsigned int msiof1_sync_d_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(0, 30),
};
static const unsigned int msiof1_sync_d_mux[] = {
	MSIOF1_SYNC_D_MARK,
};
static const unsigned int msiof1_ss1_d_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(0, 29),
};
static const unsigned int msiof1_ss1_d_mux[] = {
	MSIOF1_SS1_D_MARK,
};
static const unsigned int msiof1_rx_d_pins[] = {
	/* RXD */
	RCAR_GP_PIN(0, 27),
};
static const unsigned int msiof1_rx_d_mux[] = {
	MSIOF1_RXD_D_MARK,
};
static const unsigned int msiof1_tx_d_pins[] = {
	/* TXD */
	RCAR_GP_PIN(0, 26),
};
static const unsigned int msiof1_tx_d_mux[] = {
	MSIOF1_TXD_D_MARK,
};

static const unsigned int msiof1_clk_e_pins[] = {
	/* SCK */
	RCAR_GP_PIN(5, 18),
};
static const unsigned int msiof1_clk_e_mux[] = {
	MSIOF1_SCK_E_MARK,
};
static const unsigned int msiof1_sync_e_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(5, 19),
};
static const unsigned int msiof1_sync_e_mux[] = {
	MSIOF1_SYNC_E_MARK,
};
static const unsigned int msiof1_rx_e_pins[] = {
	/* RXD */
	RCAR_GP_PIN(5, 17),
};
static const unsigned int msiof1_rx_e_mux[] = {
	MSIOF1_RXD_E_MARK,
};
static const unsigned int msiof1_tx_e_pins[] = {
	/* TXD */
	RCAR_GP_PIN(5, 20),
};
static const unsigned int msiof1_tx_e_mux[] = {
	MSIOF1_TXD_E_MARK,
};
/* - MSIOF2 ----------------------------------------------------------------- */
static const unsigned int msiof2_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 13),
};
static const unsigned int msiof2_clk_mux[] = {
	MSIOF2_SCK_MARK,
};
static const unsigned int msiof2_sync_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(1, 14),
};
static const unsigned int msiof2_sync_mux[] = {
	MSIOF2_SYNC_MARK,
};
static const unsigned int msiof2_ss1_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(1, 17),
};
static const unsigned int msiof2_ss1_mux[] = {
	MSIOF2_SS1_MARK,
};
static const unsigned int msiof2_ss2_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(1, 18),
};
static const unsigned int msiof2_ss2_mux[] = {
	MSIOF2_SS2_MARK,
};
static const unsigned int msiof2_rx_pins[] = {
	/* RXD */
	RCAR_GP_PIN(1, 16),
};
static const unsigned int msiof2_rx_mux[] = {
	MSIOF2_RXD_MARK,
};
static const unsigned int msiof2_tx_pins[] = {
	/* TXD */
	RCAR_GP_PIN(1, 15),
};
static const unsigned int msiof2_tx_mux[] = {
	MSIOF2_TXD_MARK,
};

static const unsigned int msiof2_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 0),
};
static const unsigned int msiof2_clk_b_mux[] = {
	MSIOF2_SCK_B_MARK,
};
static const unsigned int msiof2_sync_b_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(3, 1),
};
static const unsigned int msiof2_sync_b_mux[] = {
	MSIOF2_SYNC_B_MARK,
};
static const unsigned int msiof2_ss1_b_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(3, 8),
};
static const unsigned int msiof2_ss1_b_mux[] = {
	MSIOF2_SS1_B_MARK,
};
static const unsigned int msiof2_ss2_b_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(3, 9),
};
static const unsigned int msiof2_ss2_b_mux[] = {
	MSIOF2_SS2_B_MARK,
};
static const unsigned int msiof2_rx_b_pins[] = {
	/* RXD */
	RCAR_GP_PIN(3, 17),
};
static const unsigned int msiof2_rx_b_mux[] = {
	MSIOF2_RXD_B_MARK,
};
static const unsigned int msiof2_tx_b_pins[] = {
	/* TXD */
	RCAR_GP_PIN(3, 16),
};
static const unsigned int msiof2_tx_b_mux[] = {
	MSIOF2_TXD_B_MARK,
};

static const unsigned int msiof2_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(2, 2),
};
static const unsigned int msiof2_clk_c_mux[] = {
	MSIOF2_SCK_C_MARK,
};
static const unsigned int msiof2_sync_c_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(2, 3),
};
static const unsigned int msiof2_sync_c_mux[] = {
	MSIOF2_SYNC_C_MARK,
};
static const unsigned int msiof2_rx_c_pins[] = {
	/* RXD */
	RCAR_GP_PIN(2, 5),
};
static const unsigned int msiof2_rx_c_mux[] = {
	MSIOF2_RXD_C_MARK,
};
static const unsigned int msiof2_tx_c_pins[] = {
	/* TXD */
	RCAR_GP_PIN(2, 4),
};
static const unsigned int msiof2_tx_c_mux[] = {
	MSIOF2_TXD_C_MARK,
};

static const unsigned int msiof2_clk_d_pins[] = {
	/* SCK */
	RCAR_GP_PIN(2, 14),
};
static const unsigned int msiof2_clk_d_mux[] = {
	MSIOF2_SCK_D_MARK,
};
static const unsigned int msiof2_sync_d_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(2, 15),
};
static const unsigned int msiof2_sync_d_mux[] = {
	MSIOF2_SYNC_D_MARK,
};
static const unsigned int msiof2_ss1_d_pins[] = {
	/* SS1 */
	RCAR_GP_PIN(2, 17),
};
static const unsigned int msiof2_ss1_d_mux[] = {
	MSIOF2_SS1_D_MARK,
};
static const unsigned int msiof2_ss2_d_pins[] = {
	/* SS2 */
	RCAR_GP_PIN(2, 19),
};
static const unsigned int msiof2_ss2_d_mux[] = {
	MSIOF2_SS2_D_MARK,
};
static const unsigned int msiof2_rx_d_pins[] = {
	/* RXD */
	RCAR_GP_PIN(2, 18),
};
static const unsigned int msiof2_rx_d_mux[] = {
	MSIOF2_RXD_D_MARK,
};
static const unsigned int msiof2_tx_d_pins[] = {
	/* TXD */
	RCAR_GP_PIN(2, 16),
};
static const unsigned int msiof2_tx_d_mux[] = {
	MSIOF2_TXD_D_MARK,
};

static const unsigned int msiof2_clk_e_pins[] = {
	/* SCK */
	RCAR_GP_PIN(7, 15),
};
static const unsigned int msiof2_clk_e_mux[] = {
	MSIOF2_SCK_E_MARK,
};
static const unsigned int msiof2_sync_e_pins[] = {
	/* SYNC */
	RCAR_GP_PIN(7, 16),
};
static const unsigned int msiof2_sync_e_mux[] = {
	MSIOF2_SYNC_E_MARK,
};
static const unsigned int msiof2_rx_e_pins[] = {
	/* RXD */
	RCAR_GP_PIN(7, 14),
};
static const unsigned int msiof2_rx_e_mux[] = {
	MSIOF2_RXD_E_MARK,
};
static const unsigned int msiof2_tx_e_pins[] = {
	/* TXD */
	RCAR_GP_PIN(7, 13),
};
static const unsigned int msiof2_tx_e_mux[] = {
	MSIOF2_TXD_E_MARK,
};
/* - PWM -------------------------------------------------------------------- */
static const unsigned int pwm0_pins[] = {
	RCAR_GP_PIN(6, 14),
};
static const unsigned int pwm0_mux[] = {
	PWM0_MARK,
};
static const unsigned int pwm0_b_pins[] = {
	RCAR_GP_PIN(5, 30),
};
static const unsigned int pwm0_b_mux[] = {
	PWM0_B_MARK,
};
static const unsigned int pwm1_pins[] = {
	RCAR_GP_PIN(1, 17),
};
static const unsigned int pwm1_mux[] = {
	PWM1_MARK,
};
static const unsigned int pwm1_b_pins[] = {
	RCAR_GP_PIN(6, 15),
};
static const unsigned int pwm1_b_mux[] = {
	PWM1_B_MARK,
};
static const unsigned int pwm2_pins[] = {
	RCAR_GP_PIN(1, 18),
};
static const unsigned int pwm2_mux[] = {
	PWM2_MARK,
};
static const unsigned int pwm2_b_pins[] = {
	RCAR_GP_PIN(0, 16),
};
static const unsigned int pwm2_b_mux[] = {
	PWM2_B_MARK,
};
static const unsigned int pwm3_pins[] = {
	RCAR_GP_PIN(1, 24),
};
static const unsigned int pwm3_mux[] = {
	PWM3_MARK,
};
static const unsigned int pwm4_pins[] = {
	RCAR_GP_PIN(3, 26),
};
static const unsigned int pwm4_mux[] = {
	PWM4_MARK,
};
static const unsigned int pwm4_b_pins[] = {
	RCAR_GP_PIN(3, 31),
};
static const unsigned int pwm4_b_mux[] = {
	PWM4_B_MARK,
};
static const unsigned int pwm5_pins[] = {
	RCAR_GP_PIN(7, 21),
};
static const unsigned int pwm5_mux[] = {
	PWM5_MARK,
};
static const unsigned int pwm5_b_pins[] = {
	RCAR_GP_PIN(7, 20),
};
static const unsigned int pwm5_b_mux[] = {
	PWM5_B_MARK,
};
static const unsigned int pwm6_pins[] = {
	RCAR_GP_PIN(7, 22),
};
static const unsigned int pwm6_mux[] = {
	PWM6_MARK,
};
/* - QSPI ------------------------------------------------------------------- */
static const unsigned int qspi_ctrl_pins[] = {
	/* SPCLK, SSL */
	RCAR_GP_PIN(1, 4), RCAR_GP_PIN(1, 9),
};
static const unsigned int qspi_ctrl_mux[] = {
	SPCLK_MARK, SSL_MARK,
};
static const unsigned int qspi_data2_pins[] = {
	/* MOSI_IO0, MISO_IO1 */
	RCAR_GP_PIN(1, 5), RCAR_GP_PIN(1, 6),
};
static const unsigned int qspi_data2_mux[] = {
	MOSI_IO0_MARK, MISO_IO1_MARK,
};
static const unsigned int qspi_data4_pins[] = {
	/* MOSI_IO0, MISO_IO1, IO2, IO3 */
	RCAR_GP_PIN(1, 5), RCAR_GP_PIN(1, 6), RCAR_GP_PIN(1, 7),
	RCAR_GP_PIN(1, 8),
};
static const unsigned int qspi_data4_mux[] = {
	MOSI_IO0_MARK, MISO_IO1_MARK, IO2_MARK, IO3_MARK,
};

static const unsigned int qspi_ctrl_b_pins[] = {
	/* SPCLK, SSL */
	RCAR_GP_PIN(6, 0), RCAR_GP_PIN(6, 5),
};
static const unsigned int qspi_ctrl_b_mux[] = {
	SPCLK_B_MARK, SSL_B_MARK,
};
static const unsigned int qspi_data2_b_pins[] = {
	/* MOSI_IO0, MISO_IO1 */
	RCAR_GP_PIN(6, 1), RCAR_GP_PIN(6, 2),
};
static const unsigned int qspi_data2_b_mux[] = {
	MOSI_IO0_B_MARK, MISO_IO1_B_MARK,
};
static const unsigned int qspi_data4_b_pins[] = {
	/* MOSI_IO0, MISO_IO1, IO2, IO3 */
	RCAR_GP_PIN(6, 1), RCAR_GP_PIN(6, 2), RCAR_GP_PIN(6, 3),
	RCAR_GP_PIN(6, 4),
};
static const unsigned int qspi_data4_b_mux[] = {
	SPCLK_B_MARK, MOSI_IO0_B_MARK, MISO_IO1_B_MARK,
	IO2_B_MARK, IO3_B_MARK, SSL_B_MARK,
};
/* - SCIF0 ------------------------------------------------------------------ */
static const unsigned int scif0_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(1, 7), RCAR_GP_PIN(1, 6),
};
static const unsigned int scif0_data_mux[] = {
	RX0_MARK, TX0_MARK,
};
static const unsigned int scif0_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 1), RCAR_GP_PIN(3, 0),
};
static const unsigned int scif0_data_b_mux[] = {
	RX0_B_MARK, TX0_B_MARK,
};
static const unsigned int scif0_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 26), RCAR_GP_PIN(4, 25),
};
static const unsigned int scif0_data_c_mux[] = {
	RX0_C_MARK, TX0_C_MARK,
};
static const unsigned int scif0_data_d_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(2, 23), RCAR_GP_PIN(2, 22),
};
static const unsigned int scif0_data_d_mux[] = {
	RX0_D_MARK, TX0_D_MARK,
};
static const unsigned int scif0_data_e_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(6, 29), RCAR_GP_PIN(6, 28),
};
static const unsigned int scif0_data_e_mux[] = {
	RX0_E_MARK, TX0_E_MARK,
};
/* - SCIF1 ------------------------------------------------------------------ */
static const unsigned int scif1_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(1, 9), RCAR_GP_PIN(1, 8),
};
static const unsigned int scif1_data_mux[] = {
	RX1_MARK, TX1_MARK,
};
static const unsigned int scif1_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 9), RCAR_GP_PIN(3, 8),
};
static const unsigned int scif1_data_b_mux[] = {
	RX1_B_MARK, TX1_B_MARK,
};
static const unsigned int scif1_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 10),
};
static const unsigned int scif1_clk_b_mux[] = {
	SCIF1_SCK_B_MARK,
};
static const unsigned int scif1_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 28), RCAR_GP_PIN(4, 27),
};
static const unsigned int scif1_data_c_mux[] = {
	RX1_C_MARK, TX1_C_MARK,
};
static const unsigned int scif1_data_d_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(2, 25), RCAR_GP_PIN(2, 24),
};
static const unsigned int scif1_data_d_mux[] = {
	RX1_D_MARK, TX1_D_MARK,
};
/* - SCIF2 ------------------------------------------------------------------ */
static const unsigned int scif2_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(2, 30), RCAR_GP_PIN(2, 31),
};
static const unsigned int scif2_data_mux[] = {
	RX2_MARK, TX2_MARK,
};
static const unsigned int scif2_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 17), RCAR_GP_PIN(3, 16),
};
static const unsigned int scif2_data_b_mux[] = {
	RX2_B_MARK, TX2_B_MARK,
};
static const unsigned int scif2_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 18),
};
static const unsigned int scif2_clk_b_mux[] = {
	SCIF2_SCK_B_MARK,
};
static const unsigned int scif2_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(6, 24), RCAR_GP_PIN(6, 25),
};
static const unsigned int scif2_data_c_mux[] = {
	RX2_C_MARK, TX2_C_MARK,
};
static const unsigned int scif2_data_e_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(2, 7), RCAR_GP_PIN(2, 8),
};
static const unsigned int scif2_data_e_mux[] = {
	RX2_E_MARK, TX2_E_MARK,
};
/* - SCIF3 ------------------------------------------------------------------ */
static const unsigned int scif3_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 22), RCAR_GP_PIN(3, 21),
};
static const unsigned int scif3_data_mux[] = {
	RX3_MARK, TX3_MARK,
};
static const unsigned int scif3_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 23),
};
static const unsigned int scif3_clk_mux[] = {
	SCIF3_SCK_MARK,
};
static const unsigned int scif3_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(3, 29), RCAR_GP_PIN(3, 26),
};
static const unsigned int scif3_data_b_mux[] = {
	RX3_B_MARK, TX3_B_MARK,
};
static const unsigned int scif3_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 8),
};
static const unsigned int scif3_clk_b_mux[] = {
	SCIF3_SCK_B_MARK,
};
static const unsigned int scif3_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(6, 7), RCAR_GP_PIN(6, 6),
};
static const unsigned int scif3_data_c_mux[] = {
	RX3_C_MARK, TX3_C_MARK,
};
static const unsigned int scif3_data_d_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(2, 27), RCAR_GP_PIN(2, 26),
};
static const unsigned int scif3_data_d_mux[] = {
	RX3_D_MARK, TX3_D_MARK,
};
/* - SCIF4 ------------------------------------------------------------------ */
static const unsigned int scif4_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 2), RCAR_GP_PIN(4, 1),
};
static const unsigned int scif4_data_mux[] = {
	RX4_MARK, TX4_MARK,
};
static const unsigned int scif4_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(5, 1), RCAR_GP_PIN(5, 0),
};
static const unsigned int scif4_data_b_mux[] = {
	RX4_B_MARK, TX4_B_MARK,
};
static const unsigned int scif4_data_c_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(7, 22), RCAR_GP_PIN(7, 21),
};
static const unsigned int scif4_data_c_mux[] = {
	RX4_C_MARK, TX4_C_MARK,
};
/* - SCIF5 ------------------------------------------------------------------ */
static const unsigned int scif5_data_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(4, 4), RCAR_GP_PIN(4, 3),
};
static const unsigned int scif5_data_mux[] = {
	RX5_MARK, TX5_MARK,
};
static const unsigned int scif5_data_b_pins[] = {
	/* RX, TX */
	RCAR_GP_PIN(6, 23), RCAR_GP_PIN(6, 22),
};
static const unsigned int scif5_data_b_mux[] = {
	RX5_B_MARK, TX5_B_MARK,
};
/* - SCIFA0 ----------------------------------------------------------------- */
static const unsigned int scifa0_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 7), RCAR_GP_PIN(1, 6),
};
static const unsigned int scifa0_data_mux[] = {
	SCIFA0_RXD_MARK, SCIFA0_TXD_MARK,
};
static const unsigned int scifa0_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(3, 1), RCAR_GP_PIN(3, 0),
};
static const unsigned int scifa0_data_b_mux[] = {
	SCIFA0_RXD_B_MARK, SCIFA0_TXD_B_MARK
};
/* - SCIFA1 ----------------------------------------------------------------- */
static const unsigned int scifa1_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 9), RCAR_GP_PIN(1, 8),
};
static const unsigned int scifa1_data_mux[] = {
	SCIFA1_RXD_MARK, SCIFA1_TXD_MARK,
};
static const unsigned int scifa1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 10),
};
static const unsigned int scifa1_clk_mux[] = {
	SCIFA1_SCK_MARK,
};
static const unsigned int scifa1_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(3, 9), RCAR_GP_PIN(3, 8),
};
static const unsigned int scifa1_data_b_mux[] = {
	SCIFA1_RXD_B_MARK, SCIFA1_TXD_B_MARK,
};
static const unsigned int scifa1_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 0),
};
static const unsigned int scifa1_clk_b_mux[] = {
	SCIFA1_SCK_B_MARK,
};
static const unsigned int scifa1_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 2), RCAR_GP_PIN(1, 3),
};
static const unsigned int scifa1_data_c_mux[] = {
	SCIFA1_RXD_C_MARK, SCIFA1_TXD_C_MARK,
};
/* - SCIFA2 ----------------------------------------------------------------- */
static const unsigned int scifa2_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(2, 30), RCAR_GP_PIN(2, 31),
};
static const unsigned int scifa2_data_mux[] = {
	SCIFA2_RXD_MARK, SCIFA2_TXD_MARK,
};
static const unsigned int scifa2_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 18),
};
static const unsigned int scifa2_clk_mux[] = {
	SCIFA2_SCK_MARK,
};
static const unsigned int scifa2_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(3, 17), RCAR_GP_PIN(3, 16),
};
static const unsigned int scifa2_data_b_mux[] = {
	SCIFA2_RXD_B_MARK, SCIFA2_TXD_B_MARK,
};
/* - SCIFA3 ----------------------------------------------------------------- */
static const unsigned int scifa3_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(3, 22), RCAR_GP_PIN(3, 21),
};
static const unsigned int scifa3_data_mux[] = {
	SCIFA3_RXD_MARK, SCIFA3_TXD_MARK,
};
static const unsigned int scifa3_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(3, 23),
};
static const unsigned int scifa3_clk_mux[] = {
	SCIFA3_SCK_MARK,
};
static const unsigned int scifa3_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(5, 19), RCAR_GP_PIN(5, 20),
};
static const unsigned int scifa3_data_b_mux[] = {
	SCIFA3_RXD_B_MARK, SCIFA3_TXD_B_MARK,
};
static const unsigned int scifa3_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 8),
};
static const unsigned int scifa3_clk_b_mux[] = {
	SCIFA3_SCK_B_MARK,
};
static const unsigned int scifa3_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(7, 21), RCAR_GP_PIN(7, 20),
};
static const unsigned int scifa3_data_c_mux[] = {
	SCIFA3_RXD_C_MARK, SCIFA3_TXD_C_MARK,
};
static const unsigned int scifa3_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(7, 22),
};
static const unsigned int scifa3_clk_c_mux[] = {
	SCIFA3_SCK_C_MARK,
};
/* - SCIFA4 ----------------------------------------------------------------- */
static const unsigned int scifa4_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 2), RCAR_GP_PIN(4, 1),
};
static const unsigned int scifa4_data_mux[] = {
	SCIFA4_RXD_MARK, SCIFA4_TXD_MARK,
};
static const unsigned int scifa4_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(5, 1), RCAR_GP_PIN(5, 0),
};
static const unsigned int scifa4_data_b_mux[] = {
	SCIFA4_RXD_B_MARK, SCIFA4_TXD_B_MARK,
};
static const unsigned int scifa4_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(7, 22), RCAR_GP_PIN(7, 21),
};
static const unsigned int scifa4_data_c_mux[] = {
	SCIFA4_RXD_C_MARK, SCIFA4_TXD_C_MARK,
};
/* - SCIFA5 ----------------------------------------------------------------- */
static const unsigned int scifa5_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 4), RCAR_GP_PIN(4, 3),
};
static const unsigned int scifa5_data_mux[] = {
	SCIFA5_RXD_MARK, SCIFA5_TXD_MARK,
};
static const unsigned int scifa5_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(6, 7), RCAR_GP_PIN(6, 6),
};
static const unsigned int scifa5_data_b_mux[] = {
	SCIFA5_RXD_B_MARK, SCIFA5_TXD_B_MARK,
};
static const unsigned int scifa5_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(6, 23), RCAR_GP_PIN(6, 22),
};
static const unsigned int scifa5_data_c_mux[] = {
	SCIFA5_RXD_C_MARK, SCIFA5_TXD_C_MARK,
};
/* - SCIFB0 ----------------------------------------------------------------- */
static const unsigned int scifb0_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(7, 3), RCAR_GP_PIN(7, 4),
};
static const unsigned int scifb0_data_mux[] = {
	SCIFB0_RXD_MARK, SCIFB0_TXD_MARK,
};
static const unsigned int scifb0_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(7, 2),
};
static const unsigned int scifb0_clk_mux[] = {
	SCIFB0_SCK_MARK,
};
static const unsigned int scifb0_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(7, 1), RCAR_GP_PIN(7, 0),
};
static const unsigned int scifb0_ctrl_mux[] = {
	SCIFB0_RTS_N_MARK, SCIFB0_CTS_N_MARK,
};
static const unsigned int scifb0_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 20), RCAR_GP_PIN(1, 21),
};
static const unsigned int scifb0_data_b_mux[] = {
	SCIFB0_RXD_B_MARK, SCIFB0_TXD_B_MARK,
};
static const unsigned int scifb0_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(5, 31),
};
static const unsigned int scifb0_clk_b_mux[] = {
	SCIFB0_SCK_B_MARK,
};
static const unsigned int scifb0_ctrl_b_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(1, 22), RCAR_GP_PIN(1, 23),
};
static const unsigned int scifb0_ctrl_b_mux[] = {
	SCIFB0_RTS_N_B_MARK, SCIFB0_CTS_N_B_MARK,
};
static const unsigned int scifb0_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(2, 0), RCAR_GP_PIN(2, 1),
};
static const unsigned int scifb0_data_c_mux[] = {
	SCIFB0_RXD_C_MARK, SCIFB0_TXD_C_MARK,
};
static const unsigned int scifb0_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(2, 30),
};
static const unsigned int scifb0_clk_c_mux[] = {
	SCIFB0_SCK_C_MARK,
};
static const unsigned int scifb0_data_d_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 28), RCAR_GP_PIN(4, 18),
};
static const unsigned int scifb0_data_d_mux[] = {
	SCIFB0_RXD_D_MARK, SCIFB0_TXD_D_MARK,
};
static const unsigned int scifb0_clk_d_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 17),
};
static const unsigned int scifb0_clk_d_mux[] = {
	SCIFB0_SCK_D_MARK,
};
/* - SCIFB1 ----------------------------------------------------------------- */
static const unsigned int scifb1_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(7, 5), RCAR_GP_PIN(7, 6),
};
static const unsigned int scifb1_data_mux[] = {
	SCIFB1_RXD_MARK, SCIFB1_TXD_MARK,
};
static const unsigned int scifb1_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(7, 7),
};
static const unsigned int scifb1_clk_mux[] = {
	SCIFB1_SCK_MARK,
};
static const unsigned int scifb1_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(7, 9), RCAR_GP_PIN(7, 8),
};
static const unsigned int scifb1_ctrl_mux[] = {
	SCIFB1_RTS_N_MARK, SCIFB1_CTS_N_MARK,
};
static const unsigned int scifb1_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 17), RCAR_GP_PIN(1, 18),
};
static const unsigned int scifb1_data_b_mux[] = {
	SCIFB1_RXD_B_MARK, SCIFB1_TXD_B_MARK,
};
static const unsigned int scifb1_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(1, 3),
};
static const unsigned int scifb1_clk_b_mux[] = {
	SCIFB1_SCK_B_MARK,
};
static const unsigned int scifb1_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(1, 2), RCAR_GP_PIN(1, 3),
};
static const unsigned int scifb1_data_c_mux[] = {
	SCIFB1_RXD_C_MARK, SCIFB1_TXD_C_MARK,
};
static const unsigned int scifb1_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(7, 11),
};
static const unsigned int scifb1_clk_c_mux[] = {
	SCIFB1_SCK_C_MARK,
};
static const unsigned int scifb1_data_d_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(7, 10), RCAR_GP_PIN(7, 12),
};
static const unsigned int scifb1_data_d_mux[] = {
	SCIFB1_RXD_D_MARK, SCIFB1_TXD_D_MARK,
};
/* - SCIFB2 ----------------------------------------------------------------- */
static const unsigned int scifb2_data_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(4, 16), RCAR_GP_PIN(4, 17),
};
static const unsigned int scifb2_data_mux[] = {
	SCIFB2_RXD_MARK, SCIFB2_TXD_MARK,
};
static const unsigned int scifb2_clk_pins[] = {
	/* SCK */
	RCAR_GP_PIN(4, 15),
};
static const unsigned int scifb2_clk_mux[] = {
	SCIFB2_SCK_MARK,
};
static const unsigned int scifb2_ctrl_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(4, 14), RCAR_GP_PIN(4, 13),
};
static const unsigned int scifb2_ctrl_mux[] = {
	SCIFB2_RTS_N_MARK, SCIFB2_CTS_N_MARK,
};
static const unsigned int scifb2_data_b_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 13),
};
static const unsigned int scifb2_data_b_mux[] = {
	SCIFB2_RXD_B_MARK, SCIFB2_TXD_B_MARK,
};
static const unsigned int scifb2_clk_b_pins[] = {
	/* SCK */
	RCAR_GP_PIN(5, 31),
};
static const unsigned int scifb2_clk_b_mux[] = {
	SCIFB2_SCK_B_MARK,
};
static const unsigned int scifb2_ctrl_b_pins[] = {
	/* RTS, CTS */
	RCAR_GP_PIN(3, 15), RCAR_GP_PIN(3, 14),
};
static const unsigned int scifb2_ctrl_b_mux[] = {
	SCIFB2_RTS_N_B_MARK, SCIFB2_CTS_N_B_MARK,
};
static const unsigned int scifb2_data_c_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(2, 0), RCAR_GP_PIN(2, 1),
};
static const unsigned int scifb2_data_c_mux[] = {
	SCIFB2_RXD_C_MARK, SCIFB2_TXD_C_MARK,
};
static const unsigned int scifb2_clk_c_pins[] = {
	/* SCK */
	RCAR_GP_PIN(5, 27),
};
static const unsigned int scifb2_clk_c_mux[] = {
	SCIFB2_SCK_C_MARK,
};
static const unsigned int scifb2_data_d_pins[] = {
	/* RXD, TXD */
	RCAR_GP_PIN(5, 26), RCAR_GP_PIN(5, 25),
};
static const unsigned int scifb2_data_d_mux[] = {
	SCIFB2_RXD_D_MARK, SCIFB2_TXD_D_MARK,
};
/* - SDHI0 ------------------------------------------------------------------ */
static const unsigned int sdhi0_data1_pins[] = {
	/* D0 */
	RCAR_GP_PIN(6, 2),
};
static const unsigned int sdhi0_data1_mux[] = {
	SD0_DATA0_MARK,
};
static const unsigned int sdhi0_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(6, 2), RCAR_GP_PIN(6, 3),
	RCAR_GP_PIN(6, 4), RCAR_GP_PIN(6, 5),
};
static const unsigned int sdhi0_data4_mux[] = {
	SD0_DATA0_MARK, SD0_DATA1_MARK, SD0_DATA2_MARK, SD0_DATA3_MARK,
};
static const unsigned int sdhi0_ctrl_pins[] = {
	/* CLK, CMD */
	RCAR_GP_PIN(6, 0), RCAR_GP_PIN(6, 1),
};
static const unsigned int sdhi0_ctrl_mux[] = {
	SD0_CLK_MARK, SD0_CMD_MARK,
};
static const unsigned int sdhi0_cd_pins[] = {
	/* CD */
	RCAR_GP_PIN(6, 6),
};
static const unsigned int sdhi0_cd_mux[] = {
	SD0_CD_MARK,
};
static const unsigned int sdhi0_wp_pins[] = {
	/* WP */
	RCAR_GP_PIN(6, 7),
};
static const unsigned int sdhi0_wp_mux[] = {
	SD0_WP_MARK,
};
/* - SDHI1 ------------------------------------------------------------------ */
static const unsigned int sdhi1_data1_pins[] = {
	/* D0 */
	RCAR_GP_PIN(6, 10),
};
static const unsigned int sdhi1_data1_mux[] = {
	SD1_DATA0_MARK,
};
static const unsigned int sdhi1_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(6, 10), RCAR_GP_PIN(6, 11),
	RCAR_GP_PIN(6, 12), RCAR_GP_PIN(6, 13),
};
static const unsigned int sdhi1_data4_mux[] = {
	SD1_DATA0_MARK, SD1_DATA1_MARK, SD1_DATA2_MARK, SD1_DATA3_MARK,
};
static const unsigned int sdhi1_ctrl_pins[] = {
	/* CLK, CMD */
	RCAR_GP_PIN(6, 8), RCAR_GP_PIN(6, 9),
};
static const unsigned int sdhi1_ctrl_mux[] = {
	SD1_CLK_MARK, SD1_CMD_MARK,
};
static const unsigned int sdhi1_cd_pins[] = {
	/* CD */
	RCAR_GP_PIN(6, 14),
};
static const unsigned int sdhi1_cd_mux[] = {
	SD1_CD_MARK,
};
static const unsigned int sdhi1_wp_pins[] = {
	/* WP */
	RCAR_GP_PIN(6, 15),
};
static const unsigned int sdhi1_wp_mux[] = {
	SD1_WP_MARK,
};
/* - SDHI2 ------------------------------------------------------------------ */
static const unsigned int sdhi2_data1_pins[] = {
	/* D0 */
	RCAR_GP_PIN(6, 18),
};
static const unsigned int sdhi2_data1_mux[] = {
	SD2_DATA0_MARK,
};
static const unsigned int sdhi2_data4_pins[] = {
	/* D[0:3] */
	RCAR_GP_PIN(6, 18), RCAR_GP_PIN(6, 19),
	RCAR_GP_PIN(6, 20), RCAR_GP_PIN(6, 21),
};
static const unsigned int sdhi2_data4_mux[] = {
	SD2_DATA0_MARK, SD2_DATA1_MARK, SD2_DATA2_MARK, SD2_DATA3_MARK,
};
static const unsigned int sdhi2_ctrl_pins[] = {
	/* CLK, CMD */
	RCAR_GP_PIN(6, 16), RCAR_GP_PIN(6, 17),
};
static const unsigned int sdhi2_ctrl_mux[] = {
	SD2_CLK_MARK, SD2_CMD_MARK,
};
static const unsigned int sdhi2_cd_pins[] = {
	/* CD */
	RCAR_GP_PIN(6, 22),
};
static const unsigned int sdhi2_cd_mux[] = {
	SD2_CD_MARK,
};
static const unsigned int sdhi2_wp_pins[] = {
	/* WP */
	RCAR_GP_PIN(6, 23),
};
static const unsigned int sdhi2_wp_mux[] = {
	SD2_WP_MARK,
};

/* - SSI -------------------------------------------------------------------- */
static const unsigned int ssi0_data_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(2, 2),
};

static const unsigned int ssi0_data_mux[] = {
	SSI_SDATA0_MARK,
};

static const unsigned int ssi0_data_b_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(3, 4),
};

static const unsigned int ssi0_data_b_mux[] = {
	SSI_SDATA0_B_MARK,
};

static const unsigned int ssi0129_ctrl_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(2, 0), RCAR_GP_PIN(2, 1),
};

static const unsigned int ssi0129_ctrl_mux[] = {
	SSI_SCK0129_MARK, SSI_WS0129_MARK,
};

static const unsigned int ssi0129_ctrl_b_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(3, 2), RCAR_GP_PIN(3, 3),
};

static const unsigned int ssi0129_ctrl_b_mux[] = {
	SSI_SCK0129_B_MARK, SSI_WS0129_B_MARK,
};

static const unsigned int ssi1_data_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(2, 5),
};

static const unsigned int ssi1_data_mux[] = {
	SSI_SDATA1_MARK,
};

static const unsigned int ssi1_data_b_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(3, 7),
};

static const unsigned int ssi1_data_b_mux[] = {
	SSI_SDATA1_B_MARK,
};

static const unsigned int ssi1_ctrl_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(2, 3), RCAR_GP_PIN(2, 4),
};

static const unsigned int ssi1_ctrl_mux[] = {
	SSI_SCK1_MARK, SSI_WS1_MARK,
};

static const unsigned int ssi1_ctrl_b_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(3, 5), RCAR_GP_PIN(3, 6),
};

static const unsigned int ssi1_ctrl_b_mux[] = {
	SSI_SCK1_B_MARK, SSI_WS1_B_MARK,
};

static const unsigned int ssi2_data_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(2, 8),
};

static const unsigned int ssi2_data_mux[] = {
	SSI_SDATA2_MARK,
};

static const unsigned int ssi2_ctrl_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(2, 6), RCAR_GP_PIN(2, 7),
};

static const unsigned int ssi2_ctrl_mux[] = {
	SSI_SCK2_MARK, SSI_WS2_MARK,
};

static const unsigned int ssi3_data_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(2, 11),
};

static const unsigned int ssi3_data_mux[] = {
	SSI_SDATA3_MARK,
};

static const unsigned int ssi34_ctrl_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(2, 9), RCAR_GP_PIN(2, 10),
};

static const unsigned int ssi34_ctrl_mux[] = {
	SSI_SCK34_MARK, SSI_WS34_MARK,
};

static const unsigned int ssi4_data_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(2, 14),
};

static const unsigned int ssi4_data_mux[] = {
	SSI_SDATA4_MARK,
};

static const unsigned int ssi4_ctrl_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(2, 12), RCAR_GP_PIN(2, 13),
};

static const unsigned int ssi4_ctrl_mux[] = {
	SSI_SCK4_MARK, SSI_WS4_MARK,
};

static const unsigned int ssi5_data_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(2, 17),
};

static const unsigned int ssi5_data_mux[] = {
	SSI_SDATA5_MARK,
};

static const unsigned int ssi5_ctrl_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(2, 15), RCAR_GP_PIN(2, 16),
};

static const unsigned int ssi5_ctrl_mux[] = {
	SSI_SCK5_MARK, SSI_WS5_MARK,
};

static const unsigned int ssi6_data_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(2, 20),
};

static const unsigned int ssi6_data_mux[] = {
	SSI_SDATA6_MARK,
};

static const unsigned int ssi6_ctrl_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(2, 18), RCAR_GP_PIN(2, 19),
};

static const unsigned int ssi6_ctrl_mux[] = {
	SSI_SCK6_MARK, SSI_WS6_MARK,
};

static const unsigned int ssi7_data_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(2, 23),
};

static const unsigned int ssi7_data_mux[] = {
	SSI_SDATA7_MARK,
};

static const unsigned int ssi7_data_b_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(3, 12),
};

static const unsigned int ssi7_data_b_mux[] = {
	SSI_SDATA7_B_MARK,
};

static const unsigned int ssi78_ctrl_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(2, 21), RCAR_GP_PIN(2, 22),
};

static const unsigned int ssi78_ctrl_mux[] = {
	SSI_SCK78_MARK, SSI_WS78_MARK,
};

static const unsigned int ssi78_ctrl_b_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 11),
};

static const unsigned int ssi78_ctrl_b_mux[] = {
	SSI_SCK78_B_MARK, SSI_WS78_B_MARK,
};

static const unsigned int ssi8_data_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(2, 24),
};

static const unsigned int ssi8_data_mux[] = {
	SSI_SDATA8_MARK,
};

static const unsigned int ssi8_data_b_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(3, 13),
};

static const unsigned int ssi8_data_b_mux[] = {
	SSI_SDATA8_B_MARK,
};

static const unsigned int ssi9_data_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(2, 27),
};

static const unsigned int ssi9_data_mux[] = {
	SSI_SDATA9_MARK,
};

static const unsigned int ssi9_data_b_pins[] = {
	/* SDATA */
	RCAR_GP_PIN(3, 18),
};

static const unsigned int ssi9_data_b_mux[] = {
	SSI_SDATA9_B_MARK,
};

static const unsigned int ssi9_ctrl_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(2, 25), RCAR_GP_PIN(2, 26),
};

static const unsigned int ssi9_ctrl_mux[] = {
	SSI_SCK9_MARK, SSI_WS9_MARK,
};

static const unsigned int ssi9_ctrl_b_pins[] = {
	/* SCK, WS */
	RCAR_GP_PIN(3, 14), RCAR_GP_PIN(3, 15),
};

static const unsigned int ssi9_ctrl_b_mux[] = {
	SSI_SCK9_B_MARK, SSI_WS9_B_MARK,
};

/* - USB0 ------------------------------------------------------------------- */
static const unsigned int usb0_pins[] = {
	RCAR_GP_PIN(7, 23), /* PWEN */
	RCAR_GP_PIN(7, 24), /* OVC */
};
static const unsigned int usb0_mux[] = {
	USB0_PWEN_MARK,
	USB0_OVC_MARK,
};
/* - USB1 ------------------------------------------------------------------- */
static const unsigned int usb1_pins[] = {
	RCAR_GP_PIN(7, 25), /* PWEN */
	RCAR_GP_PIN(6, 30), /* OVC */
};
static const unsigned int usb1_mux[] = {
	USB1_PWEN_MARK,
	USB1_OVC_MARK,
};
/* - VIN0 ------------------------------------------------------------------- */
static const union vin_data vin0_data_pins = {
	.data24 = {
		/* B */
		RCAR_GP_PIN(4, 5), RCAR_GP_PIN(4, 6),
		RCAR_GP_PIN(4, 7), RCAR_GP_PIN(4, 8),
		RCAR_GP_PIN(4, 9), RCAR_GP_PIN(4, 10),
		RCAR_GP_PIN(4, 11), RCAR_GP_PIN(4, 12),
		/* G */
		RCAR_GP_PIN(4, 13), RCAR_GP_PIN(4, 14),
		RCAR_GP_PIN(4, 15), RCAR_GP_PIN(4, 16),
		RCAR_GP_PIN(4, 17), RCAR_GP_PIN(4, 18),
		RCAR_GP_PIN(4, 19), RCAR_GP_PIN(4, 20),
		/* R */
		RCAR_GP_PIN(4, 21), RCAR_GP_PIN(4, 22),
		RCAR_GP_PIN(4, 23), RCAR_GP_PIN(4, 24),
		RCAR_GP_PIN(4, 25), RCAR_GP_PIN(4, 26),
		RCAR_GP_PIN(4, 27), RCAR_GP_PIN(4, 28),
	},
};
static const union vin_data vin0_data_mux = {
	.data24 = {
		/* B */
		VI0_DATA0_VI0_B0_MARK, VI0_DATA1_VI0_B1_MARK,
		VI0_DATA2_VI0_B2_MARK, VI0_DATA3_VI0_B3_MARK,
		VI0_DATA4_VI0_B4_MARK, VI0_DATA5_VI0_B5_MARK,
		VI0_DATA6_VI0_B6_MARK, VI0_DATA7_VI0_B7_MARK,
		/* G */
		VI0_G0_MARK, VI0_G1_MARK,
		VI0_G2_MARK, VI0_G3_MARK,
		VI0_G4_MARK, VI0_G5_MARK,
		VI0_G6_MARK, VI0_G7_MARK,
		/* R */
		VI0_R0_MARK, VI0_R1_MARK,
		VI0_R2_MARK, VI0_R3_MARK,
		VI0_R4_MARK, VI0_R5_MARK,
		VI0_R6_MARK, VI0_R7_MARK,
	},
};
static const unsigned int vin0_data18_pins[] = {
	/* B */
	RCAR_GP_PIN(4, 7), RCAR_GP_PIN(4, 8),
	RCAR_GP_PIN(4, 9), RCAR_GP_PIN(4, 10),
	RCAR_GP_PIN(4, 11), RCAR_GP_PIN(4, 12),
	/* G */
	RCAR_GP_PIN(4, 15), RCAR_GP_PIN(4, 16),
	RCAR_GP_PIN(4, 17), RCAR_GP_PIN(4, 18),
	RCAR_GP_PIN(4, 19), RCAR_GP_PIN(4, 20),
	/* R */
	RCAR_GP_PIN(4, 23), RCAR_GP_PIN(4, 24),
	RCAR_GP_PIN(4, 25), RCAR_GP_PIN(4, 26),
	RCAR_GP_PIN(4, 27), RCAR_GP_PIN(4, 28),
};
static const unsigned int vin0_data18_mux[] = {
	/* B */
	VI0_DATA2_VI0_B2_MARK, VI0_DATA3_VI0_B3_MARK,
	VI0_DATA4_VI0_B4_MARK, VI0_DATA5_VI0_B5_MARK,
	VI0_DATA6_VI0_B6_MARK, VI0_DATA7_VI0_B7_MARK,
	/* G */
	VI0_G2_MARK, VI0_G3_MARK,
	VI0_G4_MARK, VI0_G5_MARK,
	VI0_G6_MARK, VI0_G7_MARK,
	/* R */
	VI0_R2_MARK, VI0_R3_MARK,
	VI0_R4_MARK, VI0_R5_MARK,
	VI0_R6_MARK, VI0_R7_MARK,
};
static const unsigned int vin0_sync_pins[] = {
	RCAR_GP_PIN(4, 3), /* HSYNC */
	RCAR_GP_PIN(4, 4), /* VSYNC */
};
static const unsigned int vin0_sync_mux[] = {
	VI0_HSYNC_N_MARK,
	VI0_VSYNC_N_MARK,
};
static const unsigned int vin0_field_pins[] = {
	RCAR_GP_PIN(4, 2),
};
static const unsigned int vin0_field_mux[] = {
	VI0_FIELD_MARK,
};
static const unsigned int vin0_clkenb_pins[] = {
	RCAR_GP_PIN(4, 1),
};
static const unsigned int vin0_clkenb_mux[] = {
	VI0_CLKENB_MARK,
};
static const unsigned int vin0_clk_pins[] = {
	RCAR_GP_PIN(4, 0),
};
static const unsigned int vin0_clk_mux[] = {
	VI0_CLK_MARK,
};
/* - VIN1 ----------------------------------------------------------------- */
static const unsigned int vin1_data8_pins[] = {
	RCAR_GP_PIN(5, 5), RCAR_GP_PIN(5, 6),
	RCAR_GP_PIN(5, 7), RCAR_GP_PIN(5, 8),
	RCAR_GP_PIN(5, 9), RCAR_GP_PIN(5, 10),
	RCAR_GP_PIN(5, 11), RCAR_GP_PIN(5, 12),
};
static const unsigned int vin1_data8_mux[] = {
	VI1_DATA0_MARK, VI1_DATA1_MARK,
	VI1_DATA2_MARK, VI1_DATA3_MARK,
	VI1_DATA4_MARK, VI1_DATA5_MARK,
	VI1_DATA6_MARK, VI1_DATA7_MARK,
};
static const unsigned int vin1_sync_pins[] = {
	RCAR_GP_PIN(5, 0), /* HSYNC */
	RCAR_GP_PIN(5, 1), /* VSYNC */
};
static const unsigned int vin1_sync_mux[] = {
	VI1_HSYNC_N_MARK,
	VI1_VSYNC_N_MARK,
};
static const unsigned int vin1_field_pins[] = {
	RCAR_GP_PIN(5, 3),
};
static const unsigned int vin1_field_mux[] = {
	VI1_FIELD_MARK,
};
static const unsigned int vin1_clkenb_pins[] = {
	RCAR_GP_PIN(5, 2),
};
static const unsigned int vin1_clkenb_mux[] = {
	VI1_CLKENB_MARK,
};
static const unsigned int vin1_clk_pins[] = {
	RCAR_GP_PIN(5, 4),
};
static const unsigned int vin1_clk_mux[] = {
	VI1_CLK_MARK,
};
static const union vin_data vin1_b_data_pins = {
	.data24 = {
		/* B */
		RCAR_GP_PIN(3, 0), RCAR_GP_PIN(3, 1),
		RCAR_GP_PIN(3, 8), RCAR_GP_PIN(3, 9),
		RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 11),
		RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 13),
		/* G */
		RCAR_GP_PIN(6, 24), RCAR_GP_PIN(6, 25),
		RCAR_GP_PIN(6, 26), RCAR_GP_PIN(6, 27),
		RCAR_GP_PIN(6, 28), RCAR_GP_PIN(6, 29),
		RCAR_GP_PIN(7, 21), RCAR_GP_PIN(7, 22),
		/* R */
		RCAR_GP_PIN(7, 5), RCAR_GP_PIN(7, 6),
		RCAR_GP_PIN(2, 15), RCAR_GP_PIN(2, 16),
		RCAR_GP_PIN(2, 17), RCAR_GP_PIN(2, 18),
		RCAR_GP_PIN(2, 19), RCAR_GP_PIN(2, 20),
	},
};
static const union vin_data vin1_b_data_mux = {
	.data24 = {
		/* B */
		VI1_DATA0_B_MARK, VI1_DATA1_B_MARK,
		VI1_DATA2_B_MARK, VI1_DATA3_B_MARK,
		VI1_DATA4_B_MARK, VI1_DATA5_B_MARK,
		VI1_DATA6_B_MARK, VI1_DATA7_B_MARK,
		/* G */
		VI1_G0_B_MARK, VI1_G1_B_MARK,
		VI1_G2_B_MARK, VI1_G3_B_MARK,
		VI1_G4_B_MARK, VI1_G5_B_MARK,
		VI1_G6_B_MARK, VI1_G7_B_MARK,
		/* R */
		VI1_R0_B_MARK, VI1_R1_B_MARK,
		VI1_R2_B_MARK, VI1_R3_B_MARK,
		VI1_R4_B_MARK, VI1_R5_B_MARK,
		VI1_R6_B_MARK, VI1_R7_B_MARK,
	},
};
static const unsigned int vin1_b_data18_pins[] = {
	/* B */
	RCAR_GP_PIN(3, 8), RCAR_GP_PIN(3, 9),
	RCAR_GP_PIN(3, 10), RCAR_GP_PIN(3, 11),
	RCAR_GP_PIN(3, 12), RCAR_GP_PIN(3, 13),
	/* G */
	RCAR_GP_PIN(6, 26), RCAR_GP_PIN(6, 27),
	RCAR_GP_PIN(6, 28), RCAR_GP_PIN(6, 29),
	RCAR_GP_PIN(7, 21), RCAR_GP_PIN(7, 22),
	/* R */
	RCAR_GP_PIN(2, 15), RCAR_GP_PIN(2, 16),
	RCAR_GP_PIN(2, 17), RCAR_GP_PIN(2, 18),
	RCAR_GP_PIN(2, 19), RCAR_GP_PIN(2, 20),
};
static const unsigned int vin1_b_data18_mux[] = {
	/* B */
	VI1_DATA0_B_MARK, VI1_DATA1_B_MARK,
	VI1_DATA2_B_MARK, VI1_DATA3_B_MARK,
	VI1_DATA4_B_MARK, VI1_DATA5_B_MARK,
	VI1_DATA6_B_MARK, VI1_DATA7_B_MARK,
	/* G */
	VI1_G0_B_MARK, VI1_G1_B_MARK,
	VI1_G2_B_MARK, VI1_G3_B_MARK,
	VI1_G4_B_MARK, VI1_G5_B_MARK,
	VI1_G6_B_MARK, VI1_G7_B_MARK,
	/* R */
	VI1_R0_B_MARK, VI1_R1_B_MARK,
	VI1_R2_B_MARK, VI1_R3_B_MARK,
	VI1_R4_B_MARK, VI1_R5_B_MARK,
	VI1_R6_B_MARK, VI1_R7_B_MARK,
};
static const unsigned int vin1_b_sync_pins[] = {
	RCAR_GP_PIN(3, 17), /* HSYNC */
	RCAR_GP_PIN(3, 18), /* VSYNC */
};
static const unsigned int vin1_b_sync_mux[] = {
	VI1_HSYNC_N_B_MARK,
	VI1_VSYNC_N_B_MARK,
};
static const unsigned int vin1_b_field_pins[] = {
	RCAR_GP_PIN(3, 20),
};
static const unsigned int vin1_b_field_mux[] = {
	VI1_FIELD_B_MARK,
};
static const unsigned int vin1_b_clkenb_pins[] = {
	RCAR_GP_PIN(3, 19),
};
static const unsigned int vin1_b_clkenb_mux[] = {
	VI1_CLKENB_B_MARK,
};
static const unsigned int vin1_b_clk_pins[] = {
	RCAR_GP_PIN(3, 16),
};
static const unsigned int vin1_b_clk_mux[] = {
	VI1_CLK_B_MARK,
};
/* - VIN2 ----------------------------------------------------------------- */
static const unsigned int vin2_data8_pins[] = {
	RCAR_GP_PIN(4, 20), RCAR_GP_PIN(4, 21),
	RCAR_GP_PIN(4, 22), RCAR_GP_PIN(4, 23),
	RCAR_GP_PIN(4, 24), RCAR_GP_PIN(4, 25),
	RCAR_GP_PIN(4, 26), RCAR_GP_PIN(4, 27),
};
static const unsigned int vin2_data8_mux[] = {
	VI2_DATA0_MARK, VI2_DATA1_MARK,
	VI2_DATA2_MARK, VI2_DATA3_MARK,
	VI2_DATA4_MARK, VI2_DATA5_MARK,
	VI2_DATA6_MARK, VI2_DATA7_MARK,
};
static const unsigned int vin2_sync_pins[] = {
	RCAR_GP_PIN(4, 15), /* HSYNC */
	RCAR_GP_PIN(4, 16), /* VSYNC */
};
static const unsigned int vin2_sync_mux[] = {
	VI2_HSYNC_N_MARK,
	VI2_VSYNC_N_MARK,
};
static const unsigned int vin2_field_pins[] = {
	RCAR_GP_PIN(4, 18),
};
static const unsigned int vin2_field_mux[] = {
	VI2_FIELD_MARK,
};
static const unsigned int vin2_clkenb_pins[] = {
	RCAR_GP_PIN(4, 17),
};
static const unsigned int vin2_clkenb_mux[] = {
	VI2_CLKENB_MARK,
};
static const unsigned int vin2_clk_pins[] = {
	RCAR_GP_PIN(4, 19),
};
static const unsigned int vin2_clk_mux[] = {
	VI2_CLK_MARK,
};

static const struct sh_pfc_pin_group pinmux_groups[] = {
	SH_PFC_PIN_GROUP(audio_clk_a),
	SH_PFC_PIN_GROUP(audio_clk_b),
	SH_PFC_PIN_GROUP(audio_clk_b_b),
	SH_PFC_PIN_GROUP(audio_clk_c),
	SH_PFC_PIN_GROUP(audio_clkout),
	SH_PFC_PIN_GROUP(can0_data),
	SH_PFC_PIN_GROUP(can0_data_b),
	SH_PFC_PIN_GROUP(can0_data_c),
	SH_PFC_PIN_GROUP(can0_data_d),
	SH_PFC_PIN_GROUP(can0_data_e),
	SH_PFC_PIN_GROUP(can0_data_f),
	SH_PFC_PIN_GROUP(can1_data),
	SH_PFC_PIN_GROUP(can1_data_b),
	SH_PFC_PIN_GROUP(can1_data_c),
	SH_PFC_PIN_GROUP(can1_data_d),
	SH_PFC_PIN_GROUP(can_clk),
	SH_PFC_PIN_GROUP(can_clk_b),
	SH_PFC_PIN_GROUP(can_clk_c),
	SH_PFC_PIN_GROUP(can_clk_d),
	SH_PFC_PIN_GROUP(du_rgb666),
	SH_PFC_PIN_GROUP(du_rgb888),
	SH_PFC_PIN_GROUP(du_clk_out_0),
	SH_PFC_PIN_GROUP(du_clk_out_1),
	SH_PFC_PIN_GROUP(du_sync),
	SH_PFC_PIN_GROUP(du_oddf),
	SH_PFC_PIN_GROUP(du_cde),
	SH_PFC_PIN_GROUP(du_disp),
	SH_PFC_PIN_GROUP(du0_clk_in),
	SH_PFC_PIN_GROUP(du1_clk_in),
	SH_PFC_PIN_GROUP(du1_clk_in_b),
	SH_PFC_PIN_GROUP(du1_clk_in_c),
	SH_PFC_PIN_GROUP(eth_link),
	SH_PFC_PIN_GROUP(eth_magic),
	SH_PFC_PIN_GROUP(eth_mdio),
	SH_PFC_PIN_GROUP(eth_rmii),
	SH_PFC_PIN_GROUP(hscif0_data),
	SH_PFC_PIN_GROUP(hscif0_clk),
	SH_PFC_PIN_GROUP(hscif0_ctrl),
	SH_PFC_PIN_GROUP(hscif0_data_b),
	SH_PFC_PIN_GROUP(hscif0_ctrl_b),
	SH_PFC_PIN_GROUP(hscif0_data_c),
	SH_PFC_PIN_GROUP(hscif0_clk_c),
	SH_PFC_PIN_GROUP(hscif1_data),
	SH_PFC_PIN_GROUP(hscif1_clk),
	SH_PFC_PIN_GROUP(hscif1_ctrl),
	SH_PFC_PIN_GROUP(hscif1_data_b),
	SH_PFC_PIN_GROUP(hscif1_data_c),
	SH_PFC_PIN_GROUP(hscif1_clk_c),
	SH_PFC_PIN_GROUP(hscif1_ctrl_c),
	SH_PFC_PIN_GROUP(hscif1_data_d),
	SH_PFC_PIN_GROUP(hscif1_data_e),
	SH_PFC_PIN_GROUP(hscif1_clk_e),
	SH_PFC_PIN_GROUP(hscif1_ctrl_e),
	SH_PFC_PIN_GROUP(hscif2_data),
	SH_PFC_PIN_GROUP(hscif2_clk),
	SH_PFC_PIN_GROUP(hscif2_ctrl),
	SH_PFC_PIN_GROUP(hscif2_data_b),
	SH_PFC_PIN_GROUP(hscif2_ctrl_b),
	SH_PFC_PIN_GROUP(hscif2_data_c),
	SH_PFC_PIN_GROUP(hscif2_clk_c),
	SH_PFC_PIN_GROUP(hscif2_data_d),
	SH_PFC_PIN_GROUP(i2c0),
	SH_PFC_PIN_GROUP(i2c0_b),
	SH_PFC_PIN_GROUP(i2c0_c),
	SH_PFC_PIN_GROUP(i2c1),
	SH_PFC_PIN_GROUP(i2c1_b),
	SH_PFC_PIN_GROUP(i2c1_c),
	SH_PFC_PIN_GROUP(i2c1_d),
	SH_PFC_PIN_GROUP(i2c1_e),
	SH_PFC_PIN_GROUP(i2c2),
	SH_PFC_PIN_GROUP(i2c2_b),
	SH_PFC_PIN_GROUP(i2c2_c),
	SH_PFC_PIN_GROUP(i2c2_d),
	SH_PFC_PIN_GROUP(i2c3),
	SH_PFC_PIN_GROUP(i2c3_b),
	SH_PFC_PIN_GROUP(i2c3_c),
	SH_PFC_PIN_GROUP(i2c3_d),
	SH_PFC_PIN_GROUP(i2c4),
	SH_PFC_PIN_GROUP(i2c4_b),
	SH_PFC_PIN_GROUP(i2c4_c),
	SH_PFC_PIN_GROUP(i2c7),
	SH_PFC_PIN_GROUP(i2c7_b),
	SH_PFC_PIN_GROUP(i2c7_c),
	SH_PFC_PIN_GROUP(i2c8),
	SH_PFC_PIN_GROUP(i2c8_b),
	SH_PFC_PIN_GROUP(i2c8_c),
	SH_PFC_PIN_GROUP(intc_irq0),
	SH_PFC_PIN_GROUP(intc_irq1),
	SH_PFC_PIN_GROUP(intc_irq2),
	SH_PFC_PIN_GROUP(intc_irq3),
	SH_PFC_PIN_GROUP(mlb_3pin),
	SH_PFC_PIN_GROUP(mmc_data1),
	SH_PFC_PIN_GROUP(mmc_data4),
	SH_PFC_PIN_GROUP(mmc_data8),
	SH_PFC_PIN_GROUP(mmc_ctrl),
	SH_PFC_PIN_GROUP(msiof0_clk),
	SH_PFC_PIN_GROUP(msiof0_sync),
	SH_PFC_PIN_GROUP(msiof0_ss1),
	SH_PFC_PIN_GROUP(msiof0_ss2),
	SH_PFC_PIN_GROUP(msiof0_rx),
	SH_PFC_PIN_GROUP(msiof0_tx),
	SH_PFC_PIN_GROUP(msiof0_clk_b),
	SH_PFC_PIN_GROUP(msiof0_sync_b),
	SH_PFC_PIN_GROUP(msiof0_ss1_b),
	SH_PFC_PIN_GROUP(msiof0_ss2_b),
	SH_PFC_PIN_GROUP(msiof0_rx_b),
	SH_PFC_PIN_GROUP(msiof0_tx_b),
	SH_PFC_PIN_GROUP(msiof0_clk_c),
	SH_PFC_PIN_GROUP(msiof0_sync_c),
	SH_PFC_PIN_GROUP(msiof0_ss1_c),
	SH_PFC_PIN_GROUP(msiof0_ss2_c),
	SH_PFC_PIN_GROUP(msiof0_rx_c),
	SH_PFC_PIN_GROUP(msiof0_tx_c),
	SH_PFC_PIN_GROUP(msiof1_clk),
	SH_PFC_PIN_GROUP(msiof1_sync),
	SH_PFC_PIN_GROUP(msiof1_ss1),
	SH_PFC_PIN_GROUP(msiof1_ss2),
	SH_PFC_PIN_GROUP(msiof1_rx),
	SH_PFC_PIN_GROUP(msiof1_tx),
	SH_PFC_PIN_GROUP(msiof1_clk_b),
	SH_PFC_PIN_GROUP(msiof1_sync_b),
	SH_PFC_PIN_GROUP(msiof1_ss1_b),
	SH_PFC_PIN_GROUP(msiof1_ss2_b),
	SH_PFC_PIN_GROUP(msiof1_rx_b),
	SH_PFC_PIN_GROUP(msiof1_tx_b),
	SH_PFC_PIN_GROUP(msiof1_clk_c),
	SH_PFC_PIN_GROUP(msiof1_sync_c),
	SH_PFC_PIN_GROUP(msiof1_rx_c),
	SH_PFC_PIN_GROUP(msiof1_tx_c),
	SH_PFC_PIN_GROUP(msiof1_clk_d),
	SH_PFC_PIN_GROUP(msiof1_sync_d),
	SH_PFC_PIN_GROUP(msiof1_ss1_d),
	SH_PFC_PIN_GROUP(msiof1_rx_d),
	SH_PFC_PIN_GROUP(msiof1_tx_d),
	SH_PFC_PIN_GROUP(msiof1_clk_e),
	SH_PFC_PIN_GROUP(msiof1_sync_e),
	SH_PFC_PIN_GROUP(msiof1_rx_e),
	SH_PFC_PIN_GROUP(msiof1_tx_e),
	SH_PFC_PIN_GROUP(msiof2_clk),
	SH_PFC_PIN_GROUP(msiof2_sync),
	SH_PFC_PIN_GROUP(msiof2_ss1),
	SH_PFC_PIN_GROUP(msiof2_ss2),
	SH_PFC_PIN_GROUP(msiof2_rx),
	SH_PFC_PIN_GROUP(msiof2_tx),
	SH_PFC_PIN_GROUP(msiof2_clk_b),
	SH_PFC_PIN_GROUP(msiof2_sync_b),
	SH_PFC_PIN_GROUP(msiof2_ss1_b),
	SH_PFC_PIN_GROUP(msiof2_ss2_b),
	SH_PFC_PIN_GROUP(msiof2_rx_b),
	SH_PFC_PIN_GROUP(msiof2_tx_b),
	SH_PFC_PIN_GROUP(msiof2_clk_c),
	SH_PFC_PIN_GROUP(msiof2_sync_c),
	SH_PFC_PIN_GROUP(msiof2_rx_c),
	SH_PFC_PIN_GROUP(msiof2_tx_c),
	SH_PFC_PIN_GROUP(msiof2_clk_d),
	SH_PFC_PIN_GROUP(msiof2_sync_d),
	SH_PFC_PIN_GROUP(msiof2_ss1_d),
	SH_PFC_PIN_GROUP(msiof2_ss2_d),
	SH_PFC_PIN_GROUP(msiof2_rx_d),
	SH_PFC_PIN_GROUP(msiof2_tx_d),
	SH_PFC_PIN_GROUP(msiof2_clk_e),
	SH_PFC_PIN_GROUP(msiof2_sync_e),
	SH_PFC_PIN_GROUP(msiof2_rx_e),
	SH_PFC_PIN_GROUP(msiof2_tx_e),
	SH_PFC_PIN_GROUP(pwm0),
	SH_PFC_PIN_GROUP(pwm0_b),
	SH_PFC_PIN_GROUP(pwm1),
	SH_PFC_PIN_GROUP(pwm1_b),
	SH_PFC_PIN_GROUP(pwm2),
	SH_PFC_PIN_GROUP(pwm2_b),
	SH_PFC_PIN_GROUP(pwm3),
	SH_PFC_PIN_GROUP(pwm4),
	SH_PFC_PIN_GROUP(pwm4_b),
	SH_PFC_PIN_GROUP(pwm5),
	SH_PFC_PIN_GROUP(pwm5_b),
	SH_PFC_PIN_GROUP(pwm6),
	SH_PFC_PIN_GROUP(qspi_ctrl),
	SH_PFC_PIN_GROUP(qspi_data2),
	SH_PFC_PIN_GROUP(qspi_data4),
	SH_PFC_PIN_GROUP(qspi_ctrl_b),
	SH_PFC_PIN_GROUP(qspi_data2_b),
	SH_PFC_PIN_GROUP(qspi_data4_b),
	SH_PFC_PIN_GROUP(scif0_data),
	SH_PFC_PIN_GROUP(scif0_data_b),
	SH_PFC_PIN_GROUP(scif0_data_c),
	SH_PFC_PIN_GROUP(scif0_data_d),
	SH_PFC_PIN_GROUP(scif0_data_e),
	SH_PFC_PIN_GROUP(scif1_data),
	SH_PFC_PIN_GROUP(scif1_data_b),
	SH_PFC_PIN_GROUP(scif1_clk_b),
	SH_PFC_PIN_GROUP(scif1_data_c),
	SH_PFC_PIN_GROUP(scif1_data_d),
	SH_PFC_PIN_GROUP(scif2_data),
	SH_PFC_PIN_GROUP(scif2_data_b),
	SH_PFC_PIN_GROUP(scif2_clk_b),
	SH_PFC_PIN_GROUP(scif2_data_c),
	SH_PFC_PIN_GROUP(scif2_data_e),
	SH_PFC_PIN_GROUP(scif3_data),
	SH_PFC_PIN_GROUP(scif3_clk),
	SH_PFC_PIN_GROUP(scif3_data_b),
	SH_PFC_PIN_GROUP(scif3_clk_b),
	SH_PFC_PIN_GROUP(scif3_data_c),
	SH_PFC_PIN_GROUP(scif3_data_d),
	SH_PFC_PIN_GROUP(scif4_data),
	SH_PFC_PIN_GROUP(scif4_data_b),
	SH_PFC_PIN_GROUP(scif4_data_c),
	SH_PFC_PIN_GROUP(scif5_data),
	SH_PFC_PIN_GROUP(scif5_data_b),
	SH_PFC_PIN_GROUP(scifa0_data),
	SH_PFC_PIN_GROUP(scifa0_data_b),
	SH_PFC_PIN_GROUP(scifa1_data),
	SH_PFC_PIN_GROUP(scifa1_clk),
	SH_PFC_PIN_GROUP(scifa1_data_b),
	SH_PFC_PIN_GROUP(scifa1_clk_b),
	SH_PFC_PIN_GROUP(scifa1_data_c),
	SH_PFC_PIN_GROUP(scifa2_data),
	SH_PFC_PIN_GROUP(scifa2_clk),
	SH_PFC_PIN_GROUP(scifa2_data_b),
	SH_PFC_PIN_GROUP(scifa3_data),
	SH_PFC_PIN_GROUP(scifa3_clk),
	SH_PFC_PIN_GROUP(scifa3_data_b),
	SH_PFC_PIN_GROUP(scifa3_clk_b),
	SH_PFC_PIN_GROUP(scifa3_data_c),
	SH_PFC_PIN_GROUP(scifa3_clk_c),
	SH_PFC_PIN_GROUP(scifa4_data),
	SH_PFC_PIN_GROUP(scifa4_data_b),
	SH_PFC_PIN_GROUP(scifa4_data_c),
	SH_PFC_PIN_GROUP(scifa5_data),
	SH_PFC_PIN_GROUP(scifa5_data_b),
	SH_PFC_PIN_GROUP(scifa5_data_c),
	SH_PFC_PIN_GROUP(scifb0_data),
	SH_PFC_PIN_GROUP(scifb0_clk),
	SH_PFC_PIN_GROUP(scifb0_ctrl),
	SH_PFC_PIN_GROUP(scifb0_data_b),
	SH_PFC_PIN_GROUP(scifb0_clk_b),
	SH_PFC_PIN_GROUP(scifb0_ctrl_b),
	SH_PFC_PIN_GROUP(scifb0_data_c),
	SH_PFC_PIN_GROUP(scifb0_clk_c),
	SH_PFC_PIN_GROUP(scifb0_data_d),
	SH_PFC_PIN_GROUP(scifb0_clk_d),
	SH_PFC_PIN_GROUP(scifb1_data),
	SH_PFC_PIN_GROUP(scifb1_clk),
	SH_PFC_PIN_GROUP(scifb1_ctrl),
	SH_PFC_PIN_GROUP(scifb1_data_b),
	SH_PFC_PIN_GROUP(scifb1_clk_b),
	SH_PFC_PIN_GROUP(scifb1_data_c),
	SH_PFC_PIN_GROUP(scifb1_clk_c),
	SH_PFC_PIN_GROUP(scifb1_data_d),
	SH_PFC_PIN_GROUP(scifb2_data),
	SH_PFC_PIN_GROUP(scifb2_clk),
	SH_PFC_PIN_GROUP(scifb2_ctrl),
	SH_PFC_PIN_GROUP(scifb2_data_b),
	SH_PFC_PIN_GROUP(scifb2_clk_b),
	SH_PFC_PIN_GROUP(scifb2_ctrl_b),
	SH_PFC_PIN_GROUP(scifb2_data_c),
	SH_PFC_PIN_GROUP(scifb2_clk_c),
	SH_PFC_PIN_GROUP(scifb2_data_d),
	SH_PFC_PIN_GROUP(sdhi0_data1),
	SH_PFC_PIN_GROUP(sdhi0_data4),
	SH_PFC_PIN_GROUP(sdhi0_ctrl),
	SH_PFC_PIN_GROUP(sdhi0_cd),
	SH_PFC_PIN_GROUP(sdhi0_wp),
	SH_PFC_PIN_GROUP(sdhi1_data1),
	SH_PFC_PIN_GROUP(sdhi1_data4),
	SH_PFC_PIN_GROUP(sdhi1_ctrl),
	SH_PFC_PIN_GROUP(sdhi1_cd),
	SH_PFC_PIN_GROUP(sdhi1_wp),
	SH_PFC_PIN_GROUP(sdhi2_data1),
	SH_PFC_PIN_GROUP(sdhi2_data4),
	SH_PFC_PIN_GROUP(sdhi2_ctrl),
	SH_PFC_PIN_GROUP(sdhi2_cd),
	SH_PFC_PIN_GROUP(sdhi2_wp),
	SH_PFC_PIN_GROUP(ssi0_data),
	SH_PFC_PIN_GROUP(ssi0_data_b),
	SH_PFC_PIN_GROUP(ssi0129_ctrl),
	SH_PFC_PIN_GROUP(ssi0129_ctrl_b),
	SH_PFC_PIN_GROUP(ssi1_data),
	SH_PFC_PIN_GROUP(ssi1_data_b),
	SH_PFC_PIN_GROUP(ssi1_ctrl),
	SH_PFC_PIN_GROUP(ssi1_ctrl_b),
	SH_PFC_PIN_GROUP(ssi2_data),
	SH_PFC_PIN_GROUP(ssi2_ctrl),
	SH_PFC_PIN_GROUP(ssi3_data),
	SH_PFC_PIN_GROUP(ssi34_ctrl),
	SH_PFC_PIN_GROUP(ssi4_data),
	SH_PFC_PIN_GROUP(ssi4_ctrl),
	SH_PFC_PIN_GROUP(ssi5_data),
	SH_PFC_PIN_GROUP(ssi5_ctrl),
	SH_PFC_PIN_GROUP(ssi6_data),
	SH_PFC_PIN_GROUP(ssi6_ctrl),
	SH_PFC_PIN_GROUP(ssi7_data),
	SH_PFC_PIN_GROUP(ssi7_data_b),
	SH_PFC_PIN_GROUP(ssi78_ctrl),
	SH_PFC_PIN_GROUP(ssi78_ctrl_b),
	SH_PFC_PIN_GROUP(ssi8_data),
	SH_PFC_PIN_GROUP(ssi8_data_b),
	SH_PFC_PIN_GROUP(ssi9_data),
	SH_PFC_PIN_GROUP(ssi9_data_b),
	SH_PFC_PIN_GROUP(ssi9_ctrl),
	SH_PFC_PIN_GROUP(ssi9_ctrl_b),
	SH_PFC_PIN_GROUP(usb0),
	SH_PFC_PIN_GROUP(usb1),
	VIN_DATA_PIN_GROUP(vin0_data, 24),
	VIN_DATA_PIN_GROUP(vin0_data, 20),
	SH_PFC_PIN_GROUP(vin0_data18),
	VIN_DATA_PIN_GROUP(vin0_data, 16),
	VIN_DATA_PIN_GROUP(vin0_data, 12),
	VIN_DATA_PIN_GROUP(vin0_data, 10),
	VIN_DATA_PIN_GROUP(vin0_data, 8),
	SH_PFC_PIN_GROUP(vin0_sync),
	SH_PFC_PIN_GROUP(vin0_field),
	SH_PFC_PIN_GROUP(vin0_clkenb),
	SH_PFC_PIN_GROUP(vin0_clk),
	SH_PFC_PIN_GROUP(vin1_data8),
	SH_PFC_PIN_GROUP(vin1_sync),
	SH_PFC_PIN_GROUP(vin1_field),
	SH_PFC_PIN_GROUP(vin1_clkenb),
	SH_PFC_PIN_GROUP(vin1_clk),
	VIN_DATA_PIN_GROUP(vin1_b_data, 24),
	VIN_DATA_PIN_GROUP(vin1_b_data, 20),
	SH_PFC_PIN_GROUP(vin1_b_data18),
	VIN_DATA_PIN_GROUP(vin1_b_data, 16),
	VIN_DATA_PIN_GROUP(vin1_b_data, 12),
	VIN_DATA_PIN_GROUP(vin1_b_data, 10),
	VIN_DATA_PIN_GROUP(vin1_b_data, 8),
	SH_PFC_PIN_GROUP(vin1_b_sync),
	SH_PFC_PIN_GROUP(vin1_b_field),
	SH_PFC_PIN_GROUP(vin1_b_clkenb),
	SH_PFC_PIN_GROUP(vin1_b_clk),
	SH_PFC_PIN_GROUP(vin2_data8),
	SH_PFC_PIN_GROUP(vin2_sync),
	SH_PFC_PIN_GROUP(vin2_field),
	SH_PFC_PIN_GROUP(vin2_clkenb),
	SH_PFC_PIN_GROUP(vin2_clk),
};

static const char * const audio_clk_groups[] = {
	"audio_clk_a",
	"audio_clk_b",
	"audio_clk_b_b",
	"audio_clk_c",
	"audio_clkout",
};

static const char * const can0_groups[] = {
	"can0_data",
	"can0_data_b",
	"can0_data_c",
	"can0_data_d",
	"can0_data_e",
	"can0_data_f",
	"can_clk",
	"can_clk_b",
	"can_clk_c",
	"can_clk_d",
};

static const char * const can1_groups[] = {
	"can1_data",
	"can1_data_b",
	"can1_data_c",
	"can1_data_d",
	"can_clk",
	"can_clk_b",
	"can_clk_c",
	"can_clk_d",
};

static const char * const du_groups[] = {
	"du_rgb666",
	"du_rgb888",
	"du_clk_out_0",
	"du_clk_out_1",
	"du_sync",
	"du_oddf",
	"du_cde",
	"du_disp",
};

static const char * const du0_groups[] = {
	"du0_clk_in",
};

static const char * const du1_groups[] = {
	"du1_clk_in",
	"du1_clk_in_b",
	"du1_clk_in_c",
};

static const char * const eth_groups[] = {
	"eth_link",
	"eth_magic",
	"eth_mdio",
	"eth_rmii",
};

static const char * const hscif0_groups[] = {
	"hscif0_data",
	"hscif0_clk",
	"hscif0_ctrl",
	"hscif0_data_b",
	"hscif0_ctrl_b",
	"hscif0_data_c",
	"hscif0_clk_c",
};

static const char * const hscif1_groups[] = {
	"hscif1_data",
	"hscif1_clk",
	"hscif1_ctrl",
	"hscif1_data_b",
	"hscif1_data_c",
	"hscif1_clk_c",
	"hscif1_ctrl_c",
	"hscif1_data_d",
	"hscif1_data_e",
	"hscif1_clk_e",
	"hscif1_ctrl_e",
};

static const char * const hscif2_groups[] = {
	"hscif2_data",
	"hscif2_clk",
	"hscif2_ctrl",
	"hscif2_data_b",
	"hscif2_ctrl_b",
	"hscif2_data_c",
	"hscif2_clk_c",
	"hscif2_data_d",
};

static const char * const i2c0_groups[] = {
	"i2c0",
	"i2c0_b",
	"i2c0_c",
};

static const char * const i2c1_groups[] = {
	"i2c1",
	"i2c1_b",
	"i2c1_c",
	"i2c1_d",
	"i2c1_e",
};

static const char * const i2c2_groups[] = {
	"i2c2",
	"i2c2_b",
	"i2c2_c",
	"i2c2_d",
};

static const char * const i2c3_groups[] = {
	"i2c3",
	"i2c3_b",
	"i2c3_c",
	"i2c3_d",
};

static const char * const i2c4_groups[] = {
	"i2c4",
	"i2c4_b",
	"i2c4_c",
};

static const char * const i2c7_groups[] = {
	"i2c7",
	"i2c7_b",
	"i2c7_c",
};

static const char * const i2c8_groups[] = {
	"i2c8",
	"i2c8_b",
	"i2c8_c",
};

static const char * const intc_groups[] = {
	"intc_irq0",
	"intc_irq1",
	"intc_irq2",
	"intc_irq3",
};

static const char * const mlb_groups[] = {
	"mlb_3pin",
};

static const char * const mmc_groups[] = {
	"mmc_data1",
	"mmc_data4",
	"mmc_data8",
	"mmc_ctrl",
};

static const char * const msiof0_groups[] = {
	"msiof0_clk",
	"msiof0_sync",
	"msiof0_ss1",
	"msiof0_ss2",
	"msiof0_rx",
	"msiof0_tx",
	"msiof0_clk_b",
	"msiof0_sync_b",
	"msiof0_ss1_b",
	"msiof0_ss2_b",
	"msiof0_rx_b",
	"msiof0_tx_b",
	"msiof0_clk_c",
	"msiof0_sync_c",
	"msiof0_ss1_c",
	"msiof0_ss2_c",
	"msiof0_rx_c",
	"msiof0_tx_c",
};

static const char * const msiof1_groups[] = {
	"msiof1_clk",
	"msiof1_sync",
	"msiof1_ss1",
	"msiof1_ss2",
	"msiof1_rx",
	"msiof1_tx",
	"msiof1_clk_b",
	"msiof1_sync_b",
	"msiof1_ss1_b",
	"msiof1_ss2_b",
	"msiof1_rx_b",
	"msiof1_tx_b",
	"msiof1_clk_c",
	"msiof1_sync_c",
	"msiof1_rx_c",
	"msiof1_tx_c",
	"msiof1_clk_d",
	"msiof1_sync_d",
	"msiof1_ss1_d",
	"msiof1_rx_d",
	"msiof1_tx_d",
	"msiof1_clk_e",
	"msiof1_sync_e",
	"msiof1_rx_e",
	"msiof1_tx_e",
};

static const char * const msiof2_groups[] = {
	"msiof2_clk",
	"msiof2_sync",
	"msiof2_ss1",
	"msiof2_ss2",
	"msiof2_rx",
	"msiof2_tx",
	"msiof2_clk_b",
	"msiof2_sync_b",
	"msiof2_ss1_b",
	"msiof2_ss2_b",
	"msiof2_rx_b",
	"msiof2_tx_b",
	"msiof2_clk_c",
	"msiof2_sync_c",
	"msiof2_rx_c",
	"msiof2_tx_c",
	"msiof2_clk_d",
	"msiof2_sync_d",
	"msiof2_ss1_d",
	"msiof2_ss2_d",
	"msiof2_rx_d",
	"msiof2_tx_d",
	"msiof2_clk_e",
	"msiof2_sync_e",
	"msiof2_rx_e",
	"msiof2_tx_e",
};

static const char * const pwm0_groups[] = {
	"pwm0",
	"pwm0_b",
};

static const char * const pwm1_groups[] = {
	"pwm1",
	"pwm1_b",
};

static const char * const pwm2_groups[] = {
	"pwm2",
	"pwm2_b",
};

static const char * const pwm3_groups[] = {
	"pwm3",
};

static const char * const pwm4_groups[] = {
	"pwm4",
	"pwm4_b",
};

static const char * const pwm5_groups[] = {
	"pwm5",
	"pwm5_b",
};

static const char * const pwm6_groups[] = {
	"pwm6",
};

static const char * const qspi_groups[] = {
	"qspi_ctrl",
	"qspi_data2",
	"qspi_data4",
	"qspi_ctrl_b",
	"qspi_data2_b",
	"qspi_data4_b",
};

static const char * const scif0_groups[] = {
	"scif0_data",
	"scif0_data_b",
	"scif0_data_c",
	"scif0_data_d",
	"scif0_data_e",
};

static const char * const scif1_groups[] = {
	"scif1_data",
	"scif1_data_b",
	"scif1_clk_b",
	"scif1_data_c",
	"scif1_data_d",
};

static const char * const scif2_groups[] = {
	"scif2_data",
	"scif2_data_b",
	"scif2_clk_b",
	"scif2_data_c",
	"scif2_data_e",
};
static const char * const scif3_groups[] = {
	"scif3_data",
	"scif3_clk",
	"scif3_data_b",
	"scif3_clk_b",
	"scif3_data_c",
	"scif3_data_d",
};
static const char * const scif4_groups[] = {
	"scif4_data",
	"scif4_data_b",
	"scif4_data_c",
};
static const char * const scif5_groups[] = {
	"scif5_data",
	"scif5_data_b",
};
static const char * const scifa0_groups[] = {
	"scifa0_data",
	"scifa0_data_b",
};
static const char * const scifa1_groups[] = {
	"scifa1_data",
	"scifa1_clk",
	"scifa1_data_b",
	"scifa1_clk_b",
	"scifa1_data_c",
};
static const char * const scifa2_groups[] = {
	"scifa2_data",
	"scifa2_clk",
	"scifa2_data_b",
};
static const char * const scifa3_groups[] = {
	"scifa3_data",
	"scifa3_clk",
	"scifa3_data_b",
	"scifa3_clk_b",
	"scifa3_data_c",
	"scifa3_clk_c",
};
static const char * const scifa4_groups[] = {
	"scifa4_data",
	"scifa4_data_b",
	"scifa4_data_c",
};
static const char * const scifa5_groups[] = {
	"scifa5_data",
	"scifa5_data_b",
	"scifa5_data_c",
};
static const char * const scifb0_groups[] = {
	"scifb0_data",
	"scifb0_clk",
	"scifb0_ctrl",
	"scifb0_data_b",
	"scifb0_clk_b",
	"scifb0_ctrl_b",
	"scifb0_data_c",
	"scifb0_clk_c",
	"scifb0_data_d",
	"scifb0_clk_d",
};
static const char * const scifb1_groups[] = {
	"scifb1_data",
	"scifb1_clk",
	"scifb1_ctrl",
	"scifb1_data_b",
	"scifb1_clk_b",
	"scifb1_data_c",
	"scifb1_clk_c",
	"scifb1_data_d",
};
static const char * const scifb2_groups[] = {
	"scifb2_data",
	"scifb2_clk",
	"scifb2_ctrl",
	"scifb2_data_b",
	"scifb2_clk_b",
	"scifb2_ctrl_b",
	"scifb0_data_c",
	"scifb2_clk_c",
	"scifb2_data_d",
};

static const char * const sdhi0_groups[] = {
	"sdhi0_data1",
	"sdhi0_data4",
	"sdhi0_ctrl",
	"sdhi0_cd",
	"sdhi0_wp",
};

static const char * const sdhi1_groups[] = {
	"sdhi1_data1",
	"sdhi1_data4",
	"sdhi1_ctrl",
	"sdhi1_cd",
	"sdhi1_wp",
};

static const char * const sdhi2_groups[] = {
	"sdhi2_data1",
	"sdhi2_data4",
	"sdhi2_ctrl",
	"sdhi2_cd",
	"sdhi2_wp",
};

static const char * const ssi_groups[] = {
	"ssi0_data",
	"ssi0_data_b",
	"ssi0129_ctrl",
	"ssi0129_ctrl_b",
	"ssi1_data",
	"ssi1_data_b",
	"ssi1_ctrl",
	"ssi1_ctrl_b",
	"ssi2_data",
	"ssi2_ctrl",
	"ssi3_data",
	"ssi34_ctrl",
	"ssi4_data",
	"ssi4_ctrl",
	"ssi5_data",
	"ssi5_ctrl",
	"ssi6_data",
	"ssi6_ctrl",
	"ssi7_data",
	"ssi7_data_b",
	"ssi78_ctrl",
	"ssi78_ctrl_b",
	"ssi8_data",
	"ssi8_data_b",
	"ssi9_data",
	"ssi9_data_b",
	"ssi9_ctrl",
	"ssi9_ctrl_b",
};

static const char * const usb0_groups[] = {
	"usb0",
};
static const char * const usb1_groups[] = {
	"usb1",
};

static const char * const vin0_groups[] = {
	"vin0_data24",
	"vin0_data20",
	"vin0_data18",
	"vin0_data16",
	"vin0_data12",
	"vin0_data10",
	"vin0_data8",
	"vin0_sync",
	"vin0_field",
	"vin0_clkenb",
	"vin0_clk",
};

static const char * const vin1_groups[] = {
	"vin1_data8",
	"vin1_sync",
	"vin1_field",
	"vin1_clkenb",
	"vin1_clk",
	"vin1_b_data24",
	"vin1_b_data20",
	"vin1_b_data18",
	"vin1_b_data16",
	"vin1_b_data12",
	"vin1_b_data10",
	"vin1_b_data8",
	"vin1_b_sync",
	"vin1_b_field",
	"vin1_b_clkenb",
	"vin1_b_clk",
};

static const char * const vin2_groups[] = {
	"vin2_data8",
	"vin2_sync",
	"vin2_field",
	"vin2_clkenb",
	"vin2_clk",
};

static const struct sh_pfc_function pinmux_functions[] = {
	SH_PFC_FUNCTION(audio_clk),
	SH_PFC_FUNCTION(can0),
	SH_PFC_FUNCTION(can1),
	SH_PFC_FUNCTION(du),
	SH_PFC_FUNCTION(du0),
	SH_PFC_FUNCTION(du1),
	SH_PFC_FUNCTION(eth),
	SH_PFC_FUNCTION(hscif0),
	SH_PFC_FUNCTION(hscif1),
	SH_PFC_FUNCTION(hscif2),
	SH_PFC_FUNCTION(i2c0),
	SH_PFC_FUNCTION(i2c1),
	SH_PFC_FUNCTION(i2c2),
	SH_PFC_FUNCTION(i2c3),
	SH_PFC_FUNCTION(i2c4),
	SH_PFC_FUNCTION(i2c7),
	SH_PFC_FUNCTION(i2c8),
	SH_PFC_FUNCTION(intc),
	SH_PFC_FUNCTION(mlb),
	SH_PFC_FUNCTION(mmc),
	SH_PFC_FUNCTION(msiof0),
	SH_PFC_FUNCTION(msiof1),
	SH_PFC_FUNCTION(msiof2),
	SH_PFC_FUNCTION(pwm0),
	SH_PFC_FUNCTION(pwm1),
	SH_PFC_FUNCTION(pwm2),
	SH_PFC_FUNCTION(pwm3),
	SH_PFC_FUNCTION(pwm4),
	SH_PFC_FUNCTION(pwm5),
	SH_PFC_FUNCTION(pwm6),
	SH_PFC_FUNCTION(qspi),
	SH_PFC_FUNCTION(scif0),
	SH_PFC_FUNCTION(scif1),
	SH_PFC_FUNCTION(scif2),
	SH_PFC_FUNCTION(scif3),
	SH_PFC_FUNCTION(scif4),
	SH_PFC_FUNCTION(scif5),
	SH_PFC_FUNCTION(scifa0),
	SH_PFC_FUNCTION(scifa1),
	SH_PFC_FUNCTION(scifa2),
	SH_PFC_FUNCTION(scifa3),
	SH_PFC_FUNCTION(scifa4),
	SH_PFC_FUNCTION(scifa5),
	SH_PFC_FUNCTION(scifb0),
	SH_PFC_FUNCTION(scifb1),
	SH_PFC_FUNCTION(scifb2),
	SH_PFC_FUNCTION(sdhi0),
	SH_PFC_FUNCTION(sdhi1),
	SH_PFC_FUNCTION(sdhi2),
	SH_PFC_FUNCTION(ssi),
	SH_PFC_FUNCTION(usb0),
	SH_PFC_FUNCTION(usb1),
	SH_PFC_FUNCTION(vin0),
	SH_PFC_FUNCTION(vin1),
	SH_PFC_FUNCTION(vin2),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("GPSR0", 0xE6060004, 32, 1) {
		GP_0_31_FN, FN_IP1_22_20,
		GP_0_30_FN, FN_IP1_19_17,
		GP_0_29_FN, FN_IP1_16_14,
		GP_0_28_FN, FN_IP1_13_11,
		GP_0_27_FN, FN_IP1_10_8,
		GP_0_26_FN, FN_IP1_7_6,
		GP_0_25_FN, FN_IP1_5_4,
		GP_0_24_FN, FN_IP1_3_2,
		GP_0_23_FN, FN_IP1_1_0,
		GP_0_22_FN, FN_IP0_30_29,
		GP_0_21_FN, FN_IP0_28_27,
		GP_0_20_FN, FN_IP0_26_25,
		GP_0_19_FN, FN_IP0_24_23,
		GP_0_18_FN, FN_IP0_22_21,
		GP_0_17_FN, FN_IP0_20_19,
		GP_0_16_FN, FN_IP0_18_16,
		GP_0_15_FN, FN_IP0_15,
		GP_0_14_FN, FN_IP0_14,
		GP_0_13_FN, FN_IP0_13,
		GP_0_12_FN, FN_IP0_12,
		GP_0_11_FN, FN_IP0_11,
		GP_0_10_FN, FN_IP0_10,
		GP_0_9_FN, FN_IP0_9,
		GP_0_8_FN, FN_IP0_8,
		GP_0_7_FN, FN_IP0_7,
		GP_0_6_FN, FN_IP0_6,
		GP_0_5_FN, FN_IP0_5,
		GP_0_4_FN, FN_IP0_4,
		GP_0_3_FN, FN_IP0_3,
		GP_0_2_FN, FN_IP0_2,
		GP_0_1_FN, FN_IP0_1,
		GP_0_0_FN, FN_IP0_0, }
	},
	{ PINMUX_CFG_REG("GPSR1", 0xE6060008, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_1_25_FN, FN_IP3_21_20,
		GP_1_24_FN, FN_IP3_19_18,
		GP_1_23_FN, FN_IP3_17_16,
		GP_1_22_FN, FN_IP3_15_14,
		GP_1_21_FN, FN_IP3_13_12,
		GP_1_20_FN, FN_IP3_11_9,
		GP_1_19_FN, FN_RD_N,
		GP_1_18_FN, FN_IP3_8_6,
		GP_1_17_FN, FN_IP3_5_3,
		GP_1_16_FN, FN_IP3_2_0,
		GP_1_15_FN, FN_IP2_29_27,
		GP_1_14_FN, FN_IP2_26_25,
		GP_1_13_FN, FN_IP2_24_23,
		GP_1_12_FN, FN_EX_CS0_N,
		GP_1_11_FN, FN_IP2_22_21,
		GP_1_10_FN, FN_IP2_20_19,
		GP_1_9_FN, FN_IP2_18_16,
		GP_1_8_FN, FN_IP2_15_13,
		GP_1_7_FN, FN_IP2_12_10,
		GP_1_6_FN, FN_IP2_9_7,
		GP_1_5_FN, FN_IP2_6_5,
		GP_1_4_FN, FN_IP2_4_3,
		GP_1_3_FN, FN_IP2_2_0,
		GP_1_2_FN, FN_IP1_31_29,
		GP_1_1_FN, FN_IP1_28_26,
		GP_1_0_FN, FN_IP1_25_23, }
	},
	{ PINMUX_CFG_REG("GPSR2", 0xE606000C, 32, 1) {
		GP_2_31_FN, FN_IP6_7_6,
		GP_2_30_FN, FN_IP6_5_3,
		GP_2_29_FN, FN_IP6_2_0,
		GP_2_28_FN, FN_AUDIO_CLKA,
		GP_2_27_FN, FN_IP5_31_29,
		GP_2_26_FN, FN_IP5_28_26,
		GP_2_25_FN, FN_IP5_25_24,
		GP_2_24_FN, FN_IP5_23_22,
		GP_2_23_FN, FN_IP5_21_20,
		GP_2_22_FN, FN_IP5_19_17,
		GP_2_21_FN, FN_IP5_16_15,
		GP_2_20_FN, FN_IP5_14_12,
		GP_2_19_FN, FN_IP5_11_9,
		GP_2_18_FN, FN_IP5_8_6,
		GP_2_17_FN, FN_IP5_5_3,
		GP_2_16_FN, FN_IP5_2_0,
		GP_2_15_FN, FN_IP4_30_28,
		GP_2_14_FN, FN_IP4_27_26,
		GP_2_13_FN, FN_IP4_25_24,
		GP_2_12_FN, FN_IP4_23_22,
		GP_2_11_FN, FN_IP4_21,
		GP_2_10_FN, FN_IP4_20,
		GP_2_9_FN, FN_IP4_19,
		GP_2_8_FN, FN_IP4_18_16,
		GP_2_7_FN, FN_IP4_15_13,
		GP_2_6_FN, FN_IP4_12_10,
		GP_2_5_FN, FN_IP4_9_8,
		GP_2_4_FN, FN_IP4_7_5,
		GP_2_3_FN, FN_IP4_4_2,
		GP_2_2_FN, FN_IP4_1_0,
		GP_2_1_FN, FN_IP3_30_28,
		GP_2_0_FN, FN_IP3_27_25 }
	},
	{ PINMUX_CFG_REG("GPSR3", 0xE6060010, 32, 1) {
		GP_3_31_FN, FN_IP9_18_17,
		GP_3_30_FN, FN_IP9_16,
		GP_3_29_FN, FN_IP9_15_13,
		GP_3_28_FN, FN_IP9_12,
		GP_3_27_FN, FN_IP9_11,
		GP_3_26_FN, FN_IP9_10_8,
		GP_3_25_FN, FN_IP9_7,
		GP_3_24_FN, FN_IP9_6,
		GP_3_23_FN, FN_IP9_5_3,
		GP_3_22_FN, FN_IP9_2_0,
		GP_3_21_FN, FN_IP8_30_28,
		GP_3_20_FN, FN_IP8_27_26,
		GP_3_19_FN, FN_IP8_25_24,
		GP_3_18_FN, FN_IP8_23_21,
		GP_3_17_FN, FN_IP8_20_18,
		GP_3_16_FN, FN_IP8_17_15,
		GP_3_15_FN, FN_IP8_14_12,
		GP_3_14_FN, FN_IP8_11_9,
		GP_3_13_FN, FN_IP8_8_6,
		GP_3_12_FN, FN_IP8_5_3,
		GP_3_11_FN, FN_IP8_2_0,
		GP_3_10_FN, FN_IP7_29_27,
		GP_3_9_FN, FN_IP7_26_24,
		GP_3_8_FN, FN_IP7_23_21,
		GP_3_7_FN, FN_IP7_20_19,
		GP_3_6_FN, FN_IP7_18_17,
		GP_3_5_FN, FN_IP7_16_15,
		GP_3_4_FN, FN_IP7_14_13,
		GP_3_3_FN, FN_IP7_12_11,
		GP_3_2_FN, FN_IP7_10_9,
		GP_3_1_FN, FN_IP7_8_6,
		GP_3_0_FN, FN_IP7_5_3 }
	},
	{ PINMUX_CFG_REG("GPSR4", 0xE6060014, 32, 1) {
		GP_4_31_FN, FN_IP15_5_4,
		GP_4_30_FN, FN_IP15_3_2,
		GP_4_29_FN, FN_IP15_1_0,
		GP_4_28_FN, FN_IP11_8_6,
		GP_4_27_FN, FN_IP11_5_3,
		GP_4_26_FN, FN_IP11_2_0,
		GP_4_25_FN, FN_IP10_31_29,
		GP_4_24_FN, FN_IP10_28_27,
		GP_4_23_FN, FN_IP10_26_25,
		GP_4_22_FN, FN_IP10_24_22,
		GP_4_21_FN, FN_IP10_21_19,
		GP_4_20_FN, FN_IP10_18_17,
		GP_4_19_FN, FN_IP10_16_15,
		GP_4_18_FN, FN_IP10_14_12,
		GP_4_17_FN, FN_IP10_11_9,
		GP_4_16_FN, FN_IP10_8_6,
		GP_4_15_FN, FN_IP10_5_3,
		GP_4_14_FN, FN_IP10_2_0,
		GP_4_13_FN, FN_IP9_31_29,
		GP_4_12_FN, FN_VI0_DATA7_VI0_B7,
		GP_4_11_FN, FN_VI0_DATA6_VI0_B6,
		GP_4_10_FN, FN_VI0_DATA5_VI0_B5,
		GP_4_9_FN, FN_VI0_DATA4_VI0_B4,
		GP_4_8_FN, FN_IP9_28_27,
		GP_4_7_FN, FN_VI0_DATA2_VI0_B2,
		GP_4_6_FN, FN_VI0_DATA1_VI0_B1,
		GP_4_5_FN, FN_VI0_DATA0_VI0_B0,
		GP_4_4_FN, FN_IP9_26_25,
		GP_4_3_FN, FN_IP9_24_23,
		GP_4_2_FN, FN_IP9_22_21,
		GP_4_1_FN, FN_IP9_20_19,
		GP_4_0_FN, FN_VI0_CLK }
	},
	{ PINMUX_CFG_REG("GPSR5", 0xE6060018, 32, 1) {
		GP_5_31_FN, FN_IP3_24_22,
		GP_5_30_FN, FN_IP13_9_7,
		GP_5_29_FN, FN_IP13_6_5,
		GP_5_28_FN, FN_IP13_4_3,
		GP_5_27_FN, FN_IP13_2_0,
		GP_5_26_FN, FN_IP12_29_27,
		GP_5_25_FN, FN_IP12_26_24,
		GP_5_24_FN, FN_IP12_23_22,
		GP_5_23_FN, FN_IP12_21_20,
		GP_5_22_FN, FN_IP12_19_18,
		GP_5_21_FN, FN_IP12_17_16,
		GP_5_20_FN, FN_IP12_15_13,
		GP_5_19_FN, FN_IP12_12_10,
		GP_5_18_FN, FN_IP12_9_7,
		GP_5_17_FN, FN_IP12_6_4,
		GP_5_16_FN, FN_IP12_3_2,
		GP_5_15_FN, FN_IP12_1_0,
		GP_5_14_FN, FN_IP11_31_30,
		GP_5_13_FN, FN_IP11_29_28,
		GP_5_12_FN, FN_IP11_27,
		GP_5_11_FN, FN_IP11_26,
		GP_5_10_FN, FN_IP11_25,
		GP_5_9_FN, FN_IP11_24,
		GP_5_8_FN, FN_IP11_23,
		GP_5_7_FN, FN_IP11_22,
		GP_5_6_FN, FN_IP11_21,
		GP_5_5_FN, FN_IP11_20,
		GP_5_4_FN, FN_IP11_19,
		GP_5_3_FN, FN_IP11_18_17,
		GP_5_2_FN, FN_IP11_16_15,
		GP_5_1_FN, FN_IP11_14_12,
		GP_5_0_FN, FN_IP11_11_9 }
	},
	{ PINMUX_CFG_REG("GPSR6", 0xE606001C, 32, 1) {
		GP_6_31_FN, FN_DU0_DOTCLKIN,
		GP_6_30_FN, FN_USB1_OVC,
		GP_6_29_FN, FN_IP14_31_29,
		GP_6_28_FN, FN_IP14_28_26,
		GP_6_27_FN, FN_IP14_25_23,
		GP_6_26_FN, FN_IP14_22_20,
		GP_6_25_FN, FN_IP14_19_17,
		GP_6_24_FN, FN_IP14_16_14,
		GP_6_23_FN, FN_IP14_13_11,
		GP_6_22_FN, FN_IP14_10_8,
		GP_6_21_FN, FN_IP14_7,
		GP_6_20_FN, FN_IP14_6,
		GP_6_19_FN, FN_IP14_5,
		GP_6_18_FN, FN_IP14_4,
		GP_6_17_FN, FN_IP14_3,
		GP_6_16_FN, FN_IP14_2,
		GP_6_15_FN, FN_IP14_1_0,
		GP_6_14_FN, FN_IP13_30_28,
		GP_6_13_FN, FN_IP13_27,
		GP_6_12_FN, FN_IP13_26,
		GP_6_11_FN, FN_IP13_25,
		GP_6_10_FN, FN_IP13_24_23,
		GP_6_9_FN, FN_IP13_22,
		GP_6_8_FN, FN_SD1_CLK,
		GP_6_7_FN, FN_IP13_21_19,
		GP_6_6_FN, FN_IP13_18_16,
		GP_6_5_FN, FN_IP13_15,
		GP_6_4_FN, FN_IP13_14,
		GP_6_3_FN, FN_IP13_13,
		GP_6_2_FN, FN_IP13_12,
		GP_6_1_FN, FN_IP13_11,
		GP_6_0_FN, FN_IP13_10 }
	},
	{ PINMUX_CFG_REG("GPSR7", 0xE6060074, 32, 1) {
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		0, 0,
		GP_7_25_FN, FN_USB1_PWEN,
		GP_7_24_FN, FN_USB0_OVC,
		GP_7_23_FN, FN_USB0_PWEN,
		GP_7_22_FN, FN_IP15_14_12,
		GP_7_21_FN, FN_IP15_11_9,
		GP_7_20_FN, FN_IP15_8_6,
		GP_7_19_FN, FN_IP7_2_0,
		GP_7_18_FN, FN_IP6_29_27,
		GP_7_17_FN, FN_IP6_26_24,
		GP_7_16_FN, FN_IP6_23_21,
		GP_7_15_FN, FN_IP6_20_19,
		GP_7_14_FN, FN_IP6_18_16,
		GP_7_13_FN, FN_IP6_15_14,
		GP_7_12_FN, FN_IP6_13_12,
		GP_7_11_FN, FN_IP6_11_10,
		GP_7_10_FN, FN_IP6_9_8,
		GP_7_9_FN, FN_IP16_11_10,
		GP_7_8_FN, FN_IP16_9_8,
		GP_7_7_FN, FN_IP16_7_6,
		GP_7_6_FN, FN_IP16_5_3,
		GP_7_5_FN, FN_IP16_2_0,
		GP_7_4_FN, FN_IP15_29_27,
		GP_7_3_FN, FN_IP15_26_24,
		GP_7_2_FN, FN_IP15_23_21,
		GP_7_1_FN, FN_IP15_20_18,
		GP_7_0_FN, FN_IP15_17_15 }
	},
	{ PINMUX_CFG_REG_VAR("IPSR0", 0xE6060020, 32,
			     1, 2, 2, 2, 2, 2, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1,
			     1, 1, 1, 1, 1, 1, 1, 1) {
		/* IP0_31 [1] */
		0, 0,
		/* IP0_30_29 [2] */
		FN_A6, FN_MSIOF1_SCK,
		0, 0,
		/* IP0_28_27 [2] */
		FN_A5, FN_MSIOF0_RXD_B,
		0, 0,
		/* IP0_26_25 [2] */
		FN_A4, FN_MSIOF0_TXD_B,
		0, 0,
		/* IP0_24_23 [2] */
		FN_A3, FN_MSIOF0_SS2_B,
		0, 0,
		/* IP0_22_21 [2] */
		FN_A2, FN_MSIOF0_SS1_B,
		0, 0,
		/* IP0_20_19 [2] */
		FN_A1, FN_MSIOF0_SYNC_B,
		0, 0,
		/* IP0_18_16 [3] */
		FN_A0, FN_ATAWR0_N_C, FN_MSIOF0_SCK_B, FN_SCL0_C, FN_PWM2_B,
		0, 0, 0,
		/* IP0_15 [1] */
		FN_D15, 0,
		/* IP0_14 [1] */
		FN_D14, 0,
		/* IP0_13 [1] */
		FN_D13, 0,
		/* IP0_12 [1] */
		FN_D12, 0,
		/* IP0_11 [1] */
		FN_D11, 0,
		/* IP0_10 [1] */
		FN_D10, 0,
		/* IP0_9 [1] */
		FN_D9, 0,
		/* IP0_8 [1] */
		FN_D8, 0,
		/* IP0_7 [1] */
		FN_D7, 0,
		/* IP0_6 [1] */
		FN_D6, 0,
		/* IP0_5 [1] */
		FN_D5, 0,
		/* IP0_4 [1] */
		FN_D4, 0,
		/* IP0_3 [1] */
		FN_D3, 0,
		/* IP0_2 [1] */
		FN_D2, 0,
		/* IP0_1 [1] */
		FN_D1, 0,
		/* IP0_0 [1] */
		FN_D0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR1", 0xE6060024, 32,
			     3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2, 2) {
		/* IP1_31_29 [3] */
		FN_A18, FN_DREQ1, FN_SCIFA1_RXD_C, 0, FN_SCIFB1_RXD_C,
		0, 0, 0,
		/* IP1_28_26 [3] */
		FN_A17, FN_DACK2_B, 0, FN_SDA0_C,
		0, 0, 0, 0,
		/* IP1_25_23 [3] */
		FN_A16, FN_DREQ2_B, FN_FMCLK_C, 0, FN_SCIFA1_SCK_B,
		0, 0, 0,
		/* IP1_22_20 [3] */
		FN_A15, FN_BPFCLK_C,
		0, 0, 0, 0, 0, 0,
		/* IP1_19_17 [3] */
		FN_A14, FN_ATADIR0_N_C, FN_FMIN, FN_FMIN_C, FN_MSIOF1_SYNC_D,
		0, 0, 0,
		/* IP1_16_14 [3] */
		FN_A13, FN_ATAG0_N_C, FN_BPFCLK, FN_MSIOF1_SS1_D,
		0, 0, 0, 0,
		/* IP1_13_11 [3] */
		FN_A12, FN_FMCLK, FN_SDA3_D, FN_MSIOF1_SCK_D,
		0, 0, 0, 0,
		/* IP1_10_8 [3] */
		FN_A11, FN_MSIOF1_RXD, FN_SCL3_D, FN_MSIOF1_RXD_D,
		0, 0, 0, 0,
		/* IP1_7_6 [2] */
		FN_A10, FN_MSIOF1_TXD, 0, FN_MSIOF1_TXD_D,
		/* IP1_5_4 [2] */
		FN_A9, FN_MSIOF1_SS2, FN_SDA0, 0,
		/* IP1_3_2 [2] */
		FN_A8, FN_MSIOF1_SS1, FN_SCL0, 0,
		/* IP1_1_0 [2] */
		FN_A7, FN_MSIOF1_SYNC,
		0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR2", 0xE6060028, 32,
			     2, 3, 2, 2, 2, 2, 3, 3, 3, 3, 2, 2, 3) {
		/* IP2_31_20 [2] */
		0, 0, 0, 0,
		/* IP2_29_27 [3] */
		FN_EX_CS3_N, FN_ATADIR0_N, FN_MSIOF2_TXD,
		FN_ATAG0_N, 0, FN_EX_WAIT1,
		0, 0,
		/* IP2_26_25 [2] */
		FN_EX_CS2_N, FN_ATAWR0_N, FN_MSIOF2_SYNC, 0,
		/* IP2_24_23 [2] */
		FN_EX_CS1_N, FN_MSIOF2_SCK, 0, 0,
		/* IP2_22_21 [2] */
		FN_CS1_N_A26, FN_ATADIR0_N_B, FN_SDA1, 0,
		/* IP2_20_19 [2] */
		FN_CS0_N, FN_ATAG0_N_B, FN_SCL1, 0,
		/* IP2_18_16 [3] */
		FN_A25, FN_DACK2, FN_SSL, FN_DREQ1_C, FN_RX1, FN_SCIFA1_RXD,
		0, 0,
		/* IP2_15_13 [3] */
		FN_A24, FN_DREQ2, FN_IO3, FN_TX1, FN_SCIFA1_TXD,
		0, 0, 0,
		/* IP2_12_0 [3] */
		FN_A23, FN_IO2, FN_BPFCLK_B, FN_RX0, FN_SCIFA0_RXD,
		0, 0, 0,
		/* IP2_9_7 [3] */
		FN_A22, FN_MISO_IO1, FN_FMCLK_B, FN_TX0, FN_SCIFA0_TXD,
		0, 0, 0,
		/* IP2_6_5 [2] */
		FN_A21, FN_ATAWR0_N_B, FN_MOSI_IO0, 0,
		/* IP2_4_3 [2] */
		FN_A20, FN_SPCLK, 0, 0,
		/* IP2_2_0 [3] */
		FN_A19, FN_DACK1, FN_SCIFA1_TXD_C, 0,
		FN_SCIFB1_TXD_C, 0, FN_SCIFB1_SCK_B, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR3", 0xE606002C, 32,
			     1, 3, 3, 3, 2, 2, 2, 2, 2, 3, 3, 3, 3) {
		/* IP3_31 [1] */
		0, 0,
		/* IP3_30_28 [3] */
		FN_SSI_WS0129, FN_HTX0_C, FN_HTX2_C,
		FN_SCIFB0_TXD_C, FN_SCIFB2_TXD_C,
		0, 0, 0,
		/* IP3_27_25 [3] */
		FN_SSI_SCK0129, FN_HRX0_C, FN_HRX2_C,
		FN_SCIFB0_RXD_C, FN_SCIFB2_RXD_C,
		0, 0, 0,
		/* IP3_24_22 [3] */
		FN_SPEEDIN, 0, FN_HSCK0_C, FN_HSCK2_C, FN_SCIFB0_SCK_B,
		FN_SCIFB2_SCK_B, FN_DREQ2_C, FN_HTX2_D,
		/* IP3_21_20 [2] */
		FN_DACK0, FN_DRACK0, FN_REMOCON, 0,
		/* IP3_19_18 [2] */
		FN_DREQ0, FN_PWM3, FN_TPU_TO3, 0,
		/* IP3_17_16 [2] */
		FN_EX_WAIT0, FN_HRTS2_N_B, FN_SCIFB0_CTS_N_B, 0,
		/* IP3_15_14 [2] */
		FN_WE1_N, FN_ATARD0_N_B, FN_HTX2_B, FN_SCIFB0_RTS_N_B,
		/* IP3_13_12 [2] */
		FN_WE0_N, FN_HCTS2_N_B, FN_SCIFB0_TXD_B, 0,
		/* IP3_11_9 [3] */
		FN_RD_WR_N, FN_HRX2_B, FN_FMIN_B, FN_SCIFB0_RXD_B, FN_DREQ1_D,
		0, 0, 0,
		/* IP3_8_6 [3] */
		FN_BS_N, FN_ATACS10_N, FN_MSIOF2_SS2, FN_HTX1_B,
		FN_SCIFB1_TXD_B, FN_PWM2, FN_TPU_TO2, 0,
		/* IP3_5_3 [3] */
		FN_EX_CS5_N, FN_ATACS00_N, FN_MSIOF2_SS1, FN_HRX1_B,
		FN_SCIFB1_RXD_B, FN_PWM1, FN_TPU_TO1, 0,
		/* IP3_2_0 [3] */
		FN_EX_CS4_N, FN_ATARD0_N, FN_MSIOF2_RXD, 0, FN_EX_WAIT2,
		0, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR4", 0xE6060030, 32,
			     1, 3, 2, 2, 2, 1, 1, 1, 3, 3, 3, 2, 3, 3, 2) {
		/* IP4_31 [1] */
		0, 0,
		/* IP4_30_28 [3] */
		FN_SSI_SCK5, FN_MSIOF1_SCK_C, FN_TS_SDATA0, FN_GLO_I0,
		FN_MSIOF2_SYNC_D, FN_VI1_R2_B,
		0, 0,
		/* IP4_27_26 [2] */
		FN_SSI_SDATA4, FN_MSIOF2_SCK_D, 0, 0,
		/* IP4_25_24 [2] */
		FN_SSI_WS4, FN_GLO_RFON_D, 0, 0,
		/* IP4_23_22 [2] */
		FN_SSI_SCK4, FN_GLO_SS_D, 0, 0,
		/* IP4_21 [1] */
		FN_SSI_SDATA3, 0,
		/* IP4_20 [1] */
		FN_SSI_WS34, 0,
		/* IP4_19 [1] */
		FN_SSI_SCK34, 0,
		/* IP4_18_16 [3] */
		FN_SSI_SDATA2, FN_GPS_MAG_B, FN_TX2_E, FN_HRTS1_N_E,
		0, 0, 0, 0,
		/* IP4_15_13 [3] */
		FN_SSI_WS2, FN_SDA2, FN_GPS_SIGN_B, FN_RX2_E,
		FN_GLO_Q1_D, FN_HCTS1_N_E,
		0, 0,
		/* IP4_12_10 [3] */
		FN_SSI_SCK2, FN_SCL2, FN_GPS_CLK_B, FN_GLO_Q0_D, FN_HSCK1_E,
		0, 0, 0,
		/* IP4_9_8 [2] */
		FN_SSI_SDATA1, FN_SDA1_B, FN_SDA8_B, FN_MSIOF2_RXD_C,
		/* IP4_7_5 [3] */
		FN_SSI_WS1, FN_SCL1_B, FN_SCL8_B, FN_MSIOF2_TXD_C, FN_GLO_I1_D,
		0, 0, 0,
		/* IP4_4_2 [3] */
		FN_SSI_SCK1, FN_SDA0_B, FN_SDA7_B,
		FN_MSIOF2_SYNC_C, FN_GLO_I0_D,
		0, 0, 0,
		/* IP4_1_0 [2] */
		FN_SSI_SDATA0, FN_SCL0_B, FN_SCL7_B, FN_MSIOF2_SCK_C, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR5", 0xE6060034, 32,
			     3, 3, 2, 2, 2, 3, 2, 3, 3, 3, 3, 3) {
		/* IP5_31_29 [3] */
		FN_SSI_SDATA9, FN_RX3_D, FN_CAN0_RX_D,
		0, 0, 0, 0, 0,
		/* IP5_28_26 [3] */
		FN_SSI_WS9, FN_TX3_D, FN_CAN0_TX_D, FN_GLO_SDATA_D,
		0, 0, 0, 0,
		/* IP5_25_24 [2] */
		FN_SSI_SCK9, FN_RX1_D, FN_GLO_SCLK_D, 0,
		/* IP5_23_22 [2] */
		FN_SSI_SDATA8, FN_TX1_D, FN_STP_ISSYNC_0_B, 0,
		/* IP5_21_20 [2] */
		FN_SSI_SDATA7, FN_RX0_D, FN_STP_ISEN_0_B, 0,
		/* IP5_19_17 [3] */
		FN_SSI_WS78, FN_TX0_D, FN_STP_ISD_0_B, FN_GLO_RFON,
		0, 0, 0, 0,
		/* IP5_16_15 [2] */
		FN_SSI_SCK78, FN_STP_ISCLK_0_B, FN_GLO_SS, 0,
		/* IP5_14_12 [3] */
		FN_SSI_SDATA6, FN_STP_IVCXO27_0_B, FN_GLO_SDATA, FN_VI1_R7_B,
		0, 0, 0, 0,
		/* IP5_11_9 [3] */
		FN_SSI_WS6, FN_GLO_SCLK, FN_MSIOF2_SS2_D, FN_VI1_R6_B,
		0, 0, 0, 0,
		/* IP5_8_6 [3] */
		FN_SSI_SCK6, FN_MSIOF1_RXD_C, FN_TS_SPSYNC0, FN_GLO_Q1,
		FN_MSIOF2_RXD_D, FN_VI1_R5_B,
		0, 0,
		/* IP5_5_3 [3] */
		FN_SSI_SDATA5, FN_MSIOF1_TXD_C, FN_TS_SDEN0, FN_GLO_Q0,
		FN_MSIOF2_SS1_D, FN_VI1_R4_B,
		0, 0,
		/* IP5_2_0 [3] */
		FN_SSI_WS5, FN_MSIOF1_SYNC_C, FN_TS_SCK0, FN_GLO_I1,
		FN_MSIOF2_TXD_D, FN_VI1_R3_B,
		0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR6", 0xE6060038, 32,
			     2, 3, 3, 3, 2, 3, 2, 2, 2, 2, 2, 3, 3) {
		/* IP6_31_30 [2] */
		0, 0, 0, 0,
		/* IP6_29_27 [3] */
		FN_IRQ8, FN_HRTS1_N_C, FN_MSIOF1_RXD_B,
		FN_GPS_SIGN_C, FN_GPS_SIGN_D,
		0, 0, 0,
		/* IP6_26_24 [3] */
		FN_IRQ7, FN_HCTS1_N_C, FN_MSIOF1_TXD_B,
		FN_GPS_CLK_C, FN_GPS_CLK_D,
		0, 0, 0,
		/* IP6_23_21 [3] */
		FN_IRQ6, FN_HSCK1_C, FN_MSIOF1_SS2_B,
		FN_SDA1_E, FN_MSIOF2_SYNC_E,
		0, 0, 0,
		/* IP6_20_19 [2] */
		FN_IRQ5, FN_HTX1_C, FN_SCL1_E, FN_MSIOF2_SCK_E,
		/* IP6_18_16 [3] */
		FN_IRQ4, FN_HRX1_C, FN_SDA4_C, FN_MSIOF2_RXD_E, FN_INTC_IRQ4_N,
		0, 0, 0,
		/* IP6_15_14 [2] */
		FN_IRQ3, FN_SCL4_C, FN_MSIOF2_TXD_E, FN_INTC_IRQ3_N,
		/* IP6_13_12 [2] */
		FN_IRQ2, FN_SCIFB1_TXD_D, FN_INTC_IRQ2_N, 0,
		/* IP6_11_10 [2] */
		FN_IRQ1, FN_SCIFB1_SCK_C, FN_INTC_IRQ1_N, 0,
		/* IP6_9_8 [2] */
		FN_IRQ0, FN_SCIFB1_RXD_D, FN_INTC_IRQ0_N, 0,
		/* IP6_7_6 [2] */
		FN_AUDIO_CLKOUT, FN_MSIOF1_SS1_B, FN_TX2, FN_SCIFA2_TXD,
		/* IP6_5_3 [3] */
		FN_AUDIO_CLKC, FN_SCIFB0_SCK_C, FN_MSIOF1_SYNC_B, FN_RX2,
		FN_SCIFA2_RXD, FN_FMIN_E,
		0, 0,
		/* IP6_2_0 [3] */
		FN_AUDIO_CLKB, FN_STP_OPWM_0_B, FN_MSIOF1_SCK_B,
		FN_SCIF_CLK, 0, FN_BPFCLK_E,
		0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR7", 0xE606003C, 32,
			     2, 3, 3, 3, 2, 2, 2, 2, 2, 2, 3, 3, 3) {
		/* IP7_31_30 [2] */
		0, 0, 0, 0,
		/* IP7_29_27 [3] */
		FN_DU1_DG2, FN_LCDOUT10, FN_VI1_DATA4_B, FN_SCIF1_SCK_B,
		FN_SCIFA1_SCK, FN_SSI_SCK78_B,
		0, 0,
		/* IP7_26_24 [3] */
		FN_DU1_DG1, FN_LCDOUT9, FN_VI1_DATA3_B, FN_RX1_B,
		FN_SCIFA1_RXD_B, FN_MSIOF2_SS2_B,
		0, 0,
		/* IP7_23_21 [3] */
		FN_DU1_DG0, FN_LCDOUT8, FN_VI1_DATA2_B, FN_TX1_B,
		FN_SCIFA1_TXD_B, FN_MSIOF2_SS1_B,
		0, 0,
		/* IP7_20_19 [2] */
		FN_DU1_DR7, FN_LCDOUT7, FN_SSI_SDATA1_B, 0,
		/* IP7_18_17 [2] */
		FN_DU1_DR6, FN_LCDOUT6, FN_SSI_WS1_B, 0,
		/* IP7_16_15 [2] */
		FN_DU1_DR5, FN_LCDOUT5, FN_SSI_SCK1_B, 0,
		/* IP7_14_13 [2] */
		FN_DU1_DR4, FN_LCDOUT4, FN_SSI_SDATA0_B, 0,
		/* IP7_12_11 [2] */
		FN_DU1_DR3, FN_LCDOUT3, FN_SSI_WS0129_B, 0,
		/* IP7_10_9 [2] */
		FN_DU1_DR2, FN_LCDOUT2, FN_SSI_SCK0129_B, 0,
		/* IP7_8_6 [3] */
		FN_DU1_DR1, FN_LCDOUT1, FN_VI1_DATA1_B, FN_RX0_B,
		FN_SCIFA0_RXD_B, FN_MSIOF2_SYNC_B,
		0, 0,
		/* IP7_5_3 [3] */
		FN_DU1_DR0, FN_LCDOUT0, FN_VI1_DATA0_B, FN_TX0_B,
		FN_SCIFA0_TXD_B, FN_MSIOF2_SCK_B,
		0, 0,
		/* IP7_2_0 [3] */
		FN_IRQ9, FN_DU1_DOTCLKIN_B, FN_CAN_CLK_D, FN_GPS_MAG_C,
		FN_SCIF_CLK_B, FN_GPS_MAG_D,
		0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR8", 0xE6060040, 32,
			     1, 3, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3) {
		/* IP8_31 [1] */
		0, 0,
		/* IP8_30_28 [3] */
		FN_DU1_DB5, FN_LCDOUT21, FN_TX3, FN_SCIFA3_TXD, FN_CAN1_TX,
		0, 0, 0,
		/* IP8_27_26 [2] */
		FN_DU1_DB4, FN_LCDOUT20, FN_VI1_FIELD_B, FN_CAN1_RX,
		/* IP8_25_24 [2] */
		FN_DU1_DB3, FN_LCDOUT19, FN_VI1_CLKENB_B, 0,
		/* IP8_23_21 [3] */
		FN_DU1_DB2, FN_LCDOUT18, FN_VI1_VSYNC_N_B, FN_SCIF2_SCK_B,
		FN_SCIFA2_SCK, FN_SSI_SDATA9_B,
		0, 0,
		/* IP8_20_18 [3] */
		FN_DU1_DB1, FN_LCDOUT17, FN_VI1_HSYNC_N_B, FN_RX2_B,
		FN_SCIFA2_RXD_B, FN_MSIOF2_RXD_B,
		0, 0,
		/* IP8_17_15 [3] */
		FN_DU1_DB0, FN_LCDOUT16, FN_VI1_CLK_B, FN_TX2_B,
		FN_SCIFA2_TXD_B, FN_MSIOF2_TXD_B,
		0, 0,
		/* IP8_14_12 [3] */
		FN_DU1_DG7, FN_LCDOUT15, FN_HTX0_B,
		FN_SCIFB2_RTS_N_B, FN_SSI_WS9_B,
		0, 0, 0,
		/* IP8_11_9 [3] */
		FN_DU1_DG6, FN_LCDOUT14, FN_HRTS0_N_B,
		FN_SCIFB2_CTS_N_B, FN_SSI_SCK9_B,
		0, 0, 0,
		/* IP8_8_6 [3] */
		FN_DU1_DG5, FN_LCDOUT13, FN_VI1_DATA7_B, FN_HCTS0_N_B,
		FN_SCIFB2_TXD_B, FN_SSI_SDATA8_B,
		0, 0,
		/* IP8_5_3 [3] */
		FN_DU1_DG4, FN_LCDOUT12, FN_VI1_DATA6_B, FN_HRX0_B,
		FN_SCIFB2_RXD_B, FN_SSI_SDATA7_B,
		0, 0,
		/* IP8_2_0 [3] */
		FN_DU1_DG3, FN_LCDOUT11, FN_VI1_DATA5_B, 0, FN_SSI_WS78_B,
		0, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR9", 0xE6060044, 32,
			     3, 2, 2, 2, 2, 2, 2, 1, 3, 1, 1, 3, 1, 1, 3, 3) {
		/* IP9_31_29 [3] */
		FN_VI0_G0, FN_SCL8, FN_STP_IVCXO27_0_C, FN_SCL4,
		FN_HCTS2_N, FN_SCIFB2_CTS_N, FN_ATAWR1_N, 0,
		/* IP9_28_27 [2] */
		FN_VI0_DATA3_VI0_B3, FN_SCIF3_SCK_B, FN_SCIFA3_SCK_B, 0,
		/* IP9_26_25 [2] */
		FN_VI0_VSYNC_N, FN_RX5, FN_SCIFA5_RXD, FN_TS_SPSYNC0_D,
		/* IP9_24_23 [2] */
		FN_VI0_HSYNC_N, FN_TX5, FN_SCIFA5_TXD, FN_TS_SDEN0_D,
		/* IP9_22_21 [2] */
		FN_VI0_FIELD, FN_RX4, FN_SCIFA4_RXD, FN_TS_SCK0_D,
		/* IP9_20_19 [2] */
		FN_VI0_CLKENB, FN_TX4, FN_SCIFA4_TXD, FN_TS_SDATA0_D,
		/* IP9_18_17 [2] */
		FN_DU1_CDE, FN_QPOLB, FN_PWM4_B, 0,
		/* IP9_16 [1] */
		FN_DU1_DISP, FN_QPOLA,
		/* IP9_15_13 [3] */
		FN_DU1_EXODDF_DU1_ODDF_DISP_CDE, FN_QCPV_QDE,
		FN_CAN0_RX, FN_RX3_B, FN_SDA2_B,
		0, 0, 0,
		/* IP9_12 [1] */
		FN_DU1_EXVSYNC_DU1_VSYNC, FN_QSTB_QHE,
		/* IP9_11 [1] */
		FN_DU1_EXHSYNC_DU1_HSYNC, FN_QSTH_QHS,
		/* IP9_10_8 [3] */
		FN_DU1_DOTCLKOUT1, FN_QSTVB_QVE, FN_CAN0_TX,
		FN_TX3_B, FN_SCL2_B, FN_PWM4,
		0, 0,
		/* IP9_7 [1] */
		FN_DU1_DOTCLKOUT0, FN_QCLK,
		/* IP9_6 [1] */
		FN_DU1_DOTCLKIN, FN_QSTVA_QVS,
		/* IP9_5_3 [3] */
		FN_DU1_DB7, FN_LCDOUT23, FN_SDA3_C,
		FN_SCIF3_SCK, FN_SCIFA3_SCK,
		0, 0, 0,
		/* IP9_2_0 [3] */
		FN_DU1_DB6, FN_LCDOUT22, FN_SCL3_C, FN_RX3, FN_SCIFA3_RXD,
		0, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR10", 0xE6060048, 32,
			     3, 2, 2, 3, 3, 2, 2, 3, 3, 3, 3, 3) {
		/* IP10_31_29 [3] */
		FN_VI0_R4, FN_VI2_DATA5, FN_GLO_SCLK_B, FN_TX0_C, FN_SCL1_D,
		0, 0, 0,
		/* IP10_28_27 [2] */
		FN_VI0_R3, FN_VI2_DATA4, FN_GLO_Q1_B, FN_TS_SPSYNC0_C,
		/* IP10_26_25 [2] */
		FN_VI0_R2, FN_VI2_DATA3, FN_GLO_Q0_B, FN_TS_SDEN0_C,
		/* IP10_24_22 [3] */
		FN_VI0_R1, FN_VI2_DATA2, FN_GLO_I1_B, FN_TS_SCK0_C, FN_ATAG1_N,
		0, 0, 0,
		/* IP10_21_29 [3] */
		FN_VI0_R0, FN_VI2_DATA1, FN_GLO_I0_B,
		FN_TS_SDATA0_C, FN_ATACS11_N,
		0, 0, 0,
		/* IP10_18_17 [2] */
		FN_VI0_G7, FN_VI2_DATA0, FN_FMIN_D, 0,
		/* IP10_16_15 [2] */
		FN_VI0_G6, FN_VI2_CLK, FN_BPFCLK_D, 0,
		/* IP10_14_12 [3] */
		FN_VI0_G5, FN_VI2_FIELD, FN_STP_OPWM_0_C, FN_FMCLK_D,
		FN_CAN0_TX_E, FN_HTX1_D, FN_SCIFB0_TXD_D, 0,
		/* IP10_11_9 [3] */
		FN_VI0_G4, FN_VI2_CLKENB, FN_STP_ISSYNC_0_C,
		FN_HTX2, FN_SCIFB2_TXD, FN_SCIFB0_SCK_D,
		0, 0,
		/* IP10_8_6 [3] */
		FN_VI0_G3, FN_VI2_VSYNC_N, FN_STP_ISEN_0_C, FN_SDA3_B,
		FN_HRX2, FN_SCIFB2_RXD, FN_ATACS01_N, 0,
		/* IP10_5_3 [3] */
		FN_VI0_G2, FN_VI2_HSYNC_N, FN_STP_ISD_0_C, FN_SCL3_B,
		FN_HSCK2, FN_SCIFB2_SCK, FN_ATARD1_N, 0,
		/* IP10_2_0 [3] */
		FN_VI0_G1, FN_SDA8, FN_STP_ISCLK_0_C, FN_SDA4,
		FN_HRTS2_N, FN_SCIFB2_RTS_N, FN_ATADIR1_N, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR11", 0xE606004C, 32,
			     2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2,
			     3, 3, 3, 3, 3) {
		/* IP11_31_30 [2] */
		FN_ETH_CRS_DV, FN_AVB_LINK, FN_SDA2_C, 0,
		/* IP11_29_28 [2] */
		FN_ETH_MDIO, FN_AVB_RX_CLK, FN_SCL2_C, 0,
		/* IP11_27 [1] */
		FN_VI1_DATA7, FN_AVB_MDC,
		/* IP11_26 [1] */
		FN_VI1_DATA6, FN_AVB_MAGIC,
		/* IP11_25 [1] */
		FN_VI1_DATA5, FN_AVB_RX_DV,
		/* IP11_24 [1] */
		FN_VI1_DATA4, FN_AVB_MDIO,
		/* IP11_23 [1] */
		FN_VI1_DATA3, FN_AVB_RX_ER,
		/* IP11_22 [1] */
		FN_VI1_DATA2, FN_AVB_RXD7,
		/* IP11_21 [1] */
		FN_VI1_DATA1, FN_AVB_RXD6,
		/* IP11_20 [1] */
		FN_VI1_DATA0, FN_AVB_RXD5,
		/* IP11_19 [1] */
		FN_VI1_CLK, FN_AVB_RXD4,
		/* IP11_18_17 [2] */
		FN_VI1_FIELD, FN_AVB_RXD3, FN_TS_SPSYNC0_B, 0,
		/* IP11_16_15 [2] */
		FN_VI1_CLKENB, FN_AVB_RXD2, FN_TS_SDEN0_B, 0,
		/* IP11_14_12 [3] */
		FN_VI1_VSYNC_N, FN_AVB_RXD1, FN_TS_SCK0_B,
		FN_RX4_B, FN_SCIFA4_RXD_B,
		0, 0, 0,
		/* IP11_11_9 [3] */
		FN_VI1_HSYNC_N, FN_AVB_RXD0, FN_TS_SDATA0_B,
		FN_TX4_B, FN_SCIFA4_TXD_B,
		0, 0, 0,
		/* IP11_8_6 [3] */
		FN_VI0_R7, FN_GLO_RFON_B, FN_RX1_C, FN_CAN0_RX_E,
		FN_SDA4_B, FN_HRX1_D, FN_SCIFB0_RXD_D, 0,
		/* IP11_5_3 [3] */
		FN_VI0_R6, FN_VI2_DATA7, FN_GLO_SS_B, FN_TX1_C, FN_SCL4_B,
		0, 0, 0,
		/* IP11_2_0 [3] */
		FN_VI0_R5, FN_VI2_DATA6, FN_GLO_SDATA_B, FN_RX0_C, FN_SDA1_D,
		0, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR12", 0xE6060050, 32,
			     2, 3, 3, 2, 2, 2, 2, 3, 3, 3, 3, 2, 2) {
		/* IP12_31_30 [2] */
		0, 0, 0, 0,
		/* IP12_29_27 [3] */
		FN_STP_ISCLK_0, FN_AVB_TX_EN, FN_SCIFB2_RXD_D,
		FN_ADICS_SAMP_B, FN_MSIOF0_SCK_C,
		0, 0, 0,
		/* IP12_26_24 [3] */
		FN_STP_IVCXO27_0, FN_AVB_TXD7, FN_SCIFB2_TXD_D,
		FN_ADIDATA_B, FN_MSIOF0_SYNC_C,
		0, 0, 0,
		/* IP12_23_22 [2] */
		FN_ETH_MDC, FN_AVB_TXD6, FN_IERX_C, 0,
		/* IP12_21_20 [2] */
		FN_ETH_TXD0, FN_AVB_TXD5, FN_IECLK_C, 0,
		/* IP12_19_18 [2] */
		FN_ETH_MAGIC, FN_AVB_TXD4, FN_IETX_C, 0,
		/* IP12_17_16 [2] */
		FN_ETH_TX_EN, FN_AVB_TXD3, FN_TCLK1_B, FN_CAN_CLK_B,
		/* IP12_15_13 [3] */
		FN_ETH_TXD1, FN_AVB_TXD2, FN_SCIFA3_TXD_B,
		FN_CAN1_TX_C, FN_MSIOF1_TXD_E,
		0, 0, 0,
		/* IP12_12_10 [3] */
		FN_ETH_REFCLK, FN_AVB_TXD1, FN_SCIFA3_RXD_B,
		FN_CAN1_RX_C, FN_MSIOF1_SYNC_E,
		0, 0, 0,
		/* IP12_9_7 [3] */
		FN_ETH_LINK, FN_AVB_TXD0, FN_CAN0_RX_C,
		FN_SDA2_D, FN_MSIOF1_SCK_E,
		0, 0, 0,
		/* IP12_6_4 [3] */
		FN_ETH_RXD1, FN_AVB_GTXREFCLK, FN_CAN0_TX_C,
		FN_SCL2_D, FN_MSIOF1_RXD_E,
		0, 0, 0,
		/* IP12_3_2 [2] */
		FN_ETH_RXD0, FN_AVB_PHY_INT, FN_SDA3, FN_SDA7,
		/* IP12_1_0 [2] */
		FN_ETH_RX_ER, FN_AVB_CRS, FN_SCL3, FN_SCL7, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR13", 0xE6060054, 32,
			     1, 3, 1, 1, 1, 2, 1, 3, 3, 1, 1, 1, 1, 1, 1,
			     3, 2, 2, 3) {
		/* IP13_31 [1] */
		0, 0,
		/* IP13_30_28 [3] */
		FN_SD1_CD, FN_PWM0, FN_TPU_TO0, FN_SCL1_C,
		0, 0, 0, 0,
		/* IP13_27 [1] */
		FN_SD1_DATA3, FN_IERX_B,
		/* IP13_26 [1] */
		FN_SD1_DATA2, FN_IECLK_B,
		/* IP13_25 [1] */
		FN_SD1_DATA1, FN_IETX_B,
		/* IP13_24_23 [2] */
		FN_SD1_DATA0, FN_SPEEDIN_B, 0, 0,
		/* IP13_22 [1] */
		FN_SD1_CMD, FN_REMOCON_B,
		/* IP13_21_19 [3] */
		FN_SD0_WP, FN_MMC_D7_B, FN_SIM0_D_B, FN_CAN0_TX_F,
		FN_SCIFA5_RXD_B, FN_RX3_C,
		0, 0,
		/* IP13_18_16 [3] */
		FN_SD0_CD, FN_MMC_D6_B, FN_SIM0_RST_B, FN_CAN0_RX_F,
		FN_SCIFA5_TXD_B, FN_TX3_C,
		0, 0,
		/* IP13_15 [1] */
		FN_SD0_DATA3, FN_SSL_B,
		/* IP13_14 [1] */
		FN_SD0_DATA2, FN_IO3_B,
		/* IP13_13 [1] */
		FN_SD0_DATA1, FN_IO2_B,
		/* IP13_12 [1] */
		FN_SD0_DATA0, FN_MISO_IO1_B,
		/* IP13_11 [1] */
		FN_SD0_CMD, FN_MOSI_IO0_B,
		/* IP13_10 [1] */
		FN_SD0_CLK, FN_SPCLK_B,
		/* IP13_9_7 [3] */
		FN_STP_OPWM_0, FN_AVB_GTX_CLK, FN_PWM0_B,
		FN_ADICHS2_B, FN_MSIOF0_TXD_C,
		0, 0, 0,
		/* IP13_6_5 [2] */
		FN_STP_ISSYNC_0, FN_AVB_COL, FN_ADICHS1_B, FN_MSIOF0_RXD_C,
		/* IP13_4_3 [2] */
		FN_STP_ISEN_0, FN_AVB_TX_CLK, FN_ADICHS0_B, FN_MSIOF0_SS2_C,
		/* IP13_2_0 [3] */
		FN_STP_ISD_0, FN_AVB_TX_ER, FN_SCIFB2_SCK_C,
		FN_ADICLK_B, FN_MSIOF0_SS1_C,
		0, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR14", 0xE6060058, 32,
			     3, 3, 3, 3, 3, 3, 3, 3, 1, 1, 1, 1, 1, 1, 2) {
		/* IP14_31_29 [3] */
		FN_MSIOF0_SS2, FN_MMC_D7, FN_ADICHS2, FN_RX0_E,
		FN_VI1_VSYNC_N_C, FN_SDA7_C, FN_VI1_G5_B, 0,
		/* IP14_28_26 [3] */
		FN_MSIOF0_SS1, FN_MMC_D6, FN_ADICHS1, FN_TX0_E,
		FN_VI1_HSYNC_N_C, FN_SCL7_C, FN_VI1_G4_B, 0,
		/* IP14_25_23 [3] */
		FN_MSIOF0_RXD, FN_ADICHS0, 0, FN_VI1_DATA0_C, FN_VI1_G3_B,
		0, 0, 0,
		/* IP14_22_20 [3] */
		FN_MSIOF0_TXD, FN_ADICLK, 0, FN_VI1_FIELD_C, FN_VI1_G2_B,
		0, 0, 0,
		/* IP14_19_17 [3] */
		FN_MSIOF0_SYNC, FN_TX2_C, FN_ADICS_SAMP, 0,
		FN_VI1_CLKENB_C, FN_VI1_G1_B,
		0, 0,
		/* IP14_16_14 [3] */
		FN_MSIOF0_SCK, FN_RX2_C, FN_ADIDATA, 0,
		FN_VI1_CLK_C, FN_VI1_G0_B,
		0, 0,
		/* IP14_13_11 [3] */
		FN_SD2_WP, FN_MMC_D5, FN_SDA8_C, FN_RX5_B, FN_SCIFA5_RXD_C,
		0, 0, 0,
		/* IP14_10_8 [3] */
		FN_SD2_CD, FN_MMC_D4, FN_SCL8_C, FN_TX5_B, FN_SCIFA5_TXD_C,
		0, 0, 0,
		/* IP14_7 [1] */
		FN_SD2_DATA3, FN_MMC_D3,
		/* IP14_6 [1] */
		FN_SD2_DATA2, FN_MMC_D2,
		/* IP14_5 [1] */
		FN_SD2_DATA1, FN_MMC_D1,
		/* IP14_4 [1] */
		FN_SD2_DATA0, FN_MMC_D0,
		/* IP14_3 [1] */
		FN_SD2_CMD, FN_MMC_CMD,
		/* IP14_2 [1] */
		FN_SD2_CLK, FN_MMC_CLK,
		/* IP14_1_0 [2] */
		FN_SD1_WP, FN_PWM1_B, FN_SDA1_C, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR15", 0xE606005C, 32,
			     2, 3, 3, 3, 3, 3, 3, 3, 3, 2, 2, 2) {
		/* IP15_31_30 [2] */
		0, 0, 0, 0,
		/* IP15_29_27 [3] */
		FN_HTX0, FN_SCIFB0_TXD, 0, FN_GLO_SCLK_C,
		FN_CAN0_TX_B, FN_VI1_DATA5_C,
		0, 0,
		/* IP15_26_24 [3] */
		FN_HRX0, FN_SCIFB0_RXD, 0, FN_GLO_Q1_C,
		FN_CAN0_RX_B, FN_VI1_DATA4_C,
		0, 0,
		/* IP15_23_21 [3] */
		FN_HSCK0, FN_SCIFB0_SCK, 0, FN_GLO_Q0_C, FN_CAN_CLK,
		FN_TCLK2, FN_VI1_DATA3_C, 0,
		/* IP15_20_18 [3] */
		FN_HRTS0_N, FN_SCIFB0_RTS_N, 0, FN_GLO_I1_C, FN_VI1_DATA2_C,
		0, 0, 0,
		/* IP15_17_15 [3] */
		FN_HCTS0_N, FN_SCIFB0_CTS_N, 0, FN_GLO_I0_C,
		FN_TCLK1, FN_VI1_DATA1_C,
		0, 0,
		/* IP15_14_12 [3] */
		FN_GPS_MAG, FN_RX4_C, FN_SCIFA4_RXD_C, FN_PWM6,
		FN_VI1_G7_B, FN_SCIFA3_SCK_C,
		0, 0,
		/* IP15_11_9 [3] */
		FN_GPS_SIGN, FN_TX4_C, FN_SCIFA4_TXD_C, FN_PWM5,
		FN_VI1_G6_B, FN_SCIFA3_RXD_C,
		0, 0,
		/* IP15_8_6 [3] */
		FN_GPS_CLK, FN_DU1_DOTCLKIN_C, FN_AUDIO_CLKB_B,
		FN_PWM5_B, FN_SCIFA3_TXD_C,
		0, 0, 0,
		/* IP15_5_4 [2] */
		FN_SIM0_D, FN_IERX, FN_CAN1_RX_D, 0,
		/* IP15_3_2 [2] */
		FN_SIM0_CLK, FN_IECLK, FN_CAN_CLK_C, 0,
		/* IP15_1_0 [2] */
		FN_SIM0_RST, FN_IETX, FN_CAN1_TX_D, 0, }
	},
	{ PINMUX_CFG_REG_VAR("IPSR16", 0xE6060160, 32,
			     4, 4, 4, 4, 4, 2, 2, 2, 3, 3) {
		/* IP16_31_28 [4] */
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		/* IP16_27_24 [4] */
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		/* IP16_23_20 [4] */
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		/* IP16_19_16 [4] */
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		/* IP16_15_12 [4] */
		0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0,
		/* IP16_11_10 [2] */
		FN_HRTS1_N, FN_SCIFB1_RTS_N, FN_MLB_DAT, FN_CAN1_RX_B,
		/* IP16_9_8 [2] */
		FN_HCTS1_N, FN_SCIFB1_CTS_N, FN_MLB_SIG, FN_CAN1_TX_B,
		/* IP16_7_6 [2] */
		FN_HSCK1, FN_SCIFB1_SCK, FN_MLB_CLK, FN_GLO_RFON_C,
		/* IP16_5_3 [3] */
		FN_HTX1, FN_SCIFB1_TXD, FN_VI1_R1_B,
		FN_GLO_SS_C, FN_VI1_DATA7_C,
		0, 0, 0,
		/* IP16_2_0 [3] */
		FN_HRX1, FN_SCIFB1_RXD, FN_VI1_R0_B,
		FN_GLO_SDATA_C, FN_VI1_DATA6_C,
		0, 0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL", 0xE6060090, 32,
			     1, 2, 2, 2, 3, 2, 1, 1, 1, 1,
			     3, 2, 2, 2, 1, 2, 2, 2) {
		/* RESERVED [1] */
		0, 0,
		/* SEL_SCIF1 [2] */
		FN_SEL_SCIF1_0, FN_SEL_SCIF1_1, FN_SEL_SCIF1_2, FN_SEL_SCIF1_3,
		/* SEL_SCIFB [2] */
		FN_SEL_SCIFB_0, FN_SEL_SCIFB_1, FN_SEL_SCIFB_2, FN_SEL_SCIFB_3,
		/* SEL_SCIFB2 [2] */
		FN_SEL_SCIFB2_0, FN_SEL_SCIFB2_1,
		FN_SEL_SCIFB2_2, FN_SEL_SCIFB2_3,
		/* SEL_SCIFB1 [3] */
		FN_SEL_SCIFB1_0, FN_SEL_SCIFB1_1,
		FN_SEL_SCIFB1_2, FN_SEL_SCIFB1_3,
		0, 0, 0, 0,
		/* SEL_SCIFA1 [2] */
		FN_SEL_SCIFA1_0, FN_SEL_SCIFA1_1, FN_SEL_SCIFA1_2, 0,
		/* SEL_SSI9 [1] */
		FN_SEL_SSI9_0, FN_SEL_SSI9_1,
		/* SEL_SCFA [1] */
		FN_SEL_SCFA_0, FN_SEL_SCFA_1,
		/* SEL_QSP [1] */
		FN_SEL_QSP_0, FN_SEL_QSP_1,
		/* SEL_SSI7 [1] */
		FN_SEL_SSI7_0, FN_SEL_SSI7_1,
		/* SEL_HSCIF1 [3] */
		FN_SEL_HSCIF1_0, FN_SEL_HSCIF1_1, FN_SEL_HSCIF1_2,
		FN_SEL_HSCIF1_3, FN_SEL_HSCIF1_4,
		0, 0, 0,
		/* RESERVED [2] */
		0, 0, 0, 0,
		/* SEL_VI1 [2] */
		FN_SEL_VI1_0, FN_SEL_VI1_1, FN_SEL_VI1_2, 0,
		/* RESERVED [2] */
		0, 0, 0, 0,
		/* SEL_TMU [1] */
		FN_SEL_TMU1_0, FN_SEL_TMU1_1,
		/* SEL_LBS [2] */
		FN_SEL_LBS_0, FN_SEL_LBS_1, FN_SEL_LBS_2, FN_SEL_LBS_3,
		/* SEL_TSIF0 [2] */
		FN_SEL_TSIF0_0, FN_SEL_TSIF0_1, FN_SEL_TSIF0_2, FN_SEL_TSIF0_3,
		/* SEL_SOF0 [2] */
		FN_SEL_SOF0_0, FN_SEL_SOF0_1, FN_SEL_SOF0_2, 0, }
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL2", 0xE6060094, 32,
			     3, 1, 1, 3, 2, 1, 1, 2, 2,
			     1, 3, 2, 1, 2, 2, 2, 1, 1, 1) {
		/* SEL_SCIF0 [3] */
		FN_SEL_SCIF0_0, FN_SEL_SCIF0_1, FN_SEL_SCIF0_2,
		FN_SEL_SCIF0_3, FN_SEL_SCIF0_4,
		0, 0, 0,
		/* RESERVED [1] */
		0, 0,
		/* SEL_SCIF [1] */
		FN_SEL_SCIF_0, FN_SEL_SCIF_1,
		/* SEL_CAN0 [3] */
		FN_SEL_CAN0_0, FN_SEL_CAN0_1, FN_SEL_CAN0_2, FN_SEL_CAN0_3,
		FN_SEL_CAN0_4, FN_SEL_CAN0_5,
		0, 0,
		/* SEL_CAN1 [2] */
		FN_SEL_CAN1_0, FN_SEL_CAN1_1, FN_SEL_CAN1_2, FN_SEL_CAN1_3,
		/* RESERVED [1] */
		0, 0,
		/* SEL_SCIFA2 [1] */
		FN_SEL_SCIFA2_0, FN_SEL_SCIFA2_1,
		/* SEL_SCIF4 [2] */
		FN_SEL_SCIF4_0, FN_SEL_SCIF4_1, FN_SEL_SCIF4_2, 0,
		/* RESERVED [2] */
		0, 0, 0, 0,
		/* SEL_ADG [1] */
		FN_SEL_ADG_0, FN_SEL_ADG_1,
		/* SEL_FM [3] */
		FN_SEL_FM_0, FN_SEL_FM_1, FN_SEL_FM_2,
		FN_SEL_FM_3, FN_SEL_FM_4,
		0, 0, 0,
		/* SEL_SCIFA5 [2] */
		FN_SEL_SCIFA5_0, FN_SEL_SCIFA5_1, FN_SEL_SCIFA5_2, 0,
		/* RESERVED [1] */
		0, 0,
		/* SEL_GPS [2] */
		FN_SEL_GPS_0, FN_SEL_GPS_1, FN_SEL_GPS_2, FN_SEL_GPS_3,
		/* SEL_SCIFA4 [2] */
		FN_SEL_SCIFA4_0, FN_SEL_SCIFA4_1, FN_SEL_SCIFA4_2, 0,
		/* SEL_SCIFA3 [2] */
		FN_SEL_SCIFA3_0, FN_SEL_SCIFA3_1, FN_SEL_SCIFA3_2, 0,
		/* SEL_SIM [1] */
		FN_SEL_SIM_0, FN_SEL_SIM_1,
		/* RESERVED [1] */
		0, 0,
		/* SEL_SSI8 [1] */
		FN_SEL_SSI8_0, FN_SEL_SSI8_1, }
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL3", 0xE6060098, 32,
			     2, 2, 2, 2, 2, 2, 2, 2,
			     1, 1, 2, 2, 3, 2, 2, 2, 1) {
		/* SEL_HSCIF2 [2] */
		FN_SEL_HSCIF2_0, FN_SEL_HSCIF2_1,
		FN_SEL_HSCIF2_2, FN_SEL_HSCIF2_3,
		/* SEL_CANCLK [2] */
		FN_SEL_CANCLK_0, FN_SEL_CANCLK_1,
		FN_SEL_CANCLK_2, FN_SEL_CANCLK_3,
		/* SEL_IIC8 [2] */
		FN_SEL_IIC8_0, FN_SEL_IIC8_1, FN_SEL_IIC8_2, 0,
		/* SEL_IIC7 [2] */
		FN_SEL_IIC7_0, FN_SEL_IIC7_1, FN_SEL_IIC7_2, 0,
		/* SEL_IIC4 [2] */
		FN_SEL_IIC4_0, FN_SEL_IIC4_1, FN_SEL_IIC4_2, 0,
		/* SEL_IIC3 [2] */
		FN_SEL_IIC3_0, FN_SEL_IIC3_1, FN_SEL_IIC3_2, FN_SEL_IIC3_3,
		/* SEL_SCIF3 [2] */
		FN_SEL_SCIF3_0, FN_SEL_SCIF3_1, FN_SEL_SCIF3_2, FN_SEL_SCIF3_3,
		/* SEL_IEB [2] */
		FN_SEL_IEB_0, FN_SEL_IEB_1, FN_SEL_IEB_2, 0,
		/* SEL_MMC [1] */
		FN_SEL_MMC_0, FN_SEL_MMC_1,
		/* SEL_SCIF5 [1] */
		FN_SEL_SCIF5_0, FN_SEL_SCIF5_1,
		/* RESERVED [2] */
		0, 0, 0, 0,
		/* SEL_IIC2 [2] */
		FN_SEL_IIC2_0, FN_SEL_IIC2_1, FN_SEL_IIC2_2, FN_SEL_IIC2_3,
		/* SEL_IIC1 [3] */
		FN_SEL_IIC1_0, FN_SEL_IIC1_1, FN_SEL_IIC1_2, FN_SEL_IIC1_3,
		FN_SEL_IIC1_4,
		0, 0, 0,
		/* SEL_IIC0 [2] */
		FN_SEL_IIC0_0, FN_SEL_IIC0_1, FN_SEL_IIC0_2, 0,
		/* RESERVED [2] */
		0, 0, 0, 0,
		/* RESERVED [2] */
		0, 0, 0, 0,
		/* RESERVED [1] */
		0, 0, }
	},
	{ PINMUX_CFG_REG_VAR("MOD_SEL4", 0xE606009C, 32,
			     3, 2, 2, 1, 1, 1, 1, 3, 2,
			     2, 3, 1, 1, 1, 2, 2, 2, 2) {
		/* SEL_SOF1 [3] */
		FN_SEL_SOF1_0, FN_SEL_SOF1_1, FN_SEL_SOF1_2, FN_SEL_SOF1_3,
		FN_SEL_SOF1_4,
		0, 0, 0,
		/* SEL_HSCIF0 [2] */
		FN_SEL_HSCIF0_0, FN_SEL_HSCIF0_1, FN_SEL_HSCIF0_2, 0,
		/* SEL_DIS [2] */
		FN_SEL_DIS_0, FN_SEL_DIS_1, FN_SEL_DIS_2, 0,
		/* RESERVED [1] */
		0, 0,
		/* SEL_RAD [1] */
		FN_SEL_RAD_0, FN_SEL_RAD_1,
		/* SEL_RCN [1] */
		FN_SEL_RCN_0, FN_SEL_RCN_1,
		/* SEL_RSP [1] */
		FN_SEL_RSP_0, FN_SEL_RSP_1,
		/* SEL_SCIF2 [3] */
		FN_SEL_SCIF2_0, FN_SEL_SCIF2_1, FN_SEL_SCIF2_2,
		FN_SEL_SCIF2_3, FN_SEL_SCIF2_4,
		0, 0, 0,
		/* RESERVED [2] */
		0, 0, 0, 0,
		/* RESERVED [2] */
		0, 0, 0, 0,
		/* SEL_SOF2 [3] */
		FN_SEL_SOF2_0, FN_SEL_SOF2_1, FN_SEL_SOF2_2,
		FN_SEL_SOF2_3, FN_SEL_SOF2_4,
		0, 0, 0,
		/* RESERVED [1] */
		0, 0,
		/* SEL_SSI1 [1] */
		FN_SEL_SSI1_0, FN_SEL_SSI1_1,
		/* SEL_SSI0 [1] */
		FN_SEL_SSI0_0, FN_SEL_SSI0_1,
		/* SEL_SSP [2] */
		FN_SEL_SSP_0, FN_SEL_SSP_1, FN_SEL_SSP_2, 0,
		/* RESERVED [2] */
		0, 0, 0, 0,
		/* RESERVED [2] */
		0, 0, 0, 0,
		/* RESERVED [2] */
		0, 0, 0, 0, }
	},
	{ },
};

#ifdef CONFIG_PINCTRL_PFC_R8A7791
const struct sh_pfc_soc_info r8a7791_pinmux_info = {
	.name = "r8a77910_pfc",
	.unlock_reg = 0xe6060000, /* PMMR */

	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),
	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.cfg_regs = pinmux_config_regs,

	.pinmux_data = pinmux_data,
	.pinmux_data_size = ARRAY_SIZE(pinmux_data),
};
#endif

#ifdef CONFIG_PINCTRL_PFC_R8A7793
const struct sh_pfc_soc_info r8a7793_pinmux_info = {
	.name = "r8a77930_pfc",
	.unlock_reg = 0xe6060000, /* PMMR */

	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.groups = pinmux_groups,
	.nr_groups = ARRAY_SIZE(pinmux_groups),
	.functions = pinmux_functions,
	.nr_functions = ARRAY_SIZE(pinmux_functions),

	.cfg_regs = pinmux_config_regs,

	.pinmux_data = pinmux_data,
	.pinmux_data_size = ARRAY_SIZE(pinmux_data),
};
#endif
