/*
 * linux/arch/arm/lib/calls.h
 *
 * Copyright (C) 1995, 1996 Russell King
 */
#ifndef NR_SYSCALLS
#define NR_syscalls 256
#define NR_SYSCALLS 184
#else

/* 0 */		.long	SYMBOL_NAME(sys_setup)
		.long	SYMBOL_NAME(sys_exit)
		.long	SYMBOL_NAME(sys_fork_wrapper)
		.long	SYMBOL_NAME(sys_read)
		.long	SYMBOL_NAME(sys_write)
/* 5 */		.long	SYMBOL_NAME(sys_open)
		.long	SYMBOL_NAME(sys_close)
		.long	SYMBOL_NAME(sys_waitpid)
		.long	SYMBOL_NAME(sys_creat)
		.long	SYMBOL_NAME(sys_link)
/* 10 */	.long	SYMBOL_NAME(sys_unlink)
		.long	SYMBOL_NAME(sys_execve_wrapper)
		.long	SYMBOL_NAME(sys_chdir)
		.long	SYMBOL_NAME(sys_time)
		.long	SYMBOL_NAME(sys_mknod)
/* 15 */	.long	SYMBOL_NAME(sys_chmod)
		.long	SYMBOL_NAME(sys_chown)
		.long	SYMBOL_NAME(sys_ni_syscall)		/* was sys_break */
		.long	SYMBOL_NAME(sys_stat)
		.long	SYMBOL_NAME(sys_lseek)
/* 20 */	.long	SYMBOL_NAME(sys_getpid)
		.long	SYMBOL_NAME(sys_mount_wrapper)
		.long	SYMBOL_NAME(sys_umount)
		.long	SYMBOL_NAME(sys_setuid)
		.long	SYMBOL_NAME(sys_getuid)
/* 25 */	.long	SYMBOL_NAME(sys_stime)
		.long	SYMBOL_NAME(sys_ptrace)
		.long	SYMBOL_NAME(sys_alarm)
		.long	SYMBOL_NAME(sys_fstat)
		.long	SYMBOL_NAME(sys_pause)
/* 30 */	.long	SYMBOL_NAME(sys_utime)
		.long	SYMBOL_NAME(sys_ni_syscall)		/* was sys_stty */
		.long	SYMBOL_NAME(sys_ni_syscall)		/* was sys_getty */
		.long	SYMBOL_NAME(sys_access)
		.long	SYMBOL_NAME(sys_nice)
/* 35 */	.long	SYMBOL_NAME(sys_ni_syscall)		/* was sys_ftime */
		.long	SYMBOL_NAME(sys_sync)
		.long	SYMBOL_NAME(sys_kill)
		.long	SYMBOL_NAME(sys_rename)
		.long	SYMBOL_NAME(sys_mkdir)
/* 40 */	.long	SYMBOL_NAME(sys_rmdir)
		.long	SYMBOL_NAME(sys_dup)
		.long	SYMBOL_NAME(sys_pipe)
		.long	SYMBOL_NAME(sys_times)
		.long	SYMBOL_NAME(sys_ni_syscall)		/* was sys_prof */
/* 45 */	.long	SYMBOL_NAME(sys_brk)
		.long	SYMBOL_NAME(sys_setgid)
		.long	SYMBOL_NAME(sys_getgid)
		.long	SYMBOL_NAME(sys_signal)
		.long	SYMBOL_NAME(sys_geteuid)
/* 50 */	.long	SYMBOL_NAME(sys_getegid)
		.long	SYMBOL_NAME(sys_acct)
		.long	SYMBOL_NAME(sys_ni_syscall)		/* was sys_phys */
		.long	SYMBOL_NAME(sys_ni_syscall)		/* was sys_lock */
		.long	SYMBOL_NAME(sys_ioctl)
/* 55 */	.long	SYMBOL_NAME(sys_fcntl)
		.long	SYMBOL_NAME(sys_ni_syscall)		/* was sys_mpx */
		.long	SYMBOL_NAME(sys_setpgid)
		.long	SYMBOL_NAME(sys_ni_syscall)		/* was sys_ulimit */
		.long	SYMBOL_NAME(sys_olduname)
/* 60 */	.long	SYMBOL_NAME(sys_umask)
		.long	SYMBOL_NAME(sys_chroot)
		.long	SYMBOL_NAME(sys_ustat)
		.long	SYMBOL_NAME(sys_dup2)
		.long	SYMBOL_NAME(sys_getppid)
/* 65 */	.long	SYMBOL_NAME(sys_getpgrp)
		.long	SYMBOL_NAME(sys_setsid)
		.long	SYMBOL_NAME(sys_sigaction)
		.long	SYMBOL_NAME(sys_sgetmask)
		.long	SYMBOL_NAME(sys_ssetmask)
/* 70 */	.long	SYMBOL_NAME(sys_setreuid)
		.long	SYMBOL_NAME(sys_setregid)
		.long	SYMBOL_NAME(sys_sigsuspend_wrapper)
		.long	SYMBOL_NAME(sys_sigpending)
		.long	SYMBOL_NAME(sys_sethostname)
/* 75 */	.long	SYMBOL_NAME(sys_setrlimit)
		.long	SYMBOL_NAME(sys_getrlimit)
		.long	SYMBOL_NAME(sys_getrusage)
		.long	SYMBOL_NAME(sys_gettimeofday)
		.long	SYMBOL_NAME(sys_settimeofday)
/* 80 */	.long	SYMBOL_NAME(sys_getgroups)
		.long	SYMBOL_NAME(sys_setgroups)
		.long	SYMBOL_NAME(old_select)
		.long	SYMBOL_NAME(sys_symlink)
		.long	SYMBOL_NAME(sys_lstat)
/* 85 */	.long	SYMBOL_NAME(sys_readlink)
		.long	SYMBOL_NAME(sys_uselib)
		.long	SYMBOL_NAME(sys_swapon)
		.long	SYMBOL_NAME(sys_reboot)
		.long	SYMBOL_NAME(old_readdir)
/* 90 */	.long	SYMBOL_NAME(old_mmap)
		.long	SYMBOL_NAME(sys_munmap)
		.long	SYMBOL_NAME(sys_truncate)
		.long	SYMBOL_NAME(sys_ftruncate)
		.long	SYMBOL_NAME(sys_fchmod)
/* 95 */	.long	SYMBOL_NAME(sys_fchown)
		.long	SYMBOL_NAME(sys_getpriority)
		.long	SYMBOL_NAME(sys_setpriority)
		.long	SYMBOL_NAME(sys_ni_syscall)		/* was sys_profil */
		.long	SYMBOL_NAME(sys_statfs)
/* 100 */	.long	SYMBOL_NAME(sys_fstatfs)
		.long	SYMBOL_NAME(sys_ni_syscall)		/* .long	_sys_ioperm */
		.long	SYMBOL_NAME(sys_socketcall)
		.long	SYMBOL_NAME(sys_syslog)
		.long	SYMBOL_NAME(sys_setitimer)
/* 105 */	.long	SYMBOL_NAME(sys_getitimer)
		.long	SYMBOL_NAME(sys_newstat)
		.long	SYMBOL_NAME(sys_newlstat)
		.long	SYMBOL_NAME(sys_newfstat)
		.long	SYMBOL_NAME(sys_uname)
/* 110 */	.long	SYMBOL_NAME(sys_iopl)
		.long	SYMBOL_NAME(sys_vhangup)
		.long	SYMBOL_NAME(sys_idle)
		.long	SYMBOL_NAME(sys_syscall)		/* call a syscall */
		.long	SYMBOL_NAME(sys_wait4)
/* 115 */	.long	SYMBOL_NAME(sys_swapoff)
		.long	SYMBOL_NAME(sys_sysinfo)
		.long	SYMBOL_NAME(sys_ipc)
		.long	SYMBOL_NAME(sys_fsync)
		.long	SYMBOL_NAME(sys_sigreturn_wrapper)
		.long	SYMBOL_NAME(sys_clone_wapper)
		.long	SYMBOL_NAME(sys_setdomainname)
		.long	SYMBOL_NAME(sys_newuname)
		.long	SYMBOL_NAME(sys_ni_syscall)		/* .long	SYMBOL_NAME(sys_modify_ldt) */
		.long	SYMBOL_NAME(sys_adjtimex)
/* 125 */	.long	SYMBOL_NAME(sys_mprotect)
		.long	SYMBOL_NAME(sys_sigprocmask)
		.long	SYMBOL_NAME(sys_create_module)
		.long	SYMBOL_NAME(sys_init_module)
		.long	SYMBOL_NAME(sys_delete_module)
/* 130 */	.long	SYMBOL_NAME(sys_get_kernel_syms)
		.long	SYMBOL_NAME(sys_quotactl)
		.long	SYMBOL_NAME(sys_getpgid)
		.long	SYMBOL_NAME(sys_fchdir)
		.long	SYMBOL_NAME(sys_bdflush)
/* 135 */	.long	SYMBOL_NAME(sys_sysfs)
		.long	SYMBOL_NAME(sys_personality)
		.long	SYMBOL_NAME(sys_ni_syscall)		/* .long	_sys_afs_syscall */
		.long	SYMBOL_NAME(sys_setfsuid)
		.long	SYMBOL_NAME(sys_setfsgid)
/* 140 */	.long	SYMBOL_NAME(sys_llseek_wrapper)
		.long	SYMBOL_NAME(sys_getdents)
		.long	SYMBOL_NAME(sys_select)
		.long	SYMBOL_NAME(sys_flock)
		.long	SYMBOL_NAME(sys_msync)
/* 145 */	.long	SYMBOL_NAME(sys_readv)
		.long	SYMBOL_NAME(sys_writev)
		.long	SYMBOL_NAME(sys_getsid)
		.long	SYMBOL_NAME(sys_ni_syscall)
		.long	SYMBOL_NAME(sys_ni_syscall)
/* 150 */	.long	SYMBOL_NAME(sys_mlock)
		.long	SYMBOL_NAME(sys_munlock)
		.long	SYMBOL_NAME(sys_mlockall)
		.long	SYMBOL_NAME(sys_munlockall)
		.long	SYMBOL_NAME(sys_sched_setparam)
/* 155 */	.long	SYMBOL_NAME(sys_sched_getparam)
		.long	SYMBOL_NAME(sys_sched_setscheduler)
		.long	SYMBOL_NAME(sys_sched_getscheduler)
		.long	SYMBOL_NAME(sys_sched_yield)
		.long	SYMBOL_NAME(sys_sched_get_priority_max)
/* 160 */	.long	SYMBOL_NAME(sys_sched_get_priority_min)
		.long	SYMBOL_NAME(sys_sched_rr_get_interval)
		.long	SYMBOL_NAME(sys_nanosleep)
		.long	SYMBOL_NAME(sys_mremap)
		.long	SYMBOL_NAME(sys_setresuid)
/* 165 */	.long	SYMBOL_NAME(sys_getresuid)
		.long	SYMBOL_NAME(sys_ni_syscall)
		.long	SYMBOL_NAME(sys_query_module)
		.long	SYMBOL_NAME(sys_poll)
		.long	SYMBOL_NAME(sys_nfsservctl)
/* 170 */	.long	SYMBOL_NAME(sys_setresgid)
		.long	SYMBOL_NAME(sys_getresgid)
		.long	SYMBOL_NAME(sys_prctl)
		.long	SYMBOL_NAME(sys_rt_sigreturn_wrapper)
		.long	SYMBOL_NAME(sys_rt_sigaction)
/* 175 */	.long	SYMBOL_NAME(sys_rt_sigprocmask)
		.long	SYMBOL_NAME(sys_rt_sigpending)
		.long	SYMBOL_NAME(sys_rt_sigtimedwait)
		.long	SYMBOL_NAME(sys_rt_sigqueueinfo)
		.long	SYMBOL_NAME(sys_rt_sigsuspend_wrapper)
/* 180 */	.long	SYMBOL_NAME(sys_pread)
		.long	SYMBOL_NAME(sys_pwrite)
#if 0
		.long	SYMBOL_NAME(sys_xstat)
		.long	SYMBOL_NAME(sys_xmknod)
#else
		.space	8
#endif
		.space	(NR_syscalls - 184) * 4
#endif
