/*
 *
 *  BlueZ - Bluetooth protocol stack for Linux
 *
 *  Copyright (C) 2011  Intel Corporation
 *
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <glib.h>

#include <bluetooth/bluetooth.h>
#include <bluetooth/hci.h>
#include <bluetooth/sdp.h>

#include "src/eir.h"

static void test_basic(void)
{
	struct eir_data data;
	unsigned char buf[HCI_MAX_EIR_LENGTH];
	int err;

	memset(buf, 0, sizeof(buf));
	memset(&data, 0, sizeof(data));

	err = eir_parse(&data, buf, HCI_MAX_EIR_LENGTH);
	g_assert(err == 0);
	g_assert(data.services == NULL);
	g_assert(data.name == NULL);

	eir_data_free(&data);
}

int main(int argc, char *argv[])
{
	g_test_init(&argc, &argv, NULL);

	g_test_add_func("/eir/basic", test_basic);

	return g_test_run();
}
