Описание
========

Xkbind (сокращение от X KeyBoard INDicator) показывает текущую раскладку
клавиатуры в "многоязычных" конфигурациях, что значительно повышает
удобство и скорость работы с текстами со смешанным набором символов.
При этом каждому окну верхнего уровня присваивается своя индивидуальная
группа, которая "включается" автоматически при получении окном фокуса,
создавая эффект независимости раскладок.

Особенностью программы является то, что номера присвоенных окнам
групп хранятся не в памяти программы, как это обычно делается в
аналогичных приложениях, а на стороне X-сервера в виде свойств окна.
Это позволяет сделать привязку групп независимой от текущего состояния
управляющей программы.  Скажем, если вы перезагрузите Xkbind после
некорректного завершения ее работы, все ранее установленные настройки
будут восстановятся автоматически.

Другой отличительной особенностью программы является то, что она
не занимает места на экране компьютера, так как всю необходимую
информацию выводит непосредственно в заголовок окна.  Конечно,
конкретное расположение заголовка (и вообще его наличие) целиком
зависит от используемого менеджера окон.  Xkbind поддерживает работу с
большинством из них, включая TWM, MWM и FVWM.

Xkbind очень экономичен в отношении занимаемой памяти (<150 килобайт)
и практически не расходует рабочего времени процессора, что немаловажно
для вспомогательного программного обеспечения.

Xkbind имеет много опций конфигурации, большинство которых может
задаваться как из командой строки, так и из файлов конфигурации,
использующих стандартную нотацию X-ресурсов.  Подробнее об этом можно
узнать из прилагающегося файла помощи в man-формате.  Xkbind читает
опции конфигурации в следующей последовательности (в порядке убывания
приоритета):

1. из параметров, заданных в командной строки;

2. в файле $(HOME)/.xkbindrc;

3. в файле $(HOME)/.Xdefaults или $(HOME)/.Xresources;

4. в файле /usr/local/lib/xkbind/app-defaults/Xkbind (конкретный путь
   может отличаться в вашей системе, смотрите "Установка").

Если одна и та же опция задана более одного раза, используется та,
что имеет наивысший приоритет.


Компиляция
==========

Для "сборки" программы необходимо выполнить следующие команды:

  $ tar xvzf xkbind-<version>.tar.gz
  $ cd xkbind-<version>
  $ ./configure
  $ make

(Вместо <version> подставьте текущий номер версии.)


Установка
=========

Для установки введите команду:

     $ make install

По умолчанию, установка производится в каталог "/usr/local/".
Для установки в  другом каталоге укажите путь к нему в переменной prefix:

     $ make install prefix=<path>

Подробнее об этом можно прочитать в текстовом файле INSTALL.


Как пользоваться
================

Загружать Xkbind можно из командной строки или любым другим доступным
способом.  Для автоматической загрузки в начале каждой X-сессии, добавьте
строку "xkbind" в .xsession или .xinitrc перед запуском менеджера окон.

Так как программа не имеет собственного интерфейса, для корректного
завершения ее работы следует использовать сигнал SIGTERM или SIGINT:

  $ pkill xkbind

Замечания
=========

Xkbind несовместим с приложениям, отслеживающим изменения в заголовках
окон (свойств WM_NAME), например, другими индикаторами, работающими по
тому же принципу, в том числе и со своей второй копией, но последнее
отслеживается автоматически.  Это следует иметь в виду при эксплуатации
программы.  Характерный признак несовместимости--испорченные заголовки
в окнах.


Аналогичные программы
=====================

1. FvwmKb <http://sourceforge.net/projects/fvwmkb>--модуль поддержки
   XKB для менеджера окон FVWM.

2. xxkb <http://www.tsu.ru/~pascal/other/xxkb>--индикатор и переключатель
   раскладок XKB с поддержкой иконок.


Контакты
========

Интернет: http://xkbind.sourceforge.net
E-mail: smersh@users.sourceforge.net
