/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.deploy;

import com.sun.appserv.management.base.OperationStatusBase;
import com.sun.appserv.management.deploy.DeploymentStatus;
import com.sun.appserv.management.util.misc.TypeCast;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class DeploymentStatusImpl
extends OperationStatusBase
implements DeploymentStatus {
    transient DeploymentStatus mParent;

    public DeploymentStatusImpl(DeploymentStatus src) {
        this(src.asMap(), true);
    }

    private <T extends Serializable> DeploymentStatusImpl(Map<String, T> m, boolean doValidate) {
        super(m, "com.sun.appserv.management.deploy.DeploymentStatus");
        this.checkValidType(m, "com.sun.appserv.management.deploy.DeploymentStatus");
        this.mParent = null;
        this.convertSubStages();
        if (doValidate && !this.validate()) {
            throw new IllegalArgumentException(this.toString());
        }
    }

    public <T extends Serializable> DeploymentStatusImpl(Map<String, T> m) {
        this(m, true);
        this.convertSubStages();
    }

    public <T extends Serializable> DeploymentStatusImpl(int stageStatus, String stageStatusMessage, String stageDescription, Map<String, T> optional) {
        super(null, "com.sun.appserv.management.deploy.DeploymentStatus");
        this.putAll(optional);
        this.setStageStatus(stageStatus);
        this.setStageStatusMessage(stageStatusMessage == null ? "" : stageStatusMessage);
        this.setStageDescription(stageDescription == null ? "" : stageDescription);
        this.convertSubStages();
        if (!this.validate()) {
            throw new IllegalArgumentException();
        }
    }

    private void convertSubStages() {
        List value = (List)List.class.cast(this.getField("SubStages"));
        if (value != null && value.size() != 0) {
            ArrayList<DeploymentStatusImpl> ssList = new ArrayList<DeploymentStatusImpl>();
            for (Object o : value) {
                DeploymentStatusImpl ds = null;
                if (o instanceof Map) {
                    Map m = TypeCast.asMap(o);
                    ds = new DeploymentStatusImpl(m, true);
                } else if (o instanceof DeploymentStatus) {
                    DeploymentStatus in = (DeploymentStatus)o;
                    ds = new DeploymentStatusImpl(in);
                } else {
                    throw new IllegalArgumentException();
                }
                ds.setParent(this);
                ssList.add(ds);
            }
            this.putField("SubStages", ssList);
        }
    }

    @Override
    protected Serializable asMapHook(String key, Serializable value) {
        ArrayList<Map<String, Serializable>> result = value;
        if ("SubStages".equals(key)) {
            List l = (List)List.class.cast(value);
            if (l != null && l.size() != 0) {
                List<DeploymentStatus> lds = TypeCast.checkList(l, DeploymentStatus.class);
                ArrayList<Map<String, Serializable>> maps = new ArrayList<Map<String, Serializable>>();
                for (DeploymentStatus ds : lds) {
                    maps.add(ds.asMap());
                }
                result = maps;
            }
        } else {
            result = super.asMapHook(key, value);
        }
        return result;
    }

    @Override
    protected boolean validate() {
        boolean valid;
        boolean bl = valid = this.getInteger("StatusCodeKey") != null;
        assert (valid) : "STAGE_STATUS_KEY missing";
        if (valid && this.getString("StageStatusMessage") == null) {
            this.putField("StageStatusMessage", (Serializable)((Object)"N/A"));
        }
        if (valid) {
            List value = (List)List.class.cast(this.getField("SubStages"));
            List<DeploymentStatus> list = TypeCast.checkList(value, DeploymentStatus.class);
        }
        return valid;
    }

    @Override
    public String getStageDescription() {
        return this.getString("StageDescription");
    }

    public void setStageDescription(String description) {
        this.putField("StageDescription", (Serializable)((Object)description));
    }

    @Override
    public String getStageStatusMessage() {
        return this.getString("StageStatusMessage");
    }

    public void setStageStatusMessage(String message) {
        this.putField("StageStatusMessage", (Serializable)((Object)message));
    }

    @Override
    public int getStageStatus() {
        return this.getStatusCode();
    }

    public void setStageStatus(int status) {
        this.setStatusCode(status);
    }

    private List<DeploymentStatus> getDeploymentStatusField() {
        List value = (List)List.class.cast(this.getField("SubStages"));
        List<DeploymentStatus> subStages = TypeCast.checkList(value, DeploymentStatus.class);
        return subStages;
    }

    public void addSubStage(DeploymentStatus status) {
        status.setParent(this);
        List<DeploymentStatus> subStages = this.getDeploymentStatusField();
        if (subStages == null) {
            subStages = new ArrayList<DeploymentStatus>();
            this.putField("SubStages", (Serializable)((Object)subStages));
        }
        subStages.add(status);
    }

    @Override
    public Iterator<Map<String, Serializable>> getSubStages() {
        List maps = null;
        List<DeploymentStatus> subStages = this.getSubStagesList();
        if (subStages != null) {
            maps = new ArrayList();
            for (DeploymentStatus ds : subStages) {
                maps.add(ds.asMap());
            }
        } else {
            maps = Collections.emptyList();
        }
        return maps.iterator();
    }

    @Override
    public List<DeploymentStatus> getSubStagesList() {
        List<DeploymentStatus> subStages = this.getDeploymentStatusField();
        TypeCast.checkList(subStages, DeploymentStatus.class);
        subStages = subStages == null ? Collections.emptyList() : Collections.unmodifiableList(subStages);
        return subStages;
    }

    @Override
    public DeploymentStatus getParent() {
        return this.mParent;
    }

    @Override
    public void setParent(DeploymentStatus parent) {
        this.mParent = parent;
    }

    @Override
    public Throwable getStageThrowable() {
        return this.getThrowable();
    }

    public void setStageThrowable(Throwable t) {
        this.setThrowable(t);
    }

    @Override
    public Map<String, Serializable> getAdditionalStatus() {
        return this.getMap("AdditionalStatus");
    }

    public void setAdditionalStatus(Map<String, Serializable> additionalStatus) {
        if (!(additionalStatus instanceof Serializable)) {
            throw new IllegalArgumentException("Class is not Serializable: " + additionalStatus.getClass().getName());
        }
        this.putField("AdditionalStatus", (Serializable)((Object)additionalStatus));
    }

    @Override
    public boolean equals(Object rhs) {
        boolean equal = false;
        equal = rhs instanceof DeploymentStatus && !(rhs instanceof DeploymentStatusImpl) ? super.equals(new DeploymentStatusImpl((DeploymentStatus)rhs)) : super.equals(rhs);
        return equal;
    }
}

