
// std lib related includes
#include <tuple>

// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;

// Standard Handle
#include <Standard_Handle.hxx>


// includes to resolve forward declarations
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Poly_Triangulation.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Prs3d_IsoAspect.hxx>
#include <Prs3d_LineAspect.hxx>
#include <Prs3d_TextAspect.hxx>
#include <Prs3d_ShadingAspect.hxx>
#include <Prs3d_PointAspect.hxx>
#include <Prs3d_PlaneAspect.hxx>
#include <Prs3d_ArrowAspect.hxx>
#include <Prs3d_DatumAspect.hxx>
#include <Prs3d_DimensionAspect.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>

// module includes
#include <Prs3d.hxx>
#include <Prs3d_Arrow.hxx>
#include <Prs3d_ArrowAspect.hxx>
#include <Prs3d_BasicAspect.hxx>
#include <Prs3d_BndBox.hxx>
#include <Prs3d_DatumAspect.hxx>
#include <Prs3d_DatumAttribute.hxx>
#include <Prs3d_DatumAxes.hxx>
#include <Prs3d_DatumMode.hxx>
#include <Prs3d_DatumParts.hxx>
#include <Prs3d_DimensionArrowOrientation.hxx>
#include <Prs3d_DimensionAspect.hxx>
#include <Prs3d_DimensionTextHorizontalPosition.hxx>
#include <Prs3d_DimensionTextVerticalPosition.hxx>
#include <Prs3d_DimensionUnits.hxx>
#include <Prs3d_Drawer.hxx>
#include <Prs3d_InvalidAngle.hxx>
#include <Prs3d_IsoAspect.hxx>
#include <Prs3d_LineAspect.hxx>
#include <Prs3d_NListIteratorOfListOfSequenceOfPnt.hxx>
#include <Prs3d_NListOfSequenceOfPnt.hxx>
#include <Prs3d_PlaneAspect.hxx>
#include <Prs3d_Point.hxx>
#include <Prs3d_PointAspect.hxx>
#include <Prs3d_Presentation.hxx>
#include <Prs3d_PresentationShadow.hxx>
#include <Prs3d_Root.hxx>
#include <Prs3d_ShadingAspect.hxx>
#include <Prs3d_ShapeTool.hxx>
#include <Prs3d_Text.hxx>
#include <Prs3d_TextAspect.hxx>
#include <Prs3d_ToolCylinder.hxx>
#include <Prs3d_ToolDisk.hxx>
#include <Prs3d_ToolQuadric.hxx>
#include <Prs3d_ToolSector.hxx>
#include <Prs3d_ToolSphere.hxx>
#include <Prs3d_ToolTorus.hxx>
#include <Prs3d_TypeOfHighlight.hxx>
#include <Prs3d_TypeOfHLR.hxx>
#include <Prs3d_TypeOfLinePicking.hxx>
#include <Prs3d_VertexDrawMode.hxx>

// template related includes

// ./opencascade/Prs3d_NListOfSequenceOfPnt.hxx
#include "NCollection_tmpl.hxx"


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module
#include <Graphic3d_StructureManager.hxx>
#include <Graphic3d_Text.hxx>

// Module definiiton
void register_Prs3d(py::module &main_module) {


py::module m = static_cast<py::module>(main_module.attr("Prs3d"));
py::object klass;

//Python trampoline classes
    class Py_Prs3d_BasicAspect : public Prs3d_BasicAspect{
    public:
        using Prs3d_BasicAspect::Prs3d_BasicAspect;


        // public pure virtual
        void DumpJson(std::ostream & theOStream,Standard_Integer theDepth) const  override { PYBIND11_OVERLOAD_PURE(void,Prs3d_BasicAspect,DumpJson,theOStream,theDepth) };


        // protected pure virtual


        // private pure virtual

    };
    class Py_Prs3d_ToolQuadric : public Prs3d_ToolQuadric{
    public:
        using Prs3d_ToolQuadric::Prs3d_ToolQuadric;


        // public pure virtual


        // protected pure virtual
        gp_Pnt Vertex(const Standard_Real theU,const Standard_Real theV) const  override { PYBIND11_OVERLOAD_PURE(gp_Pnt,Prs3d_ToolQuadric,Vertex,theU,theV) };
        gp_Dir Normal(const Standard_Real theU,const Standard_Real theV) const  override { PYBIND11_OVERLOAD_PURE(gp_Dir,Prs3d_ToolQuadric,Normal,theU,theV) };


        // private pure virtual

    };

// classes

    // Class Prs3d from ./opencascade/Prs3d.hxx
    klass = m.attr("Prs3d");

    // default constructor
    register_default_constructor<Prs3d , shared_ptr<Prs3d>>(m,"Prs3d");

    // nested enums

    static_cast<py::class_<Prs3d , shared_ptr<Prs3d>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("MatchSegment_s",
                    (Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const gp_Pnt & ,  const gp_Pnt & ,  Standard_Real &  ) ) static_cast<Standard_Boolean (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const gp_Pnt & ,  const gp_Pnt & ,  Standard_Real &  ) >(&Prs3d::MatchSegment),
                    R"#(draws an arrow at a given location, with respect to a given direction.)#"  , py::arg("X"),  py::arg("Y"),  py::arg("Z"),  py::arg("aDistance"),  py::arg("p1"),  py::arg("p2"),  py::arg("dist")
          )
        .def_static("GetDeflection_s",
                    (Standard_Real (*)(  const NCollection_Vec3<Standard_Real> & ,   const NCollection_Vec3<Standard_Real> & ,  const Standard_Real  ) ) static_cast<Standard_Real (*)(  const NCollection_Vec3<Standard_Real> & ,   const NCollection_Vec3<Standard_Real> & ,  const Standard_Real  ) >(&Prs3d::GetDeflection),
                    R"#(Computes the absolute deflection value based on relative deflection Prs3d_Drawer::DeviationCoefficient().)#"  , py::arg("theBndMin"),  py::arg("theBndMax"),  py::arg("theDeviationCoefficient")
          )
        .def_static("GetDeflection_s",
                    (Standard_Real (*)( const Bnd_Box & ,  const Standard_Real ,  const Standard_Real  ) ) static_cast<Standard_Real (*)( const Bnd_Box & ,  const Standard_Real ,  const Standard_Real  ) >(&Prs3d::GetDeflection),
                    R"#(Computes the absolute deflection value based on relative deflection Prs3d_Drawer::DeviationCoefficient().)#"  , py::arg("theBndBox"),  py::arg("theDeviationCoefficient"),  py::arg("theMaximalChordialDeviation")
          )
        .def_static("PrimitivesFromPolylines_s",
                    (opencascade::handle<Graphic3d_ArrayOfPrimitives> (*)(  const NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfPrimitives> (*)(  const NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) >(&Prs3d::PrimitivesFromPolylines),
                    R"#(Assembles array of primitives for sequence of polylines.)#"  , py::arg("thePoints")
          )
        .def_static("AddPrimitivesGroup_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<Prs3d_LineAspect> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const opencascade::handle<Prs3d_LineAspect> & ,  NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>> &  ) >(&Prs3d::AddPrimitivesGroup),
                    R"#(Add primitives into new group in presentation and clear the list of polylines.)#"  , py::arg("thePrs"),  py::arg("theAspect"),  py::arg("thePolylines")
          )
        .def_static("AddFreeEdges_s",
                    (void (*)( NCollection_Sequence<gp_Pnt> & ,  const opencascade::handle<Poly_Triangulation> & ,  const gp_Trsf &  ) ) static_cast<void (*)( NCollection_Sequence<gp_Pnt> & ,  const opencascade::handle<Poly_Triangulation> & ,  const gp_Trsf &  ) >(&Prs3d::AddFreeEdges),
                    R"#(Add triangulation free edges into sequence of line segments.)#"  , py::arg("theSegments"),  py::arg("thePolyTri"),  py::arg("theLocation")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Prs3d_Arrow from ./opencascade/Prs3d_Arrow.hxx
    klass = m.attr("Prs3d_Arrow");

    // default constructor
    register_default_constructor<Prs3d_Arrow , shared_ptr<Prs3d_Arrow>>(m,"Prs3d_Arrow");

    // nested enums

    static_cast<py::class_<Prs3d_Arrow , shared_ptr<Prs3d_Arrow>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("DrawShaded_s",
                    (opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const gp_Ax1 & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const gp_Ax1 & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer  ) >(&Prs3d_Arrow::DrawShaded),
                    R"#(Defines the representation of the arrow as shaded triangulation.)#"  , py::arg("theAxis"),  py::arg("theTubeRadius"),  py::arg("theAxisLength"),  py::arg("theConeRadius"),  py::arg("theConeLength"),  py::arg("theNbFacettes")
          )
        .def_static("DrawSegments_s",
                    (opencascade::handle<Graphic3d_ArrayOfSegments> (*)( const gp_Pnt & ,  const gp_Dir & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfSegments> (*)( const gp_Pnt & ,  const gp_Dir & ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer  ) >(&Prs3d_Arrow::DrawSegments),
                    R"#(Defines the representation of the arrow as a container of segments.)#"  , py::arg("theLocation"),  py::arg("theDir"),  py::arg("theAngle"),  py::arg("theLength"),  py::arg("theNbSegments")
          )
        .def_static("Draw_s",
                    (void (*)( const opencascade::handle<Graphic3d_Group> & ,  const gp_Pnt & ,  const gp_Dir & ,  const Standard_Real ,  const Standard_Real  ) ) static_cast<void (*)( const opencascade::handle<Graphic3d_Group> & ,  const gp_Pnt & ,  const gp_Dir & ,  const Standard_Real ,  const Standard_Real  ) >(&Prs3d_Arrow::Draw),
                    R"#(Defines the representation of the arrow. Note that this method does NOT assign any presentation aspects to the primitives group!)#"  , py::arg("theGroup"),  py::arg("theLocation"),  py::arg("theDirection"),  py::arg("theAngle"),  py::arg("theLength")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Prs3d_BasicAspect from ./opencascade/Prs3d_BasicAspect.hxx
    klass = m.attr("Prs3d_BasicAspect");


    // nested enums

    static_cast<py::class_<Prs3d_BasicAspect ,opencascade::handle<Prs3d_BasicAspect> ,Py_Prs3d_BasicAspect , Standard_Transient >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("DumpJson",
             (void (Prs3d_BasicAspect::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Prs3d_BasicAspect::*)( std::ostream & ,  Standard_Integer  ) const>(&Prs3d_BasicAspect::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_BasicAspect::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_BasicAspect::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_BasicAspect::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_BasicAspect::*)() const>(&Prs3d_BasicAspect::DynamicType),
             R"#(None)#"
             
         )
;

    // Class Prs3d_DimensionUnits from ./opencascade/Prs3d_DimensionUnits.hxx
    klass = m.attr("Prs3d_DimensionUnits");


    // nested enums

    static_cast<py::class_<Prs3d_DimensionUnits , shared_ptr<Prs3d_DimensionUnits>  >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Prs3d_DimensionUnits & >()  , py::arg("theUnits") )
    // custom constructors
    // methods
        .def("SetAngleUnits",
             (void (Prs3d_DimensionUnits::*)( const TCollection_AsciiString &  ) ) static_cast<void (Prs3d_DimensionUnits::*)( const TCollection_AsciiString &  ) >(&Prs3d_DimensionUnits::SetAngleUnits),
             R"#(Sets angle units)#"  , py::arg("theUnits")
          )
        .def("SetLengthUnits",
             (void (Prs3d_DimensionUnits::*)( const TCollection_AsciiString &  ) ) static_cast<void (Prs3d_DimensionUnits::*)( const TCollection_AsciiString &  ) >(&Prs3d_DimensionUnits::SetLengthUnits),
             R"#(Sets length units)#"  , py::arg("theUnits")
          )
    // methods using call by reference i.s.o. return
    // static methods
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("GetAngleUnits",
             (const TCollection_AsciiString & (Prs3d_DimensionUnits::*)() const) static_cast<const TCollection_AsciiString & (Prs3d_DimensionUnits::*)() const>(&Prs3d_DimensionUnits::GetAngleUnits),
             R"#(Returns angle units)#"
             
         )
       .def("GetLengthUnits",
             (const TCollection_AsciiString & (Prs3d_DimensionUnits::*)() const) static_cast<const TCollection_AsciiString & (Prs3d_DimensionUnits::*)() const>(&Prs3d_DimensionUnits::GetLengthUnits),
             R"#(Returns length units)#"
             
         )
;

    // Class Prs3d_Drawer from ./opencascade/Prs3d_Drawer.hxx
    klass = m.attr("Prs3d_Drawer");


    // nested enums

    static_cast<py::class_<Prs3d_Drawer ,opencascade::handle<Prs3d_Drawer>  , Graphic3d_PresentationAttributes >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetupOwnDefaults",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::SetupOwnDefaults),
             R"#(Setup all own aspects with default values.)#" 
          )
        .def("SetTypeOfDeflection",
             (void (Prs3d_Drawer::*)( const Aspect_TypeOfDeflection  ) ) static_cast<void (Prs3d_Drawer::*)( const Aspect_TypeOfDeflection  ) >(&Prs3d_Drawer::SetTypeOfDeflection),
             R"#(Sets the type of chordal deflection. This indicates whether the deflection value is absolute or relative to the size of the object.)#"  , py::arg("theTypeOfDeflection")
          )
        .def("TypeOfDeflection",
             (Aspect_TypeOfDeflection (Prs3d_Drawer::*)() const) static_cast<Aspect_TypeOfDeflection (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::TypeOfDeflection),
             R"#(Returns the type of chordal deflection. This indicates whether the deflection value is absolute or relative to the size of the object.)#" 
          )
        .def("HasOwnTypeOfDeflection",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnTypeOfDeflection),
             R"#(Returns true if the drawer has a type of deflection setting active.)#" 
          )
        .def("UnsetOwnTypeOfDeflection",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnTypeOfDeflection),
             R"#(Resets HasOwnTypeOfDeflection() flag, e.g. undoes SetTypeOfDeflection().)#" 
          )
        .def("SetMaximalChordialDeviation",
             (void (Prs3d_Drawer::*)( const Standard_Real  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Real  ) >(&Prs3d_Drawer::SetMaximalChordialDeviation),
             R"#(Defines the maximal chordial deviation when drawing any curve. Even if the type of deviation is set to TOD_Relative, this value is used by: Prs3d_DeflectionCurve Prs3d_WFDeflectionSurface Prs3d_WFDeflectionRestrictedFace)#"  , py::arg("theChordialDeviation")
          )
        .def("MaximalChordialDeviation",
             (Standard_Real (Prs3d_Drawer::*)() const) static_cast<Standard_Real (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::MaximalChordialDeviation),
             R"#(Returns the maximal chordal deviation. The default value is 0.0001. Drawings of curves or patches are made with respect to an absolute maximal chordal deviation.)#" 
          )
        .def("HasOwnMaximalChordialDeviation",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnMaximalChordialDeviation),
             R"#(Returns true if the drawer has a maximal chordial deviation setting active.)#" 
          )
        .def("UnsetOwnMaximalChordialDeviation",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnMaximalChordialDeviation),
             R"#(Resets HasOwnMaximalChordialDeviation() flag, e.g. undoes SetMaximalChordialDeviation().)#" 
          )
        .def("SetTypeOfHLR",
             (void (Prs3d_Drawer::*)( const Prs3d_TypeOfHLR  ) ) static_cast<void (Prs3d_Drawer::*)( const Prs3d_TypeOfHLR  ) >(&Prs3d_Drawer::SetTypeOfHLR),
             R"#(Sets the type of HLR algorithm used by drawer's interactive objects)#"  , py::arg("theTypeOfHLR")
          )
        .def("TypeOfHLR",
             (Prs3d_TypeOfHLR (Prs3d_Drawer::*)() const) static_cast<Prs3d_TypeOfHLR (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::TypeOfHLR),
             R"#(Returns the type of HLR algorithm currently in use.)#" 
          )
        .def("HasOwnTypeOfHLR",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnTypeOfHLR),
             R"#(Returns true if the type of HLR is not equal to Prs3d_TOH_NotSet.)#" 
          )
        .def("SetMaximalParameterValue",
             (void (Prs3d_Drawer::*)( const Standard_Real  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Real  ) >(&Prs3d_Drawer::SetMaximalParameterValue),
             R"#(Defines the maximum value allowed for the first and last parameters of an infinite curve.)#"  , py::arg("theValue")
          )
        .def("MaximalParameterValue",
             (Standard_Real (Prs3d_Drawer::*)() const) static_cast<Standard_Real (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::MaximalParameterValue),
             R"#(Sets the maximum value allowed for the first and last parameters of an infinite curve. By default, this value is 500000.)#" 
          )
        .def("HasOwnMaximalParameterValue",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnMaximalParameterValue),
             R"#(Returns true if the drawer has a maximum value allowed for the first and last parameters of an infinite curve setting active.)#" 
          )
        .def("UnsetOwnMaximalParameterValue",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnMaximalParameterValue),
             R"#(Resets HasOwnMaximalParameterValue() flag, e.g. undoes SetMaximalParameterValue().)#" 
          )
        .def("SetIsoOnPlane",
             (void (Prs3d_Drawer::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Boolean  ) >(&Prs3d_Drawer::SetIsoOnPlane),
             R"#(Sets IsoOnPlane on or off by setting the parameter theIsEnabled to true or false.)#"  , py::arg("theIsEnabled")
          )
        .def("IsoOnPlane",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::IsoOnPlane),
             R"#(Returns True if the drawing of isos on planes is enabled.)#" 
          )
        .def("HasOwnIsoOnPlane",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnIsoOnPlane),
             R"#(Returns true if the drawer has IsoOnPlane setting active.)#" 
          )
        .def("UnsetOwnIsoOnPlane",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnIsoOnPlane),
             R"#(Resets HasOwnIsoOnPlane() flag, e.g. undoes SetIsoOnPlane().)#" 
          )
        .def("IsoOnTriangulation",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::IsoOnTriangulation),
             R"#(Returns True if the drawing of isos on triangulation is enabled.)#" 
          )
        .def("HasOwnIsoOnTriangulation",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnIsoOnTriangulation),
             R"#(Returns true if the drawer has IsoOnTriangulation setting active.)#" 
          )
        .def("UnsetOwnIsoOnTriangulation",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnIsoOnTriangulation),
             R"#(Resets HasOwnIsoOnTriangulation() flag, e.g. undoes SetIsoOnTriangulation().)#" 
          )
        .def("SetIsoOnTriangulation",
             (void (Prs3d_Drawer::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Boolean  ) >(&Prs3d_Drawer::SetIsoOnTriangulation),
             R"#(Enables or disables isolines on triangulation by setting the parameter theIsEnabled to true or false.)#"  , py::arg("theToEnable")
          )
        .def("SetDiscretisation",
             (void (Prs3d_Drawer::*)( const Standard_Integer  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Integer  ) >(&Prs3d_Drawer::SetDiscretisation),
             R"#(Sets the discretisation parameter theValue.)#"  , py::arg("theValue")
          )
        .def("Discretisation",
             (Standard_Integer (Prs3d_Drawer::*)() const) static_cast<Standard_Integer (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::Discretisation),
             R"#(Returns the discretisation setting.)#" 
          )
        .def("HasOwnDiscretisation",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnDiscretisation),
             R"#(Returns true if the drawer has discretisation setting active.)#" 
          )
        .def("UnsetOwnDiscretisation",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnDiscretisation),
             R"#(Resets HasOwnDiscretisation() flag, e.g. undoes SetDiscretisation().)#" 
          )
        .def("SetDeviationCoefficient",
             (void (Prs3d_Drawer::*)( const Standard_Real  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Real  ) >(&Prs3d_Drawer::SetDeviationCoefficient),
             R"#(Sets the deviation coefficient theCoefficient. Also sets the hasOwnDeviationCoefficient flag to Standard_True and myPreviousDeviationCoefficient)#"  , py::arg("theCoefficient")
          )
        .def("DeviationCoefficient",
             (Standard_Real (Prs3d_Drawer::*)() const) static_cast<Standard_Real (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::DeviationCoefficient),
             R"#(Returns the deviation coefficient. Drawings of curves or patches are made with respect to a maximal chordal deviation. A Deviation coefficient is used in the shading display mode. The shape is seen decomposed into triangles. These are used to calculate reflection of light from the surface of the object. The triangles are formed from chords of the curves in the shape. The deviation coefficient gives the highest value of the angle with which a chord can deviate from a tangent to a curve. If this limit is reached, a new triangle is begun. This deviation is absolute and is set through the method: SetMaximalChordialDeviation. The default value is 0.001. In drawing shapes, however, you are allowed to ask for a relative deviation. This deviation will be: SizeOfObject * DeviationCoefficient.)#" 
          )
        .def("SetDeviationCoefficient",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::SetDeviationCoefficient),
             R"#(Resets HasOwnDeviationCoefficient() flag, e.g. undoes previous SetDeviationCoefficient().)#" 
          )
        .def("HasOwnDeviationCoefficient",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnDeviationCoefficient),
             R"#(Returns true if there is a local setting for deviation coefficient in this framework for a specific interactive object.)#" 
          )
        .def("PreviousDeviationCoefficient",
             (Standard_Real (Prs3d_Drawer::*)() const) static_cast<Standard_Real (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::PreviousDeviationCoefficient),
             R"#(Saves the previous value used for the chordal deviation coefficient.)#" 
          )
        .def("UpdatePreviousDeviationCoefficient",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UpdatePreviousDeviationCoefficient),
             R"#(Updates the previous value used for the chordal deviation coefficient to the current state.)#" 
          )
        .def("SetDeviationAngle",
             (void (Prs3d_Drawer::*)( const Standard_Real  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Real  ) >(&Prs3d_Drawer::SetDeviationAngle),
             R"#(Sets the deviation angle theAngle. Also sets the hasOwnDeviationAngle flag to Standard_True, and myPreviousDeviationAngle.)#"  , py::arg("theAngle")
          )
        .def("DeviationAngle",
             (Standard_Real (Prs3d_Drawer::*)() const) static_cast<Standard_Real (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::DeviationAngle),
             R"#(Returns the value for deviation angle in radians, 20 * M_PI / 180 by default.)#" 
          )
        .def("SetDeviationAngle",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::SetDeviationAngle),
             R"#(Resets HasOwnDeviationAngle() flag, e.g. undoes previous SetDeviationAngle().)#" 
          )
        .def("HasOwnDeviationAngle",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnDeviationAngle),
             R"#(Returns true if there is a local setting for deviation angle in this framework for a specific interactive object.)#" 
          )
        .def("PreviousDeviationAngle",
             (Standard_Real (Prs3d_Drawer::*)() const) static_cast<Standard_Real (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::PreviousDeviationAngle),
             R"#(Returns the previous deviation angle)#" 
          )
        .def("UpdatePreviousDeviationAngle",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UpdatePreviousDeviationAngle),
             R"#(Updates the previous deviation angle to the current value)#" 
          )
        .def("SetAutoTriangulation",
             (void (Prs3d_Drawer::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Boolean  ) >(&Prs3d_Drawer::SetAutoTriangulation),
             R"#(Sets IsAutoTriangulated on or off by setting the parameter theIsEnabled to true or false. If this flag is True automatic re-triangulation with deflection-check logic will be applied. Else this feature will be disable and triangulation is expected to be computed by application itself and no shading presentation at all if unavailable.)#"  , py::arg("theIsEnabled")
          )
        .def("IsAutoTriangulation",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::IsAutoTriangulation),
             R"#(Returns True if automatic triangulation is enabled.)#" 
          )
        .def("HasOwnIsAutoTriangulation",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnIsAutoTriangulation),
             R"#(Returns true if the drawer has IsoOnPlane setting active.)#" 
          )
        .def("UnsetOwnIsAutoTriangulation",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnIsAutoTriangulation),
             R"#(Resets HasOwnIsAutoTriangulation() flag, e.g. undoes SetAutoTriangulation().)#" 
          )
        .def("SetUIsoAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_IsoAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_IsoAspect> &  ) >(&Prs3d_Drawer::SetUIsoAspect),
             R"#(None)#"  , py::arg("theAspect")
          )
        .def("HasOwnUIsoAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnUIsoAspect),
             R"#(Returns true if the drawer has its own attribute for UIso aspect that overrides the one in the link.)#" 
          )
        .def("SetVIsoAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_IsoAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_IsoAspect> &  ) >(&Prs3d_Drawer::SetVIsoAspect),
             R"#(Sets the appearance of V isoparameters - theAspect.)#"  , py::arg("theAspect")
          )
        .def("HasOwnVIsoAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnVIsoAspect),
             R"#(Returns true if the drawer has its own attribute for VIso aspect that overrides the one in the link.)#" 
          )
        .def("SetWireAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) >(&Prs3d_Drawer::SetWireAspect),
             R"#(Sets the parameter theAspect for display of wires.)#"  , py::arg("theAspect")
          )
        .def("HasOwnWireAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnWireAspect),
             R"#(Returns true if the drawer has its own attribute for wire aspect that overrides the one in the link.)#" 
          )
        .def("SetWireDraw",
             (void (Prs3d_Drawer::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Boolean  ) >(&Prs3d_Drawer::SetWireDraw),
             R"#(Sets WireDraw on or off by setting the parameter theIsEnabled to true or false.)#"  , py::arg("theIsEnabled")
          )
        .def("WireDraw",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::WireDraw),
             R"#(Returns True if the drawing of the wire is enabled.)#" 
          )
        .def("HasOwnWireDraw",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnWireDraw),
             R"#(Returns true if the drawer has its own attribute for "draw wires" flag that overrides the one in the link.)#" 
          )
        .def("UnsetOwnWireDraw",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnWireDraw),
             R"#(Resets HasOwnWireDraw() flag, e.g. undoes SetWireDraw().)#" 
          )
        .def("SetPointAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_PointAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_PointAspect> &  ) >(&Prs3d_Drawer::SetPointAspect),
             R"#(Sets the parameter theAspect for display attributes of points)#"  , py::arg("theAspect")
          )
        .def("HasOwnPointAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnPointAspect),
             R"#(Returns true if the drawer has its own attribute for point aspect that overrides the one in the link.)#" 
          )
        .def("SetupOwnPointAspect",
             (Standard_Boolean (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) >(&Prs3d_Drawer::SetupOwnPointAspect),
             R"#(Sets own point aspect, which is a yellow Aspect_TOM_PLUS marker by default. Returns FALSE if the drawer already has its own attribute for point aspect.)#"  , py::arg("theDefaults")=static_cast<const opencascade::handle<Prs3d_Drawer> &>(Handle ( Prs3d_Drawer ) ( ))
          )
        .def("SetLineAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) >(&Prs3d_Drawer::SetLineAspect),
             R"#(Sets the parameter theAspect for display attributes of lines.)#"  , py::arg("theAspect")
          )
        .def("HasOwnLineAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnLineAspect),
             R"#(Returns true if the drawer has its own attribute for line aspect that overrides the one in the link.)#" 
          )
        .def("SetOwnLineAspects",
             (Standard_Boolean (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) >(&Prs3d_Drawer::SetOwnLineAspects),
             R"#(Sets own line aspects, which are single U and single V gray75 solid isolines (::UIsoAspect(), ::VIsoAspect()), red wire (::WireAspect()), yellow line (::LineAspect()), yellow seen line (::SeenLineAspect()), dashed yellow hidden line (::HiddenLineAspect()), green free boundary (::FreeBoundaryAspect()), yellow unfree boundary (::UnFreeBoundaryAspect()). Returns FALSE if own line aspect are already set.)#"  , py::arg("theDefaults")=static_cast<const opencascade::handle<Prs3d_Drawer> &>(Handle ( Prs3d_Drawer ) ( ))
          )
        .def("SetOwnDatumAspects",
             (Standard_Boolean (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) >(&Prs3d_Drawer::SetOwnDatumAspects),
             R"#(Sets own line aspects for datums. Returns FALSE if own line for datums are already set.)#"  , py::arg("theDefaults")=static_cast<const opencascade::handle<Prs3d_Drawer> &>(Handle ( Prs3d_Drawer ) ( ))
          )
        .def("SetTextAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_TextAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_TextAspect> &  ) >(&Prs3d_Drawer::SetTextAspect),
             R"#(Sets the parameter theAspect for display attributes of text.)#"  , py::arg("theAspect")
          )
        .def("HasOwnTextAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnTextAspect),
             R"#(Returns true if the drawer has its own attribute for text aspect that overrides the one in the link.)#" 
          )
        .def("SetShadingAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_ShadingAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_ShadingAspect> &  ) >(&Prs3d_Drawer::SetShadingAspect),
             R"#(Sets the parameter theAspect for display attributes of shading.)#"  , py::arg("theAspect")
          )
        .def("HasOwnShadingAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnShadingAspect),
             R"#(Returns true if the drawer has its own attribute for shading aspect that overrides the one in the link.)#" 
          )
        .def("SetupOwnShadingAspect",
             (Standard_Boolean (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) >(&Prs3d_Drawer::SetupOwnShadingAspect),
             R"#(Sets own shading aspect, which is Graphic3d_NameOfMaterial_Brass material by default. Returns FALSE if the drawer already has its own attribute for shading aspect.)#"  , py::arg("theDefaults")=static_cast<const opencascade::handle<Prs3d_Drawer> &>(Handle ( Prs3d_Drawer ) ( ))
          )
        .def("SetSeenLineAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) >(&Prs3d_Drawer::SetSeenLineAspect),
             R"#(Sets the parameter theAspect for the display of seen lines in hidden line removal mode.)#"  , py::arg("theAspect")
          )
        .def("HasOwnSeenLineAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnSeenLineAspect),
             R"#(Returns true if the drawer has its own attribute for seen line aspect that overrides the one in the link.)#" 
          )
        .def("SetPlaneAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_PlaneAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_PlaneAspect> &  ) >(&Prs3d_Drawer::SetPlaneAspect),
             R"#(Sets the parameter theAspect for the display of planes.)#"  , py::arg("theAspect")
          )
        .def("HasOwnPlaneAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnPlaneAspect),
             R"#(Returns true if the drawer has its own attribute for plane aspect that overrides the one in the link.)#" 
          )
        .def("SetArrowAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_ArrowAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_ArrowAspect> &  ) >(&Prs3d_Drawer::SetArrowAspect),
             R"#(Sets the parameter theAspect for display attributes of arrows.)#"  , py::arg("theAspect")
          )
        .def("HasOwnArrowAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnArrowAspect),
             R"#(Returns true if the drawer has its own attribute for arrow aspect that overrides the one in the link.)#" 
          )
        .def("SetLineArrowDraw",
             (void (Prs3d_Drawer::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Boolean  ) >(&Prs3d_Drawer::SetLineArrowDraw),
             R"#(Enables the drawing of an arrow at the end of each line. By default the arrows are not drawn.)#"  , py::arg("theIsEnabled")
          )
        .def("LineArrowDraw",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::LineArrowDraw),
             R"#(Returns True if drawing an arrow at the end of each edge is enabled and False otherwise (the default).)#" 
          )
        .def("HasOwnLineArrowDraw",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnLineArrowDraw),
             R"#(Returns true if the drawer has its own attribute for "draw arrow" flag that overrides the one in the link.)#" 
          )
        .def("UnsetOwnLineArrowDraw",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnLineArrowDraw),
             R"#(Reset HasOwnLineArrowDraw() flag, e.g. undoes SetLineArrowDraw().)#" 
          )
        .def("SetHiddenLineAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) >(&Prs3d_Drawer::SetHiddenLineAspect),
             R"#(Sets the parameter theAspect for the display of hidden lines in hidden line removal mode.)#"  , py::arg("theAspect")
          )
        .def("HasOwnHiddenLineAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnHiddenLineAspect),
             R"#(Returns true if the drawer has its own attribute for hidden lines aspect that overrides the one in the link.)#" 
          )
        .def("DrawHiddenLine",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::DrawHiddenLine),
             R"#(Returns Standard_True if the hidden lines are to be drawn. By default the hidden lines are not drawn.)#" 
          )
        .def("EnableDrawHiddenLine",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::EnableDrawHiddenLine),
             R"#(Enables the DrawHiddenLine function.)#" 
          )
        .def("DisableDrawHiddenLine",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::DisableDrawHiddenLine),
             R"#(Disables the DrawHiddenLine function.)#" 
          )
        .def("HasOwnDrawHiddenLine",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnDrawHiddenLine),
             R"#(Returns true if the drawer has its own attribute for "draw hidden lines" flag that overrides the one in the link.)#" 
          )
        .def("UnsetOwnDrawHiddenLine",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnDrawHiddenLine),
             R"#(Resets HasOwnDrawHiddenLine() flag, e.g. unsets EnableDrawHiddenLine()/DisableDrawHiddenLine().)#" 
          )
        .def("SetVectorAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) >(&Prs3d_Drawer::SetVectorAspect),
             R"#(Sets the modality theAspect for the display of vectors.)#"  , py::arg("theAspect")
          )
        .def("HasOwnVectorAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnVectorAspect),
             R"#(Returns true if the drawer has its own attribute for vector aspect that overrides the one in the link.)#" 
          )
        .def("SetVertexDrawMode",
             (void (Prs3d_Drawer::*)( const Prs3d_VertexDrawMode  ) ) static_cast<void (Prs3d_Drawer::*)( const Prs3d_VertexDrawMode  ) >(&Prs3d_Drawer::SetVertexDrawMode),
             R"#(Sets the mode of visualization of vertices of a TopoDS_Shape instance. By default, only stand-alone vertices (not belonging topologically to an edge) are drawn, that corresponds to Prs3d_VDM_Standalone mode. Switching to Prs3d_VDM_Standalone mode makes all shape's vertices visible. To inherit this parameter from the global drawer instance ("the link") when it is present, Prs3d_VDM_Inherited value should be used.)#"  , py::arg("theMode")
          )
        .def("VertexDrawMode",
             (Prs3d_VertexDrawMode (Prs3d_Drawer::*)() const) static_cast<Prs3d_VertexDrawMode (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::VertexDrawMode),
             R"#(Returns the current mode of visualization of vertices of a TopoDS_Shape instance.)#" 
          )
        .def("HasOwnVertexDrawMode",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnVertexDrawMode),
             R"#(Returns true if the vertex draw mode is not equal to Prs3d_VDM_Inherited. This means that individual vertex draw mode value (i.e. not inherited from the global drawer) is used for a specific interactive object.)#" 
          )
        .def("SetDatumAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_DatumAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_DatumAspect> &  ) >(&Prs3d_Drawer::SetDatumAspect),
             R"#(Sets the modality theAspect for the display of datums.)#"  , py::arg("theAspect")
          )
        .def("HasOwnDatumAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnDatumAspect),
             R"#(Returns true if the drawer has its own attribute for datum aspect that overrides the one in the link.)#" 
          )
        .def("SetSectionAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) >(&Prs3d_Drawer::SetSectionAspect),
             R"#(Sets the parameter theAspect for display attributes of sections.)#"  , py::arg("theAspect")
          )
        .def("HasOwnSectionAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnSectionAspect),
             R"#(Returns true if the drawer has its own attribute for section aspect that overrides the one in the link.)#" 
          )
        .def("SetFreeBoundaryAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) >(&Prs3d_Drawer::SetFreeBoundaryAspect),
             R"#(Sets the parameter theAspect for the display of free boundaries. The method sets aspect owned by the drawer that will be used during visualization instead of the one set in link.)#"  , py::arg("theAspect")
          )
        .def("HasOwnFreeBoundaryAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnFreeBoundaryAspect),
             R"#(Returns true if the drawer has its own attribute for free boundaries aspect that overrides the one in the link.)#" 
          )
        .def("SetFreeBoundaryDraw",
             (void (Prs3d_Drawer::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Boolean  ) >(&Prs3d_Drawer::SetFreeBoundaryDraw),
             R"#(Enables or disables drawing of free boundaries for shading presentations. The method sets drawing flag owned by the drawer that will be used during visualization instead of the one set in link. theIsEnabled is a boolean flag indicating whether the free boundaries should be drawn or not.)#"  , py::arg("theIsEnabled")
          )
        .def("FreeBoundaryDraw",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::FreeBoundaryDraw),
             R"#(Returns True if the drawing of the free boundaries is enabled True is the default setting.)#" 
          )
        .def("HasOwnFreeBoundaryDraw",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnFreeBoundaryDraw),
             R"#(Returns true if the drawer has its own attribute for "draw free boundaries" flag that overrides the one in the link.)#" 
          )
        .def("UnsetOwnFreeBoundaryDraw",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnFreeBoundaryDraw),
             R"#(Resets HasOwnFreeBoundaryDraw() flag, e.g. undoes SetFreeBoundaryDraw().)#" 
          )
        .def("SetUnFreeBoundaryAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) >(&Prs3d_Drawer::SetUnFreeBoundaryAspect),
             R"#(Sets the parameter theAspect for the display of shared boundaries. The method sets aspect owned by the drawer that will be used during visualization instead of the one set in link.)#"  , py::arg("theAspect")
          )
        .def("HasOwnUnFreeBoundaryAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnUnFreeBoundaryAspect),
             R"#(Returns true if the drawer has its own attribute for unfree boundaries aspect that overrides the one in the link.)#" 
          )
        .def("SetUnFreeBoundaryDraw",
             (void (Prs3d_Drawer::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Boolean  ) >(&Prs3d_Drawer::SetUnFreeBoundaryDraw),
             R"#(Enables or disables drawing of shared boundaries for shading presentations. The method sets drawing flag owned by the drawer that will be used during visualization instead of the one set in link. theIsEnabled is a boolean flag indicating whether the shared boundaries should be drawn or not.)#"  , py::arg("theIsEnabled")
          )
        .def("UnFreeBoundaryDraw",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::UnFreeBoundaryDraw),
             R"#(Returns True if the drawing of the shared boundaries is enabled. True is the default setting.)#" 
          )
        .def("HasOwnUnFreeBoundaryDraw",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnUnFreeBoundaryDraw),
             R"#(Returns true if the drawer has its own attribute for "draw shared boundaries" flag that overrides the one in the link.)#" 
          )
        .def("UnsetOwnUnFreeBoundaryDraw",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnUnFreeBoundaryDraw),
             R"#(Resets HasOwnUnFreeBoundaryDraw() flag, e.g. undoes SetUnFreeBoundaryDraw().)#" 
          )
        .def("SetFaceBoundaryAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_LineAspect> &  ) >(&Prs3d_Drawer::SetFaceBoundaryAspect),
             R"#(Sets line aspect for face boundaries. The method sets line aspect owned by the drawer that will be used during visualization instead of the one set in link. theAspect is the line aspect that determines the look of the face boundaries.)#"  , py::arg("theAspect")
          )
        .def("HasOwnFaceBoundaryAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnFaceBoundaryAspect),
             R"#(Returns true if the drawer has its own attribute for face boundaries aspect that overrides the one in the link.)#" 
          )
        .def("SetupOwnFaceBoundaryAspect",
             (Standard_Boolean (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<Standard_Boolean (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) >(&Prs3d_Drawer::SetupOwnFaceBoundaryAspect),
             R"#(Sets own face boundary aspect, which is a black solid line by default. Returns FALSE if the drawer already has its own attribute for face boundary aspect.)#"  , py::arg("theDefaults")=static_cast<const opencascade::handle<Prs3d_Drawer> &>(Handle ( Prs3d_Drawer ) ( ))
          )
        .def("SetFaceBoundaryDraw",
             (void (Prs3d_Drawer::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Boolean  ) >(&Prs3d_Drawer::SetFaceBoundaryDraw),
             R"#(Enables or disables face boundary drawing for shading presentations. The method sets drawing flag owned by the drawer that will be used during visualization instead of the one set in link. theIsEnabled is a boolean flag indicating whether the face boundaries should be drawn or not.)#"  , py::arg("theIsEnabled")
          )
        .def("FaceBoundaryDraw",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::FaceBoundaryDraw),
             R"#(Checks whether the face boundary drawing is enabled or not.)#" 
          )
        .def("HasOwnFaceBoundaryDraw",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnFaceBoundaryDraw),
             R"#(Returns true if the drawer has its own attribute for "draw face boundaries" flag that overrides the one in the link.)#" 
          )
        .def("UnsetOwnFaceBoundaryDraw",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnFaceBoundaryDraw),
             R"#(Resets HasOwnFaceBoundaryDraw() flag, e.g. undoes SetFaceBoundaryDraw().)#" 
          )
        .def("HasOwnFaceBoundaryUpperContinuity",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnFaceBoundaryUpperContinuity),
             R"#(Returns true if the drawer has its own attribute for face boundaries upper edge continuity class that overrides the one in the link.)#" 
          )
        .def("FaceBoundaryUpperContinuity",
             (GeomAbs_Shape (Prs3d_Drawer::*)() const) static_cast<GeomAbs_Shape (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::FaceBoundaryUpperContinuity),
             R"#(Get the most edge continuity class; GeomAbs_CN by default (all edges).)#" 
          )
        .def("SetFaceBoundaryUpperContinuity",
             (void (Prs3d_Drawer::*)( GeomAbs_Shape  ) ) static_cast<void (Prs3d_Drawer::*)( GeomAbs_Shape  ) >(&Prs3d_Drawer::SetFaceBoundaryUpperContinuity),
             R"#(Set the most edge continuity class for face boundaries.)#"  , py::arg("theMostAllowedEdgeClass")
          )
        .def("UnsetFaceBoundaryUpperContinuity",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetFaceBoundaryUpperContinuity),
             R"#(Unset the most edge continuity class for face boundaries.)#" 
          )
        .def("SetDimensionAspect",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_DimensionAspect> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_DimensionAspect> &  ) >(&Prs3d_Drawer::SetDimensionAspect),
             R"#(Sets the settings for the appearance of dimensions. The method sets aspect owned by the drawer that will be used during visualization instead of the one set in link.)#"  , py::arg("theAspect")
          )
        .def("HasOwnDimensionAspect",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnDimensionAspect),
             R"#(Returns true if the drawer has its own attribute for the appearance of dimensions that overrides the one in the link.)#" 
          )
        .def("SetDimLengthModelUnits",
             (void (Prs3d_Drawer::*)( const TCollection_AsciiString &  ) ) static_cast<void (Prs3d_Drawer::*)( const TCollection_AsciiString &  ) >(&Prs3d_Drawer::SetDimLengthModelUnits),
             R"#(Sets dimension length model units for computing of dimension presentation. The method sets value owned by the drawer that will be used during visualization instead of the one set in link.)#"  , py::arg("theUnits")
          )
        .def("SetDimAngleModelUnits",
             (void (Prs3d_Drawer::*)( const TCollection_AsciiString &  ) ) static_cast<void (Prs3d_Drawer::*)( const TCollection_AsciiString &  ) >(&Prs3d_Drawer::SetDimAngleModelUnits),
             R"#(Sets dimension angle model units for computing of dimension presentation. The method sets value owned by the drawer that will be used during visualization instead of the one set in link.)#"  , py::arg("theUnits")
          )
        .def("HasOwnDimLengthModelUnits",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnDimLengthModelUnits),
             R"#(Returns true if the drawer has its own attribute for dimension length model units that overrides the one in the link.)#" 
          )
        .def("UnsetOwnDimLengthModelUnits",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnDimLengthModelUnits),
             R"#(Resets HasOwnDimLengthModelUnits() flag, e.g. undoes SetDimLengthModelUnits().)#" 
          )
        .def("HasOwnDimAngleModelUnits",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnDimAngleModelUnits),
             R"#(Returns true if the drawer has its own attribute for dimension angle model units that overrides the one in the link.)#" 
          )
        .def("UnsetOwnDimAngleModelUnits",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnDimAngleModelUnits),
             R"#(Resets HasOwnDimAngleModelUnits() flag, e.g. undoes SetDimAngleModelUnits().)#" 
          )
        .def("SetDimLengthDisplayUnits",
             (void (Prs3d_Drawer::*)( const TCollection_AsciiString &  ) ) static_cast<void (Prs3d_Drawer::*)( const TCollection_AsciiString &  ) >(&Prs3d_Drawer::SetDimLengthDisplayUnits),
             R"#(Sets length units in which value for dimension presentation is displayed. The method sets value owned by the drawer that will be used during visualization instead of the one set in link.)#"  , py::arg("theUnits")
          )
        .def("SetDimAngleDisplayUnits",
             (void (Prs3d_Drawer::*)( const TCollection_AsciiString &  ) ) static_cast<void (Prs3d_Drawer::*)( const TCollection_AsciiString &  ) >(&Prs3d_Drawer::SetDimAngleDisplayUnits),
             R"#(Sets angle units in which value for dimension presentation is displayed. The method sets value owned by the drawer that will be used during visualization instead of the one set in link.)#"  , py::arg("theUnits")
          )
        .def("HasOwnDimLengthDisplayUnits",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnDimLengthDisplayUnits),
             R"#(Returns true if the drawer has its own attribute for length units in which dimension presentation is displayed that overrides the one in the link.)#" 
          )
        .def("UnsetOwnDimLengthDisplayUnits",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnDimLengthDisplayUnits),
             R"#(Resets HasOwnDimLengthModelUnits() flag, e.g. undoes SetDimLengthDisplayUnits().)#" 
          )
        .def("HasOwnDimAngleDisplayUnits",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnDimAngleDisplayUnits),
             R"#(Returns true if the drawer has its own attribute for angle units in which dimension presentation is displayed that overrides the one in the link.)#" 
          )
        .def("UnsetOwnDimAngleDisplayUnits",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::UnsetOwnDimAngleDisplayUnits),
             R"#(Resets HasOwnDimAngleDisplayUnits() flag, e.g. undoes SetDimLengthDisplayUnits().)#" 
          )
        .def("HasLink",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasLink),
             R"#(Returns true if the current object has a link on the other drawer.)#" 
          )
        .def("Link",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) >(&Prs3d_Drawer::Link),
             R"#(Sets theDrawer as a link to which the current object references.)#"  , py::arg("theDrawer")
          )
        .def("SetLink",
             (void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (Prs3d_Drawer::*)( const opencascade::handle<Prs3d_Drawer> &  ) >(&Prs3d_Drawer::SetLink),
             R"#(Sets theDrawer as a link to which the current object references.)#"  , py::arg("theDrawer")
          )
        .def("ClearLocalAttributes",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::ClearLocalAttributes),
             R"#(Removes local attributes.)#" 
          )
        .def("SetShaderProgram",
             (bool (Prs3d_Drawer::*)( const opencascade::handle<Graphic3d_ShaderProgram> & ,  const Graphic3d_GroupAspect ,  const bool  ) ) static_cast<bool (Prs3d_Drawer::*)( const opencascade::handle<Graphic3d_ShaderProgram> & ,  const Graphic3d_GroupAspect ,  const bool  ) >(&Prs3d_Drawer::SetShaderProgram),
             R"#(Assign shader program for specified type of primitives.)#"  , py::arg("theProgram"),  py::arg("theAspect"),  py::arg("theToOverrideDefaults")=static_cast<const bool>(false)
          )
        .def("SetShadingModel",
             (bool (Prs3d_Drawer::*)( Graphic3d_TypeOfShadingModel ,  bool  ) ) static_cast<bool (Prs3d_Drawer::*)( Graphic3d_TypeOfShadingModel ,  bool  ) >(&Prs3d_Drawer::SetShadingModel),
             R"#(Sets Shading Model type for the shading aspect.)#"  , py::arg("theModel"),  py::arg("theToOverrideDefaults")=static_cast<bool>(false)
          )
        .def("DumpJson",
             (void (Prs3d_Drawer::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Prs3d_Drawer::*)( std::ostream & ,  Standard_Integer  ) const>(&Prs3d_Drawer::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
        .def("SetHLRAngle",
             (void (Prs3d_Drawer::*)( const Standard_Real  ) ) static_cast<void (Prs3d_Drawer::*)( const Standard_Real  ) >(&Prs3d_Drawer::SetHLRAngle),
             R"#()#"  , py::arg("theAngle")
          )
        .def("HLRAngle",
             (Standard_Real (Prs3d_Drawer::*)() const) static_cast<Standard_Real (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HLRAngle),
             R"#(None)#" 
          )
        .def("SetHLRAngle",
             (void (Prs3d_Drawer::*)() ) static_cast<void (Prs3d_Drawer::*)() >(&Prs3d_Drawer::SetHLRAngle),
             R"#(None)#" 
          )
        .def("HasOwnHLRDeviationAngle",
             (Standard_Boolean (Prs3d_Drawer::*)() const) static_cast<Standard_Boolean (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HasOwnHLRDeviationAngle),
             R"#(None)#" 
          )
        .def("PreviousHLRDeviationAngle",
             (Standard_Real (Prs3d_Drawer::*)() const) static_cast<Standard_Real (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::PreviousHLRDeviationAngle),
             R"#(None)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_Drawer::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_Drawer::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::DynamicType),
             R"#(None)#"
             
         )
       .def("UIsoAspect",
             (const opencascade::handle<Prs3d_IsoAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_IsoAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::UIsoAspect),
             R"#(Defines own attributes for drawing an U isoparametric curve of a face, settings from linked Drawer or NULL if neither was set.)#"
             
         )
       .def("VIsoAspect",
             (const opencascade::handle<Prs3d_IsoAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_IsoAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::VIsoAspect),
             R"#(Defines own attributes for drawing an V isoparametric curve of a face, settings from linked Drawer or NULL if neither was set.)#"
             
         )
       .def("WireAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::WireAspect),
             R"#(Returns own wire aspect settings, settings from linked Drawer or NULL if neither was set. These attributes are used by the algorithm Prs3d_WFShape.)#"
             
         )
       .def("PointAspect",
             (const opencascade::handle<Prs3d_PointAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_PointAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::PointAspect),
             R"#(Returns own point aspect setting, settings from linked Drawer or NULL if neither was set. These attributes are used by the algorithms Prs3d_Point.)#"
             
         )
       .def("LineAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::LineAspect),
             R"#(Returns own settings for line aspects, settings from linked Drawer or NULL if neither was set. These attributes are used by the following algorithms: Prs3d_Curve Prs3d_Line Prs3d_HLRShape)#"
             
         )
       .def("TextAspect",
             (const opencascade::handle<Prs3d_TextAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_TextAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::TextAspect),
             R"#(Returns own settings for text aspect, settings from linked Drawer or NULL if neither was set.)#"
             
         )
       .def("ShadingAspect",
             (const opencascade::handle<Prs3d_ShadingAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_ShadingAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::ShadingAspect),
             R"#(Returns own settings for shading aspects, settings from linked Drawer or NULL if neither was set.)#"
             
         )
       .def("SeenLineAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::SeenLineAspect),
             R"#(Returns own settings for seen line aspects, settings of linked Drawer or NULL if neither was set.)#"
             
         )
       .def("PlaneAspect",
             (const opencascade::handle<Prs3d_PlaneAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_PlaneAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::PlaneAspect),
             R"#(Returns own settings for the appearance of planes, settings from linked Drawer or NULL if neither was set.)#"
             
         )
       .def("ArrowAspect",
             (const opencascade::handle<Prs3d_ArrowAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_ArrowAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::ArrowAspect),
             R"#(Returns own attributes for display of arrows, settings from linked Drawer or NULL if neither was set.)#"
             
         )
       .def("HiddenLineAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::HiddenLineAspect),
             R"#(Returns own settings for hidden line aspects, settings from linked Drawer or NULL if neither was set.)#"
             
         )
       .def("VectorAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::VectorAspect),
             R"#(Returns own settings for the appearance of vectors, settings from linked Drawer or NULL if neither was set.)#"
             
         )
       .def("DatumAspect",
             (const opencascade::handle<Prs3d_DatumAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_DatumAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::DatumAspect),
             R"#(Returns own settings for the appearance of datums, settings from linked Drawer or NULL if neither was set.)#"
             
         )
       .def("SectionAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::SectionAspect),
             R"#(Returns own LineAspect for section wire, settings from linked Drawer or NULL if neither was set. These attributes are used by the algorithm Prs3d_WFShape.)#"
             
         )
       .def("FreeBoundaryAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::FreeBoundaryAspect),
             R"#(Returns own settings for presentation of free boundaries, settings from linked Drawer or NULL if neither was set. In other words, this settings affect boundaries which are not shared. These attributes are used by the algorithm Prs3d_WFShape)#"
             
         )
       .def("UnFreeBoundaryAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::UnFreeBoundaryAspect),
             R"#(Returns own settings for shared boundary line aspects, settings from linked Drawer or NULL if neither was set. These attributes are used by the algorithm Prs3d_WFShape)#"
             
         )
       .def("FaceBoundaryAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::FaceBoundaryAspect),
             R"#(Returns own line aspect of face boundaries, settings from linked Drawer or NULL if neither was set.)#"
             
         )
       .def("DimensionAspect",
             (const opencascade::handle<Prs3d_DimensionAspect> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_DimensionAspect> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::DimensionAspect),
             R"#(Returns own settings for the appearance of dimensions, settings from linked Drawer or NULL if neither was set.)#"
             
         )
       .def("DimLengthModelUnits",
             (const TCollection_AsciiString & (Prs3d_Drawer::*)() const) static_cast<const TCollection_AsciiString & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::DimLengthModelUnits),
             R"#(Returns length model units for the dimension presentation.)#"
             
         )
       .def("DimAngleModelUnits",
             (const TCollection_AsciiString & (Prs3d_Drawer::*)() const) static_cast<const TCollection_AsciiString & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::DimAngleModelUnits),
             R"#(Returns angle model units for the dimension presentation.)#"
             
         )
       .def("DimLengthDisplayUnits",
             (const TCollection_AsciiString & (Prs3d_Drawer::*)() const) static_cast<const TCollection_AsciiString & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::DimLengthDisplayUnits),
             R"#(Returns length units in which dimension presentation is displayed.)#"
             
         )
       .def("DimAngleDisplayUnits",
             (const TCollection_AsciiString & (Prs3d_Drawer::*)() const) static_cast<const TCollection_AsciiString & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::DimAngleDisplayUnits),
             R"#(Returns angle units in which dimension presentation is displayed.)#"
             
         )
       .def("Link",
             (const opencascade::handle<Prs3d_Drawer> & (Prs3d_Drawer::*)() const) static_cast<const opencascade::handle<Prs3d_Drawer> & (Prs3d_Drawer::*)() const>(&Prs3d_Drawer::Link),
             R"#(Returns the drawer to which the current object references.)#"
             
         )
;

    // Class Prs3d_PresentationShadow from ./opencascade/Prs3d_PresentationShadow.hxx
    klass = m.attr("Prs3d_PresentationShadow");


    // nested enums

    static_cast<py::class_<Prs3d_PresentationShadow ,opencascade::handle<Prs3d_PresentationShadow>  , Graphic3d_Structure >>(klass)
    // constructors
        .def(py::init< const opencascade::handle<Graphic3d_StructureManager> &,const opencascade::handle<Graphic3d_Structure> & >()  , py::arg("theViewer"),  py::arg("thePrs") )
    // custom constructors
    // methods
        .def("ParentId",
             (Standard_Integer (Prs3d_PresentationShadow::*)() const) static_cast<Standard_Integer (Prs3d_PresentationShadow::*)() const>(&Prs3d_PresentationShadow::ParentId),
             R"#(Returns the id of the parent presentation)#" 
          )
        .def("CalculateBoundBox",
             (void (Prs3d_PresentationShadow::*)() ) static_cast<void (Prs3d_PresentationShadow::*)() >(&Prs3d_PresentationShadow::CalculateBoundBox),
             R"#(Do nothing - axis-aligned bounding box should be initialized from parent structure.)#" 
          )
        .def("DumpJson",
             (void (Prs3d_PresentationShadow::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Prs3d_PresentationShadow::*)( std::ostream & ,  Standard_Integer  ) const>(&Prs3d_PresentationShadow::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_PresentationShadow::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_PresentationShadow::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_PresentationShadow::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_PresentationShadow::*)() const>(&Prs3d_PresentationShadow::DynamicType),
             R"#(None)#"
             
         )
       .def("ParentAffinity",
             (const opencascade::handle<Graphic3d_ViewAffinity> & (Prs3d_PresentationShadow::*)() const) static_cast<const opencascade::handle<Graphic3d_ViewAffinity> & (Prs3d_PresentationShadow::*)() const>(&Prs3d_PresentationShadow::ParentAffinity),
             R"#(Returns view affinity of the parent presentation)#"
             
         )
;

    // Class Prs3d_Root from ./opencascade/Prs3d_Root.hxx
    klass = m.attr("Prs3d_Root");

    // default constructor
    register_default_constructor<Prs3d_Root , shared_ptr<Prs3d_Root>>(m,"Prs3d_Root");

    // nested enums

    static_cast<py::class_<Prs3d_Root , shared_ptr<Prs3d_Root>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("CurrentGroup_s",
                    (opencascade::handle<Graphic3d_Group> (*)( const opencascade::handle<Prs3d_Presentation> &  ) ) static_cast<opencascade::handle<Graphic3d_Group> (*)( const opencascade::handle<Prs3d_Presentation> &  ) >(&Prs3d_Root::CurrentGroup),
                    R"#(None)#"  , py::arg("thePrs3d")
          )
        .def_static("NewGroup_s",
                    (opencascade::handle<Graphic3d_Group> (*)( const opencascade::handle<Prs3d_Presentation> &  ) ) static_cast<opencascade::handle<Graphic3d_Group> (*)( const opencascade::handle<Prs3d_Presentation> &  ) >(&Prs3d_Root::NewGroup),
                    R"#(None)#"  , py::arg("thePrs3d")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Prs3d_Text from ./opencascade/Prs3d_Text.hxx
    klass = m.attr("Prs3d_Text");

    // default constructor
    register_default_constructor<Prs3d_Text , shared_ptr<Prs3d_Text>>(m,"Prs3d_Text");

    // nested enums

    static_cast<py::class_<Prs3d_Text , shared_ptr<Prs3d_Text>  >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Draw_s",
                    (opencascade::handle<Graphic3d_Text> (*)( const opencascade::handle<Graphic3d_Group> & ,  const opencascade::handle<Prs3d_TextAspect> & ,  const TCollection_ExtendedString & ,  const gp_Pnt &  ) ) static_cast<opencascade::handle<Graphic3d_Text> (*)( const opencascade::handle<Graphic3d_Group> & ,  const opencascade::handle<Prs3d_TextAspect> & ,  const TCollection_ExtendedString & ,  const gp_Pnt &  ) >(&Prs3d_Text::Draw),
                    R"#(Defines the display of the text.)#"  , py::arg("theGroup"),  py::arg("theAspect"),  py::arg("theText"),  py::arg("theAttachmentPoint")
          )
        .def_static("Draw_s",
                    (opencascade::handle<Graphic3d_Text> (*)( const opencascade::handle<Graphic3d_Group> & ,  const opencascade::handle<Prs3d_TextAspect> & ,  const TCollection_ExtendedString & ,  const gp_Ax2 & ,  const Standard_Boolean  ) ) static_cast<opencascade::handle<Graphic3d_Text> (*)( const opencascade::handle<Graphic3d_Group> & ,  const opencascade::handle<Prs3d_TextAspect> & ,  const TCollection_ExtendedString & ,  const gp_Ax2 & ,  const Standard_Boolean  ) >(&Prs3d_Text::Draw),
                    R"#(Draws the text label.)#"  , py::arg("theGroup"),  py::arg("theAspect"),  py::arg("theText"),  py::arg("theOrientation"),  py::arg("theHasOwnAnchor")=static_cast<const Standard_Boolean>(Standard_True)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Prs3d_ToolQuadric from ./opencascade/Prs3d_ToolQuadric.hxx
    klass = m.attr("Prs3d_ToolQuadric");


    // nested enums

    static_cast<py::class_<Prs3d_ToolQuadric , shared_ptr<Prs3d_ToolQuadric> ,Py_Prs3d_ToolQuadric >>(klass)
    // constructors
    // custom constructors
    // methods
        .def("CreateTriangulation",
             (opencascade::handle<Graphic3d_ArrayOfTriangles> (Prs3d_ToolQuadric::*)( const gp_Trsf &  ) const) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (Prs3d_ToolQuadric::*)( const gp_Trsf &  ) const>(&Prs3d_ToolQuadric::CreateTriangulation),
             R"#(Generate primitives for 3D quadric surface presentation.)#"  , py::arg("theTrsf")
          )
        .def("CreatePolyTriangulation",
             (opencascade::handle<Poly_Triangulation> (Prs3d_ToolQuadric::*)( const gp_Trsf &  ) const) static_cast<opencascade::handle<Poly_Triangulation> (Prs3d_ToolQuadric::*)( const gp_Trsf &  ) const>(&Prs3d_ToolQuadric::CreatePolyTriangulation),
             R"#(Generate primitives for 3D quadric surface presentation.)#"  , py::arg("theTrsf")
          )
        .def("TrianglesNb",
             (Standard_Integer (Prs3d_ToolQuadric::*)() const) static_cast<Standard_Integer (Prs3d_ToolQuadric::*)() const>(&Prs3d_ToolQuadric::TrianglesNb),
             R"#(Return number of triangles in generated presentation.)#" 
          )
        .def("VerticesNb",
             (Standard_Integer (Prs3d_ToolQuadric::*)( bool  ) const) static_cast<Standard_Integer (Prs3d_ToolQuadric::*)( bool  ) const>(&Prs3d_ToolQuadric::VerticesNb),
             R"#(Return number of vertices in generated presentation.)#"  , py::arg("theIsIndexed")=static_cast<bool>(true)
          )
    // methods using call by reference i.s.o. return
        .def("FillArray",
             []( Prs3d_ToolQuadric &self , Graphic3d_ArrayOfTriangles& theArray,const gp_Trsf & theTrsf ){
                 opencascade::handle<Graphic3d_ArrayOfTriangles>  theArray_ptr; theArray_ptr = &theArray;

                 self.FillArray(theArray_ptr,theTrsf);
                 if ( theArray_ptr.get() != &theArray ) copy_if_copy_constructible(theArray, *theArray_ptr);

                 return std::make_tuple(); },
             R"#(Generate primitives for 3D quadric surface and fill the given array.)#"  , py::arg("theArray"),  py::arg("theTrsf")
          )
        .def("FillArray",
             []( Prs3d_ToolQuadric &self , Graphic3d_ArrayOfTriangles& theArray,Poly_Triangulation& theTriangulation,const gp_Trsf & theTrsf ){
                 opencascade::handle<Graphic3d_ArrayOfTriangles>  theArray_ptr; theArray_ptr = &theArray;
                opencascade::handle<Poly_Triangulation>  theTriangulation_ptr; theTriangulation_ptr = &theTriangulation;

                 self.FillArray(theArray_ptr,theTriangulation_ptr,theTrsf);
                 if ( theArray_ptr.get() != &theArray ) copy_if_copy_constructible(theArray, *theArray_ptr);
                if ( theTriangulation_ptr.get() != &theTriangulation ) copy_if_copy_constructible(theTriangulation, *theTriangulation_ptr);

                 return std::make_tuple(); },
             R"#(Generate primitives for 3D quadric surface presentation.)#"  , py::arg("theArray"),  py::arg("theTriangulation"),  py::arg("theTrsf")
          )
    // static methods
        .def_static("TrianglesNb_s",
                    (Standard_Integer (*)( const Standard_Integer ,  const Standard_Integer  ) ) static_cast<Standard_Integer (*)( const Standard_Integer ,  const Standard_Integer  ) >(&Prs3d_ToolQuadric::TrianglesNb),
                    R"#(Return number of triangles for presentation with the given params.)#"  , py::arg("theSlicesNb"),  py::arg("theStacksNb")
          )
        .def_static("VerticesNb_s",
                    (Standard_Integer (*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Boolean  ) ) static_cast<Standard_Integer (*)( const Standard_Integer ,  const Standard_Integer ,  const Standard_Boolean  ) >(&Prs3d_ToolQuadric::VerticesNb),
                    R"#(Return number of vertices for presentation with the given params.)#"  , py::arg("theSlicesNb"),  py::arg("theStacksNb"),  py::arg("theIsIndexed")=static_cast<const Standard_Boolean>(Standard_True)
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Prs3d_ArrowAspect from ./opencascade/Prs3d_ArrowAspect.hxx
    klass = m.attr("Prs3d_ArrowAspect");


    // nested enums

    static_cast<py::class_<Prs3d_ArrowAspect ,opencascade::handle<Prs3d_ArrowAspect>  , Prs3d_BasicAspect >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const Standard_Real,const Standard_Real >()  , py::arg("anAngle"),  py::arg("aLength") )
        .def(py::init< const opencascade::handle<Graphic3d_AspectLine3d> & >()  , py::arg("theAspect") )
    // custom constructors
    // methods
        .def("SetAngle",
             (void (Prs3d_ArrowAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_ArrowAspect::*)( const Standard_Real  ) >(&Prs3d_ArrowAspect::SetAngle),
             R"#(defines the angle of the arrows.)#"  , py::arg("anAngle")
          )
        .def("Angle",
             (Standard_Real (Prs3d_ArrowAspect::*)() const) static_cast<Standard_Real (Prs3d_ArrowAspect::*)() const>(&Prs3d_ArrowAspect::Angle),
             R"#(returns the current value of the angle used when drawing an arrow.)#" 
          )
        .def("SetLength",
             (void (Prs3d_ArrowAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_ArrowAspect::*)( const Standard_Real  ) >(&Prs3d_ArrowAspect::SetLength),
             R"#(Defines the length of the arrows.)#"  , py::arg("theLength")
          )
        .def("Length",
             (Standard_Real (Prs3d_ArrowAspect::*)() const) static_cast<Standard_Real (Prs3d_ArrowAspect::*)() const>(&Prs3d_ArrowAspect::Length),
             R"#(Returns the current value of the length used when drawing an arrow.)#" 
          )
        .def("SetZoomable",
             (void (Prs3d_ArrowAspect::*)( bool  ) ) static_cast<void (Prs3d_ArrowAspect::*)( bool  ) >(&Prs3d_ArrowAspect::SetZoomable),
             R"#(Turns usage of arrow zoomable on/off)#"  , py::arg("theIsZoomable")
          )
        .def("IsZoomable",
             (bool (Prs3d_ArrowAspect::*)() const) static_cast<bool (Prs3d_ArrowAspect::*)() const>(&Prs3d_ArrowAspect::IsZoomable),
             R"#(Returns TRUE when the Arrow Zoomable is on; TRUE by default.)#" 
          )
        .def("SetColor",
             (void (Prs3d_ArrowAspect::*)( const Quantity_Color &  ) ) static_cast<void (Prs3d_ArrowAspect::*)( const Quantity_Color &  ) >(&Prs3d_ArrowAspect::SetColor),
             R"#(None)#"  , py::arg("theColor")
          )
        .def("SetAspect",
             (void (Prs3d_ArrowAspect::*)( const opencascade::handle<Graphic3d_AspectLine3d> &  ) ) static_cast<void (Prs3d_ArrowAspect::*)( const opencascade::handle<Graphic3d_AspectLine3d> &  ) >(&Prs3d_ArrowAspect::SetAspect),
             R"#(None)#"  , py::arg("theAspect")
          )
        .def("DumpJson",
             (void (Prs3d_ArrowAspect::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Prs3d_ArrowAspect::*)( std::ostream & ,  Standard_Integer  ) const>(&Prs3d_ArrowAspect::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_ArrowAspect::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_ArrowAspect::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_ArrowAspect::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_ArrowAspect::*)() const>(&Prs3d_ArrowAspect::DynamicType),
             R"#(None)#"
             
         )
       .def("Aspect",
             (const opencascade::handle<Graphic3d_AspectLine3d> & (Prs3d_ArrowAspect::*)() const) static_cast<const opencascade::handle<Graphic3d_AspectLine3d> & (Prs3d_ArrowAspect::*)() const>(&Prs3d_ArrowAspect::Aspect),
             R"#(None)#"
             
         )
;

    // Class Prs3d_BndBox from ./opencascade/Prs3d_BndBox.hxx
    klass = m.attr("Prs3d_BndBox");

    // default constructor
    register_default_constructor<Prs3d_BndBox , shared_ptr<Prs3d_BndBox>>(m,"Prs3d_BndBox");

    // nested enums

    static_cast<py::class_<Prs3d_BndBox , shared_ptr<Prs3d_BndBox>  , Prs3d_Root >>(klass)
    // constructors
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Bnd_Box & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Bnd_Box & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&Prs3d_BndBox::Add),
                    R"#(Computes presentation of a bounding box.)#"  , py::arg("thePresentation"),  py::arg("theBndBox"),  py::arg("theDrawer")
          )
        .def_static("Add_s",
                    (void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Bnd_OBB & ,  const opencascade::handle<Prs3d_Drawer> &  ) ) static_cast<void (*)( const opencascade::handle<Prs3d_Presentation> & ,  const Bnd_OBB & ,  const opencascade::handle<Prs3d_Drawer> &  ) >(&Prs3d_BndBox::Add),
                    R"#(Computes presentation of a bounding box.)#"  , py::arg("thePresentation"),  py::arg("theBndBox"),  py::arg("theDrawer")
          )
        .def_static("FillSegments_s",
                    (opencascade::handle<Graphic3d_ArrayOfSegments> (*)( const Bnd_OBB &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfSegments> (*)( const Bnd_OBB &  ) >(&Prs3d_BndBox::FillSegments),
                    R"#(Create primitive array with line segments for displaying a box.)#"  , py::arg("theBox")
          )
        .def_static("FillSegments_s",
                    (opencascade::handle<Graphic3d_ArrayOfSegments> (*)( const Bnd_Box &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfSegments> (*)( const Bnd_Box &  ) >(&Prs3d_BndBox::FillSegments),
                    R"#(Create primitive array with line segments for displaying a box.)#"  , py::arg("theBox")
          )
        .def_static("FillSegments_s",
                    (void (*)( const opencascade::handle<Graphic3d_ArrayOfSegments> & ,  const Bnd_OBB &  ) ) static_cast<void (*)( const opencascade::handle<Graphic3d_ArrayOfSegments> & ,  const Bnd_OBB &  ) >(&Prs3d_BndBox::FillSegments),
                    R"#(Create primitive array with line segments for displaying a box.)#"  , py::arg("theSegments"),  py::arg("theBox")
          )
        .def_static("FillSegments_s",
                    (void (*)( const opencascade::handle<Graphic3d_ArrayOfSegments> & ,  const Bnd_Box &  ) ) static_cast<void (*)( const opencascade::handle<Graphic3d_ArrayOfSegments> & ,  const Bnd_Box &  ) >(&Prs3d_BndBox::FillSegments),
                    R"#(Create primitive array with line segments for displaying a box.)#"  , py::arg("theSegments"),  py::arg("theBox")
          )
        .def_static("fillSegments_s",
                    (void (*)( const opencascade::handle<Graphic3d_ArrayOfSegments> & ,  const gp_Pnt *  ) ) static_cast<void (*)( const opencascade::handle<Graphic3d_ArrayOfSegments> & ,  const gp_Pnt *  ) >(&Prs3d_BndBox::fillSegments),
                    R"#(Create primitive array with line segments for displaying a box.)#"  , py::arg("theSegments"),  py::arg("theBox")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Prs3d_DatumAspect from ./opencascade/Prs3d_DatumAspect.hxx
    klass = m.attr("Prs3d_DatumAspect");


    // nested enums

    static_cast<py::class_<Prs3d_DatumAspect ,opencascade::handle<Prs3d_DatumAspect>  , Prs3d_BasicAspect >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("LineAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_DatumAspect::*)( Prs3d_DatumParts  ) const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_DatumAspect::*)( Prs3d_DatumParts  ) const>(&Prs3d_DatumAspect::LineAspect),
             R"#(Returns line aspect for specified part.)#"  , py::arg("thePart")
          )
        .def("ShadingAspect",
             (const opencascade::handle<Prs3d_ShadingAspect> & (Prs3d_DatumAspect::*)( Prs3d_DatumParts  ) const) static_cast<const opencascade::handle<Prs3d_ShadingAspect> & (Prs3d_DatumAspect::*)( Prs3d_DatumParts  ) const>(&Prs3d_DatumAspect::ShadingAspect),
             R"#(Returns shading aspect for specified part.)#"  , py::arg("thePart")
          )
        .def("TextAspect",
             (const opencascade::handle<Prs3d_TextAspect> & (Prs3d_DatumAspect::*)( Prs3d_DatumParts  ) const) static_cast<const opencascade::handle<Prs3d_TextAspect> & (Prs3d_DatumAspect::*)( Prs3d_DatumParts  ) const>(&Prs3d_DatumAspect::TextAspect),
             R"#(Returns the text attributes for rendering label of specified part (Prs3d_DatumParts_XAxis/Prs3d_DatumParts_YAxis/Prs3d_DatumParts_ZAxis).)#"  , py::arg("thePart")
          )
        .def("SetTextAspect",
             (void (Prs3d_DatumAspect::*)( const opencascade::handle<Prs3d_TextAspect> &  ) ) static_cast<void (Prs3d_DatumAspect::*)( const opencascade::handle<Prs3d_TextAspect> &  ) >(&Prs3d_DatumAspect::SetTextAspect),
             R"#(Sets text attributes for rendering labels.)#"  , py::arg("theTextAspect")
          )
        .def("SetPointAspect",
             (void (Prs3d_DatumAspect::*)( const opencascade::handle<Prs3d_PointAspect> &  ) ) static_cast<void (Prs3d_DatumAspect::*)( const opencascade::handle<Prs3d_PointAspect> &  ) >(&Prs3d_DatumAspect::SetPointAspect),
             R"#(Returns the point aspect of origin wireframe presentation)#"  , py::arg("theAspect")
          )
        .def("SetArrowAspect",
             (void (Prs3d_DatumAspect::*)( const opencascade::handle<Prs3d_ArrowAspect> &  ) ) static_cast<void (Prs3d_DatumAspect::*)( const opencascade::handle<Prs3d_ArrowAspect> &  ) >(&Prs3d_DatumAspect::SetArrowAspect),
             R"#(Sets the arrow aspect of presentation)#"  , py::arg("theAspect")
          )
        .def("DrawDatumPart",
             (Standard_Boolean (Prs3d_DatumAspect::*)( Prs3d_DatumParts  ) const) static_cast<Standard_Boolean (Prs3d_DatumAspect::*)( Prs3d_DatumParts  ) const>(&Prs3d_DatumAspect::DrawDatumPart),
             R"#(Returns true if the given part is used in axes of aspect)#"  , py::arg("thePart")
          )
        .def("SetDrawDatumAxes",
             (void (Prs3d_DatumAspect::*)( Prs3d_DatumAxes  ) ) static_cast<void (Prs3d_DatumAspect::*)( Prs3d_DatumAxes  ) >(&Prs3d_DatumAspect::SetDrawDatumAxes),
             R"#(Sets the axes used in the datum aspect)#"  , py::arg("theType")
          )
        .def("DatumAxes",
             (Prs3d_DatumAxes (Prs3d_DatumAspect::*)() const) static_cast<Prs3d_DatumAxes (Prs3d_DatumAspect::*)() const>(&Prs3d_DatumAspect::DatumAxes),
             R"#(Returns axes used in the datum aspect)#" 
          )
        .def("Attribute",
             (Standard_Real (Prs3d_DatumAspect::*)( Prs3d_DatumAttribute  ) const) static_cast<Standard_Real (Prs3d_DatumAspect::*)( Prs3d_DatumAttribute  ) const>(&Prs3d_DatumAspect::Attribute),
             R"#(Returns the attribute of the datum type)#"  , py::arg("theType")
          )
        .def("SetAttribute",
             (void (Prs3d_DatumAspect::*)( Prs3d_DatumAttribute ,  const Standard_Real  ) ) static_cast<void (Prs3d_DatumAspect::*)( Prs3d_DatumAttribute ,  const Standard_Real  ) >(&Prs3d_DatumAspect::SetAttribute),
             R"#(Sets the attribute of the datum type)#"  , py::arg("theType"),  py::arg("theValue")
          )
        .def("AxisLength",
             (Standard_Real (Prs3d_DatumAspect::*)( Prs3d_DatumParts  ) const) static_cast<Standard_Real (Prs3d_DatumAspect::*)( Prs3d_DatumParts  ) const>(&Prs3d_DatumAspect::AxisLength),
             R"#(Returns the length of the displayed first axis.)#"  , py::arg("thePart")
          )
        .def("SetAxisLength",
             (void (Prs3d_DatumAspect::*)( Standard_Real ,  Standard_Real ,  Standard_Real  ) ) static_cast<void (Prs3d_DatumAspect::*)( Standard_Real ,  Standard_Real ,  Standard_Real  ) >(&Prs3d_DatumAspect::SetAxisLength),
             R"#(Sets the lengths of the three axes.)#"  , py::arg("theL1"),  py::arg("theL2"),  py::arg("theL3")
          )
        .def("ToDrawLabels",
             (Standard_Boolean (Prs3d_DatumAspect::*)() const) static_cast<Standard_Boolean (Prs3d_DatumAspect::*)() const>(&Prs3d_DatumAspect::ToDrawLabels),
             R"#(Returns true if axes labels are drawn; TRUE by default.)#" 
          )
        .def("SetDrawLabels",
             (void (Prs3d_DatumAspect::*)( Standard_Boolean  ) ) static_cast<void (Prs3d_DatumAspect::*)( Standard_Boolean  ) >(&Prs3d_DatumAspect::SetDrawLabels),
             R"#(Sets option to draw or not to draw text labels for axes)#"  , py::arg("theToDraw")
          )
        .def("SetToDrawLabels",
             (void (Prs3d_DatumAspect::*)( Standard_Boolean  ) ) static_cast<void (Prs3d_DatumAspect::*)( Standard_Boolean  ) >(&Prs3d_DatumAspect::SetToDrawLabels),
             R"#(None)#"  , py::arg("theToDraw")
          )
        .def("ToDrawArrows",
             (Standard_Boolean (Prs3d_DatumAspect::*)() const) static_cast<Standard_Boolean (Prs3d_DatumAspect::*)() const>(&Prs3d_DatumAspect::ToDrawArrows),
             R"#(Returns true if axes arrows are drawn; TRUE by default.)#" 
          )
        .def("SetDrawArrows",
             (void (Prs3d_DatumAspect::*)( Standard_Boolean  ) ) static_cast<void (Prs3d_DatumAspect::*)( Standard_Boolean  ) >(&Prs3d_DatumAspect::SetDrawArrows),
             R"#(Sets option to draw or not arrows for axes)#"  , py::arg("theToDraw")
          )
        .def("CopyAspectsFrom",
             (void (Prs3d_DatumAspect::*)( const opencascade::handle<Prs3d_DatumAspect> &  ) ) static_cast<void (Prs3d_DatumAspect::*)( const opencascade::handle<Prs3d_DatumAspect> &  ) >(&Prs3d_DatumAspect::CopyAspectsFrom),
             R"#(Performs deep copy of attributes from another aspect instance.)#"  , py::arg("theOther")
          )
        .def("DumpJson",
             (void (Prs3d_DatumAspect::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Prs3d_DatumAspect::*)( std::ostream & ,  Standard_Integer  ) const>(&Prs3d_DatumAspect::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_DatumAspect::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_DatumAspect::get_type_descriptor),
                    R"#(None)#" 
          )
        .def_static("ArrowPartForAxis_s",
                    (Prs3d_DatumParts (*)( Prs3d_DatumParts  ) ) static_cast<Prs3d_DatumParts (*)( Prs3d_DatumParts  ) >(&Prs3d_DatumAspect::ArrowPartForAxis),
                    R"#(Returns type of arrow for a type of axis)#"  , py::arg("thePart")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_DatumAspect::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_DatumAspect::*)() const>(&Prs3d_DatumAspect::DynamicType),
             R"#(None)#"
             
         )
       .def("PointAspect",
             (const opencascade::handle<Prs3d_PointAspect> & (Prs3d_DatumAspect::*)() const) static_cast<const opencascade::handle<Prs3d_PointAspect> & (Prs3d_DatumAspect::*)() const>(&Prs3d_DatumAspect::PointAspect),
             R"#(Returns the point aspect of origin wireframe presentation)#"
             
         )
       .def("ArrowAspect",
             (const opencascade::handle<Prs3d_ArrowAspect> & (Prs3d_DatumAspect::*)() const) static_cast<const opencascade::handle<Prs3d_ArrowAspect> & (Prs3d_DatumAspect::*)() const>(&Prs3d_DatumAspect::ArrowAspect),
             R"#(Returns the arrow aspect of presentation.)#"
             
         )
       .def("TextAspect",
             (const opencascade::handle<Prs3d_TextAspect> & (Prs3d_DatumAspect::*)() const) static_cast<const opencascade::handle<Prs3d_TextAspect> & (Prs3d_DatumAspect::*)() const>(&Prs3d_DatumAspect::TextAspect),
             R"#(Returns the text attributes for rendering labels.)#"
             
         )
;

    // Class Prs3d_DimensionAspect from ./opencascade/Prs3d_DimensionAspect.hxx
    klass = m.attr("Prs3d_DimensionAspect");


    // nested enums

    static_cast<py::class_<Prs3d_DimensionAspect ,opencascade::handle<Prs3d_DimensionAspect>  , Prs3d_BasicAspect >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetLineAspect",
             (void (Prs3d_DimensionAspect::*)( const opencascade::handle<Prs3d_LineAspect> &  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const opencascade::handle<Prs3d_LineAspect> &  ) >(&Prs3d_DimensionAspect::SetLineAspect),
             R"#(Sets the display attributes of lines used in presentation of dimensions.)#"  , py::arg("theAspect")
          )
        .def("SetTextAspect",
             (void (Prs3d_DimensionAspect::*)( const opencascade::handle<Prs3d_TextAspect> &  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const opencascade::handle<Prs3d_TextAspect> &  ) >(&Prs3d_DimensionAspect::SetTextAspect),
             R"#(Sets the display attributes of text used in presentation of dimensions.)#"  , py::arg("theAspect")
          )
        .def("IsText3d",
             (Standard_Boolean (Prs3d_DimensionAspect::*)() const) static_cast<Standard_Boolean (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::IsText3d),
             R"#(Check if text for dimension label is 3d.)#" 
          )
        .def("MakeText3d",
             (void (Prs3d_DimensionAspect::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const Standard_Boolean  ) >(&Prs3d_DimensionAspect::MakeText3d),
             R"#(Sets type of text.)#"  , py::arg("isText3d")
          )
        .def("IsTextShaded",
             (Standard_Boolean (Prs3d_DimensionAspect::*)() const) static_cast<Standard_Boolean (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::IsTextShaded),
             R"#(Check if 3d text for dimension label is shaded.)#" 
          )
        .def("MakeTextShaded",
             (void (Prs3d_DimensionAspect::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const Standard_Boolean  ) >(&Prs3d_DimensionAspect::MakeTextShaded),
             R"#(Turns on/off text shading for 3d text.)#"  , py::arg("theIsTextShaded")
          )
        .def("IsArrows3d",
             (Standard_Boolean (Prs3d_DimensionAspect::*)() const) static_cast<Standard_Boolean (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::IsArrows3d),
             R"#(Gets type of arrows.)#" 
          )
        .def("MakeArrows3d",
             (void (Prs3d_DimensionAspect::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const Standard_Boolean  ) >(&Prs3d_DimensionAspect::MakeArrows3d),
             R"#(Sets type of arrows.)#"  , py::arg("theIsArrows3d")
          )
        .def("IsUnitsDisplayed",
             (Standard_Boolean (Prs3d_DimensionAspect::*)() const) static_cast<Standard_Boolean (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::IsUnitsDisplayed),
             R"#(Shows if Units are to be displayed along with dimension value.)#" 
          )
        .def("MakeUnitsDisplayed",
             (void (Prs3d_DimensionAspect::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const Standard_Boolean  ) >(&Prs3d_DimensionAspect::MakeUnitsDisplayed),
             R"#(Specifies whether the units string should be displayed along with value label or not.)#"  , py::arg("theIsDisplayed")
          )
        .def("SetArrowOrientation",
             (void (Prs3d_DimensionAspect::*)( const Prs3d_DimensionArrowOrientation  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const Prs3d_DimensionArrowOrientation  ) >(&Prs3d_DimensionAspect::SetArrowOrientation),
             R"#(Sets orientation of arrows (external or internal). By default orientation is chosen automatically according to situation and text label size.)#"  , py::arg("theArrowOrient")
          )
        .def("ArrowOrientation",
             (Prs3d_DimensionArrowOrientation (Prs3d_DimensionAspect::*)() const) static_cast<Prs3d_DimensionArrowOrientation (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::ArrowOrientation),
             R"#(Gets orientation of arrows (external or internal).)#" 
          )
        .def("SetTextVerticalPosition",
             (void (Prs3d_DimensionAspect::*)( const Prs3d_DimensionTextVerticalPosition  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const Prs3d_DimensionTextVerticalPosition  ) >(&Prs3d_DimensionAspect::SetTextVerticalPosition),
             R"#(Sets vertical text alignment for text label.)#"  , py::arg("thePosition")
          )
        .def("TextVerticalPosition",
             (Prs3d_DimensionTextVerticalPosition (Prs3d_DimensionAspect::*)() const) static_cast<Prs3d_DimensionTextVerticalPosition (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::TextVerticalPosition),
             R"#(Gets vertical text alignment for text label.)#" 
          )
        .def("SetTextHorizontalPosition",
             (void (Prs3d_DimensionAspect::*)( const Prs3d_DimensionTextHorizontalPosition  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const Prs3d_DimensionTextHorizontalPosition  ) >(&Prs3d_DimensionAspect::SetTextHorizontalPosition),
             R"#(Sets horizontal text alignment for text label.)#"  , py::arg("thePosition")
          )
        .def("TextHorizontalPosition",
             (Prs3d_DimensionTextHorizontalPosition (Prs3d_DimensionAspect::*)() const) static_cast<Prs3d_DimensionTextHorizontalPosition (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::TextHorizontalPosition),
             R"#(Gets horizontal text alignment for text label.)#" 
          )
        .def("SetArrowAspect",
             (void (Prs3d_DimensionAspect::*)( const opencascade::handle<Prs3d_ArrowAspect> &  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const opencascade::handle<Prs3d_ArrowAspect> &  ) >(&Prs3d_DimensionAspect::SetArrowAspect),
             R"#(Sets the display attributes of arrows used in presentation of dimensions.)#"  , py::arg("theAspect")
          )
        .def("SetCommonColor",
             (void (Prs3d_DimensionAspect::*)( const Quantity_Color &  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const Quantity_Color &  ) >(&Prs3d_DimensionAspect::SetCommonColor),
             R"#(Sets the same color for all parts of dimension: lines, arrows and text.)#"  , py::arg("theColor")
          )
        .def("SetExtensionSize",
             (void (Prs3d_DimensionAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const Standard_Real  ) >(&Prs3d_DimensionAspect::SetExtensionSize),
             R"#(Sets extension size.)#"  , py::arg("theSize")
          )
        .def("ExtensionSize",
             (Standard_Real (Prs3d_DimensionAspect::*)() const) static_cast<Standard_Real (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::ExtensionSize),
             R"#(Returns extension size.)#" 
          )
        .def("SetArrowTailSize",
             (void (Prs3d_DimensionAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const Standard_Real  ) >(&Prs3d_DimensionAspect::SetArrowTailSize),
             R"#(Set size for arrow tail (extension without text).)#"  , py::arg("theSize")
          )
        .def("ArrowTailSize",
             (Standard_Real (Prs3d_DimensionAspect::*)() const) static_cast<Standard_Real (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::ArrowTailSize),
             R"#(Returns arrow tail size.)#" 
          )
        .def("SetValueStringFormat",
             (void (Prs3d_DimensionAspect::*)( const TCollection_AsciiString &  ) ) static_cast<void (Prs3d_DimensionAspect::*)( const TCollection_AsciiString &  ) >(&Prs3d_DimensionAspect::SetValueStringFormat),
             R"#(Sets "sprintf"-syntax format for formatting dimension value labels.)#"  , py::arg("theFormat")
          )
        .def("DumpJson",
             (void (Prs3d_DimensionAspect::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Prs3d_DimensionAspect::*)( std::ostream & ,  Standard_Integer  ) const>(&Prs3d_DimensionAspect::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_DimensionAspect::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_DimensionAspect::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_DimensionAspect::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::DynamicType),
             R"#(None)#"
             
         )
       .def("LineAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_DimensionAspect::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::LineAspect),
             R"#(Returns the settings for the display of lines used in presentation of dimensions.)#"
             
         )
       .def("TextAspect",
             (const opencascade::handle<Prs3d_TextAspect> & (Prs3d_DimensionAspect::*)() const) static_cast<const opencascade::handle<Prs3d_TextAspect> & (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::TextAspect),
             R"#(Returns the settings for the display of text used in presentation of dimensions.)#"
             
         )
       .def("ArrowAspect",
             (const opencascade::handle<Prs3d_ArrowAspect> & (Prs3d_DimensionAspect::*)() const) static_cast<const opencascade::handle<Prs3d_ArrowAspect> & (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::ArrowAspect),
             R"#(Returns the settings for displaying arrows.)#"
             
         )
       .def("ValueStringFormat",
             (const TCollection_AsciiString & (Prs3d_DimensionAspect::*)() const) static_cast<const TCollection_AsciiString & (Prs3d_DimensionAspect::*)() const>(&Prs3d_DimensionAspect::ValueStringFormat),
             R"#(Returns format.)#"
             
         )
;

    // Class Prs3d_LineAspect from ./opencascade/Prs3d_LineAspect.hxx
    klass = m.attr("Prs3d_LineAspect");


    // nested enums

    static_cast<py::class_<Prs3d_LineAspect ,opencascade::handle<Prs3d_LineAspect>  , Prs3d_BasicAspect >>(klass)
    // constructors
        .def(py::init< const Quantity_Color &,const Aspect_TypeOfLine,const Standard_Real >()  , py::arg("theColor"),  py::arg("theType"),  py::arg("theWidth") )
        .def(py::init< const opencascade::handle<Graphic3d_AspectLine3d> & >()  , py::arg("theAspect") )
    // custom constructors
    // methods
        .def("SetColor",
             (void (Prs3d_LineAspect::*)( const Quantity_Color &  ) ) static_cast<void (Prs3d_LineAspect::*)( const Quantity_Color &  ) >(&Prs3d_LineAspect::SetColor),
             R"#(Sets the line color defined at the time of construction. Default value: Quantity_NOC_YELLOW)#"  , py::arg("theColor")
          )
        .def("SetTypeOfLine",
             (void (Prs3d_LineAspect::*)( const Aspect_TypeOfLine  ) ) static_cast<void (Prs3d_LineAspect::*)( const Aspect_TypeOfLine  ) >(&Prs3d_LineAspect::SetTypeOfLine),
             R"#(Sets the type of line defined at the time of construction. This could, for example, be solid, dotted or made up of dashes. Default value: Aspect_TOL_SOLID)#"  , py::arg("theType")
          )
        .def("SetWidth",
             (void (Prs3d_LineAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_LineAspect::*)( const Standard_Real  ) >(&Prs3d_LineAspect::SetWidth),
             R"#(Sets the line width defined at the time of construction. Default value: 1.)#"  , py::arg("theWidth")
          )
        .def("SetAspect",
             (void (Prs3d_LineAspect::*)( const opencascade::handle<Graphic3d_AspectLine3d> &  ) ) static_cast<void (Prs3d_LineAspect::*)( const opencascade::handle<Graphic3d_AspectLine3d> &  ) >(&Prs3d_LineAspect::SetAspect),
             R"#(None)#"  , py::arg("theAspect")
          )
        .def("DumpJson",
             (void (Prs3d_LineAspect::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Prs3d_LineAspect::*)( std::ostream & ,  Standard_Integer  ) const>(&Prs3d_LineAspect::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_LineAspect::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_LineAspect::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_LineAspect::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_LineAspect::*)() const>(&Prs3d_LineAspect::DynamicType),
             R"#(None)#"
             
         )
       .def("Aspect",
             (const opencascade::handle<Graphic3d_AspectLine3d> & (Prs3d_LineAspect::*)() const) static_cast<const opencascade::handle<Graphic3d_AspectLine3d> & (Prs3d_LineAspect::*)() const>(&Prs3d_LineAspect::Aspect),
             R"#(Returns the line aspect. This is defined as the set of color, type and thickness attributes.)#"
             
         )
;

    // Class Prs3d_PlaneAspect from ./opencascade/Prs3d_PlaneAspect.hxx
    klass = m.attr("Prs3d_PlaneAspect");


    // nested enums

    static_cast<py::class_<Prs3d_PlaneAspect ,opencascade::handle<Prs3d_PlaneAspect>  , Prs3d_BasicAspect >>(klass)
    // constructors
        .def(py::init<  >()  )
    // custom constructors
    // methods
        .def("SetArrowsLength",
             (void (Prs3d_PlaneAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_PlaneAspect::*)( const Standard_Real  ) >(&Prs3d_PlaneAspect::SetArrowsLength),
             R"#(None)#"  , py::arg("theLength")
          )
        .def("ArrowsLength",
             (Standard_Real (Prs3d_PlaneAspect::*)() const) static_cast<Standard_Real (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::ArrowsLength),
             R"#(Returns the length of the arrow shaft used in the display of arrows.)#" 
          )
        .def("SetArrowsSize",
             (void (Prs3d_PlaneAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_PlaneAspect::*)( const Standard_Real  ) >(&Prs3d_PlaneAspect::SetArrowsSize),
             R"#(Sets the angle of the arrowhead used in the display of planes.)#"  , py::arg("theSize")
          )
        .def("ArrowsSize",
             (Standard_Real (Prs3d_PlaneAspect::*)() const) static_cast<Standard_Real (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::ArrowsSize),
             R"#(Returns the size of arrows used in the display of planes.)#" 
          )
        .def("SetArrowsAngle",
             (void (Prs3d_PlaneAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_PlaneAspect::*)( const Standard_Real  ) >(&Prs3d_PlaneAspect::SetArrowsAngle),
             R"#(Sets the angle of the arrowhead used in the display of arrows involved in the presentation of planes.)#"  , py::arg("theAngle")
          )
        .def("ArrowsAngle",
             (Standard_Real (Prs3d_PlaneAspect::*)() const) static_cast<Standard_Real (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::ArrowsAngle),
             R"#(Returns the angle of the arrowhead used in the display of arrows involved in the presentation of planes.)#" 
          )
        .def("SetDisplayCenterArrow",
             (void (Prs3d_PlaneAspect::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_PlaneAspect::*)( const Standard_Boolean  ) >(&Prs3d_PlaneAspect::SetDisplayCenterArrow),
             R"#(Sets the display attributes defined in DisplayCenterArrow to active.)#"  , py::arg("theToDraw")
          )
        .def("DisplayCenterArrow",
             (Standard_Boolean (Prs3d_PlaneAspect::*)() const) static_cast<Standard_Boolean (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::DisplayCenterArrow),
             R"#(Returns true if the display of center arrows is allowed.)#" 
          )
        .def("SetDisplayEdgesArrows",
             (void (Prs3d_PlaneAspect::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_PlaneAspect::*)( const Standard_Boolean  ) >(&Prs3d_PlaneAspect::SetDisplayEdgesArrows),
             R"#(Sets the display attributes defined in DisplayEdgesArrows to active.)#"  , py::arg("theToDraw")
          )
        .def("DisplayEdgesArrows",
             (Standard_Boolean (Prs3d_PlaneAspect::*)() const) static_cast<Standard_Boolean (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::DisplayEdgesArrows),
             R"#(Returns true if the display of edge arrows is allowed.)#" 
          )
        .def("SetDisplayEdges",
             (void (Prs3d_PlaneAspect::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_PlaneAspect::*)( const Standard_Boolean  ) >(&Prs3d_PlaneAspect::SetDisplayEdges),
             R"#(None)#"  , py::arg("theToDraw")
          )
        .def("DisplayEdges",
             (Standard_Boolean (Prs3d_PlaneAspect::*)() const) static_cast<Standard_Boolean (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::DisplayEdges),
             R"#(None)#" 
          )
        .def("SetDisplayIso",
             (void (Prs3d_PlaneAspect::*)( const Standard_Boolean  ) ) static_cast<void (Prs3d_PlaneAspect::*)( const Standard_Boolean  ) >(&Prs3d_PlaneAspect::SetDisplayIso),
             R"#(Sets the display attributes defined in DisplayIso to active.)#"  , py::arg("theToDraw")
          )
        .def("DisplayIso",
             (Standard_Boolean (Prs3d_PlaneAspect::*)() const) static_cast<Standard_Boolean (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::DisplayIso),
             R"#(Returns true if the display of isoparameters is allowed.)#" 
          )
        .def("SetPlaneLength",
             (void (Prs3d_PlaneAspect::*)( const Standard_Real ,  const Standard_Real  ) ) static_cast<void (Prs3d_PlaneAspect::*)( const Standard_Real ,  const Standard_Real  ) >(&Prs3d_PlaneAspect::SetPlaneLength),
             R"#(None)#"  , py::arg("theLX"),  py::arg("theLY")
          )
        .def("PlaneXLength",
             (Standard_Real (Prs3d_PlaneAspect::*)() const) static_cast<Standard_Real (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::PlaneXLength),
             R"#(Returns the length of the x axis used in the display of planes.)#" 
          )
        .def("PlaneYLength",
             (Standard_Real (Prs3d_PlaneAspect::*)() const) static_cast<Standard_Real (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::PlaneYLength),
             R"#(Returns the length of the y axis used in the display of planes.)#" 
          )
        .def("SetIsoDistance",
             (void (Prs3d_PlaneAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_PlaneAspect::*)( const Standard_Real  ) >(&Prs3d_PlaneAspect::SetIsoDistance),
             R"#(Sets the distance L between isoparameters used in the display of planes.)#"  , py::arg("theL")
          )
        .def("IsoDistance",
             (Standard_Real (Prs3d_PlaneAspect::*)() const) static_cast<Standard_Real (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::IsoDistance),
             R"#(Returns the distance between isoparameters used in the display of planes.)#" 
          )
        .def("DumpJson",
             (void (Prs3d_PlaneAspect::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Prs3d_PlaneAspect::*)( std::ostream & ,  Standard_Integer  ) const>(&Prs3d_PlaneAspect::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_PlaneAspect::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_PlaneAspect::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_PlaneAspect::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::DynamicType),
             R"#(None)#"
             
         )
       .def("EdgesAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_PlaneAspect::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::EdgesAspect),
             R"#(Returns the attributes of displayed edges involved in the presentation of planes.)#"
             
         )
       .def("IsoAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_PlaneAspect::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::IsoAspect),
             R"#(Returns the attributes of displayed isoparameters involved in the presentation of planes.)#"
             
         )
       .def("ArrowAspect",
             (const opencascade::handle<Prs3d_LineAspect> & (Prs3d_PlaneAspect::*)() const) static_cast<const opencascade::handle<Prs3d_LineAspect> & (Prs3d_PlaneAspect::*)() const>(&Prs3d_PlaneAspect::ArrowAspect),
             R"#(Returns the settings for displaying an arrow.)#"
             
         )
;

    // Class Prs3d_PointAspect from ./opencascade/Prs3d_PointAspect.hxx
    klass = m.attr("Prs3d_PointAspect");


    // nested enums

    static_cast<py::class_<Prs3d_PointAspect ,opencascade::handle<Prs3d_PointAspect>  , Prs3d_BasicAspect >>(klass)
    // constructors
        .def(py::init< const Aspect_TypeOfMarker,const Quantity_Color &,const Standard_Real >()  , py::arg("theType"),  py::arg("theColor"),  py::arg("theScale") )
        .def(py::init< const Quantity_Color &,const Standard_Integer,const Standard_Integer,const opencascade::handle<TColStd_HArray1OfByte> & >()  , py::arg("theColor"),  py::arg("theWidth"),  py::arg("theHeight"),  py::arg("theTexture") )
        .def(py::init< const opencascade::handle<Graphic3d_AspectMarker3d> & >()  , py::arg("theAspect") )
    // custom constructors
    // methods
        .def("SetColor",
             (void (Prs3d_PointAspect::*)( const Quantity_Color &  ) ) static_cast<void (Prs3d_PointAspect::*)( const Quantity_Color &  ) >(&Prs3d_PointAspect::SetColor),
             R"#(defines the color to be used when drawing a point. Default value: Quantity_NOC_YELLOW)#"  , py::arg("theColor")
          )
        .def("SetTypeOfMarker",
             (void (Prs3d_PointAspect::*)( const Aspect_TypeOfMarker  ) ) static_cast<void (Prs3d_PointAspect::*)( const Aspect_TypeOfMarker  ) >(&Prs3d_PointAspect::SetTypeOfMarker),
             R"#(defines the type of representation to be used when drawing a point. Default value: Aspect_TOM_PLUS)#"  , py::arg("theType")
          )
        .def("SetScale",
             (void (Prs3d_PointAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_PointAspect::*)( const Standard_Real  ) >(&Prs3d_PointAspect::SetScale),
             R"#(defines the size of the marker used when drawing a point. Default value: 1.)#"  , py::arg("theScale")
          )
        .def("SetAspect",
             (void (Prs3d_PointAspect::*)( const opencascade::handle<Graphic3d_AspectMarker3d> &  ) ) static_cast<void (Prs3d_PointAspect::*)( const opencascade::handle<Graphic3d_AspectMarker3d> &  ) >(&Prs3d_PointAspect::SetAspect),
             R"#(None)#"  , py::arg("theAspect")
          )
        .def("DumpJson",
             (void (Prs3d_PointAspect::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Prs3d_PointAspect::*)( std::ostream & ,  Standard_Integer  ) const>(&Prs3d_PointAspect::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
        .def("GetTextureSize",
             []( Prs3d_PointAspect &self   ){
                 Standard_Integer  theWidth;
                Standard_Integer  theHeight;

                 self.GetTextureSize(theWidth,theHeight);
                 
                 return std::make_tuple(theWidth,theHeight); },
             R"#(Returns marker's texture size.)#" 
          )
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_PointAspect::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_PointAspect::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_PointAspect::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_PointAspect::*)() const>(&Prs3d_PointAspect::DynamicType),
             R"#(None)#"
             
         )
       .def("Aspect",
             (const opencascade::handle<Graphic3d_AspectMarker3d> & (Prs3d_PointAspect::*)() const) static_cast<const opencascade::handle<Graphic3d_AspectMarker3d> & (Prs3d_PointAspect::*)() const>(&Prs3d_PointAspect::Aspect),
             R"#(None)#"
             
         )
       .def("GetTexture",
             (const opencascade::handle<Graphic3d_MarkerImage> & (Prs3d_PointAspect::*)() const) static_cast<const opencascade::handle<Graphic3d_MarkerImage> & (Prs3d_PointAspect::*)() const>(&Prs3d_PointAspect::GetTexture),
             R"#(Returns marker's texture.)#"
             
         )
;

    // Class Prs3d_ShadingAspect from ./opencascade/Prs3d_ShadingAspect.hxx
    klass = m.attr("Prs3d_ShadingAspect");


    // nested enums

    static_cast<py::class_<Prs3d_ShadingAspect ,opencascade::handle<Prs3d_ShadingAspect>  , Prs3d_BasicAspect >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<Graphic3d_AspectFillArea3d> & >()  , py::arg("theAspect") )
    // custom constructors
    // methods
        .def("SetColor",
             (void (Prs3d_ShadingAspect::*)( const Quantity_Color & ,  const Aspect_TypeOfFacingModel  ) ) static_cast<void (Prs3d_ShadingAspect::*)( const Quantity_Color & ,  const Aspect_TypeOfFacingModel  ) >(&Prs3d_ShadingAspect::SetColor),
             R"#(Change the polygons interior color and material ambient color.)#"  , py::arg("aColor"),  py::arg("aModel")=static_cast<const Aspect_TypeOfFacingModel>(Aspect_TOFM_BOTH_SIDE)
          )
        .def("SetMaterial",
             (void (Prs3d_ShadingAspect::*)( const Graphic3d_MaterialAspect & ,  const Aspect_TypeOfFacingModel  ) ) static_cast<void (Prs3d_ShadingAspect::*)( const Graphic3d_MaterialAspect & ,  const Aspect_TypeOfFacingModel  ) >(&Prs3d_ShadingAspect::SetMaterial),
             R"#(Change the polygons material aspect.)#"  , py::arg("aMaterial"),  py::arg("aModel")=static_cast<const Aspect_TypeOfFacingModel>(Aspect_TOFM_BOTH_SIDE)
          )
        .def("SetTransparency",
             (void (Prs3d_ShadingAspect::*)( const Standard_Real ,  const Aspect_TypeOfFacingModel  ) ) static_cast<void (Prs3d_ShadingAspect::*)( const Standard_Real ,  const Aspect_TypeOfFacingModel  ) >(&Prs3d_ShadingAspect::SetTransparency),
             R"#(Change the polygons transparency value. Warning : aValue must be in the range 0,1. 0 is the default (NO transparent))#"  , py::arg("aValue"),  py::arg("aModel")=static_cast<const Aspect_TypeOfFacingModel>(Aspect_TOFM_BOTH_SIDE)
          )
        .def("Color",
             (const Quantity_Color & (Prs3d_ShadingAspect::*)( const Aspect_TypeOfFacingModel  ) const) static_cast<const Quantity_Color & (Prs3d_ShadingAspect::*)( const Aspect_TypeOfFacingModel  ) const>(&Prs3d_ShadingAspect::Color),
             R"#(Returns the polygons color.)#"  , py::arg("aModel")=static_cast<const Aspect_TypeOfFacingModel>(Aspect_TOFM_FRONT_SIDE)
          )
        .def("Material",
             (const Graphic3d_MaterialAspect & (Prs3d_ShadingAspect::*)( const Aspect_TypeOfFacingModel  ) const) static_cast<const Graphic3d_MaterialAspect & (Prs3d_ShadingAspect::*)( const Aspect_TypeOfFacingModel  ) const>(&Prs3d_ShadingAspect::Material),
             R"#(Returns the polygons material aspect.)#"  , py::arg("aModel")=static_cast<const Aspect_TypeOfFacingModel>(Aspect_TOFM_FRONT_SIDE)
          )
        .def("Transparency",
             (Standard_Real (Prs3d_ShadingAspect::*)( const Aspect_TypeOfFacingModel  ) const) static_cast<Standard_Real (Prs3d_ShadingAspect::*)( const Aspect_TypeOfFacingModel  ) const>(&Prs3d_ShadingAspect::Transparency),
             R"#(Returns the polygons transparency value.)#"  , py::arg("aModel")=static_cast<const Aspect_TypeOfFacingModel>(Aspect_TOFM_FRONT_SIDE)
          )
        .def("SetAspect",
             (void (Prs3d_ShadingAspect::*)( const opencascade::handle<Graphic3d_AspectFillArea3d> &  ) ) static_cast<void (Prs3d_ShadingAspect::*)( const opencascade::handle<Graphic3d_AspectFillArea3d> &  ) >(&Prs3d_ShadingAspect::SetAspect),
             R"#(None)#"  , py::arg("theAspect")
          )
        .def("DumpJson",
             (void (Prs3d_ShadingAspect::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Prs3d_ShadingAspect::*)( std::ostream & ,  Standard_Integer  ) const>(&Prs3d_ShadingAspect::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_ShadingAspect::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_ShadingAspect::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_ShadingAspect::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_ShadingAspect::*)() const>(&Prs3d_ShadingAspect::DynamicType),
             R"#(None)#"
             
         )
       .def("Aspect",
             (const opencascade::handle<Graphic3d_AspectFillArea3d> & (Prs3d_ShadingAspect::*)() const) static_cast<const opencascade::handle<Graphic3d_AspectFillArea3d> & (Prs3d_ShadingAspect::*)() const>(&Prs3d_ShadingAspect::Aspect),
             R"#(Returns the polygons aspect properties.)#"
             
         )
;

    // Class Prs3d_TextAspect from ./opencascade/Prs3d_TextAspect.hxx
    klass = m.attr("Prs3d_TextAspect");


    // nested enums

    static_cast<py::class_<Prs3d_TextAspect ,opencascade::handle<Prs3d_TextAspect>  , Prs3d_BasicAspect >>(klass)
    // constructors
        .def(py::init<  >()  )
        .def(py::init< const opencascade::handle<Graphic3d_AspectText3d> & >()  , py::arg("theAspect") )
    // custom constructors
    // methods
        .def("SetColor",
             (void (Prs3d_TextAspect::*)( const Quantity_Color &  ) ) static_cast<void (Prs3d_TextAspect::*)( const Quantity_Color &  ) >(&Prs3d_TextAspect::SetColor),
             R"#(Sets the color of the type used in text display.)#"  , py::arg("theColor")
          )
        .def("SetFont",
             (void (Prs3d_TextAspect::*)( const Standard_CString  ) ) static_cast<void (Prs3d_TextAspect::*)( const Standard_CString  ) >(&Prs3d_TextAspect::SetFont),
             R"#(Sets the font used in text display.)#"  , py::arg("theFont")
          )
        .def("SetHeight",
             (void (Prs3d_TextAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_TextAspect::*)( const Standard_Real  ) >(&Prs3d_TextAspect::SetHeight),
             R"#(Sets the height of the text.)#"  , py::arg("theHeight")
          )
        .def("SetAngle",
             (void (Prs3d_TextAspect::*)( const Standard_Real  ) ) static_cast<void (Prs3d_TextAspect::*)( const Standard_Real  ) >(&Prs3d_TextAspect::SetAngle),
             R"#(Sets the angle)#"  , py::arg("theAngle")
          )
        .def("Height",
             (Standard_Real (Prs3d_TextAspect::*)() const) static_cast<Standard_Real (Prs3d_TextAspect::*)() const>(&Prs3d_TextAspect::Height),
             R"#(Returns the height of the text box.)#" 
          )
        .def("Angle",
             (Standard_Real (Prs3d_TextAspect::*)() const) static_cast<Standard_Real (Prs3d_TextAspect::*)() const>(&Prs3d_TextAspect::Angle),
             R"#(Returns the angle)#" 
          )
        .def("SetHorizontalJustification",
             (void (Prs3d_TextAspect::*)( const Graphic3d_HorizontalTextAlignment  ) ) static_cast<void (Prs3d_TextAspect::*)( const Graphic3d_HorizontalTextAlignment  ) >(&Prs3d_TextAspect::SetHorizontalJustification),
             R"#(Sets horizontal alignment of text.)#"  , py::arg("theJustification")
          )
        .def("SetVerticalJustification",
             (void (Prs3d_TextAspect::*)( const Graphic3d_VerticalTextAlignment  ) ) static_cast<void (Prs3d_TextAspect::*)( const Graphic3d_VerticalTextAlignment  ) >(&Prs3d_TextAspect::SetVerticalJustification),
             R"#(Sets the vertical alignment of text.)#"  , py::arg("theJustification")
          )
        .def("SetOrientation",
             (void (Prs3d_TextAspect::*)( const Graphic3d_TextPath  ) ) static_cast<void (Prs3d_TextAspect::*)( const Graphic3d_TextPath  ) >(&Prs3d_TextAspect::SetOrientation),
             R"#(Sets the orientation of text.)#"  , py::arg("theOrientation")
          )
        .def("HorizontalJustification",
             (Graphic3d_HorizontalTextAlignment (Prs3d_TextAspect::*)() const) static_cast<Graphic3d_HorizontalTextAlignment (Prs3d_TextAspect::*)() const>(&Prs3d_TextAspect::HorizontalJustification),
             R"#(Returns the horizontal alignment of the text. The range of values includes: - left - center - right, and - normal (justified).)#" 
          )
        .def("VerticalJustification",
             (Graphic3d_VerticalTextAlignment (Prs3d_TextAspect::*)() const) static_cast<Graphic3d_VerticalTextAlignment (Prs3d_TextAspect::*)() const>(&Prs3d_TextAspect::VerticalJustification),
             R"#(Returns the vertical alignment of the text. The range of values includes: - normal - top - cap - half - base - bottom)#" 
          )
        .def("Orientation",
             (Graphic3d_TextPath (Prs3d_TextAspect::*)() const) static_cast<Graphic3d_TextPath (Prs3d_TextAspect::*)() const>(&Prs3d_TextAspect::Orientation),
             R"#(Returns the orientation of the text. Text can be displayed in the following directions: - up - down - left, or - right)#" 
          )
        .def("SetAspect",
             (void (Prs3d_TextAspect::*)( const opencascade::handle<Graphic3d_AspectText3d> &  ) ) static_cast<void (Prs3d_TextAspect::*)( const opencascade::handle<Graphic3d_AspectText3d> &  ) >(&Prs3d_TextAspect::SetAspect),
             R"#(None)#"  , py::arg("theAspect")
          )
        .def("DumpJson",
             (void (Prs3d_TextAspect::*)( std::ostream & ,  Standard_Integer  ) const) static_cast<void (Prs3d_TextAspect::*)( std::ostream & ,  Standard_Integer  ) const>(&Prs3d_TextAspect::DumpJson),
             R"#(Dumps the content of me into the stream)#"  , py::arg("theOStream"),  py::arg("theDepth")=static_cast<Standard_Integer>(- 1)
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_TextAspect::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_TextAspect::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_TextAspect::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_TextAspect::*)() const>(&Prs3d_TextAspect::DynamicType),
             R"#(None)#"
             
         )
       .def("Aspect",
             (const opencascade::handle<Graphic3d_AspectText3d> & (Prs3d_TextAspect::*)() const) static_cast<const opencascade::handle<Graphic3d_AspectText3d> & (Prs3d_TextAspect::*)() const>(&Prs3d_TextAspect::Aspect),
             R"#(Returns the purely textual attributes used in the display of text. These include: - color - font - height/width ratio, that is, the expansion factor, and - space between characters.)#"
             
         )
;

    // Class Prs3d_ToolCylinder from ./opencascade/Prs3d_ToolCylinder.hxx
    klass = m.attr("Prs3d_ToolCylinder");


    // nested enums

    static_cast<py::class_<Prs3d_ToolCylinder , shared_ptr<Prs3d_ToolCylinder>  , Prs3d_ToolQuadric >>(klass)
    // constructors
        .def(py::init< const Standard_Real,const Standard_Real,const Standard_Real,const Standard_Integer,const Standard_Integer >()  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theNbSlices"),  py::arg("theNbStacks") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Create_s",
                    (opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) >(&Prs3d_ToolCylinder::Create),
                    R"#(Generate primitives for 3D quadric surface and return a filled array.)#"  , py::arg("theBottomRad"),  py::arg("theTopRad"),  py::arg("theHeight"),  py::arg("theNbSlices"),  py::arg("theNbStacks"),  py::arg("theTrsf")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Prs3d_ToolDisk from ./opencascade/Prs3d_ToolDisk.hxx
    klass = m.attr("Prs3d_ToolDisk");


    // nested enums

    static_cast<py::class_<Prs3d_ToolDisk , shared_ptr<Prs3d_ToolDisk>  , Prs3d_ToolQuadric >>(klass)
    // constructors
        .def(py::init< const Standard_Real,const Standard_Real,const Standard_Integer,const Standard_Integer >()  , py::arg("theInnerRadius"),  py::arg("theOuterRadius"),  py::arg("theNbSlices"),  py::arg("theNbStacks") )
    // custom constructors
    // methods
        .def("SetAngleRange",
             (void (Prs3d_ToolDisk::*)( Standard_Real ,  Standard_Real  ) ) static_cast<void (Prs3d_ToolDisk::*)( Standard_Real ,  Standard_Real  ) >(&Prs3d_ToolDisk::SetAngleRange),
             R"#(Set angle range in radians [0, 2*PI] by default.)#"  , py::arg("theStartAngle"),  py::arg("theEndAngle")
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Create_s",
                    (opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) >(&Prs3d_ToolDisk::Create),
                    R"#(Generate primitives for 3D quadric surface.)#"  , py::arg("theInnerRadius"),  py::arg("theOuterRadius"),  py::arg("theNbSlices"),  py::arg("theNbStacks"),  py::arg("theTrsf")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Prs3d_ToolSector from ./opencascade/Prs3d_ToolSector.hxx
    klass = m.attr("Prs3d_ToolSector");


    // nested enums

    static_cast<py::class_<Prs3d_ToolSector , shared_ptr<Prs3d_ToolSector>  , Prs3d_ToolQuadric >>(klass)
    // constructors
        .def(py::init< const Standard_Real,const Standard_Integer,const Standard_Integer >()  , py::arg("theRadius"),  py::arg("theNbSlices"),  py::arg("theNbStacks") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Create_s",
                    (opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) >(&Prs3d_ToolSector::Create),
                    R"#(Generate primitives for 3D quadric surface.)#"  , py::arg("theRadius"),  py::arg("theNbSlices"),  py::arg("theNbStacks"),  py::arg("theTrsf")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Prs3d_ToolSphere from ./opencascade/Prs3d_ToolSphere.hxx
    klass = m.attr("Prs3d_ToolSphere");


    // nested enums

    static_cast<py::class_<Prs3d_ToolSphere , shared_ptr<Prs3d_ToolSphere>  , Prs3d_ToolQuadric >>(klass)
    // constructors
        .def(py::init< const Standard_Real,const Standard_Integer,const Standard_Integer >()  , py::arg("theRadius"),  py::arg("theNbSlices"),  py::arg("theNbStacks") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Create_s",
                    (opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) >(&Prs3d_ToolSphere::Create),
                    R"#(Generate primitives for 3D quadric surface.)#"  , py::arg("theRadius"),  py::arg("theNbSlices"),  py::arg("theNbStacks"),  py::arg("theTrsf")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Prs3d_ToolTorus from ./opencascade/Prs3d_ToolTorus.hxx
    klass = m.attr("Prs3d_ToolTorus");


    // nested enums

    static_cast<py::class_<Prs3d_ToolTorus , shared_ptr<Prs3d_ToolTorus>  , Prs3d_ToolQuadric >>(klass)
    // constructors
        .def(py::init< const Standard_Real,const Standard_Real,const Standard_Integer,const Standard_Integer >()  , py::arg("theMajorRad"),  py::arg("theMinorRad"),  py::arg("theNbSlices"),  py::arg("theNbStacks") )
        .def(py::init< const Standard_Real,const Standard_Real,const Standard_Real,const Standard_Integer,const Standard_Integer >()  , py::arg("theMajorRad"),  py::arg("theMinorRad"),  py::arg("theAngle"),  py::arg("theNbSlices"),  py::arg("theNbStacks") )
        .def(py::init< const Standard_Real,const Standard_Real,const Standard_Real,const Standard_Real,const Standard_Integer,const Standard_Integer >()  , py::arg("theMajorRad"),  py::arg("theMinorRad"),  py::arg("theAngle1"),  py::arg("theAngle2"),  py::arg("theNbSlices"),  py::arg("theNbStacks") )
        .def(py::init< const Standard_Real,const Standard_Real,const Standard_Real,const Standard_Real,const Standard_Real,const Standard_Integer,const Standard_Integer >()  , py::arg("theMajorRad"),  py::arg("theMinorRad"),  py::arg("theAngle1"),  py::arg("theAngle2"),  py::arg("theAngle"),  py::arg("theNbSlices"),  py::arg("theNbStacks") )
    // custom constructors
    // methods
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("Create_s",
                    (opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) >(&Prs3d_ToolTorus::Create),
                    R"#(Generate primitives for 3D quadric surface (complete torus).)#"  , py::arg("theMajorRad"),  py::arg("theMinorRad"),  py::arg("theNbSlices"),  py::arg("theNbStacks"),  py::arg("theTrsf")
          )
        .def_static("Create_s",
                    (opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) >(&Prs3d_ToolTorus::Create),
                    R"#(Generate primitives for 3D quadric surface (torus segment).)#"  , py::arg("theMajorRad"),  py::arg("theMinorRad"),  py::arg("theAngle"),  py::arg("theNbSlices"),  py::arg("theNbStacks"),  py::arg("theTrsf")
          )
        .def_static("Create_s",
                    (opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) >(&Prs3d_ToolTorus::Create),
                    R"#(Generate primitives for 3D quadric surface (torus ring segment).)#"  , py::arg("theMajorRad"),  py::arg("theMinorRad"),  py::arg("theAngle1"),  py::arg("theAngle2"),  py::arg("theNbSlices"),  py::arg("theNbStacks"),  py::arg("theTrsf")
          )
        .def_static("Create_s",
                    (opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) ) static_cast<opencascade::handle<Graphic3d_ArrayOfTriangles> (*)( const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Real ,  const Standard_Integer ,  const Standard_Integer ,  const gp_Trsf &  ) >(&Prs3d_ToolTorus::Create),
                    R"#(Generate primitives for 3D quadric surface (segment of the torus ring segment).)#"  , py::arg("theMajorRad"),  py::arg("theMinorRad"),  py::arg("theAngle1"),  py::arg("theAngle2"),  py::arg("theAngle"),  py::arg("theNbSlices"),  py::arg("theNbStacks"),  py::arg("theTrsf")
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
;

    // Class Prs3d_IsoAspect from ./opencascade/Prs3d_IsoAspect.hxx
    klass = m.attr("Prs3d_IsoAspect");


    // nested enums

    static_cast<py::class_<Prs3d_IsoAspect ,opencascade::handle<Prs3d_IsoAspect>  , Prs3d_LineAspect >>(klass)
    // constructors
        .def(py::init< const Quantity_Color &,const Aspect_TypeOfLine,const Standard_Real,const Standard_Integer >()  , py::arg("theColor"),  py::arg("theType"),  py::arg("theWidth"),  py::arg("theNumber") )
    // custom constructors
    // methods
        .def("SetNumber",
             (void (Prs3d_IsoAspect::*)( const Standard_Integer  ) ) static_cast<void (Prs3d_IsoAspect::*)( const Standard_Integer  ) >(&Prs3d_IsoAspect::SetNumber),
             R"#(defines the number of U or V isoparametric curves to be drawn for a single face. Default value: 10)#"  , py::arg("theNumber")
          )
        .def("Number",
             (Standard_Integer (Prs3d_IsoAspect::*)() const) static_cast<Standard_Integer (Prs3d_IsoAspect::*)() const>(&Prs3d_IsoAspect::Number),
             R"#(returns the number of U or V isoparametric curves drawn for a single face.)#" 
          )
    // methods using call by reference i.s.o. return
    // static methods
        .def_static("get_type_name_s",
                    (const char * (*)() ) static_cast<const char * (*)() >(&Prs3d_IsoAspect::get_type_name),
                    R"#(None)#" 
          )
        .def_static("get_type_descriptor_s",
                    (const opencascade::handle<Standard_Type> & (*)() ) static_cast<const opencascade::handle<Standard_Type> & (*)() >(&Prs3d_IsoAspect::get_type_descriptor),
                    R"#(None)#" 
          )
    // static methods using call by reference i.s.o. return
    // operators
    // additional methods and static methods
    // properties
    // methods returning by ref wrapped as properties
       .def("DynamicType",
             (const opencascade::handle<Standard_Type> & (Prs3d_IsoAspect::*)() const) static_cast<const opencascade::handle<Standard_Type> & (Prs3d_IsoAspect::*)() const>(&Prs3d_IsoAspect::DynamicType),
             R"#(None)#"
             
         )
;

// functions
// ./opencascade/Prs3d.hxx
// ./opencascade/Prs3d_Arrow.hxx
// ./opencascade/Prs3d_ArrowAspect.hxx
// ./opencascade/Prs3d_BasicAspect.hxx
// ./opencascade/Prs3d_BndBox.hxx
// ./opencascade/Prs3d_DatumAspect.hxx
// ./opencascade/Prs3d_DatumAttribute.hxx
// ./opencascade/Prs3d_DatumAxes.hxx
// ./opencascade/Prs3d_DatumMode.hxx
// ./opencascade/Prs3d_DatumParts.hxx
// ./opencascade/Prs3d_DimensionArrowOrientation.hxx
// ./opencascade/Prs3d_DimensionAspect.hxx
// ./opencascade/Prs3d_DimensionTextHorizontalPosition.hxx
// ./opencascade/Prs3d_DimensionTextVerticalPosition.hxx
// ./opencascade/Prs3d_DimensionUnits.hxx
// ./opencascade/Prs3d_Drawer.hxx
// ./opencascade/Prs3d_InvalidAngle.hxx
// ./opencascade/Prs3d_IsoAspect.hxx
// ./opencascade/Prs3d_LineAspect.hxx
// ./opencascade/Prs3d_NListIteratorOfListOfSequenceOfPnt.hxx
// ./opencascade/Prs3d_NListOfSequenceOfPnt.hxx
// ./opencascade/Prs3d_PlaneAspect.hxx
// ./opencascade/Prs3d_Point.hxx
// ./opencascade/Prs3d_PointAspect.hxx
// ./opencascade/Prs3d_Presentation.hxx
// ./opencascade/Prs3d_PresentationShadow.hxx
// ./opencascade/Prs3d_Root.hxx
// ./opencascade/Prs3d_ShadingAspect.hxx
// ./opencascade/Prs3d_ShapeTool.hxx
// ./opencascade/Prs3d_Text.hxx
// ./opencascade/Prs3d_TextAspect.hxx
// ./opencascade/Prs3d_ToolCylinder.hxx
// ./opencascade/Prs3d_ToolDisk.hxx
// ./opencascade/Prs3d_ToolQuadric.hxx
// ./opencascade/Prs3d_ToolSector.hxx
// ./opencascade/Prs3d_ToolSphere.hxx
// ./opencascade/Prs3d_ToolTorus.hxx
// ./opencascade/Prs3d_TypeOfHLR.hxx
// ./opencascade/Prs3d_TypeOfHighlight.hxx
// ./opencascade/Prs3d_TypeOfLinePicking.hxx
// ./opencascade/Prs3d_VertexDrawMode.hxx

// Additional functions

// operators

// register typdefs
    register_template_NCollection_List<opencascade::handle<TColgp_HSequenceOfPnt>>(m,"Prs3d_NListOfSequenceOfPnt");


// exceptions
register_occ_exception<Prs3d_InvalidAngle>(m, "Prs3d_InvalidAngle");

// user-defined post-inclusion per module in the body

};

// user-defined post-inclusion per module

// user-defined post
