# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "cdn edge-action version deploy-version-code",
)
class DeployVersionCode(AAZCommand):
    """A long-running operation to deploy versioncode to EdgeActionVersion resource.

    :example: DeployEdgeActionVersionCode
        az cdn edge-action version deploy-version-code --resource-group testrg --edge-action-name edgeAction1 --version version2 --name zippedFile --content UEsDBBQAAAAIAI1NzkQAAAAABQAAAA==
    """

    _aaz_info = {
        "version": "2024-07-22-preview",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.cdn/edgeactions/{}/versions/{}/deployversioncode", "2024-07-22-preview"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.edge_action_name = AAZStrArg(
            options=["--edge-action-name"],
            help="The name of the Edge Action",
            required=True,
            id_part="name",
            fmt=AAZStrArgFormat(
                pattern="[a-zA-Z0-9]+",
                max_length=50,
            ),
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )
        _args_schema.version = AAZStrArg(
            options=["--version"],
            help="The name of the Edge Action version",
            required=True,
            id_part="child_name_1",
            fmt=AAZStrArgFormat(
                pattern="[a-zA-Z0-9]+",
                max_length=50,
            ),
        )

        # define Arg Group "Body"

        _args_schema = cls._args_schema
        _args_schema.content = AAZStrArg(
            options=["--content"],
            arg_group="Body",
            help="The version code deployment content ",
            required=True,
        )
        _args_schema.name = AAZStrArg(
            options=["--name"],
            arg_group="Body",
            help="The version code name",
            required=True,
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        yield self.EdgeActionVersionsDeployVersionCode(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class EdgeActionVersionsDeployVersionCode(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200,
                    self.on_error,
                    lro_options={"final-state-via": "location"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Cdn/edgeActions/{edgeActionName}/versions/{version}/deployVersionCode",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "MgmtErrorFormat"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "edgeActionName", self.ctx.args.edge_action_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
                **self.serialize_url_param(
                    "version", self.ctx.args.version,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2024-07-22-preview",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("content", AAZStrType, ".content", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.deployment_type = AAZStrType(
                serialized_name="deploymentType",
                flags={"required": True},
            )
            _schema_on_200.is_default_version = AAZStrType(
                serialized_name="isDefaultVersion",
                flags={"required": True},
            )
            _schema_on_200.last_package_update_time = AAZStrType(
                serialized_name="lastPackageUpdateTime",
                flags={"read_only": True},
            )
            _schema_on_200.provisioning_state = AAZStrType(
                serialized_name="provisioningState",
                flags={"read_only": True},
            )
            _schema_on_200.validation_status = AAZStrType(
                serialized_name="validationStatus",
                flags={"read_only": True},
            )

            return cls._schema_on_200


class _DeployVersionCodeHelper:
    """Helper class for DeployVersionCode"""


__all__ = ["DeployVersionCode"]
