/*
 * Decompiled with CFR 0.152.
 */
package info.aduna.text;

import java.io.Serializable;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToTextComparator
implements Comparator<Object>,
Serializable {
    private static final long serialVersionUID = -8493047534229566981L;
    private static final Map<Locale, ToTextComparator> cache = new WeakHashMap<Locale, ToTextComparator>();
    private Collator collator;

    private ToTextComparator(Collator collator) {
        this.collator = collator;
    }

    public static ToTextComparator getInstance() {
        return ToTextComparator.getInstance(Locale.getDefault());
    }

    public static ToTextComparator getInstance(Locale locale) {
        ToTextComparator result = cache.get(locale);
        if (result == null) {
            result = new ToTextComparator(Collator.getInstance(locale));
            cache.put(locale, result);
        }
        return result;
    }

    @Override
    public int compare(Object o1, Object o2) {
        int result = 0;
        if (o1 != o2) {
            result = this.collator.compare(o1.toString(), o2.toString());
        }
        return result;
    }
}

