package App::Manoc::Logger::Role;
#ABSTRACT: Role for Manoc logger


use Moose::Role;

our $VERSION = '2.99.4'; ##TRIAL VERSION

use Log::Log4perl;
use App::Manoc::Logger;

has 'log' => (
    is      => 'rw',
    lazy    => 1,
    builder => '_build_log'
);

sub _build_log {
    my $self = shift;

    if ( $self->can('_init_logging') ) {
        $self->_init_logging;
    }
    else {
        App::Manoc::Logger->initialized or die "Using unitialized logger";
    }
    return App::Manoc::Logger->logger( ref( $_[0] ) );
}

1;

# Local Variables:
# mode: cperl
# indent-tabs-mode: nil
# cperl-indent-level: 4
# cperl-indent-parens-as-block: t
# End:

__END__

=pod

=head1 NAME

App::Manoc::Logger::Role - Role for Manoc logger

=head1 VERSION

version 2.99.4

=head1 Description

This role adds a log attribute pointing to a L<App::Manoc::Logger> instance.

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
