package App::Manoc::Form::Ip;

use HTML::FormHandler::Moose;

extends 'App::Manoc::Form::Base';

our $VERSION = '2.99.2'; ##TRIAL VERSION

has 'ipaddr' => (
    isa      => 'Str',
    is       => 'ro',
    required => 1,
);

has_field 'description' => ( type => 'TextArea' );

has_field 'assigned_to' => (
    type  => 'Text',
    label => 'Assigned to'
);

has_field 'phone' => ( type => 'Text' );

has_field 'email' => ( type => 'Email', );

has_field 'notes' => ( type => 'TextArea', );

has_field 'save' => (
    type           => 'Submit',
    widget         => 'ButtonTag',
    element_attr   => { class => [ 'btn', 'btn-primary' ] },
    widget_wrapper => 'None',
    value          => "Save"
);

override 'update_model' => sub {
    my $self   = shift;
    my $values = $self->values;

    $values->{ipaddr} = $self->ipaddr;
    $self->_set_value($values);

    super();
};

1;

__END__

=pod

=head1 NAME

App::Manoc::Form::Ip

=head1 VERSION

version 2.99.2

=head1 AUTHORS

=over 4

=item *

Gabriele Mambrini <gmambro@cpan.org>

=item *

Enrico Liguori

=back

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2017 by Gabriele Mambrini.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
