use strict;
use warnings;
use Test::More;
use Perl::Version;
my $required_module_version = '2.3.1';


plan skip_all => "Test::Compile required for testing file compileabilty"
     unless eval "use Test::Compile; 1";
plan skip_all => "Test::Compile version $required_module_version required because fixed prove compatibility"
    unless (Perl::Version->new($Test::Compile::VERSION) >= Perl::Version->new($required_module_version));

my $test = Test::Compile->new();
$test->verbose => undef;


my @modules = $test->all_pm_files("lib");
my @binaries = $test->all_pl_files("bin", "example_scripts");

my $tests = scalar(@modules) + scalar(@binaries);
plan tests => $tests;
foreach my $file (@modules) {
    ok($test->pm_file_compiles($file), "checking file $file");
}
foreach my $file (@binaries) {
    ok($test->pl_file_compiles($file), "checking file $file");
}

1;