


gpc(3)                    Gimp Plug-ins                    gpc(3)


NAME
       GPC - GTK Plug-in Convenience library


SYNOPSIS
       #include <plug-ins/gpc/gpc.h>


       void gpc_setup_tooltips(GtkWidget *parent);

       Initialize tooltips interface, set colors.

       void gpc_set_tooltip(GtkWidget *widget, const char *tip);

       Set tooltip for a widget (if tip is non-null).


       void gpc_add_action_button(char *label,
           GtkSignalFunc callback, GtkWidget *dialog, char *tip);

       Add action button (with tooltip) to a dialog.

       void gpc_add_radio_button(GSList **group, char *label,
           GtkWidget *box, gint *value, char *tip);

       Add radio button (with tooltip) to a dialog.

       void gpc_add_hscale(GtkWidget *table, int width,
           float low, float high, gdouble *val,
           int left, int right, int top, int bottom, char *tip);

       Add  horizontal scale widget (with tooltip) to a dialog at
       given location.

       void gpc_add_label(char *value, GtkWidget *parent,
           int left, int right, int top, int bottom);

       Add label widget (no tooltip) to a dialog at  given  loca-
       tion.


       void gpc_close_callback(GtkWidget *widget, gpointer data);

       Destroy callback - quit this plug-in.

       void gpc_cancel_callback(GtkWidget *widget, gpointer data);

       Cancel  button  callback  -  go away without saving state,
       etc.

       void gpc_scale_update(GtkAdjustment *adjustment, double *scale_val);

       Scale update callback - update the SCALE widget's data.




Roadkills-R-Us             30 Apr 1998                          1





gpc(3)                    Gimp Plug-ins                    gpc(3)


       void gpc_text_update(GtkWidget *widget, gpointer data);

       Text update callback - update the TEXT widget's data.


DESCRIPTION
       This is a set of routines to make life easier  on  plug-in
       writers.   It helps keep the GUI code short and sweet. (In
       the plug-in for which it was originally designed,  it  cut
       the GUI code in half.)  It's somewhat arbitrary in what it
       includes so far, because I haven't  needed  everything  in
       GTK.  Feel free to contribute more to it.


   TOOLTIPS ROUTINES
       gpc_setup_tooltips()  must be called first.  This initial-
       izes internal data structures and sets the tooltip colors.
       It  can be called with any widget high enough in the hier-
       archy to contain all the widgets needing tooltips.   Typi-
       cally  this  will  be  the container widget under the top-
       level frame:

       Example:
           frame = gtk_frame_new("Parameter Settings");
               :
           gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dlg)->vbox),
               frame, TRUE, TRUE, 0);
           table = gtk_table_new(4, 2, FALSE);
               :
           gtk_widget_show(table);
           gpc_setup_tooltips(table);


       gpc_set_tooltip() may be called directly, but  is  usually
       called  inside  other  convenience  functions.   If called
       directly,  it  must   still   be   after   the   call   to
       gpc_setup_tooltips().  It hides a lot of detail of the GTK
       tooltips:

       Example:
           gtk_widget_show(button);
           gpc_set_tooltip(button, tip);




   USER INTERFACE ROUTINES
       These routines all hide implementation details to make  it
       easier  to  lay  out  a  GUI  with a consitent, gimp-style
       interface, while keeping the plug-in code cleaner.


       gpc_add_action_button() adds an  action  button  (such  as
       [Cancel]  or  [OK]  to  the action button area of a frame.



Roadkills-R-Us             30 Apr 1998                          2





gpc(3)                    Gimp Plug-ins                    gpc(3)


       The callback argument has the standard GTK callback inter-
       face.   A  standard callback is provided for [Cancel] but-
       tons if you wish to use it.


       Usage:
           void
           gpc_add_action_button(
               char *label,            /* text for action button */
               GtkSignalFunc callback, /* callback function address */
               GtkWidget *dialog,      /* dialog widget to contain button */
               char *tip               /* tooltip text */
           )

       Example:
           static void
           randomize_ok_callback(GtkWidget *widget, gpointer data) {
               rndm_int.run = TRUE;
               gtk_widget_destroy(GTK_WIDGET(data));
           }
               :
           gpc_add_action_button("OK",
               (GtkSignalFunc) randomize_ok_callback, dlg,
               "Accept settings and apply filter to image");
           gpc_add_action_button("Cancel",
               (GtkSignalFunc) gpc_cancel_callback, dlg,
               "Close plug-in without making any changes");


       gpc_add_radio_button() adds a radio button.  If the  radio
       group  does  not exist, it will be created and passed back
       in the  group  argument.   A  standard  callback  will  be
       attached  to  the radio button, requiring a state variable
       which you provide via the value argument.

       Usage:
           void
           gpc_add_radio_button(
               GSList **group,         /* address of radio group */
               char *label,            /* label for new radio button */
               GtkWidget *box,         /* radio box for this radio button */
               gint *value,            /* address of state variable */
               char *tip               /* tooltip text */
           )

       Example:
           GSList *type_group = NULL;
               :
           gpc_add_label("Randomization Type:", table, 0, 1, 0, 1);

           toggle_hbox = gtk_hbox_new(FALSE, 5);
           gtk_container_border_width(GTK_CONTAINER(toggle_hbox), 5);
           gtk_table_attach(GTK_TABLE(table), toggle_hbox, 1, 2, 0, 1,
               GTK_FILL | GTK_EXPAND, GTK_FILL, 5, 0);



Roadkills-R-Us             30 Apr 1998                          3





gpc(3)                    Gimp Plug-ins                    gpc(3)


           gpc_add_radio_button(&type_group,
               "Hurl", toggle_hbox, &do_hurl,
               "Hurl random colors onto pixels");
           gpc_add_radio_button(&type_group,
               "Pick", toggle_hbox, &do_pick,
               "Pick at random from neighboring pixels");
           gpc_add_radio_button(&type_group,
               "Slur", toggle_hbox, &do_slur,
               "Simplistic melt");



       gpc_add_hscale() adds a horizontal scale to a  table  con-
       tainer at the designated coordinates.  A standard callback
       will be attached to the scale, requiring a state  variable
       which you provide via the value argument.

       Usage:
           void
           gpc_add_hscale(
               GtkWidget *table,       /* table widget to hold scale */
               int width,              /* width (in pixels) of scale */
               float low,              /* low value for scale */
               float high,             /* high value for scale */
               gdouble *value,         /* pointer to current value */
               int left,               /* left table position info */
               int right,              /* right table position info */
               int top,                /* top table position info */
               int bottom,             /* bottom table position info */
               char *tip               /* tooltip text */
           )

       Example:
           gpc_add_label("Randomization %:", table, 0, 1, 2, 3);
           gpc_add_hscale(table, SCALE_WIDTH,
               1.0, 100.0, &pivals.rndm_pct, 1, 2, 2, 3,
               "Percentage of pixels to be filtered");


       gpc_add_label()  simply  adds  a  label  at the designated
       coordinates in the table.  Labels don't get tooltips.

       Usage:
           void
           gpc_add_label(
               char *value,            /* text for new label */
               GtkWidget *table,       /* table widget to hold label */
               int left,               /* left table position info */
               int right,              /* right table position info */
               int top,                /* top table position info */
               int bottom              /* bottom table position info */
           )

       Example:



Roadkills-R-Us             30 Apr 1998                          4





gpc(3)                    Gimp Plug-ins                    gpc(3)


           gpc_add_label("Randomization %:", table, 0, 1, 2, 3);


   CALLBACKS:
       gpc_close_callback() is used in OK callbacks, and anywhere
       else  you need a callback to destroy widgets.  The default
       cancel  callback,  gpc_cancel_callback()   simply   closes
       (destroys)  the current panel.  The gpc_scale_update() and
       gpc_text_update() callbacks update  the  appropriate  wid-
       get's data from that widget.


       No special diagnostics are provided.


BUGS
       This software should be 100% Bug-Free [tm].


AUTHOR
       Miles O'Neal
       <meo@rru.com>
       http://www.rru.com/~meo/
       Leander, TX
       Additionally,  some  of  the  code may have been distilled
       from the following plug-ins: alienmap (Copyright (C) 1996,
       1997  Daniel  Cotting)  plasma (Copyright (C) 1996 Stephen
       Norris), oilify (Copyright (C)  1996  Torsten  Martinsen),
       ripple  (Copyright  (C)  1997  Brian Degenhardt) and whirl
       (Copyright (C) 1997 Federico Mena Quintero).



























Roadkills-R-Us             30 Apr 1998                          5


